/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.schema;

import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerAdapter;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerListener;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.io.OpenLdapSchemaFileExporter;
import org.apache.directory.studio.schemaeditor.view.editors.schema.Messages;
import org.apache.directory.studio.schemaeditor.view.editors.schema.SchemaEditor;
import org.apache.directory.studio.schemaeditor.view.widget.SchemaSourceViewer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SchemaEditorSourceCodePage
extends FormPage {
    public static final String ID = String.valueOf(SchemaEditor.ID) + "sourceCode";
    private boolean initialized = false;
    private Schema schema;
    private SchemaSourceViewer schemaSourceViewer;
    private SchemaHandlerListener schemaHandlerListener = new SchemaHandlerAdapter(){

        @Override
        public void attributeTypeAdded(AttributeType at) {
            SchemaEditorSourceCodePage.this.refreshUI();
        }

        @Override
        public void attributeTypeModified(AttributeType at) {
            SchemaEditorSourceCodePage.this.refreshUI();
        }

        @Override
        public void attributeTypeRemoved(AttributeType at) {
            SchemaEditorSourceCodePage.this.refreshUI();
        }

        @Override
        public void matchingRuleAdded(MatchingRule mr) {
            SchemaEditorSourceCodePage.this.refreshUI();
        }

        @Override
        public void matchingRuleModified(MatchingRule mr) {
            SchemaEditorSourceCodePage.this.refreshUI();
        }

        @Override
        public void matchingRuleRemoved(MatchingRule mr) {
            SchemaEditorSourceCodePage.this.refreshUI();
        }

        @Override
        public void objectClassAdded(ObjectClass oc) {
            SchemaEditorSourceCodePage.this.refreshUI();
        }

        @Override
        public void objectClassModified(ObjectClass oc) {
            SchemaEditorSourceCodePage.this.refreshUI();
        }

        @Override
        public void objectClassRemoved(ObjectClass oc) {
            SchemaEditorSourceCodePage.this.refreshUI();
        }

        @Override
        public void syntaxAdded(LdapSyntax syntax) {
            SchemaEditorSourceCodePage.this.refreshUI();
        }

        @Override
        public void syntaxModified(LdapSyntax syntax) {
            SchemaEditorSourceCodePage.this.refreshUI();
        }

        @Override
        public void syntaxRemoved(LdapSyntax syntax) {
            SchemaEditorSourceCodePage.this.refreshUI();
        }
    };

    public SchemaEditorSourceCodePage(FormEditor editor) {
        super(editor, ID, Messages.getString("SchemaEditorSourceCodePage.SourceCode"));
        Activator.getDefault().getSchemaHandler().addListener(this.schemaHandlerListener);
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.schema = ((SchemaEditor)this.getEditor()).getSchema();
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        GridLayout layout = new GridLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.paintBordersFor(form.getBody());
        this.schemaSourceViewer = new SchemaSourceViewer(form.getBody(), null, null, false, 2816);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 10;
        this.schemaSourceViewer.getTextWidget().setLayoutData((Object)gd);
        this.schemaSourceViewer.getTextWidget().setEditable(false);
        Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        this.schemaSourceViewer.getTextWidget().setFont(font);
        Document document = new Document();
        this.schemaSourceViewer.setDocument((IDocument)document);
        this.fillInUiFields();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, String.valueOf(PluginConstants.PLUGIN_ID) + "." + "schema_editor");
        this.initialized = true;
    }

    private void fillInUiFields() {
        this.schemaSourceViewer.getDocument().set(OpenLdapSchemaFileExporter.toSourceCode(this.schema));
    }

    public void dispose() {
        Activator.getDefault().getSchemaHandler().removeListener(this.schemaHandlerListener);
        super.dispose();
    }

    public void refreshUI() {
        if (this.initialized) {
            this.fillInUiFields();
        }
    }
}

