/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.filtereditor;

import org.apache.directory.studio.common.ui.CommonUIPlugin;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterParser;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterToken;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

public class FilterDamagerRepairer
implements IPresentationDamager,
IPresentationRepairer {
    private LdapFilterParser parser;
    private IDocument document;

    public FilterDamagerRepairer(LdapFilterParser parser) {
        this.parser = parser;
        this.document = null;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent event, boolean documentPartitioningChanged) {
        return partition;
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion damage) {
        TextAttribute DEFAULT_TEXT_ATTRIBUTE = new TextAttribute(this.getColor("defaultColor"));
        TextAttribute AND_OR_NOT_TEXT_ATTRIBUTE = new TextAttribute(this.getColor("keyword1Color"), null, 1);
        TextAttribute ATTRIBUTE_TEXT_ATTRIBUTE = new TextAttribute(this.getColor("attributeTypeColor"));
        TextAttribute FILTER_TYPE_TEXT_ATTRIBUTE = new TextAttribute(this.getColor("separatorColor"), null, 1);
        TextAttribute VALUE_TEXT_ATTRIBUTE = new TextAttribute(this.getColor("valueColor"));
        TextAttribute PARENTHESIS_TEXT_ATTRIBUTE = new TextAttribute(this.getColor("defaultColor"), null, 1);
        this.parser.parse(this.document.get());
        LdapFilterToken[] tokens = this.parser.getModel().getTokens();
        int i = 0;
        while (i < tokens.length) {
            switch (tokens[i].getType()) {
                case 11: 
                case 12: {
                    this.addStyleRange(presentation, tokens[i], PARENTHESIS_TEXT_ATTRIBUTE);
                    break;
                }
                case 21: 
                case 22: 
                case 23: {
                    this.addStyleRange(presentation, tokens[i], AND_OR_NOT_TEXT_ATTRIBUTE);
                    break;
                }
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 62: 
                case 64: 
                case 66: {
                    this.addStyleRange(presentation, tokens[i], FILTER_TYPE_TEXT_ATTRIBUTE);
                    break;
                }
                case 31: 
                case 61: 
                case 63: 
                case 65: {
                    this.addStyleRange(presentation, tokens[i], ATTRIBUTE_TEXT_ATTRIBUTE);
                    break;
                }
                case 51: {
                    this.addStyleRange(presentation, tokens[i], VALUE_TEXT_ATTRIBUTE);
                    break;
                }
                default: {
                    this.addStyleRange(presentation, tokens[i], DEFAULT_TEXT_ATTRIBUTE);
                }
            }
            ++i;
        }
    }

    private Color getColor(String name) {
        return CommonUIPlugin.getDefault().getColor(name);
    }

    private void addStyleRange(TextPresentation presentation, LdapFilterToken token, TextAttribute textAttribute) {
        if (token.getLength() > 0) {
            StyleRange range = new StyleRange(token.getOffset(), token.getLength(), textAttribute.getForeground(), textAttribute.getBackground(), textAttribute.getStyle());
            presentation.addStyleRange(range);
        }
    }
}

