/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.eventing.backend.notification;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.ws.eventing.backend.database.SubscriptionTicket;
import org.apache.cxf.ws.eventing.backend.manager.SubscriptionManagerInterfaceForNotificators;
import org.apache.cxf.ws.eventing.backend.notification.SubscriptionEndNotificationTask;
import org.apache.cxf.ws.eventing.backend.notification.SubscriptionEndStatus;

public abstract class NotificatorService {
    public static final int CORE_POOL_SIZE = 15;
    protected static final Logger LOG = LogUtils.getLogger(NotificatorService.class);
    protected ExecutorService service;

    protected abstract SubscriptionManagerInterfaceForNotificators obtainManager();

    public void dispatchEvent(Object event) {
        if (this.service == null) {
            throw new IllegalStateException("NotificatorService is not started. Please call the start() method before passing any events to it.");
        }
        for (SubscriptionTicket ticket : this.obtainManager().getTickets()) {
            if (!ticket.isExpired()) {
                this.submitNotificationTask(ticket, event);
                continue;
            }
            LOG.info("Ticket expired at " + ticket.getExpires().toXMLFormat());
        }
    }

    protected abstract void submitNotificationTask(SubscriptionTicket var1, Object var2);

    public void subscriptionEnd(SubscriptionTicket ticket, String reason, SubscriptionEndStatus status) {
        LOG.info("NotificatorService will notify about subscription end for ticket=" + ticket.getUuid() + "; reason=" + reason);
        this.service.submit(new SubscriptionEndNotificationTask(ticket, reason, status));
    }

    public void start() {
        this.obtainManager().registerNotificator(this);
        this.service = new ScheduledThreadPoolExecutor(15);
    }

    public void stop() {
        this.service.shutdown();
    }
}

