/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.tasks;

import java.util.StringTokenizer;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.tasks.VfsTask;
import org.apache.commons.vfs2.util.Messages;
import org.apache.tools.ant.BuildException;

public class DeleteTask
extends VfsTask {
    private String file;
    private String srcDirUrl;
    private String filesList;

    public void execute() throws BuildException {
        if (this.srcDirUrl == null ? this.file == null : this.filesList == null) {
            String message = Messages.getString((String)"vfs.tasks/delete.no-source-files.error");
            throw new BuildException(message);
        }
        try {
            if (this.srcDirUrl != null) {
                this.log("Deleting " + this.filesList + " in the directory " + this.srcDirUrl);
                if (!this.srcDirUrl.endsWith("/")) {
                    this.srcDirUrl = this.srcDirUrl + "/";
                }
                StringTokenizer tok = new StringTokenizer(this.filesList, ", \t\n\r\f", false);
                while (tok.hasMoreTokens()) {
                    String nextFile = tok.nextToken();
                    FileObject srcFile = this.resolveFile(this.srcDirUrl + nextFile);
                    srcFile.deleteAll();
                }
            } else {
                FileObject srcFile = this.resolveFile(this.file);
                this.log("Deleting " + srcFile.getPublicURIString());
                srcFile.deleteAll();
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setIncludes(String filesList) {
        this.filesList = filesList;
    }

    public void setSrcDir(String srcDirUrl) {
        this.srcDirUrl = srcDirUrl;
    }
}

