/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import java.io.File;
import java.nio.file.Paths;
import junit.framework.Test;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.VfsTestUtils;
import org.apache.commons.vfs2.provider.sftp.AbstractSftpProviderTestCase;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.server.channel.ChannelSession;
import org.junit.jupiter.api.Assertions;

public class SftpPermissionExceptionTestCase
extends AbstractSftpProviderTestCase {
    public static Test suite() throws Exception {
        return new AbstractSftpProviderTestCase.SftpProviderTestSuite(new SftpPermissionExceptionTestCase()){

            @Override
            protected void addBaseTests() throws Exception {
                this.addTests(SftpPermissionExceptionTestCase.class);
            }
        };
    }

    protected FileObject createScratchFolder() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        scratchFolder.setWritable(false, false);
        return scratchFolder;
    }

    @Override
    protected Capability[] getRequiredCapabilities() {
        return new Capability[]{Capability.CREATE, Capability.DELETE, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.WRITE_CONTENT};
    }

    @Override
    protected boolean isExecChannelClosed() {
        return false;
    }

    @org.junit.Test
    public void testGetOutputStreamException() throws Exception {
        File localFile = new File("src/test/resources/test-data/test.zip");
        FileObject localFileObject = VFS.getManager().toFileObject(localFile);
        FileObject scratchFolder = this.createScratchFolder();
        String fileName = "filecopy.txt";
        FileObject fileObjectCopy = scratchFolder.resolveFile("filecopy.txt");
        fileObjectCopy.setWritable(false, false);
        fileObjectCopy.copyFrom(localFileObject, Selectors.SELECT_SELF);
        Paths.get(VfsTestUtils.getTestDirectory(), scratchFolder.getName().getBaseName(), "filecopy.txt").toFile().setWritable(false);
        for (int i = 0; i < 30; ++i) {
            try {
                fileObjectCopy = scratchFolder.resolveFile("filecopy.txt");
                Assertions.assertFalse((boolean)fileObjectCopy.isWriteable());
                fileObjectCopy.copyFrom(localFileObject, Selectors.SELECT_SELF);
                Assertions.fail((String)"permission fail");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int channelId = ((AbstractSession)server.getActiveSessions().get(0)).registerChannel((Channel)new ChannelSession());
        Assertions.assertTrue((channelId < 30 ? 1 : 0) != 0, (String)"create too many sftp channel more");
        Paths.get(VfsTestUtils.getTestDirectory(), scratchFolder.getName().getBaseName(), "filecopy.txt").toFile().setWritable(true);
        fileObjectCopy = scratchFolder.resolveFile("filecopy.txt");
        Assertions.assertTrue((boolean)fileObjectCopy.isWriteable());
        fileObjectCopy.copyFrom(localFileObject, Selectors.SELECT_SELF);
    }
}

