/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.junit.Test;

public class TempFileTests
extends AbstractProviderTestCase {
    @Test
    public void testLocalFile() throws Exception {
        String prefix = "tet";
        Path file = Files.createTempFile("tet-", "-tet", new FileAttribute[0]);
        TempFileTests.assertTrue((boolean)Files.exists(file, new LinkOption[0]));
        URI uri = file.toUri();
        try (DefaultFileSystemManager manager = this.getManager();
             FileObject fileObject = manager.resolveFile(uri);
             FileContent sourceContent = fileObject.getContent();){
            TempFileTests.assertEquals((long)sourceContent.getSize(), (long)Files.size(file));
        }
    }
}

