/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.ResultIteratorCallback;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.FluentSelectPrefetchRouterAction;
import org.apache.cayenne.query.ObjectSelectMetadata;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.query.Select;
import org.apache.cayenne.query.SortOrder;

public abstract class FluentSelect<T, S extends FluentSelect<T, S>>
extends AbstractQuery
implements Select<T> {
    protected Class<?> entityType;
    protected String entityName;
    protected String dbEntityName;
    protected Expression where;
    protected Expression having;
    protected boolean havingExpressionIsActive = false;
    protected Collection<Ordering> orderings;
    protected boolean distinct;
    protected ObjectSelectMetadata metaData = this.createMetadata();

    protected FluentSelect() {
    }

    protected abstract ObjectSelectMetadata createMetadata();

    protected Object resolveRoot(EntityResolver resolver) {
        Serializable root;
        if (this.entityType != null) {
            root = this.entityType;
        } else if (this.entityName != null) {
            ObjEntity entity = resolver.getObjEntity(this.entityName);
            if (entity == null) {
                throw new CayenneRuntimeException("Unrecognized ObjEntity name: %s", this.entityName);
            }
            root = entity;
        } else if (this.dbEntityName != null) {
            DbEntity entity = resolver.getDbEntity(this.dbEntityName);
            if (entity == null) {
                throw new CayenneRuntimeException("Unrecognized DbEntity name: %s", this.dbEntityName);
            }
            root = entity;
        } else {
            throw new CayenneRuntimeException("Undefined root entity of the query", new Object[0]);
        }
        return root;
    }

    public S entityType(Class<?> entityType) {
        return this.resetEntity(entityType, null, null);
    }

    public S entityName(String entityName) {
        return this.resetEntity(null, entityName, null);
    }

    public S dbEntityName(String dbEntityName) {
        return this.resetEntity(null, null, dbEntityName);
    }

    private S resetEntity(Class<?> entityType, String entityName, String dbEntityName) {
        this.entityType = entityType;
        this.entityName = entityName;
        this.dbEntityName = dbEntityName;
        return (S)((FluentSelect)this.castSelf());
    }

    public S where(Expression expression) {
        return this.and(expression);
    }

    public S where(String expressionString, Object ... parameters) {
        return this.and(ExpressionFactory.exp(expressionString, parameters));
    }

    public S and(Expression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return (S)((FluentSelect)this.castSelf());
        }
        return this.and(Arrays.asList(expressions));
    }

    public S and(Collection<Expression> expressions) {
        return this.joinExpression(expressions, ExpressionFactory::and);
    }

    protected S joinExpression(Collection<Expression> expressions, Function<Collection<Expression>, Expression> joiner) {
        Collection<Expression> all;
        if (expressions == null || expressions.isEmpty()) {
            return (S)((FluentSelect)this.castSelf());
        }
        Expression activeExpression = this.getActiveExpression();
        if (activeExpression != null) {
            all = new ArrayList<Expression>(expressions.size() + 1);
            all.add(activeExpression);
            all.addAll(expressions);
        } else {
            all = expressions;
        }
        this.setActiveExpression(joiner.apply(all));
        return (S)((FluentSelect)this.castSelf());
    }

    public S or(Expression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return (S)((FluentSelect)this.castSelf());
        }
        return this.or(Arrays.asList(expressions));
    }

    public S or(Collection<Expression> expressions) {
        return this.joinExpression(expressions, ExpressionFactory::or);
    }

    public S orderBy(String property) {
        return this.orderBy(new Ordering(property));
    }

    public S orderBy(String property, SortOrder sortOrder) {
        return this.orderBy(new Ordering(property, sortOrder));
    }

    public S orderBy(Ordering ... orderings) {
        if (orderings == null) {
            return (S)((FluentSelect)this.castSelf());
        }
        if (this.orderings == null) {
            this.orderings = new ArrayList<Ordering>(orderings.length);
        }
        Collections.addAll(this.orderings, orderings);
        return (S)((FluentSelect)this.castSelf());
    }

    public S orderBy(Collection<Ordering> orderings) {
        if (orderings == null) {
            return (S)((FluentSelect)this.castSelf());
        }
        if (this.orderings == null) {
            this.orderings = new ArrayList<Ordering>(orderings.size());
        }
        this.orderings.addAll(orderings);
        return (S)((FluentSelect)this.castSelf());
    }

    public S prefetch(PrefetchTreeNode prefetch) {
        this.getBaseMetaData().mergePrefetch(prefetch);
        return (S)((FluentSelect)this.castSelf());
    }

    public S prefetch(String path, int semantics) {
        if (path == null) {
            return (S)((FluentSelect)this.castSelf());
        }
        this.getBaseMetaData().addPrefetch(path, semantics);
        return (S)((FluentSelect)this.castSelf());
    }

    public S limit(int fetchLimit) {
        this.getBaseMetaData().setFetchLimit(fetchLimit);
        return (S)((FluentSelect)this.castSelf());
    }

    public S offset(int fetchOffset) {
        this.getBaseMetaData().setFetchOffset(fetchOffset);
        return (S)((FluentSelect)this.castSelf());
    }

    public S pageSize(int pageSize) {
        this.getBaseMetaData().setPageSize(pageSize);
        return (S)((FluentSelect)this.castSelf());
    }

    public S statementFetchSize(int size) {
        this.getBaseMetaData().setStatementFetchSize(size);
        return (S)((FluentSelect)this.castSelf());
    }

    public S queryTimeout(int timeout) {
        this.getBaseMetaData().setQueryTimeout(timeout);
        return (S)((FluentSelect)this.castSelf());
    }

    public S cacheStrategy(QueryCacheStrategy strategy) {
        this.setCacheStrategy(strategy);
        this.setCacheGroup(null);
        return (S)((FluentSelect)this.castSelf());
    }

    public S cacheStrategy(QueryCacheStrategy strategy, String cacheGroup) {
        return ((FluentSelect)this.cacheStrategy(strategy)).cacheGroup(cacheGroup);
    }

    public S cacheGroup(String cacheGroup) {
        this.setCacheGroup(cacheGroup);
        return (S)((FluentSelect)this.castSelf());
    }

    public S localCache(String cacheGroup) {
        return this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE, cacheGroup);
    }

    public S localCache() {
        return this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
    }

    public S sharedCache(String cacheGroup) {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE, cacheGroup);
    }

    public S sharedCache() {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE);
    }

    public int getStatementFetchSize() {
        return this.getBaseMetaData().getStatementFetchSize();
    }

    public int getQueryTimeout() {
        return this.getBaseMetaData().getQueryTimeout();
    }

    public int getPageSize() {
        return this.getBaseMetaData().getPageSize();
    }

    public int getLimit() {
        return this.getBaseMetaData().getFetchLimit();
    }

    public int getOffset() {
        return this.getBaseMetaData().getFetchOffset();
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getDbEntityName() {
        return this.dbEntityName;
    }

    public Expression getWhere() {
        return this.where;
    }

    public Expression getHaving() {
        return this.having;
    }

    public Collection<Ordering> getOrderings() {
        return this.orderings;
    }

    public PrefetchTreeNode getPrefetches() {
        return this.getBaseMetaData().getPrefetchTree();
    }

    protected void setActiveExpression(Expression exp) {
        if (this.havingExpressionIsActive) {
            this.having = exp;
        } else {
            this.where = exp;
        }
    }

    protected Expression getActiveExpression() {
        if (this.havingExpressionIsActive) {
            return this.having;
        }
        return this.where;
    }

    @Override
    public List<T> select(ObjectContext context) {
        return context.select(this);
    }

    @Override
    public T selectOne(ObjectContext context) {
        return context.selectOne(this);
    }

    @Override
    public void iterate(ObjectContext context, ResultIteratorCallback<T> callback) {
        context.iterate(this, callback);
    }

    @Override
    public ResultIterator<T> iterator(ObjectContext context) {
        return context.iterator(this);
    }

    @Override
    public ResultBatchIterator<T> batchIterator(ObjectContext context, int size) {
        return context.batchIterator(this, size);
    }

    @Override
    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        return visitor.objectSelectAction(this);
    }

    @Override
    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        super.route(router, resolver, substitutedQuery);
        if (this.getPageSize() <= 0) {
            this.routePrefetches(router, resolver);
        }
    }

    public boolean isFetchingDataRows() {
        return this.getBaseMetaData().isFetchingDataRows();
    }

    protected void routePrefetches(QueryRouter router, EntityResolver resolver) {
        new FluentSelectPrefetchRouterAction().route(this, router, resolver);
    }

    public Collection<Property<?>> getColumns() {
        return null;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void initWithProperties(Map<String, String> properties) {
        this.getBaseMetaData().initWithProperties(properties);
    }

    protected <E> E castSelf() {
        return (E)this;
    }
}

