/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.io.PrintWriter;
import org.apache.cayenne.configuration.BaseConfigurationNodeVisitor;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.project.extension.SaverDelegate;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

class ConfigurationSaver
extends BaseConfigurationNodeVisitor<Void> {
    private PrintWriter printWriter;
    private String version;
    private SaverDelegate delegate;

    ConfigurationSaver(PrintWriter printWriter, String version, SaverDelegate delegate) {
        this.printWriter = printWriter;
        this.version = version;
        this.delegate = delegate;
    }

    @Override
    public Void visitDataChannelDescriptor(DataChannelDescriptor node) {
        this.encodeNode(node);
        return null;
    }

    @Override
    public Void visitDataMap(DataMap node) {
        this.encodeNode(node);
        return null;
    }

    private void encodeNode(XMLSerializable node) {
        XMLEncoder encoder = new XMLEncoder(this.printWriter, "\t", this.version);
        encoder.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.delegate.setXMLEncoder(encoder);
        node.encodeAsXML(encoder, this.delegate);
    }
}

