/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.state;

import java.util.ArrayList;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.util.state.EntityDisplayEventType;

class RelationshipDisplayEventType
extends EntityDisplayEventType {
    RelationshipDisplayEventType(ProjectController controller) {
        super(controller);
    }

    @Override
    public void fireLastDisplayEvent() {
        DataChannelDescriptor dataChannel = (DataChannelDescriptor)this.controller.getProject().getRootNode();
        if (!dataChannel.getName().equals(this.preferences.getDomain())) {
            return;
        }
        DataNodeDescriptor dataNode = dataChannel.getNodeDescriptor(this.preferences.getNode());
        DataMap dataMap = dataChannel.getDataMap(this.preferences.getDataMap());
        if (dataMap == null) {
            return;
        }
        Entity<?, ?, ?> entity = this.getLastEntity(dataMap);
        if (entity == null) {
            return;
        }
        Relationship<?, ?, ?>[] relationships = this.getLastEntityRelationships(entity);
        EntityDisplayEvent entityDisplayEvent = new EntityDisplayEvent(this, entity, dataMap, dataNode, dataChannel);
        RelationshipDisplayEvent displayEvent = new RelationshipDisplayEvent((Object)this, relationships, entity, dataMap, dataChannel);
        if (entity instanceof ObjEntity) {
            this.controller.fireObjEntityDisplayEvent(entityDisplayEvent);
            this.controller.fireObjRelationshipDisplayEvent(displayEvent);
        } else if (entity instanceof DbEntity) {
            this.controller.fireDbEntityDisplayEvent(entityDisplayEvent);
            this.controller.fireDbRelationshipDisplayEvent(displayEvent);
        }
    }

    @Override
    public void saveLastDisplayEvent() {
        this.preferences.setEvent(RelationshipDisplayEvent.class.getSimpleName());
        this.preferences.setDomain(this.controller.getCurrentDataChanel().getName());
        this.preferences.setNode(this.controller.getCurrentDataNode() != null ? this.controller.getCurrentDataNode().getName() : "");
        this.preferences.setDataMap(this.controller.getCurrentDataMap().getName());
        if (this.controller.getCurrentObjEntity() != null) {
            this.preferences.setObjEntity(this.controller.getCurrentObjEntity().getName());
            this.preferences.setObjRels(this.parseToString(this.controller.getCurrentObjRelationships()));
            this.preferences.setDbEntity(null);
        } else if (this.controller.getCurrentDbEntity() != null) {
            this.preferences.setDbEntity(this.controller.getCurrentDbEntity().getName());
            this.preferences.setDbRels(this.parseToString(this.controller.getCurrentDbRelationships()));
            this.preferences.setObjEntity(null);
        }
    }

    private Relationship<?, ?, ?>[] getLastEntityRelationships(Entity<?, ?, ?> entity) {
        ArrayList relationshipList = new ArrayList();
        String rels = entity instanceof ObjEntity ? this.preferences.getObjRels() : this.preferences.getDbRels();
        for (String objRelName : rels.split(",")) {
            Object rel = entity.getRelationship(objRelName);
            if (rel == null) continue;
            relationshipList.add(rel);
        }
        return relationshipList.toArray(new Relationship[0]);
    }
}

