/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.ProjectUtil;

public class WarningDialogByDbTargetChange {
    public static boolean showWarningDialog(ProjectController mediator, DbRelationship relationship) {
        Collection<ObjRelationship> objRelationshipsForDbRelationship = ProjectUtil.findObjRelationshipsForDbRelationship(mediator, relationship);
        Collection<ObjAttribute> fObjAttributesForDbRelationship = ProjectUtil.findObjAttributesForDbRelationship(mediator, relationship);
        if (fObjAttributesForDbRelationship.isEmpty() && objRelationshipsForDbRelationship.isEmpty()) {
            int result = JOptionPane.showConfirmDialog(Application.getFrame(), "Changing target entity will reset all joins.", "Warning", 2, -1);
            return result == 0;
        }
        JPanel dialogPanel = new JPanel();
        dialogPanel.setLayout(new BorderLayout());
        JLabel textLabel = new JLabel(String.format("<html><p>Following ObjAttributes and ObjRelationships <br>will be affected by change of DbRelationship <br> '%s' target and must be fixed manually. <br>Are you sure you want to proceed?</p><br></html>", relationship.getName()));
        dialogPanel.add((Component)textLabel, "North");
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        JList objects = new JList(model);
        JScrollPane scrollPane = new JScrollPane(objects);
        if (!objRelationshipsForDbRelationship.isEmpty()) {
            model.addElement("Relationships: ");
            for (ObjRelationship objRelationship : objRelationshipsForDbRelationship) {
                model.addElement(objRelationship.getSourceEntity().getName() + "." + objRelationship.getName());
            }
        }
        if (!fObjAttributesForDbRelationship.isEmpty()) {
            model.addElement("Attributes: ");
            for (ObjAttribute objAttribute : fObjAttributesForDbRelationship) {
                model.addElement(objAttribute.getEntity().getName() + "." + objAttribute.getName());
            }
        }
        dialogPanel.add((Component)scrollPane, "South");
        int result = JOptionPane.showConfirmDialog(Application.getFrame(), dialogPanel, "Warning", 2, -1);
        return result == 0;
    }
}

