/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.xml;

import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.dbsync.reverse.dbimport.SchemaContainer;
import org.apache.cayenne.dbsync.xml.IncludeTableHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class SchemaHandler
extends NamespaceAwareNestedTagHandler {
    private static final String SCHEMA_TAG = "schema";
    private static final String SCHEMA_NAME_TAG = "name";
    private static final String INCLUDE_TABLE_TAG = "includeTable";
    private static final String EXCLUDE_TABLE_TAG = "excludeTable";
    private static final String INCLUDE_COLUMN_TAG = "includeColumn";
    private static final String EXCLUDE_COLUMN_TAG = "excludeColumn";
    private static final String INCLUDE_PROCEDURE_TAG = "includeProcedure";
    private static final String EXCLUDE_PROCEDURE_TAG = "excludeProcedure";
    private SchemaContainer entity;
    private Schema schema;

    SchemaHandler(NamespaceAwareNestedTagHandler parentHandler, SchemaContainer entity) {
        super(parentHandler);
        this.entity = entity;
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "schema": {
                this.createSchema();
                return true;
            }
        }
        return false;
    }

    @Override
    protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String qName, Attributes attributes) {
        if (namespaceURI.equals(this.targetNamespace)) {
            switch (localName) {
                case "includeTable": {
                    return new IncludeTableHandler(this, this.schema);
                }
            }
        }
        return super.createChildTagHandler(namespaceURI, localName, qName, attributes);
    }

    @Override
    protected boolean processCharData(String localName, String data) {
        switch (localName) {
            case "includeTable": {
                this.createIncludeTable(data);
                break;
            }
            case "name": {
                this.createSchemaName(data);
                break;
            }
            case "excludeTable": {
                this.createExcludeTable(data);
                break;
            }
            case "includeColumn": {
                this.createIncludeColumn(data);
                break;
            }
            case "excludeColumn": {
                this.createExcludeColumn(data);
                break;
            }
            case "includeProcedure": {
                this.createIncludeProcedure(data);
                break;
            }
            case "excludeProcedure": {
                this.createExcludeProcedure(data);
            }
        }
        return true;
    }

    private void createIncludeTable(String includeTableData) {
        if (includeTableData.trim().length() == 0) {
            return;
        }
        if (this.schema != null) {
            IncludeTable includeTable = new IncludeTable();
            includeTable.setName(includeTableData);
            this.schema.addIncludeTable(includeTable);
        }
    }

    private void createExcludeProcedure(String excludeProcedure) {
        if (excludeProcedure.trim().length() == 0) {
            return;
        }
        if (this.schema != null) {
            this.schema.addExcludeProcedure(new ExcludeProcedure(excludeProcedure));
        }
    }

    private void createIncludeProcedure(String includeProcedure) {
        if (includeProcedure.trim().length() == 0) {
            return;
        }
        if (this.schema != null) {
            this.schema.addIncludeProcedure(new IncludeProcedure(includeProcedure));
        }
    }

    private void createExcludeColumn(String excludeColumn) {
        if (excludeColumn.trim().length() == 0) {
            return;
        }
        if (this.schema != null) {
            this.schema.addExcludeColumn(new ExcludeColumn(excludeColumn));
        }
    }

    private void createIncludeColumn(String includeColumn) {
        if (includeColumn.trim().length() == 0) {
            return;
        }
        if (this.schema != null) {
            this.schema.addIncludeColumn(new IncludeColumn(includeColumn));
        }
    }

    private void createExcludeTable(String excludeTable) {
        if (excludeTable.trim().length() == 0) {
            return;
        }
        if (this.schema != null) {
            this.schema.addExcludeTable(new ExcludeTable(excludeTable));
        }
    }

    private void createSchemaName(String schemaName) {
        if (schemaName.trim().length() == 0) {
            return;
        }
        if (this.schema != null) {
            this.schema.setName(schemaName);
        }
    }

    private void createSchema() {
        this.schema = new Schema();
        this.entity.addSchema(this.schema);
    }
}

