/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.flush.operation.DbRowOp;
import org.apache.cayenne.access.flush.operation.DbRowOpVisitor;
import org.apache.cayenne.access.flush.operation.DeleteDbRowOp;
import org.apache.cayenne.access.flush.operation.InsertDbRowOp;
import org.apache.cayenne.access.flush.operation.UpdateDbRowOp;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ToManyMapProperty;

class PostprocessVisitor
implements DbRowOpVisitor<Void> {
    private final DataContext context;
    private Map<ObjectId, DataRow> updatedSnapshots;
    private Collection<ObjectId> deletedIds;

    PostprocessVisitor(DataContext context) {
        this.context = context;
    }

    @Override
    public Void visitInsert(InsertDbRowOp dbRow) {
        this.processObjectChange(dbRow);
        return null;
    }

    @Override
    public Void visitUpdate(UpdateDbRowOp dbRow) {
        this.processObjectChange(dbRow);
        return null;
    }

    private void processObjectChange(DbRowOp dbRow) {
        if (dbRow.getChangeId().getEntityName().startsWith("db:")) {
            return;
        }
        DataRow dataRow = this.context.currentSnapshot(dbRow.getObject());
        if (dbRow.getObject() != null) {
            Persistent persistent = dbRow.getObject();
            dataRow.setReplacesVersion(persistent.getSnapshotVersion());
            persistent.setSnapshotVersion(dataRow.getVersion());
        }
        if (this.updatedSnapshots == null) {
            this.updatedSnapshots = new HashMap<ObjectId, DataRow>();
        }
        this.updatedSnapshots.put(dbRow.getObject().getObjectId(), dataRow);
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(dbRow.getChangeId().getEntityName());
        for (ArcProperty arc : descriptor.getMapArcProperties()) {
            ToManyMapProperty reverseArc = (ToManyMapProperty)arc.getComplimentaryReverseArc();
            Object source = arc.readProperty(dbRow.getObject());
            if (source == null || reverseArc.isFault(source)) continue;
            this.remapTarget(reverseArc, source, dbRow.getObject());
        }
    }

    @Override
    public Void visitDelete(DeleteDbRowOp dbRow) {
        if (dbRow.getChangeId().getEntityName().startsWith("db:")) {
            return null;
        }
        if (this.deletedIds == null) {
            this.deletedIds = new HashSet<ObjectId>();
        }
        this.deletedIds.add(dbRow.getChangeId());
        return null;
    }

    Collection<ObjectId> getDeletedIds() {
        return this.deletedIds == null ? Collections.emptyList() : this.deletedIds;
    }

    Map<ObjectId, DataRow> getUpdatedSnapshots() {
        return this.updatedSnapshots == null ? Collections.emptyMap() : this.updatedSnapshots;
    }

    private void remapTarget(ToManyMapProperty property, Object source, Object target) {
        Object newKey;
        Map map = (Map)property.readProperty(source);
        Object currentValue = map.get(newKey = property.getMapKey(target));
        if (currentValue == target) {
            return;
        }
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            if (e.getValue() != target) continue;
            it.remove();
            break;
        }
        map.put(newKey, target);
    }
}

