/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlite;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.ExtendedType;

class SQLiteFloatType
implements ExtendedType<Float> {
    SQLiteFloatType() {
    }

    @Override
    public String getClassName() {
        return Float.class.getName();
    }

    @Override
    public Float materializeObject(CallableStatement rs, int index, int type) throws Exception {
        Number n = (Number)rs.getObject(index);
        return n == null ? null : Float.valueOf(n.floatValue());
    }

    @Override
    public Float materializeObject(ResultSet rs, int index, int type) throws Exception {
        Number n = (Number)rs.getObject(index);
        return n == null ? null : Float.valueOf(n.floatValue());
    }

    @Override
    public void setJdbcObject(PreparedStatement st, Float val, int pos, int type, int scale) throws Exception {
        if (scale != -1) {
            st.setObject(pos, (Object)val, type, scale);
        } else {
            st.setObject(pos, (Object)val, type);
        }
    }

    @Override
    public String toString(Float value) {
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }
}

