/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.pipespec.integration.traits.ServiceBinding;
import org.apache.camel.v1.pipespec.integration.traits.servicebinding.Configuration;
import org.apache.camel.v1.pipespec.integration.traits.servicebinding.ConfigurationBuilder;
import org.apache.camel.v1.pipespec.integration.traits.servicebinding.ConfigurationFluent;

public class ServiceBindingFluent<A extends ServiceBindingFluent<A>>
extends BaseFluent<A> {
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private List<String> services;

    public ServiceBindingFluent() {
    }

    public ServiceBindingFluent(ServiceBinding instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServiceBinding instance) {
        ServiceBinding serviceBinding = instance = instance != null ? instance : new ServiceBinding();
        if (instance != null) {
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withServices(instance.getServices());
        }
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public A addToServices(int index, String item) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        this.services.add(index, item);
        return (A)((Object)this);
    }

    public A setToServices(int index, String item) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        this.services.set(index, item);
        return (A)((Object)this);
    }

    public A addToServices(String ... items) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        for (String item : items) {
            this.services.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToServices(Collection<String> items) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        for (String item : items) {
            this.services.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromServices(String ... items) {
        if (this.services == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.services.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromServices(Collection<String> items) {
        if (this.services == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.services.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getServices() {
        return this.services;
    }

    public String getService(int index) {
        return this.services.get(index);
    }

    public String getFirstService() {
        return this.services.get(0);
    }

    public String getLastService() {
        return this.services.get(this.services.size() - 1);
    }

    public String getMatchingService(Predicate<String> predicate) {
        for (String item : this.services) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingService(Predicate<String> predicate) {
        for (String item : this.services) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServices(List<String> services) {
        if (services != null) {
            this.services = new ArrayList<String>();
            for (String item : services) {
                this.addToServices(item);
            }
        } else {
            this.services = null;
        }
        return (A)((Object)this);
    }

    public A withServices(String ... services) {
        if (this.services != null) {
            this.services.clear();
            this._visitables.remove((Object)"services");
        }
        if (services != null) {
            for (String item : services) {
                this.addToServices(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasServices() {
        return this.services != null && !this.services.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBindingFluent that = (ServiceBindingFluent)((Object)o);
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        return Objects.equals(this.services, that.services);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configuration, this.enabled, this.services, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.services != null && !this.services.isEmpty()) {
            sb.append("services:");
            sb.append(this.services);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)ServiceBindingFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

