/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.template.spec.initcontainers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.integrationspec.template.spec.initcontainers.LifecycleBuilder;
import org.apache.camel.v1.integrationspec.template.spec.initcontainers.lifecycle.PostStart;
import org.apache.camel.v1.integrationspec.template.spec.initcontainers.lifecycle.PreStop;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"postStart", "preStop"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Lifecycle
implements Editable<LifecycleBuilder>,
KubernetesResource {
    @JsonProperty(value="postStart")
    @JsonPropertyDescription(value="PostStart is called immediately after a container is created. If the handler fails,\nthe container is terminated and restarted according to its restart policy.\nOther management of the container blocks until the hook completes.\nMore info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks")
    @JsonSetter(nulls=Nulls.SKIP)
    private PostStart postStart;
    @JsonProperty(value="preStop")
    @JsonPropertyDescription(value="PreStop is called immediately before a container is terminated due to an\nAPI request or management event such as liveness/startup probe failure,\npreemption, resource contention, etc. The handler is not called if the\ncontainer crashes or exits. The Pod's termination grace period countdown begins before the\nPreStop hook is executed. Regardless of the outcome of the handler, the\ncontainer will eventually terminate within the Pod's termination grace\nperiod (unless delayed by finalizers). Other management of the container blocks until the hook completes\nor until the termination grace period is reached.\nMore info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks")
    @JsonSetter(nulls=Nulls.SKIP)
    private PreStop preStop;

    public LifecycleBuilder edit() {
        return new LifecycleBuilder(this);
    }

    public PostStart getPostStart() {
        return this.postStart;
    }

    public void setPostStart(PostStart postStart) {
        this.postStart = postStart;
    }

    public PreStop getPreStop() {
        return this.preStop;
    }

    public void setPreStop(PreStop preStop) {
        this.preStop = preStop;
    }

    public String toString() {
        return "Lifecycle(postStart=" + this.getPostStart() + ", preStop=" + this.getPreStop() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Lifecycle)) {
            return false;
        }
        Lifecycle other = (Lifecycle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PostStart this$postStart = this.getPostStart();
        PostStart other$postStart = other.getPostStart();
        if (this$postStart == null ? other$postStart != null : !((Object)this$postStart).equals(other$postStart)) {
            return false;
        }
        PreStop this$preStop = this.getPreStop();
        PreStop other$preStop = other.getPreStop();
        return !(this$preStop == null ? other$preStop != null : !((Object)this$preStop).equals(other$preStop));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Lifecycle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PostStart $postStart = this.getPostStart();
        result = result * 59 + ($postStart == null ? 43 : ((Object)$postStart).hashCode());
        PreStop $preStop = this.getPreStop();
        result = result * 59 + ($preStop == null ? 43 : ((Object)$preStop).hashCode());
        return result;
    }
}

