/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationprofilestatus.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.integrationprofilestatus.traits.JolokiaBuilder;
import org.apache.camel.v1.integrationprofilestatus.traits.jolokia.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"CACert", "clientPrincipal", "configuration", "discoveryEnabled", "enabled", "extendedClientCheck", "host", "options", "password", "port", "protocol", "useSSLClientAuthentication", "user"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Jolokia
implements Editable<JolokiaBuilder>,
KubernetesResource {
    @JsonProperty(value="CACert")
    @JsonPropertyDescription(value="The PEM encoded CA certification file path, used to verify client certificates, applicable when `protocol` is `https` and `use-ssl-client-authentication` is `true` (default `/var/run/secrets/kubernetes.io/serviceaccount/service-ca.crt` for OpenShift).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String CACert;
    @JsonProperty(value="clientPrincipal")
    @JsonPropertyDescription(value="The principal(s) which must be given in a client certificate to allow access to the Jolokia endpoint, applicable when `protocol` is `https` and `use-ssl-client-authentication` is `true` (default `clientPrincipal=cn=system:master-proxy`, `cn=hawtio-online.hawtio.svc` and `cn=fuse-console.fuse.svc` for OpenShift).")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> clientPrincipal;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="discoveryEnabled")
    @JsonPropertyDescription(value="Listen for multicast requests (default `false`)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean discoveryEnabled;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Can be used to enable or disable a trait. All traits share this common property.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="extendedClientCheck")
    @JsonPropertyDescription(value="Mandate the client certificate contains a client flag in the extended key usage section, applicable when `protocol` is `https` and `use-ssl-client-authentication` is `true` (default `true` for OpenShift).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean extendedClientCheck;
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="The Host address to which the Jolokia agent should bind to. If `\"\\*\"` or `\"0.0.0.0\"` is given, the servers binds to every network interface (default `\"*\"`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String host;
    @JsonProperty(value="options")
    @JsonPropertyDescription(value="A list of additional Jolokia options as defined in https://jolokia.org/reference/html/agents.html#agent-jvm-config[JVM agent configuration options]")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> options;
    @JsonProperty(value="password")
    @JsonPropertyDescription(value="The password used for authentication, applicable when the `user` option is set.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String password;
    @JsonProperty(value="port")
    @JsonPropertyDescription(value="The Jolokia endpoint port (default `8778`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long port;
    @JsonProperty(value="protocol")
    @JsonPropertyDescription(value="The protocol to use, either `http` or `https` (default `https` for OpenShift)")
    @JsonSetter(nulls=Nulls.SKIP)
    private String protocol;
    @JsonProperty(value="useSSLClientAuthentication")
    @JsonPropertyDescription(value="Whether client certificates should be used for authentication (default `true` for OpenShift).")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean useSSLClientAuthentication;
    @JsonProperty(value="user")
    @JsonPropertyDescription(value="The user to be used for authentication")
    @JsonSetter(nulls=Nulls.SKIP)
    private String user;

    public JolokiaBuilder edit() {
        return new JolokiaBuilder(this);
    }

    public String getCACert() {
        return this.CACert;
    }

    public void setCACert(String CACert) {
        this.CACert = CACert;
    }

    public List<String> getClientPrincipal() {
        return this.clientPrincipal;
    }

    public void setClientPrincipal(List<String> clientPrincipal) {
        this.clientPrincipal = clientPrincipal;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    public void setDiscoveryEnabled(Boolean discoveryEnabled) {
        this.discoveryEnabled = discoveryEnabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getExtendedClientCheck() {
        return this.extendedClientCheck;
    }

    public void setExtendedClientCheck(Boolean extendedClientCheck) {
        this.extendedClientCheck = extendedClientCheck;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Long getPort() {
        return this.port;
    }

    public void setPort(Long port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Boolean getUseSSLClientAuthentication() {
        return this.useSSLClientAuthentication;
    }

    public void setUseSSLClientAuthentication(Boolean useSSLClientAuthentication) {
        this.useSSLClientAuthentication = useSSLClientAuthentication;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String toString() {
        return "Jolokia(CACert=" + this.getCACert() + ", clientPrincipal=" + this.getClientPrincipal() + ", configuration=" + this.getConfiguration() + ", discoveryEnabled=" + this.getDiscoveryEnabled() + ", enabled=" + this.getEnabled() + ", extendedClientCheck=" + this.getExtendedClientCheck() + ", host=" + this.getHost() + ", options=" + this.getOptions() + ", password=" + this.getPassword() + ", port=" + this.getPort() + ", protocol=" + this.getProtocol() + ", useSSLClientAuthentication=" + this.getUseSSLClientAuthentication() + ", user=" + this.getUser() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Jolokia)) {
            return false;
        }
        Jolokia other = (Jolokia)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$discoveryEnabled = this.getDiscoveryEnabled();
        Boolean other$discoveryEnabled = other.getDiscoveryEnabled();
        if (this$discoveryEnabled == null ? other$discoveryEnabled != null : !((Object)this$discoveryEnabled).equals(other$discoveryEnabled)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$extendedClientCheck = this.getExtendedClientCheck();
        Boolean other$extendedClientCheck = other.getExtendedClientCheck();
        if (this$extendedClientCheck == null ? other$extendedClientCheck != null : !((Object)this$extendedClientCheck).equals(other$extendedClientCheck)) {
            return false;
        }
        Long this$port = this.getPort();
        Long other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Boolean this$useSSLClientAuthentication = this.getUseSSLClientAuthentication();
        Boolean other$useSSLClientAuthentication = other.getUseSSLClientAuthentication();
        if (this$useSSLClientAuthentication == null ? other$useSSLClientAuthentication != null : !((Object)this$useSSLClientAuthentication).equals(other$useSSLClientAuthentication)) {
            return false;
        }
        String this$CACert = this.getCACert();
        String other$CACert = other.getCACert();
        if (this$CACert == null ? other$CACert != null : !this$CACert.equals(other$CACert)) {
            return false;
        }
        List<String> this$clientPrincipal = this.getClientPrincipal();
        List<String> other$clientPrincipal = other.getClientPrincipal();
        if (this$clientPrincipal == null ? other$clientPrincipal != null : !((Object)this$clientPrincipal).equals(other$clientPrincipal)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        List<String> this$options = this.getOptions();
        List<String> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Jolokia;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $discoveryEnabled = this.getDiscoveryEnabled();
        result = result * 59 + ($discoveryEnabled == null ? 43 : ((Object)$discoveryEnabled).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $extendedClientCheck = this.getExtendedClientCheck();
        result = result * 59 + ($extendedClientCheck == null ? 43 : ((Object)$extendedClientCheck).hashCode());
        Long $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Boolean $useSSLClientAuthentication = this.getUseSSLClientAuthentication();
        result = result * 59 + ($useSSLClientAuthentication == null ? 43 : ((Object)$useSSLClientAuthentication).hashCode());
        String $CACert = this.getCACert();
        result = result * 59 + ($CACert == null ? 43 : $CACert.hashCode());
        List<String> $clientPrincipal = this.getClientPrincipal();
        result = result * 59 + ($clientPrincipal == null ? 43 : ((Object)$clientPrincipal).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        List<String> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }
}

