/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.EtchedLineBorder;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsConstraint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;

public class InstallerFrame
extends JFrame {
    public LocaleDatabase langpack;
    protected InstallData installdata;
    public IconsDatabase icons;
    protected JPanel panelsContainer;
    protected JPanel contentPane;
    protected JButton prevButton;
    protected JButton nextButton;
    protected JButton quitButton;
    private JLabel madewithLabel;

    public InstallerFrame(String string, InstallData installData) throws Exception {
        super(string);
        this.installdata = installData;
        this.langpack = installData.langpack;
        this.addWindowListener(new WindowHandler());
        this.loadIcons();
        this.loadPanels();
        this.buildGUI();
        this.showFrame();
        this.switchPanel(0);
    }

    private void loadPanels() throws Exception {
        List list = this.installdata.panelsOrder;
        int n = list.size();
        Class[] classArray = new Class[]{Class.forName("com.izforge.izpack.installer.InstallerFrame"), Class.forName("com.izforge.izpack.installer.InstallData")};
        Object[] objectArray = new Object[]{this, this.installdata};
        for (int i = 0; i < n; ++i) {
            Panel panel = (Panel)list.get(i);
            if (!OsConstraint.oneMatchesCurrentSystem(panel.osConstraints)) continue;
            String string = panel.className;
            Class<?> clazz = Class.forName("com.izforge.izpack.panels." + string);
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            Object obj = constructor.newInstance(objectArray);
            IzPanel izPanel = (IzPanel)obj;
            this.installdata.panels.add(izPanel);
            XMLElement xMLElement = new XMLElement(string);
            this.installdata.xmlData.addChild(xMLElement);
        }
    }

    private void loadIcons() throws Exception {
        ImageIcon imageIcon;
        URL uRL;
        XMLElement xMLElement;
        int n;
        this.icons = new IconsDatabase();
        InputStream inputStream = this.getClass().getResourceAsStream("/com/izforge/izpack/installer/icons.xml");
        StdXMLParser stdXMLParser = new StdXMLParser();
        stdXMLParser.setBuilder(new StdXMLBuilder());
        stdXMLParser.setReader(new StdXMLReader(inputStream));
        stdXMLParser.setValidator(new NonValidator());
        XMLElement xMLElement2 = (XMLElement)stdXMLParser.parse();
        Vector vector = xMLElement2.getChildrenNamed("icon");
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            xMLElement = (XMLElement)vector.get(n);
            uRL = this.getClass().getResource(xMLElement.getAttribute("res"));
            imageIcon = new ImageIcon(uRL);
            this.icons.put(xMLElement.getAttribute("id"), imageIcon);
        }
        vector = xMLElement2.getChildrenNamed("sysicon");
        n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            xMLElement = (XMLElement)vector.get(n);
            uRL = this.getClass().getResource(xMLElement.getAttribute("res"));
            imageIcon = new ImageIcon(uRL);
            UIManager.put(xMLElement.getAttribute("id"), imageIcon);
        }
    }

    private void buildGUI() {
        this.setIconImage(this.icons.getImageIcon("JFrameIcon").getImage());
        JPanel jPanel = (JPanel)this.getGlassPane();
        jPanel.addMouseListener(new MouseAdapter(){});
        jPanel.addMouseMotionListener(new MouseMotionAdapter(){});
        jPanel.addKeyListener(new KeyAdapter(){});
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.panelsContainer = new JPanel();
        this.panelsContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.panelsContainer.setLayout(new GridLayout(1, 1));
        this.contentPane.add((Component)this.panelsContainer, "Center");
        this.installdata.curPanelNumber = 0;
        IzPanel izPanel = (IzPanel)this.installdata.panels.get(0);
        this.panelsContainer.add(izPanel);
        NavigationHandler navigationHandler = new NavigationHandler();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createTitledBorder(new EtchedLineBorder(), this.langpack.getString("installer.madewith") + " ")));
        jPanel2.add(Box.createHorizontalGlue());
        this.prevButton = ButtonFactory.createButton(this.langpack.getString("installer.prev"), this.icons.getImageIcon("stepback"), this.installdata.buttonsHColor);
        jPanel2.add(this.prevButton);
        this.prevButton.addActionListener(navigationHandler);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        this.nextButton = ButtonFactory.createButton(this.langpack.getString("installer.next"), this.icons.getImageIcon("stepforward"), this.installdata.buttonsHColor);
        jPanel2.add(this.nextButton);
        this.nextButton.addActionListener(navigationHandler);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        this.quitButton = ButtonFactory.createButton(this.langpack.getString("installer.quit"), this.icons.getImageIcon("stop"), this.installdata.buttonsHColor);
        jPanel2.add(this.quitButton);
        this.quitButton.addActionListener(navigationHandler);
        this.contentPane.add((Component)jPanel2, "South");
        try {
            ResourceManager resourceManager = ResourceManager.getInstance();
            ImageIcon imageIcon = resourceManager.getImageIconResource("Installer.image");
            if (imageIcon != null) {
                JPanel jPanel3 = new JPanel();
                jPanel3.setLayout(new BorderLayout());
                jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
                JLabel jLabel = new JLabel(imageIcon);
                jLabel.setBorder(BorderFactory.createLoweredBevelBorder());
                jPanel3.add((Component)jLabel, "Center");
                this.contentPane.add((Component)jPanel3, "West");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getRootPane().setDefaultButton(this.nextButton);
    }

    private void showFrame() {
        this.pack();
        this.setSize(this.installdata.guiPrefs.width, this.installdata.guiPrefs.height);
        this.setResizable(this.installdata.guiPrefs.resizable);
        this.centerFrame(this);
        this.setVisible(true);
    }

    protected void switchPanel(int n) {
        this.panelsContainer.setVisible(false);
        IzPanel izPanel = (IzPanel)this.installdata.panels.get(this.installdata.curPanelNumber);
        IzPanel izPanel2 = (IzPanel)this.installdata.panels.get(n);
        izPanel2.makeXMLData(this.installdata.xmlData.getChildAtIndex(n));
        this.panelsContainer.remove(izPanel2);
        this.panelsContainer.add(izPanel);
        if (this.installdata.curPanelNumber == 0) {
            this.prevButton.setVisible(false);
            this.lockPrevButton();
            this.unlockNextButton();
        } else if (this.installdata.curPanelNumber == this.installdata.panels.size() - 1) {
            this.prevButton.setVisible(false);
            this.nextButton.setVisible(false);
            this.lockNextButton();
        } else {
            this.prevButton.setVisible(true);
            this.nextButton.setVisible(true);
            this.unlockPrevButton();
            this.unlockNextButton();
        }
        izPanel2.panelDeactivate();
        izPanel.panelActivate();
        this.panelsContainer.setVisible(true);
    }

    private void writeUninstallData() {
        try {
            UninstallData uninstallData = UninstallData.getInstance();
            List list = uninstallData.getFilesList();
            ZipOutputStream zipOutputStream = this.installdata.uninstallOutJar;
            if (zipOutputStream == null) {
                return;
            }
            zipOutputStream.putNextEntry(new ZipEntry("install.log"));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
            bufferedWriter.write(this.installdata.getInstallPath());
            bufferedWriter.newLine();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                bufferedWriter.write((String)iterator.next());
                if (!iterator.hasNext()) continue;
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("jarlocation.log"));
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
            bufferedWriter.write(uninstallData.getUninstallerJarFilename());
            bufferedWriter.newLine();
            bufferedWriter.write(uninstallData.getUninstallerPath());
            bufferedWriter.flush();
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("executables"));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(zipOutputStream);
            iterator = uninstallData.getExecutablesList().iterator();
            objectOutputStream.writeInt(uninstallData.getExecutablesList().size());
            while (iterator.hasNext()) {
                ExecutableFile executableFile = (ExecutableFile)iterator.next();
                objectOutputStream.writeObject(executableFile);
            }
            objectOutputStream.flush();
            zipOutputStream.closeEntry();
            zipOutputStream.flush();
            zipOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public InputStream getResource(String string) {
        try {
            return ResourceManager.getInstance().getInputStream(string);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return null;
        }
    }

    public void centerFrame(Window window) {
        Dimension dimension = window.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        window.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2 - 10);
    }

    public Dimension getPanelsContainerSize() {
        return this.panelsContainer.getSize();
    }

    public void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    public void exit() {
        if (this.installdata.canClose) {
            if (this.installdata.info.getWriteUninstaller()) {
                this.writeUninstallData();
            }
            Housekeeper.getInstance().shutDown(0);
        } else {
            int n = JOptionPane.showConfirmDialog(this, this.langpack.getString("installer.quit.message"), this.langpack.getString("installer.quit.title"), 0);
            if (n == 0) {
                this.wipeAborted();
                Housekeeper.getInstance().shutDown(0);
            }
        }
    }

    protected void wipeAborted() {
        Object object;
        ArrayList arrayList = Unpacker.getRunningInstances();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (Thread)iterator.next();
            ((Thread)object).interrupt();
            try {
                Thread.sleep(3000L, 0);
            }
            catch (Exception exception) {}
        }
        object = UninstallData.getInstance();
        iterator = ((UninstallData)object).getFilesList().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            File file = new File(string);
            file.delete();
        }
        this.cleanWipe(new File(this.installdata.getInstallPath()));
    }

    private void cleanWipe(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                this.cleanWipe(fileArray[i]);
            }
        }
        file.delete();
    }

    public void install(AbstractUIProgressHandler abstractUIProgressHandler) {
        Unpacker unpacker = new Unpacker(this.installdata, abstractUIProgressHandler);
        unpacker.start();
    }

    public void writeXMLTree(XMLElement xMLElement, OutputStream outputStream) throws Exception {
        XMLWriter xMLWriter = new XMLWriter(outputStream);
        xMLWriter.write(xMLElement);
    }

    public void blockGUI() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        this.getGlassPane().setEnabled(true);
    }

    public void releaseGUI() {
        this.getGlassPane().setEnabled(false);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void lockPrevButton() {
        this.prevButton.setEnabled(false);
    }

    public void lockNextButton() {
        this.nextButton.setEnabled(false);
    }

    public void unlockPrevButton() {
        this.prevButton.setEnabled(true);
    }

    public void unlockNextButton() {
        this.nextButton.setEnabled(true);
        this.nextButton.requestFocus();
    }

    public void skipPanel() {
        if (this.installdata.curPanelNumber < this.installdata.panels.size() - 1) {
            ++this.installdata.curPanelNumber;
            this.switchPanel(this.installdata.curPanelNumber - 1);
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (!InstallerFrame.this.installdata.canClose) {
                JOptionPane.showMessageDialog(null, InstallerFrame.this.langpack.getString("installer.quit.message"), InstallerFrame.this.langpack.getString("installer.warning"), 0);
            }
            InstallerFrame.this.wipeAborted();
            Housekeeper.getInstance().shutDown(0);
        }
    }

    class NavigationHandler
    implements ActionListener {
        NavigationHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == InstallerFrame.this.prevButton) {
                if (InstallerFrame.this.installdata.curPanelNumber > 0) {
                    --InstallerFrame.this.installdata.curPanelNumber;
                    InstallerFrame.this.switchPanel(InstallerFrame.this.installdata.curPanelNumber + 1);
                }
            } else if (object == InstallerFrame.this.nextButton) {
                if (InstallerFrame.this.installdata.curPanelNumber < InstallerFrame.this.installdata.panels.size() - 1 && ((IzPanel)InstallerFrame.this.installdata.panels.get(InstallerFrame.this.installdata.curPanelNumber)).isValidated()) {
                    ++InstallerFrame.this.installdata.curPanelNumber;
                    InstallerFrame.this.switchPanel(InstallerFrame.this.installdata.curPanelNumber - 1);
                }
            } else if (object == InstallerFrame.this.quitButton) {
                InstallerFrame.this.exit();
            }
        }
    }
}

