/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.CompileHandler;
import com.izforge.izpack.installer.CompileResult;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.VariableSubstitutor;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsConstraint;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;

public class CompileWorker
implements Runnable {
    private ArrayList jobs;
    private static final String SPEC_RESOURCE_NAME = "CompilePanel.Spec.xml";
    private VariableSubstitutor vs;
    private Thread compilationThread;
    private XMLElement spec;
    private AutomatedInstallData idata;
    private CompileHandler handler;
    private XMLElement compilerSpec;
    private ArrayList compilerList;
    private String compilerToUse;
    private XMLElement compilerArgumentsSpec;
    private ArrayList compilerArgumentsList;
    private String compilerArgumentsToUse;
    private CompileResult result = null;

    public CompileWorker(AutomatedInstallData automatedInstallData, CompileHandler compileHandler) throws IOException {
        this.idata = automatedInstallData;
        this.handler = compileHandler;
        this.vs = new VariableSubstitutor(automatedInstallData.getVariableValueMap());
        this.compilationThread = null;
        if (!this.readSpec()) {
            throw new IOException("Error reading compilation specification");
        }
    }

    public ArrayList getAvailableCompilers() {
        this.readChoices(this.compilerSpec, this.compilerList);
        return this.compilerList;
    }

    public void setCompiler(String string) {
        this.compilerToUse = string;
    }

    public String getCompiler() {
        return this.compilerToUse;
    }

    public ArrayList getAvailableArguments() {
        this.readChoices(this.compilerArgumentsSpec, this.compilerArgumentsList);
        return this.compilerArgumentsList;
    }

    public void setCompilerArguments(String string) {
        this.compilerArgumentsToUse = string;
    }

    public String getCompilerArguments() {
        return this.compilerArgumentsToUse;
    }

    public CompileResult getResult() {
        return this.result;
    }

    public void startThread() {
        this.compilationThread = new Thread((Runnable)this, "compilation thread");
        this.compilationThread.start();
    }

    public void run() {
        try {
            if (!this.collectJobs()) {
                String[] stringArray = new String[]{"no command"};
                this.result = new CompileResult(this.idata.langpack.getString("CompilePanel.worker.nofiles"), stringArray, "", "");
            } else {
                this.result = this.compileJobs();
            }
        }
        catch (Exception exception) {
            this.result = new CompileResult();
            this.result.setStatus(23);
            this.result.setAction(27);
        }
        this.handler.stopAction();
    }

    private boolean readSpec() {
        InputStream inputStream;
        try {
            inputStream = ResourceManager.getInstance().getInputStream(SPEC_RESOURCE_NAME);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        StdXMLParser stdXMLParser = new StdXMLParser();
        stdXMLParser.setBuilder(new StdXMLBuilder());
        stdXMLParser.setValidator(new NonValidator());
        try {
            stdXMLParser.setReader(new StdXMLReader(inputStream));
            this.spec = (XMLElement)stdXMLParser.parse();
        }
        catch (Exception exception) {
            System.out.println("Error parsing XML specification for compilation.");
            exception.printStackTrace();
            return false;
        }
        if (!this.spec.hasChildren()) {
            return false;
        }
        this.compilerArgumentsList = new ArrayList();
        this.compilerList = new ArrayList();
        XMLElement xMLElement = this.spec.getFirstChildNamed("global");
        if (xMLElement != null) {
            this.compilerSpec = xMLElement.getFirstChildNamed("compiler");
            if (this.compilerSpec != null) {
                this.readChoices(this.compilerSpec, this.compilerList);
            }
            this.compilerArgumentsSpec = xMLElement.getFirstChildNamed("arguments");
            if (this.compilerArgumentsSpec != null) {
                this.readChoices(this.compilerArgumentsSpec, this.compilerArgumentsList);
            }
        }
        if (this.compilerList.size() == 0) {
            this.compilerList.add("javac");
            this.compilerList.add("jikes");
        }
        if (this.compilerArgumentsList.size() == 0) {
            this.compilerArgumentsList.add("-O -g:none");
            this.compilerArgumentsList.add("-O");
            this.compilerArgumentsList.add("-g");
            this.compilerArgumentsList.add("");
        }
        return true;
    }

    private void readChoices(XMLElement xMLElement, ArrayList arrayList) {
        Vector vector = xMLElement.getChildrenNamed("choice");
        if (vector == null) {
            return;
        }
        arrayList.clear();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            List list;
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string = xMLElement2.getAttribute("value");
            if (string == null || !OsConstraint.oneMatchesCurrentSystem(list = OsConstraint.getOsList(xMLElement2))) continue;
            arrayList.add(this.vs.substitute(string, "plain"));
        }
    }

    private boolean collectJobs() throws Exception {
        XMLElement xMLElement = this.spec.getFirstChildNamed("jobs");
        if (xMLElement == null) {
            return false;
        }
        ArrayList arrayList = new ArrayList();
        this.jobs = new ArrayList();
        this.collectJobsRecursive(xMLElement, arrayList);
        return true;
    }

    private CompileResult compileJobs() {
        CompilationJob compilationJob;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.compilerArgumentsToUse);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        Iterator iterator = this.jobs.iterator();
        this.handler.startAction("Compilation", this.jobs.size());
        if (iterator.hasNext() && !((CompileResult)(object = (compilationJob = (CompilationJob)this.jobs.get(0)).checkCompiler(this.compilerToUse, arrayList))).isContinue()) {
            return object;
        }
        int n = 0;
        while (iterator.hasNext()) {
            object = (CompilationJob)iterator.next();
            this.handler.nextStep(((CompilationJob)object).getName(), ((CompilationJob)object).getSize(), n++);
            CompileResult compileResult = ((CompilationJob)object).perform(this.compilerToUse, arrayList);
            if (compileResult.isContinue()) continue;
            return compileResult;
        }
        Debug.trace("compilation finished.");
        return new CompileResult();
    }

    private CompilationJob collectJobsRecursive(XMLElement xMLElement, ArrayList arrayList) throws Exception {
        Enumeration enumeration = xMLElement.enumerateChildren();
        ArrayList arrayList2 = (ArrayList)arrayList.clone();
        ArrayList<File> arrayList3 = new ArrayList<File>();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            if (xMLElement2.getName().equals("classpath")) {
                this.changeClassPath(arrayList2, xMLElement2);
                continue;
            }
            if (xMLElement2.getName().equals("job")) {
                object2 = this.collectJobsRecursive(xMLElement2, arrayList2);
                if (object2 == null) continue;
                this.jobs.add(object2);
                continue;
            }
            if (xMLElement2.getName().equals("directory")) {
                object2 = xMLElement2.getAttribute("name");
                if (object2 == null) continue;
                object = this.vs.substitute((String)object2, "plain");
                arrayList3.addAll(this.scanDirectory(new File((String)object)));
                continue;
            }
            if (xMLElement2.getName().equals("file")) {
                object2 = xMLElement2.getAttribute("name");
                if (object2 == null) continue;
                object = this.vs.substitute((String)object2, "plain");
                arrayList3.add(new File((String)object));
                continue;
            }
            if (!xMLElement2.getName().equals("packdepency")) continue;
            object2 = xMLElement2.getAttribute("name");
            if (object2 == null) {
                System.out.println("invalid compilation spec: <packdepency> without name attribute");
                return null;
            }
            object = this.idata.selectedPacks.iterator();
            boolean bl = false;
            while (object.hasNext()) {
                Pack pack = (Pack)object.next();
                if (!pack.name.equals(object2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            Debug.trace("skipping job because pack " + (String)object2 + " was not selected.");
            return null;
        }
        if (arrayList3.size() > 0) {
            return new CompilationJob(this.handler, this.idata.langpack, xMLElement.getAttribute("name"), arrayList3, arrayList2);
        }
        return null;
    }

    private void changeClassPath(ArrayList arrayList, XMLElement xMLElement) throws Exception {
        String string;
        String string2 = xMLElement.getAttribute("add");
        if (string2 != null) {
            if (!new File(string2 = this.vs.substitute(string2, "plain")).exists()) {
                if (!this.handler.emitWarning("Invalid classpath", "The path " + string2 + " could not be found.\nCompilation may fail.")) {
                    throw new Exception("Classpath " + string2 + " does not exist.");
                }
            } else {
                arrayList.add(this.vs.substitute(string2, "plain"));
            }
        }
        if ((string = xMLElement.getAttribute("sub")) != null) {
            int n = -1;
            string = this.vs.substitute(string, "plain");
            do {
                n = arrayList.indexOf(string);
                arrayList.remove(n);
            } while (n >= 0);
        }
    }

    private ArrayList scanDirectory(File file) {
        Debug.trace("scanning directory " + file.getAbsolutePath());
        ArrayList<File> arrayList = new ArrayList<File>();
        if (!file.isDirectory()) {
            return arrayList;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2 == null) continue;
            if (file2.isDirectory()) {
                arrayList.addAll(this.scanDirectory(file2));
                continue;
            }
            if (!file2.isFile() || !file2.getName().toLowerCase().endsWith(".java")) continue;
            arrayList.add(file2);
        }
        return arrayList;
    }

    private class CompilationJob {
        private CompileHandler listener;
        private String name;
        private ArrayList files;
        private ArrayList classpath;
        private LocaleDatabase langpack;
        private static final int MAX_CMDLINE_SIZE = 4096;

        public CompilationJob(CompileHandler compileHandler, LocaleDatabase localeDatabase, ArrayList arrayList, ArrayList arrayList2) {
            this.listener = compileHandler;
            this.langpack = localeDatabase;
            this.name = null;
            this.files = arrayList;
            this.classpath = arrayList2;
        }

        public CompilationJob(CompileHandler compileHandler, LocaleDatabase localeDatabase, String string, ArrayList arrayList, ArrayList arrayList2) {
            this.listener = compileHandler;
            this.langpack = localeDatabase;
            this.name = string;
            this.files = arrayList;
            this.classpath = arrayList2;
        }

        public String getName() {
            if (this.name != null) {
                return this.name;
            }
            return "";
        }

        public int getSize() {
            return this.files.size();
        }

        public CompileResult perform(String string, ArrayList arrayList) {
            String[] stringArray;
            String[] stringArray2;
            String string2;
            Debug.trace("starting job " + this.name);
            int n = 0;
            LinkedList<String> linkedList = new LinkedList<String>(arrayList);
            Object object = linkedList.iterator();
            while (object.hasNext()) {
                n += ((String)object.next()).length() + 1;
            }
            linkedList.add(0, string);
            n += string.length() + 1;
            object = new StringBuffer();
            Iterator iterator = this.classpath.iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                if (((StringBuffer)object).length() > 0) {
                    ((StringBuffer)object).append(File.pathSeparatorChar);
                }
                ((StringBuffer)object).append(new File(string2).getAbsolutePath());
            }
            string2 = ((StringBuffer)object).toString();
            if (string2.length() > 0) {
                linkedList.add("-classpath");
                n += 11;
                linkedList.add(string2);
                n += string2.length() + 1;
            }
            int n2 = linkedList.size();
            int n3 = n;
            FileExecutor fileExecutor = new FileExecutor();
            String[] stringArray3 = new String[2];
            String string3 = "";
            int n4 = 0;
            int n5 = 0;
            Iterator iterator2 = this.files.iterator();
            while (iterator2.hasNext()) {
                Object object2;
                stringArray2 = (String[])iterator2.next();
                String string4 = stringArray2.getAbsolutePath();
                Debug.trace("processing " + string4);
                ++n4;
                string3 = string3 + stringArray2.getName() + " ";
                linkedList.add(string4);
                if ((n += string4.length()) < 4096) continue;
                Debug.trace("compiling " + string3);
                this.listener.progress(n5, string3);
                n5 = n4;
                stringArray = linkedList.toArray(stringArray3);
                int n6 = fileExecutor.executeCommand(stringArray, stringArray3);
                this.listener.progress(n4, string3);
                if (n6 != 0) {
                    object2 = new CompileResult(this.langpack.getString("CompilePanel.error"), stringArray, stringArray3[0], stringArray3[1]);
                    this.listener.handleCompileError((CompileResult)object2);
                    if (!((CompileResult)object2).isContinue()) {
                        return object2;
                    }
                } else {
                    object2 = linkedList.listIterator(n2);
                    while (object2.hasNext()) {
                        File file = new File((String)object2.next());
                        String string5 = file.getName();
                        int n7 = string5.lastIndexOf(46);
                        string5 = string5.substring(0, n7) + ".class";
                        File file2 = new File(file.getParentFile(), string5);
                        if (file2.exists()) continue;
                        CompileResult compileResult = new CompileResult(this.langpack.getString("CompilePanel.error.noclassfile") + file.getAbsolutePath(), stringArray, stringArray3[0], stringArray3[1]);
                        this.listener.handleCompileError(compileResult);
                        if (compileResult.isContinue()) break;
                        return compileResult;
                    }
                }
                for (int i = linkedList.size() - 1; i >= n2; --i) {
                    linkedList.removeLast();
                }
                n = n3;
                string3 = "";
            }
            if (n > n3) {
                this.listener.progress(n5, string3);
                stringArray2 = linkedList.toArray(stringArray3);
                int n8 = fileExecutor.executeCommand(stringArray2, stringArray3);
                this.listener.progress(n4, string3);
                if (n8 != 0) {
                    stringArray = new CompileResult(this.langpack.getString("CompilePanel.error"), stringArray2, stringArray3[0], stringArray3[1]);
                    this.listener.handleCompileError((CompileResult)stringArray);
                    if (!stringArray.isContinue()) {
                        return stringArray;
                    }
                }
            }
            Debug.trace("job " + this.name + " done (" + n4 + " files compiled)");
            return new CompileResult();
        }

        public CompileResult checkCompiler(String string, ArrayList arrayList) {
            String[] stringArray;
            String string2;
            Object object;
            int n = 0;
            FileExecutor fileExecutor = new FileExecutor();
            String[] stringArray2 = new String[2];
            Debug.trace("checking whether \"" + string + " -help\" works");
            Object object2 = new String[]{string, "-help"};
            n = fileExecutor.executeCommand((String[])object2, stringArray2);
            if (n != 0) {
                object = new CompileResult(this.langpack.getString("CompilePanel.error.compilernotfound"), (String[])object2, stringArray2[0], stringArray2[1]);
                this.listener.handleCompileError((CompileResult)object);
                if (!((CompileResult)object).isContinue()) {
                    return object;
                }
            }
            Debug.trace("checking whether \"" + string + " -help +arguments\" works");
            object2 = new LinkedList(arrayList);
            ((LinkedList)object2).add(0, "-help");
            ((LinkedList)object2).add(0, string);
            object = new StringBuffer();
            Iterator iterator = this.classpath.iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                if (((StringBuffer)object).length() > 0) {
                    ((StringBuffer)object).append(File.pathSeparatorChar);
                }
                ((StringBuffer)object).append(new File(string2).getAbsolutePath());
            }
            string2 = ((StringBuffer)object).toString();
            if (string2.length() > 0) {
                ((LinkedList)object2).add("-classpath");
                ((LinkedList)object2).add(string2);
            }
            if ((n = fileExecutor.executeCommand(stringArray = ((LinkedList)object2).toArray(stringArray2), stringArray2)) != 0) {
                CompileResult compileResult = new CompileResult(this.langpack.getString("CompilePanel.error.invalidarguments"), stringArray, stringArray2[0], stringArray2[1]);
                this.listener.handleCompileError(compileResult);
                if (!compileResult.isContinue()) {
                    return compileResult;
                }
            }
            return new CompileResult();
        }
    }
}

