/*
 * Decompiled with CFR 0.152.
 */
package sun.tracing;

import com.sun.tracing.Probe;
import java.lang.reflect.Field;

public abstract class ProbeSkeleton
implements Probe {
    protected Class<?>[] parameters;

    protected ProbeSkeleton(Class<?>[] parameters) {
        this.parameters = parameters;
    }

    @Override
    public abstract boolean isEnabled();

    public abstract void uncheckedTrigger(Object[] var1);

    private static boolean isAssignable(Object o, Class<?> formal) {
        if (o != null && !formal.isInstance(o)) {
            if (formal.isPrimitive()) {
                try {
                    Field f = o.getClass().getField("TYPE");
                    return formal.isAssignableFrom((Class)f.get(null));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void trigger(Object ... args) {
        if (args.length != this.parameters.length) {
            throw new IllegalArgumentException("Wrong number of arguments");
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            if (ProbeSkeleton.isAssignable(args[i], this.parameters[i])) continue;
            throw new IllegalArgumentException("Wrong type of argument at position " + i);
        }
        this.uncheckedTrigger(args);
    }
}

