/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class InQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -5801329450358952434L;
    private ValueExp val;
    private ValueExp[] valueList;

    public InQueryExp() {
    }

    public InQueryExp(ValueExp v1, ValueExp[] items) {
        this.val = v1;
        this.valueList = items;
    }

    public ValueExp getCheckedValue() {
        return this.val;
    }

    public ValueExp[] getExplicitValues() {
        return this.valueList;
    }

    @Override
    public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        if (this.valueList != null) {
            ValueExp v = this.val.apply(name);
            boolean numeric = v instanceof NumericValueExp;
            for (ValueExp element : this.valueList) {
                element = element.apply(name);
                if (!(numeric ? ((NumericValueExp)element).doubleValue() == ((NumericValueExp)v).doubleValue() : ((StringValueExp)element).getValue().equals(((StringValueExp)v).getValue()))) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.val + " in (" + this.generateValueList() + ")";
    }

    private String generateValueList() {
        if (this.valueList == null || this.valueList.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(this.valueList[0].toString());
        for (int i = 1; i < this.valueList.length; ++i) {
            result.append(", ");
            result.append(this.valueList[i]);
        }
        return result.toString();
    }
}

