/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSPeriodicWaveOptions.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> ConversionResult<IDLDictionary<PeriodicWaveOptions>> convertDictionary<PeriodicWaveOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    PeriodicWaveOptions result;
    JSValue disableNormalizationValue;
    if (isNullOrUndefined)
        disableNormalizationValue = jsUndefined();
    else {
        disableNormalizationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "disableNormalization"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto disableNormalizationConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, disableNormalizationValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(disableNormalizationConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.disableNormalization = disableNormalizationConversionResult.releaseReturnValue();
    JSValue imagValue;
    if (isNullOrUndefined)
        imagValue = jsUndefined();
    else {
        imagValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "imag"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!imagValue.isUndefined()) {
        auto imagConversionResult = convert<IDLSequence<IDLFloat>>(lexicalGlobalObject, imagValue);
        if (UNLIKELY(imagConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.imag = imagConversionResult.releaseReturnValue();
    }
    JSValue realValue;
    if (isNullOrUndefined)
        realValue = jsUndefined();
    else {
        realValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "real"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!realValue.isUndefined()) {
        auto realConversionResult = convert<IDLSequence<IDLFloat>>(lexicalGlobalObject, realValue);
        if (UNLIKELY(realConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.real = realConversionResult.releaseReturnValue();
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
