/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFontFace.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSFontFace.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(FontFace::LoadStatus enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("unloaded"),
        MAKE_STATIC_STRING_IMPL("loading"),
        MAKE_STATIC_STRING_IMPL("loaded"),
        MAKE_STATIC_STRING_IMPL("error"),
    };
    static_assert(static_cast<size_t>(FontFace::LoadStatus::Unloaded) == 0, "FontFace::LoadStatus::Unloaded is not 0 as expected");
    static_assert(static_cast<size_t>(FontFace::LoadStatus::Loading) == 1, "FontFace::LoadStatus::Loading is not 1 as expected");
    static_assert(static_cast<size_t>(FontFace::LoadStatus::Loaded) == 2, "FontFace::LoadStatus::Loaded is not 2 as expected");
    static_assert(static_cast<size_t>(FontFace::LoadStatus::Error) == 3, "FontFace::LoadStatus::Error is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, FontFace::LoadStatus enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<FontFace::LoadStatus> parseEnumerationFromString<FontFace::LoadStatus>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, FontFace::LoadStatus> mappings[] = {
        { "error", FontFace::LoadStatus::Error },
        { "loaded", FontFace::LoadStatus::Loaded },
        { "loading", FontFace::LoadStatus::Loading },
        { "unloaded", FontFace::LoadStatus::Unloaded },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<FontFace::LoadStatus> parseEnumeration<FontFace::LoadStatus>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<FontFace::LoadStatus>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<FontFace::LoadStatus>()
{
    return "\"unloaded\", \"loading\", \"loaded\", \"error\""_s;
}

template<> ConversionResult<IDLDictionary<FontFace::Descriptors>> convertDictionary<FontFace::Descriptors>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    FontFace::Descriptors result;
    JSValue displayValue;
    if (isNullOrUndefined)
        displayValue = jsUndefined();
    else {
        displayValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "display"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto displayConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, displayValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { "auto"_s }; });
    if (UNLIKELY(displayConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.display = displayConversionResult.releaseReturnValue();
    JSValue featureSettingsValue;
    if (isNullOrUndefined)
        featureSettingsValue = jsUndefined();
    else {
        featureSettingsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "featureSettings"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto featureSettingsConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, featureSettingsValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { "normal"_s }; });
    if (UNLIKELY(featureSettingsConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.featureSettings = featureSettingsConversionResult.releaseReturnValue();
    JSValue sizeAdjustValue;
    if (isNullOrUndefined)
        sizeAdjustValue = jsUndefined();
    else {
        sizeAdjustValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sizeAdjust"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto sizeAdjustConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, sizeAdjustValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { "100%"_s }; });
    if (UNLIKELY(sizeAdjustConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.sizeAdjust = sizeAdjustConversionResult.releaseReturnValue();
    JSValue stretchValue;
    if (isNullOrUndefined)
        stretchValue = jsUndefined();
    else {
        stretchValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stretch"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto stretchConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, stretchValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { "normal"_s }; });
    if (UNLIKELY(stretchConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.stretch = stretchConversionResult.releaseReturnValue();
    JSValue styleValue;
    if (isNullOrUndefined)
        styleValue = jsUndefined();
    else {
        styleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "style"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto styleConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, styleValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { "normal"_s }; });
    if (UNLIKELY(styleConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.style = styleConversionResult.releaseReturnValue();
    JSValue unicodeRangeValue;
    if (isNullOrUndefined)
        unicodeRangeValue = jsUndefined();
    else {
        unicodeRangeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "unicodeRange"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto unicodeRangeConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, unicodeRangeValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { "U+0-10FFFF"_s }; });
    if (UNLIKELY(unicodeRangeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.unicodeRange = unicodeRangeConversionResult.releaseReturnValue();
    JSValue weightValue;
    if (isNullOrUndefined)
        weightValue = jsUndefined();
    else {
        weightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "weight"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto weightConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, weightValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { "normal"_s }; });
    if (UNLIKELY(weightConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.weight = weightConversionResult.releaseReturnValue();
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsFontFacePrototypeFunction_load);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsFontFaceConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsFontFace_family);
static JSC_DECLARE_CUSTOM_SETTER(setJSFontFace_family);
static JSC_DECLARE_CUSTOM_GETTER(jsFontFace_style);
static JSC_DECLARE_CUSTOM_SETTER(setJSFontFace_style);
static JSC_DECLARE_CUSTOM_GETTER(jsFontFace_weight);
static JSC_DECLARE_CUSTOM_SETTER(setJSFontFace_weight);
static JSC_DECLARE_CUSTOM_GETTER(jsFontFace_stretch);
static JSC_DECLARE_CUSTOM_SETTER(setJSFontFace_stretch);
static JSC_DECLARE_CUSTOM_GETTER(jsFontFace_unicodeRange);
static JSC_DECLARE_CUSTOM_SETTER(setJSFontFace_unicodeRange);
static JSC_DECLARE_CUSTOM_GETTER(jsFontFace_featureSettings);
static JSC_DECLARE_CUSTOM_SETTER(setJSFontFace_featureSettings);
static JSC_DECLARE_CUSTOM_GETTER(jsFontFace_display);
static JSC_DECLARE_CUSTOM_SETTER(setJSFontFace_display);
static JSC_DECLARE_CUSTOM_GETTER(jsFontFace_sizeAdjust);
static JSC_DECLARE_CUSTOM_SETTER(setJSFontFace_sizeAdjust);
static JSC_DECLARE_CUSTOM_GETTER(jsFontFace_status);
static JSC_DECLARE_CUSTOM_GETTER(jsFontFace_loaded);

class JSFontFacePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFontFacePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFontFacePrototype* ptr = new (NotNull, JSC::allocateCell<JSFontFacePrototype>(vm)) JSFontFacePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFontFacePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFontFacePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFontFacePrototype, JSFontFacePrototype::Base);

using JSFontFaceDOMConstructor = JSDOMConstructor<JSFontFace>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSFontFaceDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSFontFaceDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "FontFace"_s);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto familyConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(familyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto sourceConversionResult = convert<IDLUnion<IDLDOMString, IDLArrayBuffer, IDLArrayBufferView>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(sourceConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto descriptorsConversionResult = convert<IDLDictionary<FontFace::Descriptors>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(descriptorsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = FontFace::create(*context, familyConversionResult.releaseReturnValue(), sourceConversionResult.releaseReturnValue(), descriptorsConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<FontFace>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<FontFace>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSFontFaceDOMConstructorConstruct, JSFontFaceDOMConstructor::construct);

template<> const ClassInfo JSFontFaceDOMConstructor::s_info = { "FontFace"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFontFaceDOMConstructor) };

template<> JSValue JSFontFaceDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFontFaceDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "FontFace"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSFontFace::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSFontFacePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFaceConstructor, 0 } },
    { "family"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFace_family, setJSFontFace_family } },
    { "style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFace_style, setJSFontFace_style } },
    { "weight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFace_weight, setJSFontFace_weight } },
    { "stretch"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFace_stretch, setJSFontFace_stretch } },
    { "unicodeRange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFace_unicodeRange, setJSFontFace_unicodeRange } },
    { "featureSettings"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFace_featureSettings, setJSFontFace_featureSettings } },
    { "display"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFace_display, setJSFontFace_display } },
    { "sizeAdjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFace_sizeAdjust, setJSFontFace_sizeAdjust } },
    { "status"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFace_status, 0 } },
    { "loaded"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFace_loaded, 0 } },
    { "load"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFontFacePrototypeFunction_load, 0 } },
};

const ClassInfo JSFontFacePrototype::s_info = { "FontFace"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFontFacePrototype) };

void JSFontFacePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFontFace::info(), JSFontFacePrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().cssFontFaceSizeAdjustEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "sizeAdjust"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSFontFace::s_info = { "FontFace"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFontFace) };

JSFontFace::JSFontFace(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FontFace>&& impl)
    : JSDOMWrapper<FontFace>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, FontFace>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSFontFace::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSFontFacePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSFontFacePrototype::create(vm, &globalObject, structure);
}

JSObject* JSFontFace::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFontFace>(vm, globalObject);
}

JSValue JSFontFace::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFontFaceDOMConstructor, DOMConstructorID::FontFace>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSFontFace::destroy(JSC::JSCell* cell)
{
    JSFontFace* thisObject = static_cast<JSFontFace*>(cell);
    thisObject->JSFontFace::~JSFontFace();
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFaceConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFontFacePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFontFace::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsFontFace_familyGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.family())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFace_family, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::get<jsFontFace_familyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSFontFace_familySetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFamily(*context, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSFontFace_family, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::set<setJSFontFace_familySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsFontFace_styleGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.style())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFace_style, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::get<jsFontFace_styleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSFontFace_styleSetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setStyle(*context, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSFontFace_style, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::set<setJSFontFace_styleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsFontFace_weightGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.weight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFace_weight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::get<jsFontFace_weightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSFontFace_weightSetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setWeight(*context, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSFontFace_weight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::set<setJSFontFace_weightSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsFontFace_stretchGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.stretch())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFace_stretch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::get<jsFontFace_stretchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSFontFace_stretchSetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setStretch(*context, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSFontFace_stretch, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::set<setJSFontFace_stretchSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsFontFace_unicodeRangeGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.unicodeRange())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFace_unicodeRange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::get<jsFontFace_unicodeRangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSFontFace_unicodeRangeSetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnicodeRange(*context, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSFontFace_unicodeRange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::set<setJSFontFace_unicodeRangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsFontFace_featureSettingsGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.featureSettings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFace_featureSettings, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::get<jsFontFace_featureSettingsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSFontFace_featureSettingsSetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFeatureSettings(*context, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSFontFace_featureSettings, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::set<setJSFontFace_featureSettingsSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsFontFace_displayGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.display())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFace_display, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::get<jsFontFace_displayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSFontFace_displaySetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setDisplay(*context, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSFontFace_display, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::set<setJSFontFace_displaySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsFontFace_sizeAdjustGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.sizeAdjust())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFace_sizeAdjust, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::get<jsFontFace_sizeAdjustGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSFontFace_sizeAdjustSetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setSizeAdjust(*context, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSFontFace_sizeAdjust, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::set<setJSFontFace_sizeAdjustSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsFontFace_statusGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<FontFace::LoadStatus>>(lexicalGlobalObject, throwScope, impl.status())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFace_status, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::get<jsFontFace_statusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFontFace_loadedGetter(JSGlobalObject& lexicalGlobalObject, JSFontFace& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLPromise<IDLInterface<FontFace>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, [&]() -> decltype(auto) { return impl.loadedForBindings(); })));
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFace_loaded, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFace>::get<jsFontFace_loadedGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsFontFacePrototypeFunction_loadBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFontFace>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<FontFace>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.loadForBindings(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFontFacePrototypeFunction_load, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFontFace>::callReturningOwnPromise<jsFontFacePrototypeFunction_loadBody>(*lexicalGlobalObject, *callFrame, "load");
}

JSC::GCClient::IsoSubspace* JSFontFace::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSFontFace, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForFontFace.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFontFace = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForFontFace.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForFontFace = std::forward<decltype(space)>(space); }
    );
}

void JSFontFace::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFontFace*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSFontFaceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsFontFace = jsCast<JSFontFace*>(handle.slot()->asCell());
    auto& wrapped = jsFontFace->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFontFaceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFontFace = static_cast<JSFontFace*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFontFace->protectedWrapped().ptr(), jsFontFace);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FontFace@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore8FontFaceE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, FontFace>, void>> static inline void verifyVTable(FontFace* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7FontFace@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore8FontFaceE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // FontFace has subclasses. If FontFace has subclasses that get passed
        // to toJS() we currently require FontFace you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<FontFace>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<FontFace>(impl.ptr());
#endif
    return createWrapper<FontFace>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, FontFace& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

FontFace* JSFontFace::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFontFace*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
