/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioBufferSourceOptions.h"

#include "JSAudioBuffer.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> ConversionResult<IDLDictionary<AudioBufferSourceOptions>> convertDictionary<AudioBufferSourceOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    AudioBufferSourceOptions result;
    JSValue bufferValue;
    if (isNullOrUndefined)
        bufferValue = jsUndefined();
    else {
        bufferValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "buffer"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!bufferValue.isUndefined()) {
        auto bufferConversionResult = convert<IDLNullable<IDLInterface<AudioBuffer>>>(lexicalGlobalObject, bufferValue);
        if (UNLIKELY(bufferConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.buffer = bufferConversionResult.releaseReturnValue();
    }
    JSValue detuneValue;
    if (isNullOrUndefined)
        detuneValue = jsUndefined();
    else {
        detuneValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detune"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto detuneConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, detuneValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 0 }; });
    if (UNLIKELY(detuneConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.detune = detuneConversionResult.releaseReturnValue();
    JSValue loopValue;
    if (isNullOrUndefined)
        loopValue = jsUndefined();
    else {
        loopValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "loop"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto loopConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, loopValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(loopConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.loop = loopConversionResult.releaseReturnValue();
    JSValue loopEndValue;
    if (isNullOrUndefined)
        loopEndValue = jsUndefined();
    else {
        loopEndValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "loopEnd"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto loopEndConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, loopEndValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0 }; });
    if (UNLIKELY(loopEndConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.loopEnd = loopEndConversionResult.releaseReturnValue();
    JSValue loopStartValue;
    if (isNullOrUndefined)
        loopStartValue = jsUndefined();
    else {
        loopStartValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "loopStart"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto loopStartConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, loopStartValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0 }; });
    if (UNLIKELY(loopStartConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.loopStart = loopStartConversionResult.releaseReturnValue();
    JSValue playbackRateValue;
    if (isNullOrUndefined)
        playbackRateValue = jsUndefined();
    else {
        playbackRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "playbackRate"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto playbackRateConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, playbackRateValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 1 }; });
    if (UNLIKELY(playbackRateConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.playbackRate = playbackRateConversionResult.releaseReturnValue();
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
