/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAbstractRange.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsAbstractRangeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsAbstractRange_startContainer);
static JSC_DECLARE_CUSTOM_GETTER(jsAbstractRange_startOffset);
static JSC_DECLARE_CUSTOM_GETTER(jsAbstractRange_endContainer);
static JSC_DECLARE_CUSTOM_GETTER(jsAbstractRange_endOffset);
static JSC_DECLARE_CUSTOM_GETTER(jsAbstractRange_collapsed);

class JSAbstractRangePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAbstractRangePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAbstractRangePrototype* ptr = new (NotNull, JSC::allocateCell<JSAbstractRangePrototype>(vm)) JSAbstractRangePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAbstractRangePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAbstractRangePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAbstractRangePrototype, JSAbstractRangePrototype::Base);

using JSAbstractRangeDOMConstructor = JSDOMConstructorNotConstructable<JSAbstractRange>;

template<> const ClassInfo JSAbstractRangeDOMConstructor::s_info = { "AbstractRange"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAbstractRangeDOMConstructor) };

template<> JSValue JSAbstractRangeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSAbstractRangeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "AbstractRange"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSAbstractRange::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSAbstractRangePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsAbstractRangeConstructor, 0 } },
    { "startContainer"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAbstractRange_startContainer, 0 } },
    { "startOffset"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAbstractRange_startOffset, 0 } },
    { "endContainer"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAbstractRange_endContainer, 0 } },
    { "endOffset"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAbstractRange_endOffset, 0 } },
    { "collapsed"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAbstractRange_collapsed, 0 } },
};

const ClassInfo JSAbstractRangePrototype::s_info = { "AbstractRange"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAbstractRangePrototype) };

void JSAbstractRangePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAbstractRange::info(), JSAbstractRangePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSAbstractRange::s_info = { "AbstractRange"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAbstractRange) };

JSAbstractRange::JSAbstractRange(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AbstractRange>&& impl)
    : JSDOMWrapper<AbstractRange>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, AbstractRange>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSAbstractRange::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSAbstractRangePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSAbstractRangePrototype::create(vm, &globalObject, structure);
}

JSObject* JSAbstractRange::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAbstractRange>(vm, globalObject);
}

JSValue JSAbstractRange::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAbstractRangeDOMConstructor, DOMConstructorID::AbstractRange>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSAbstractRange::destroy(JSC::JSCell* cell)
{
    JSAbstractRange* thisObject = static_cast<JSAbstractRange*>(cell);
    thisObject->JSAbstractRange::~JSAbstractRange();
}

JSC_DEFINE_CUSTOM_GETTER(jsAbstractRangeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAbstractRangePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAbstractRange::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsAbstractRange_startContainerGetter(JSGlobalObject& lexicalGlobalObject, JSAbstractRange& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Node>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.startContainer())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAbstractRange_startContainer, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAbstractRange>::get<jsAbstractRange_startContainerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAbstractRange_startOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSAbstractRange& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.startOffset())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAbstractRange_startOffset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAbstractRange>::get<jsAbstractRange_startOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAbstractRange_endContainerGetter(JSGlobalObject& lexicalGlobalObject, JSAbstractRange& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<Node>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.endContainer())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAbstractRange_endContainer, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAbstractRange>::get<jsAbstractRange_endContainerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAbstractRange_endOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSAbstractRange& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.endOffset())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAbstractRange_endOffset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAbstractRange>::get<jsAbstractRange_endOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAbstractRange_collapsedGetter(JSGlobalObject& lexicalGlobalObject, JSAbstractRange& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.collapsed())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAbstractRange_collapsed, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAbstractRange>::get<jsAbstractRange_collapsedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSAbstractRange::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSAbstractRange, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForAbstractRange.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForAbstractRange = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForAbstractRange.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForAbstractRange = std::forward<decltype(space)>(space); }
    );
}

void JSAbstractRange::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAbstractRange*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSAbstractRangeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSAbstractRangeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAbstractRange = static_cast<JSAbstractRange*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsAbstractRange->protectedWrapped().ptr(), jsAbstractRange);
}

AbstractRange* JSAbstractRange::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAbstractRange*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
