# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_nethsm_global_optspecs
	string join \n a/auth-passphrase-file= c/config= l/label= u/user= h/help V/version
end

function __fish_nethsm_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_nethsm_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_nethsm_using_subcommand
	set -l cmd (__fish_nethsm_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c nethsm -n "__fish_nethsm_needs_command" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_needs_command" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_needs_command" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_needs_command" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_needs_command" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_needs_command" -s V -l version -d 'Print version'
complete -c nethsm -n "__fish_nethsm_needs_command" -f -a "config" -d 'Manage the configuration of a device'
complete -c nethsm -n "__fish_nethsm_needs_command" -f -a "env" -d 'Manage environments in the configuration file'
complete -c nethsm -n "__fish_nethsm_needs_command" -f -a "health" -d 'Retrieve health information for a device'
complete -c nethsm -n "__fish_nethsm_needs_command" -f -a "info" -d 'Retrieve the info for a device'
complete -c nethsm -n "__fish_nethsm_needs_command" -f -a "key" -d 'Operate on the keys of a device'
complete -c nethsm -n "__fish_nethsm_needs_command" -f -a "lock" -d 'Lock a device'
complete -c nethsm -n "__fish_nethsm_needs_command" -f -a "metrics" -d 'Get metrics'
complete -c nethsm -n "__fish_nethsm_needs_command" -f -a "namespace" -d 'Operate on namespaces of a device'
complete -c nethsm -n "__fish_nethsm_needs_command" -f -a "openpgp" -d 'OpenPGP operations'
complete -c nethsm -n "__fish_nethsm_needs_command" -f -a "provision" -d 'Provision a device'
complete -c nethsm -n "__fish_nethsm_needs_command" -f -a "random" -d 'Get random bytes from a device'
complete -c nethsm -n "__fish_nethsm_needs_command" -f -a "system" -d 'Do system actions for a device'
complete -c nethsm -n "__fish_nethsm_needs_command" -f -a "unlock" -d 'Unlock a device'
complete -c nethsm -n "__fish_nethsm_needs_command" -f -a "user" -d 'Operate on users of a device'
complete -c nethsm -n "__fish_nethsm_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and not __fish_seen_subcommand_from get set help" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and not __fish_seen_subcommand_from get set help" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and not __fish_seen_subcommand_from get set help" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and not __fish_seen_subcommand_from get set help" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and not __fish_seen_subcommand_from get set help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and not __fish_seen_subcommand_from get set help" -f -a "get" -d 'Get a configuration item for a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and not __fish_seen_subcommand_from get set help" -f -a "set" -d 'Set a configuration item for a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and not __fish_seen_subcommand_from get set help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from get" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from get" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from get" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from get" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from get" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from get" -f -a "boot-mode" -d 'Get the unattended boot configuration'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from get" -f -a "logging" -d 'Get the logging configuration'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from get" -f -a "network" -d 'Get the network configuration'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from get" -f -a "time" -d 'Get the time'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from get" -f -a "tls-certificate" -d 'Get the certificate for the TLS connection'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from get" -f -a "tls-csr" -d 'Get a Certificate Signing Request for the TLS certificate'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from get" -f -a "tls-public-key" -d 'Get the public key for the TLS connection'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from get" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from set" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from set" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from set" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from set" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from set" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from set" -f -a "backup-passphrase" -d 'Set the backup passphrase'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from set" -f -a "boot-mode" -d 'Set the unattended boot mode'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from set" -f -a "logging" -d 'Set the logging configuration'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from set" -f -a "network" -d 'Set the network configuration'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from set" -f -a "time" -d 'Set the time'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from set" -f -a "tls-certificate" -d 'Set a new TLS certificate'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from set" -f -a "tls-generate" -d 'Generate a new TLS certificate'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from set" -f -a "unlock-passphrase" -d 'Set the unlock passphrase'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from set" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from help" -f -a "get" -d 'Get a configuration item for a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from help" -f -a "set" -d 'Set a configuration item for a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand config; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and not __fish_seen_subcommand_from add delete list help" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and not __fish_seen_subcommand_from add delete list help" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and not __fish_seen_subcommand_from add delete list help" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and not __fish_seen_subcommand_from add delete list help" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and not __fish_seen_subcommand_from add delete list help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and not __fish_seen_subcommand_from add delete list help" -f -a "add" -d 'Add a configuration item'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and not __fish_seen_subcommand_from add delete list help" -f -a "delete" -d 'Delete a configuration item'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and not __fish_seen_subcommand_from add delete list help" -f -a "list" -d 'List all items in the configuration file'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and not __fish_seen_subcommand_from add delete list help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from add" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from add" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from add" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from add" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from add" -f -a "credentials" -d 'Add credentials for a device in the configuration'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from add" -f -a "device" -d 'Add a device to the configuration'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from add" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from delete" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from delete" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from delete" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from delete" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from delete" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from delete" -f -a "credentials" -d 'Delete credentials for a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from delete" -f -a "device" -d 'Delete a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from delete" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from list" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from list" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from list" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from list" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from help" -f -a "add" -d 'Add a configuration item'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from help" -f -a "delete" -d 'Delete a configuration item'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from help" -f -a "list" -d 'List all items in the configuration file'
complete -c nethsm -n "__fish_nethsm_using_subcommand env; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and not __fish_seen_subcommand_from alive ready state help" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and not __fish_seen_subcommand_from alive ready state help" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and not __fish_seen_subcommand_from alive ready state help" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and not __fish_seen_subcommand_from alive ready state help" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and not __fish_seen_subcommand_from alive ready state help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and not __fish_seen_subcommand_from alive ready state help" -f -a "alive" -d 'Check whether a device is in locked or unprovisioned state'
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and not __fish_seen_subcommand_from alive ready state help" -f -a "ready" -d 'Check whether a device is in operational state'
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and not __fish_seen_subcommand_from alive ready state help" -f -a "state" -d 'Retrieve the state for a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and not __fish_seen_subcommand_from alive ready state help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from alive" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from alive" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from alive" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from alive" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from alive" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from ready" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from ready" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from ready" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from ready" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from ready" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from state" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from state" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from state" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from state" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from state" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from help" -f -a "alive" -d 'Check whether a device is in locked or unprovisioned state'
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from help" -f -a "ready" -d 'Check whether a device is in operational state'
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from help" -f -a "state" -d 'Retrieve the state for a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand health; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand info" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand info" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand info" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand info" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand info" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -f -a "cert" -d 'Operate on certificates for a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -f -a "csr" -d 'Get a Certificate Signing Request for a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -f -a "decrypt" -d 'Decrypt a message using a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -f -a "encrypt" -d 'Encrypt a message using a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -f -a "generate" -d 'Generate a new key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -f -a "get" -d 'Get information on a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -f -a "import" -d 'Import a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -f -a "list" -d 'List all key IDs'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -f -a "public-key" -d 'Get the public key for a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -f -a "remove" -d 'Remove a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -f -a "sign" -d 'Sign a message using a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -f -a "tag" -d 'Tag a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -f -a "untag" -d 'Untag a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and not __fish_seen_subcommand_from cert csr decrypt encrypt generate get import list public-key remove sign tag untag help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from cert" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from cert" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from cert" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from cert" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from cert" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from cert" -f -a "delete" -d 'Delete the certificate for a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from cert" -f -a "get" -d 'Get the certificate for a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from cert" -f -a "import" -d 'Import the certificate for a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from cert" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from csr" -s o -l output -d 'The optional path to a specific output file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from csr" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from csr" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from csr" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from csr" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from csr" -s f -l force -d 'Write to output file even if it exists already'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from csr" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from decrypt" -s i -l initialization-vector -d 'The path to a file containing the initialization vector (IV) for symmetric decryption' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from decrypt" -s o -l output -d 'The path to a specific file to write the decrypted message to' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from decrypt" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from decrypt" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from decrypt" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from decrypt" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from decrypt" -s f -l force -d 'Write to output file even if it exists already'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from decrypt" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from encrypt" -s i -l initialization-vector -d 'The path to a file containing the initialization vector (IV) for symmetric encryption' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from encrypt" -s o -l output -d 'The path to a specific file to write the encrypted message to' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from encrypt" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from encrypt" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from encrypt" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from encrypt" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from encrypt" -s f -l force -d 'Write to output file even if it exists already'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from encrypt" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from generate" -s L -l length -d 'The optional bit length of the generated key' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from generate" -s k -l key-id -d 'An optional unique ID that is assigned to the generated key' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from generate" -s t -l tags -d 'An optional list of tags that are assigned to the generated key' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from generate" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from generate" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from generate" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from generate" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from generate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from get" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from get" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from get" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from get" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from get" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from import" -l format -d 'The format of key to import' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from import" -s k -l key-id -d 'An optional unique ID that is assigned to the imported key' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from import" -s t -l tags -d 'An optional list of tags that are assigned to the imported key' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from import" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from import" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from import" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from import" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from import" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from list" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from list" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from list" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from list" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from public-key" -s o -l output -d 'The optional path to a specific output file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from public-key" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from public-key" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from public-key" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from public-key" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from public-key" -s f -l force -d 'Write to output file even if it exists already'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from public-key" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from remove" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from remove" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from remove" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from remove" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from sign" -s o -l output -d 'The optional path to a specific file that the signature is written to' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from sign" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from sign" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from sign" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from sign" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from sign" -s f -l force -d 'Write to output file even if it exists already'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from sign" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from tag" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from tag" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from tag" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from tag" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from tag" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from untag" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from untag" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from untag" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from untag" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from untag" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from help" -f -a "cert" -d 'Operate on certificates for a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from help" -f -a "csr" -d 'Get a Certificate Signing Request for a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from help" -f -a "decrypt" -d 'Decrypt a message using a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from help" -f -a "encrypt" -d 'Encrypt a message using a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from help" -f -a "generate" -d 'Generate a new key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from help" -f -a "get" -d 'Get information on a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from help" -f -a "import" -d 'Import a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from help" -f -a "list" -d 'List all key IDs'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from help" -f -a "public-key" -d 'Get the public key for a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from help" -f -a "sign" -d 'Sign a message using a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from help" -f -a "tag" -d 'Tag a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from help" -f -a "untag" -d 'Untag a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand key; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand lock" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand lock" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand lock" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand lock" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand lock" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand metrics" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand metrics" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand metrics" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand metrics" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand metrics" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and not __fish_seen_subcommand_from add list remove help" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and not __fish_seen_subcommand_from add list remove help" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and not __fish_seen_subcommand_from add list remove help" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and not __fish_seen_subcommand_from add list remove help" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and not __fish_seen_subcommand_from add list remove help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and not __fish_seen_subcommand_from add list remove help" -f -a "add" -d 'Add a namespace'
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and not __fish_seen_subcommand_from add list remove help" -f -a "list" -d 'List all namespace names'
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and not __fish_seen_subcommand_from add list remove help" -f -a "remove" -d 'Remove a namespace'
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and not __fish_seen_subcommand_from add list remove help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from add" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from add" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from add" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from add" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from list" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from list" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from list" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from list" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from remove" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from remove" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from remove" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from remove" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from help" -f -a "add" -d 'Add a namespace'
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from help" -f -a "list" -d 'List all namespace names'
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove a namespace'
complete -c nethsm -n "__fish_nethsm_using_subcommand namespace; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and not __fish_seen_subcommand_from add import sign sign-state help" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and not __fish_seen_subcommand_from add import sign sign-state help" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and not __fish_seen_subcommand_from add import sign sign-state help" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and not __fish_seen_subcommand_from add import sign sign-state help" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and not __fish_seen_subcommand_from add import sign sign-state help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and not __fish_seen_subcommand_from add import sign sign-state help" -f -a "add" -d 'Add an OpenPGP certificate for a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and not __fish_seen_subcommand_from add import sign sign-state help" -f -a "import" -d 'Import OpenPGP TSK-formatted private key'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and not __fish_seen_subcommand_from add import sign sign-state help" -f -a "sign" -d 'Create an OpenPGP signature for a message'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and not __fish_seen_subcommand_from add import sign sign-state help" -f -a "sign-state" -d 'Create an OpenPGP signature for a hasher state'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and not __fish_seen_subcommand_from add import sign sign-state help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from add" -s t -l time -d 'The optional creation time of the certificate (defaults to now)' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from add" -s v -l version -d 'The OpenPGP version the certificate is created with (defaults to "4")' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from add" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from add" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from add" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from add" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from add" -l can-sign -d 'Sets the signing key flag (default to set)'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from add" -l cannot-sign -d 'Clears the signing key flag'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from import" -s k -l key-id -d 'An optional unique ID that is assigned to the imported key' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from import" -s t -l tags -d 'An optional list of tags that are assigned to the imported key' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from import" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from import" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from import" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from import" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from import" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from sign" -s o -l output -d 'The optional path to a specific output file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from sign" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from sign" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from sign" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from sign" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from sign" -s f -l force -d 'Write to output file even if it exists already'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from sign" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from sign-state" -s o -l output -d 'The optional path to a specific output file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from sign-state" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from sign-state" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from sign-state" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from sign-state" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from sign-state" -s f -l force -d 'Write to output file even if it exists already'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from sign-state" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from help" -f -a "add" -d 'Add an OpenPGP certificate for a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from help" -f -a "import" -d 'Import OpenPGP TSK-formatted private key'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from help" -f -a "sign" -d 'Create an OpenPGP signature for a message'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from help" -f -a "sign-state" -d 'Create an OpenPGP signature for a hasher state'
complete -c nethsm -n "__fish_nethsm_using_subcommand openpgp; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand provision" -s A -l admin-passphrase-file -d 'The path to a file containing the admin passphrase' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand provision" -s s -l system-time -d 'The initial system time for the device' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand provision" -s U -l unlock-passphrase-file -d 'The path to a file containing the unlock passphrase' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand provision" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand provision" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand provision" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand provision" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand provision" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand random" -s o -l output -d 'The optional path to a specific output file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand random" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand random" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand random" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand random" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand random" -s f -l force -d 'Write to output file even if it exists already'
complete -c nethsm -n "__fish_nethsm_using_subcommand random" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and not __fish_seen_subcommand_from backup factory-reset info reboot restore shutdown upload-update cancel-update commit-update validate-backup help" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and not __fish_seen_subcommand_from backup factory-reset info reboot restore shutdown upload-update cancel-update commit-update validate-backup help" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and not __fish_seen_subcommand_from backup factory-reset info reboot restore shutdown upload-update cancel-update commit-update validate-backup help" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and not __fish_seen_subcommand_from backup factory-reset info reboot restore shutdown upload-update cancel-update commit-update validate-backup help" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and not __fish_seen_subcommand_from backup factory-reset info reboot restore shutdown upload-update cancel-update commit-update validate-backup help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and not __fish_seen_subcommand_from backup factory-reset info reboot restore shutdown upload-update cancel-update commit-update validate-backup help" -f -a "backup" -d 'Backup the key store of a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and not __fish_seen_subcommand_from backup factory-reset info reboot restore shutdown upload-update cancel-update commit-update validate-backup help" -f -a "factory-reset" -d 'Reset the device to factory settings'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and not __fish_seen_subcommand_from backup factory-reset info reboot restore shutdown upload-update cancel-update commit-update validate-backup help" -f -a "info" -d 'Retrieve system information of a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and not __fish_seen_subcommand_from backup factory-reset info reboot restore shutdown upload-update cancel-update commit-update validate-backup help" -f -a "reboot" -d 'Reboot the device'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and not __fish_seen_subcommand_from backup factory-reset info reboot restore shutdown upload-update cancel-update commit-update validate-backup help" -f -a "restore" -d 'Restore the device from a backup'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and not __fish_seen_subcommand_from backup factory-reset info reboot restore shutdown upload-update cancel-update commit-update validate-backup help" -f -a "shutdown" -d 'Shut down the device'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and not __fish_seen_subcommand_from backup factory-reset info reboot restore shutdown upload-update cancel-update commit-update validate-backup help" -f -a "upload-update" -d 'Upload an update to the device'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and not __fish_seen_subcommand_from backup factory-reset info reboot restore shutdown upload-update cancel-update commit-update validate-backup help" -f -a "cancel-update" -d 'Cancel an uploaded update on the device'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and not __fish_seen_subcommand_from backup factory-reset info reboot restore shutdown upload-update cancel-update commit-update validate-backup help" -f -a "commit-update" -d 'Commit an uploaded update on the device'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and not __fish_seen_subcommand_from backup factory-reset info reboot restore shutdown upload-update cancel-update commit-update validate-backup help" -f -a "validate-backup" -d 'Validate a backup file'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and not __fish_seen_subcommand_from backup factory-reset info reboot restore shutdown upload-update cancel-update commit-update validate-backup help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from backup" -s o -l output -d 'The optional path to a specific output file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from backup" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from backup" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from backup" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from backup" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from backup" -s f -l force -d 'Write to output file even if it exists already'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from backup" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from factory-reset" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from factory-reset" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from factory-reset" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from factory-reset" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from factory-reset" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from info" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from info" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from info" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from info" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from reboot" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from reboot" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from reboot" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from reboot" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from reboot" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from restore" -s b -l backup-passphrase-file -d 'The path to a file containing the backup passphrase' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from restore" -s s -l system-time -d 'The new system time for the device' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from restore" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from restore" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from restore" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from restore" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from restore" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from shutdown" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from shutdown" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from shutdown" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from shutdown" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from shutdown" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from upload-update" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from upload-update" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from upload-update" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from upload-update" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from upload-update" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from cancel-update" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from cancel-update" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from cancel-update" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from cancel-update" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from cancel-update" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from commit-update" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from commit-update" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from commit-update" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from commit-update" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from commit-update" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from validate-backup" -s b -l backup-passphrase-file -d 'The path to a file containing the backup passphrase' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from validate-backup" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from validate-backup" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from validate-backup" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from validate-backup" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from validate-backup" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "backup" -d 'Backup the key store of a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "factory-reset" -d 'Reset the device to factory settings'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "info" -d 'Retrieve system information of a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "reboot" -d 'Reboot the device'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "restore" -d 'Restore the device from a backup'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "shutdown" -d 'Shut down the device'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "upload-update" -d 'Upload an update to the device'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "cancel-update" -d 'Cancel an uploaded update on the device'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "commit-update" -d 'Commit an uploaded update on the device'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "validate-backup" -d 'Validate a backup file'
complete -c nethsm -n "__fish_nethsm_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand unlock" -s U -l unlock-passphrase-file -d 'The path to a file containing the unlock passphrase' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand unlock" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand unlock" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand unlock" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand unlock" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand unlock" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and not __fish_seen_subcommand_from add get list passphrase remove tag untag help" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and not __fish_seen_subcommand_from add get list passphrase remove tag untag help" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and not __fish_seen_subcommand_from add get list passphrase remove tag untag help" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and not __fish_seen_subcommand_from add get list passphrase remove tag untag help" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and not __fish_seen_subcommand_from add get list passphrase remove tag untag help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and not __fish_seen_subcommand_from add get list passphrase remove tag untag help" -f -a "add" -d 'Add a user'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and not __fish_seen_subcommand_from add get list passphrase remove tag untag help" -f -a "get" -d 'Get information about a user'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and not __fish_seen_subcommand_from add get list passphrase remove tag untag help" -f -a "list" -d 'List all user names'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and not __fish_seen_subcommand_from add get list passphrase remove tag untag help" -f -a "passphrase" -d 'Set the passphrase for a user'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and not __fish_seen_subcommand_from add get list passphrase remove tag untag help" -f -a "remove" -d 'Remove a user'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and not __fish_seen_subcommand_from add get list passphrase remove tag untag help" -f -a "tag" -d 'Add a tag to a user'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and not __fish_seen_subcommand_from add get list passphrase remove tag untag help" -f -a "untag" -d 'Remove a tag from a user'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and not __fish_seen_subcommand_from add get list passphrase remove tag untag help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from add" -s p -l passphrase-file -d 'The path to a file containing the new user\'s passphrase' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from add" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from add" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from add" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from add" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from get" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from get" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from get" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from get" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from get" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from list" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from list" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from list" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from list" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from passphrase" -s p -l passphrase-file -d 'The path to a file containing the user\'s new passphrase' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from passphrase" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from passphrase" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from passphrase" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from passphrase" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from passphrase" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from remove" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from remove" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from remove" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from remove" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from tag" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from tag" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from tag" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from tag" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from tag" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from untag" -s a -l auth-passphrase-file -d 'The path to a file containing a passphrase for authentication' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from untag" -s c -l config -d 'The path to a custom configuration file' -r -F
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from untag" -s l -l label -d 'A label uniquely identifying a device in the configuration file' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from untag" -s u -l user -d 'A user name which is used for the command' -r
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from untag" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from help" -f -a "add" -d 'Add a user'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from help" -f -a "get" -d 'Get information about a user'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from help" -f -a "list" -d 'List all user names'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from help" -f -a "passphrase" -d 'Set the passphrase for a user'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove a user'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from help" -f -a "tag" -d 'Add a tag to a user'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from help" -f -a "untag" -d 'Remove a tag from a user'
complete -c nethsm -n "__fish_nethsm_using_subcommand user; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and not __fish_seen_subcommand_from config env health info key lock metrics namespace openpgp provision random system unlock user help" -f -a "config" -d 'Manage the configuration of a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and not __fish_seen_subcommand_from config env health info key lock metrics namespace openpgp provision random system unlock user help" -f -a "env" -d 'Manage environments in the configuration file'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and not __fish_seen_subcommand_from config env health info key lock metrics namespace openpgp provision random system unlock user help" -f -a "health" -d 'Retrieve health information for a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and not __fish_seen_subcommand_from config env health info key lock metrics namespace openpgp provision random system unlock user help" -f -a "info" -d 'Retrieve the info for a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and not __fish_seen_subcommand_from config env health info key lock metrics namespace openpgp provision random system unlock user help" -f -a "key" -d 'Operate on the keys of a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and not __fish_seen_subcommand_from config env health info key lock metrics namespace openpgp provision random system unlock user help" -f -a "lock" -d 'Lock a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and not __fish_seen_subcommand_from config env health info key lock metrics namespace openpgp provision random system unlock user help" -f -a "metrics" -d 'Get metrics'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and not __fish_seen_subcommand_from config env health info key lock metrics namespace openpgp provision random system unlock user help" -f -a "namespace" -d 'Operate on namespaces of a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and not __fish_seen_subcommand_from config env health info key lock metrics namespace openpgp provision random system unlock user help" -f -a "openpgp" -d 'OpenPGP operations'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and not __fish_seen_subcommand_from config env health info key lock metrics namespace openpgp provision random system unlock user help" -f -a "provision" -d 'Provision a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and not __fish_seen_subcommand_from config env health info key lock metrics namespace openpgp provision random system unlock user help" -f -a "random" -d 'Get random bytes from a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and not __fish_seen_subcommand_from config env health info key lock metrics namespace openpgp provision random system unlock user help" -f -a "system" -d 'Do system actions for a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and not __fish_seen_subcommand_from config env health info key lock metrics namespace openpgp provision random system unlock user help" -f -a "unlock" -d 'Unlock a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and not __fish_seen_subcommand_from config env health info key lock metrics namespace openpgp provision random system unlock user help" -f -a "user" -d 'Operate on users of a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and not __fish_seen_subcommand_from config env health info key lock metrics namespace openpgp provision random system unlock user help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from config" -f -a "get" -d 'Get a configuration item for a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from config" -f -a "set" -d 'Set a configuration item for a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from env" -f -a "add" -d 'Add a configuration item'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from env" -f -a "delete" -d 'Delete a configuration item'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from env" -f -a "list" -d 'List all items in the configuration file'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from health" -f -a "alive" -d 'Check whether a device is in locked or unprovisioned state'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from health" -f -a "ready" -d 'Check whether a device is in operational state'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from health" -f -a "state" -d 'Retrieve the state for a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from key" -f -a "cert" -d 'Operate on certificates for a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from key" -f -a "csr" -d 'Get a Certificate Signing Request for a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from key" -f -a "decrypt" -d 'Decrypt a message using a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from key" -f -a "encrypt" -d 'Encrypt a message using a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from key" -f -a "generate" -d 'Generate a new key'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from key" -f -a "get" -d 'Get information on a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from key" -f -a "import" -d 'Import a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from key" -f -a "list" -d 'List all key IDs'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from key" -f -a "public-key" -d 'Get the public key for a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from key" -f -a "remove" -d 'Remove a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from key" -f -a "sign" -d 'Sign a message using a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from key" -f -a "tag" -d 'Tag a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from key" -f -a "untag" -d 'Untag a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from namespace" -f -a "add" -d 'Add a namespace'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from namespace" -f -a "list" -d 'List all namespace names'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from namespace" -f -a "remove" -d 'Remove a namespace'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from openpgp" -f -a "add" -d 'Add an OpenPGP certificate for a key'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from openpgp" -f -a "import" -d 'Import OpenPGP TSK-formatted private key'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from openpgp" -f -a "sign" -d 'Create an OpenPGP signature for a message'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from openpgp" -f -a "sign-state" -d 'Create an OpenPGP signature for a hasher state'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "backup" -d 'Backup the key store of a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "factory-reset" -d 'Reset the device to factory settings'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "info" -d 'Retrieve system information of a device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "reboot" -d 'Reboot the device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "restore" -d 'Restore the device from a backup'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "shutdown" -d 'Shut down the device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "upload-update" -d 'Upload an update to the device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "cancel-update" -d 'Cancel an uploaded update on the device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "commit-update" -d 'Commit an uploaded update on the device'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "validate-backup" -d 'Validate a backup file'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from user" -f -a "add" -d 'Add a user'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from user" -f -a "get" -d 'Get information about a user'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from user" -f -a "list" -d 'List all user names'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from user" -f -a "passphrase" -d 'Set the passphrase for a user'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from user" -f -a "remove" -d 'Remove a user'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from user" -f -a "tag" -d 'Add a tag to a user'
complete -c nethsm -n "__fish_nethsm_using_subcommand help; and __fish_seen_subcommand_from user" -f -a "untag" -d 'Remove a tag from a user'
