SCM_GLOBAL_SMOB (scm_tc16_avahi_entry_group_state_enum, "entry-group-state", 0);
SCM scm_avahi_entry_group_state_enum_values = SCM_EOL;
static const char *
scm_avahi_entry_group_state_to_c_string (AvahiEntryGroupState c_obj)
{
  static const struct { AvahiEntryGroupState value; const char *name; } table[] =
    {
       { AVAHI_ENTRY_GROUP_UNCOMMITED, "uncommited" },
       { AVAHI_ENTRY_GROUP_REGISTERING, "registering" },
       { AVAHI_ENTRY_GROUP_ESTABLISHED, "established" },
       { AVAHI_ENTRY_GROUP_COLLISION, "collision" },
       { AVAHI_ENTRY_GROUP_FAILURE, "failure" },
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < 5; i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_avahi_entry_group_state_enum, entry_group_state_print, obj, port, pstate)
{
  scm_puts ("#<avahi-entry-group-state-enum ", port);
  scm_puts (scm_avahi_entry_group_state_to_c_string (scm_to_avahi_entry_group_state (obj, 1, "entry_group_state_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_avahi_entry_group_state_to_string, "entry-group-state->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{entry-group-state} value.")
#define FUNC_NAME s_scm_avahi_entry_group_state_to_string
{
  AvahiEntryGroupState c_enum;
  const char *c_string;
  c_enum = scm_to_avahi_entry_group_state (enumval, 1, FUNC_NAME);
  c_string = scm_avahi_entry_group_state_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_avahi_publish_flag_enum, "publish-flag", 0);
SCM scm_avahi_publish_flag_enum_values = SCM_EOL;
static const char *
scm_avahi_publish_flag_to_c_string (AvahiPublishFlags c_obj)
{
  static const struct { AvahiPublishFlags value; const char *name; } table[] =
    {
       { AVAHI_PUBLISH_UNIQUE, "unique" },
       { AVAHI_PUBLISH_NO_PROBE, "no-probe" },
       { AVAHI_PUBLISH_NO_ANNOUNCE, "no-announce" },
       { AVAHI_PUBLISH_ALLOW_MULTIPLE, "allow-multiple" },
       { AVAHI_PUBLISH_NO_REVERSE, "no-reverse" },
       { AVAHI_PUBLISH_NO_COOKIE, "no-cookie" },
       { AVAHI_PUBLISH_UPDATE, "update" },
       { AVAHI_PUBLISH_USE_WIDE_AREA, "use-wide-area" },
       { AVAHI_PUBLISH_USE_MULTICAST, "use-multicast" },
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < 9; i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_avahi_publish_flag_enum, publish_flag_print, obj, port, pstate)
{
  scm_puts ("#<avahi-publish-flag-enum ", port);
  scm_puts (scm_avahi_publish_flag_to_c_string (scm_to_avahi_publish_flag (obj, 1, "publish_flag_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_avahi_publish_flag_to_string, "publish-flag->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{publish-flag} value.")
#define FUNC_NAME s_scm_avahi_publish_flag_to_string
{
  AvahiPublishFlags c_enum;
  const char *c_string;
  c_enum = scm_to_avahi_publish_flag (enumval, 1, FUNC_NAME);
  c_string = scm_avahi_publish_flag_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
static inline void
scm_avahi_define_enums (void)
{
  SCM enum_values, enum_smob;
  enum_values = SCM_EOL;
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_entry_group_state_enum, (scm_t_bits) AVAHI_ENTRY_GROUP_UNCOMMITED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("entry-group-state/uncommited", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_entry_group_state_enum, (scm_t_bits) AVAHI_ENTRY_GROUP_REGISTERING);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("entry-group-state/registering", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_entry_group_state_enum, (scm_t_bits) AVAHI_ENTRY_GROUP_ESTABLISHED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("entry-group-state/established", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_entry_group_state_enum, (scm_t_bits) AVAHI_ENTRY_GROUP_COLLISION);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("entry-group-state/collision", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_entry_group_state_enum, (scm_t_bits) AVAHI_ENTRY_GROUP_FAILURE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("entry-group-state/failure", enum_smob);
  scm_avahi_entry_group_state_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_publish_flag_enum, (scm_t_bits) AVAHI_PUBLISH_UNIQUE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("publish-flag/unique", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_publish_flag_enum, (scm_t_bits) AVAHI_PUBLISH_NO_PROBE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("publish-flag/no-probe", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_publish_flag_enum, (scm_t_bits) AVAHI_PUBLISH_NO_ANNOUNCE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("publish-flag/no-announce", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_publish_flag_enum, (scm_t_bits) AVAHI_PUBLISH_ALLOW_MULTIPLE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("publish-flag/allow-multiple", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_publish_flag_enum, (scm_t_bits) AVAHI_PUBLISH_NO_REVERSE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("publish-flag/no-reverse", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_publish_flag_enum, (scm_t_bits) AVAHI_PUBLISH_NO_COOKIE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("publish-flag/no-cookie", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_publish_flag_enum, (scm_t_bits) AVAHI_PUBLISH_UPDATE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("publish-flag/update", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_publish_flag_enum, (scm_t_bits) AVAHI_PUBLISH_USE_WIDE_AREA);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("publish-flag/use-wide-area", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_publish_flag_enum, (scm_t_bits) AVAHI_PUBLISH_USE_MULTICAST);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("publish-flag/use-multicast", enum_smob);
  scm_avahi_publish_flag_enum_values = scm_permanent_object (enum_values);
}
