/* Generated by wayland-scanner 1.23.1 */

#ifndef LINUX_DMABUF_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define LINUX_DMABUF_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_linux_dmabuf_unstable_v1 The linux_dmabuf_unstable_v1 protocol
 * @section page_ifaces_linux_dmabuf_unstable_v1 Interfaces
 * - @subpage page_iface_zwp_linux_dmabuf_v1 - factory for creating dmabuf-based wl_buffers
 * - @subpage page_iface_zwp_linux_buffer_params_v1 - parameters for creating a dmabuf-based wl_buffer
 * - @subpage page_iface_zwp_linux_dmabuf_feedback_v1 - dmabuf feedback
 * @section page_copyright_linux_dmabuf_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2014, 2015 Collabora, Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_buffer;
struct wl_surface;
struct zwp_linux_buffer_params_v1;
struct zwp_linux_dmabuf_feedback_v1;
struct zwp_linux_dmabuf_v1;

#ifndef ZWP_LINUX_DMABUF_V1_INTERFACE
#define ZWP_LINUX_DMABUF_V1_INTERFACE
/**
 * @page page_iface_zwp_linux_dmabuf_v1 zwp_linux_dmabuf_v1
 * @section page_iface_zwp_linux_dmabuf_v1_desc Description
 *
 * Following the interfaces from:
 * https://www.khronos.org/registry/egl/extensions/EXT/EGL_EXT_image_dma_buf_import.txt
 * https://www.khronos.org/registry/EGL/extensions/EXT/EGL_EXT_image_dma_buf_import_modifiers.txt
 * and the Linux DRM sub-system's AddFb2 ioctl.
 *
 * This interface offers ways to create generic dmabuf-based wl_buffers.
 *
 * Clients can use the get_surface_feedback request to get dmabuf feedback
 * for a particular surface. If the client wants to retrieve feedback not
 * tied to a surface, they can use the get_default_feedback request.
 *
 * The following are required from clients:
 *
 * - Clients must ensure that either all data in the dma-buf is
 * coherent for all subsequent read access or that coherency is
 * correctly handled by the underlying kernel-side dma-buf
 * implementation.
 *
 * - Don't make any more attachments after sending the buffer to the
 * compositor. Making more attachments later increases the risk of
 * the compositor not being able to use (re-import) an existing
 * dmabuf-based wl_buffer.
 *
 * The underlying graphics stack must ensure the following:
 *
 * - The dmabuf file descriptors relayed to the server will stay valid
 * for the whole lifetime of the wl_buffer. This means the server may
 * at any time use those fds to import the dmabuf into any kernel
 * sub-system that might accept it.
 *
 * However, when the underlying graphics stack fails to deliver the
 * promise, because of e.g. a device hot-unplug which raises internal
 * errors, after the wl_buffer has been successfully created the
 * compositor must not raise protocol errors to the client when dmabuf
 * import later fails.
 *
 * To create a wl_buffer from one or more dmabufs, a client creates a
 * zwp_linux_dmabuf_params_v1 object with a zwp_linux_dmabuf_v1.create_params
 * request. All planes required by the intended format are added with
 * the 'add' request. Finally, a 'create' or 'create_immed' request is
 * issued, which has the following outcome depending on the import success.
 *
 * The 'create' request,
 * - on success, triggers a 'created' event which provides the final
 * wl_buffer to the client.
 * - on failure, triggers a 'failed' event to convey that the server
 * cannot use the dmabufs received from the client.
 *
 * For the 'create_immed' request,
 * - on success, the server immediately imports the added dmabufs to
 * create a wl_buffer. No event is sent from the server in this case.
 * - on failure, the server can choose to either:
 * - terminate the client by raising a fatal error.
 * - mark the wl_buffer as failed, and send a 'failed' event to the
 * client. If the client uses a failed wl_buffer as an argument to any
 * request, the behaviour is compositor implementation-defined.
 *
 * For all DRM formats and unless specified in another protocol extension,
 * pre-multiplied alpha is used for pixel values.
 *
 * Unless specified otherwise in another protocol extension, implicit
 * synchronization is used. In other words, compositors and clients must
 * wait and signal fences implicitly passed via the DMA-BUF's reservation
 * mechanism.
 *
 * Disclaimer: This protocol extension has been marked stable. This copy is
 * no longer used and only retained for backwards compatibility. The
 * canonical version can be found in the stable/ directory.
 * @section page_iface_zwp_linux_dmabuf_v1_api API
 * See @ref iface_zwp_linux_dmabuf_v1.
 */
/**
 * @defgroup iface_zwp_linux_dmabuf_v1 The zwp_linux_dmabuf_v1 interface
 *
 * Following the interfaces from:
 * https://www.khronos.org/registry/egl/extensions/EXT/EGL_EXT_image_dma_buf_import.txt
 * https://www.khronos.org/registry/EGL/extensions/EXT/EGL_EXT_image_dma_buf_import_modifiers.txt
 * and the Linux DRM sub-system's AddFb2 ioctl.
 *
 * This interface offers ways to create generic dmabuf-based wl_buffers.
 *
 * Clients can use the get_surface_feedback request to get dmabuf feedback
 * for a particular surface. If the client wants to retrieve feedback not
 * tied to a surface, they can use the get_default_feedback request.
 *
 * The following are required from clients:
 *
 * - Clients must ensure that either all data in the dma-buf is
 * coherent for all subsequent read access or that coherency is
 * correctly handled by the underlying kernel-side dma-buf
 * implementation.
 *
 * - Don't make any more attachments after sending the buffer to the
 * compositor. Making more attachments later increases the risk of
 * the compositor not being able to use (re-import) an existing
 * dmabuf-based wl_buffer.
 *
 * The underlying graphics stack must ensure the following:
 *
 * - The dmabuf file descriptors relayed to the server will stay valid
 * for the whole lifetime of the wl_buffer. This means the server may
 * at any time use those fds to import the dmabuf into any kernel
 * sub-system that might accept it.
 *
 * However, when the underlying graphics stack fails to deliver the
 * promise, because of e.g. a device hot-unplug which raises internal
 * errors, after the wl_buffer has been successfully created the
 * compositor must not raise protocol errors to the client when dmabuf
 * import later fails.
 *
 * To create a wl_buffer from one or more dmabufs, a client creates a
 * zwp_linux_dmabuf_params_v1 object with a zwp_linux_dmabuf_v1.create_params
 * request. All planes required by the intended format are added with
 * the 'add' request. Finally, a 'create' or 'create_immed' request is
 * issued, which has the following outcome depending on the import success.
 *
 * The 'create' request,
 * - on success, triggers a 'created' event which provides the final
 * wl_buffer to the client.
 * - on failure, triggers a 'failed' event to convey that the server
 * cannot use the dmabufs received from the client.
 *
 * For the 'create_immed' request,
 * - on success, the server immediately imports the added dmabufs to
 * create a wl_buffer. No event is sent from the server in this case.
 * - on failure, the server can choose to either:
 * - terminate the client by raising a fatal error.
 * - mark the wl_buffer as failed, and send a 'failed' event to the
 * client. If the client uses a failed wl_buffer as an argument to any
 * request, the behaviour is compositor implementation-defined.
 *
 * For all DRM formats and unless specified in another protocol extension,
 * pre-multiplied alpha is used for pixel values.
 *
 * Unless specified otherwise in another protocol extension, implicit
 * synchronization is used. In other words, compositors and clients must
 * wait and signal fences implicitly passed via the DMA-BUF's reservation
 * mechanism.
 *
 * Disclaimer: This protocol extension has been marked stable. This copy is
 * no longer used and only retained for backwards compatibility. The
 * canonical version can be found in the stable/ directory.
 */
extern const struct wl_interface zwp_linux_dmabuf_v1_interface;
#endif
#ifndef ZWP_LINUX_BUFFER_PARAMS_V1_INTERFACE
#define ZWP_LINUX_BUFFER_PARAMS_V1_INTERFACE
/**
 * @page page_iface_zwp_linux_buffer_params_v1 zwp_linux_buffer_params_v1
 * @section page_iface_zwp_linux_buffer_params_v1_desc Description
 *
 * This temporary object is a collection of dmabufs and other
 * parameters that together form a single logical buffer. The temporary
 * object may eventually create one wl_buffer unless cancelled by
 * destroying it before requesting 'create'.
 *
 * Single-planar formats only require one dmabuf, however
 * multi-planar formats may require more than one dmabuf. For all
 * formats, an 'add' request must be called once per plane (even if the
 * underlying dmabuf fd is identical).
 *
 * You must use consecutive plane indices ('plane_idx' argument for 'add')
 * from zero to the number of planes used by the drm_fourcc format code.
 * All planes required by the format must be given exactly once, but can
 * be given in any order. Each plane index can be set only once.
 * @section page_iface_zwp_linux_buffer_params_v1_api API
 * See @ref iface_zwp_linux_buffer_params_v1.
 */
/**
 * @defgroup iface_zwp_linux_buffer_params_v1 The zwp_linux_buffer_params_v1 interface
 *
 * This temporary object is a collection of dmabufs and other
 * parameters that together form a single logical buffer. The temporary
 * object may eventually create one wl_buffer unless cancelled by
 * destroying it before requesting 'create'.
 *
 * Single-planar formats only require one dmabuf, however
 * multi-planar formats may require more than one dmabuf. For all
 * formats, an 'add' request must be called once per plane (even if the
 * underlying dmabuf fd is identical).
 *
 * You must use consecutive plane indices ('plane_idx' argument for 'add')
 * from zero to the number of planes used by the drm_fourcc format code.
 * All planes required by the format must be given exactly once, but can
 * be given in any order. Each plane index can be set only once.
 */
extern const struct wl_interface zwp_linux_buffer_params_v1_interface;
#endif
#ifndef ZWP_LINUX_DMABUF_FEEDBACK_V1_INTERFACE
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_INTERFACE
/**
 * @page page_iface_zwp_linux_dmabuf_feedback_v1 zwp_linux_dmabuf_feedback_v1
 * @section page_iface_zwp_linux_dmabuf_feedback_v1_desc Description
 *
 * This object advertises dmabuf parameters feedback. This includes the
 * preferred devices and the supported formats/modifiers.
 *
 * The parameters are sent once when this object is created and whenever they
 * change. The done event is always sent once after all parameters have been
 * sent. When a single parameter changes, all parameters are re-sent by the
 * compositor.
 *
 * Compositors can re-send the parameters when the current client buffer
 * allocations are sub-optimal. Compositors should not re-send the
 * parameters if re-allocating the buffers would not result in a more optimal
 * configuration. In particular, compositors should avoid sending the exact
 * same parameters multiple times in a row.
 *
 * The tranche_target_device and tranche_formats events are grouped by
 * tranches of preference. For each tranche, a tranche_target_device, one
 * tranche_flags and one or more tranche_formats events are sent, followed
 * by a tranche_done event finishing the list. The tranches are sent in
 * descending order of preference. All formats and modifiers in the same
 * tranche have the same preference.
 *
 * To send parameters, the compositor sends one main_device event, tranches
 * (each consisting of one tranche_target_device event, one tranche_flags
 * event, tranche_formats events and then a tranche_done event), then one
 * done event.
 * @section page_iface_zwp_linux_dmabuf_feedback_v1_api API
 * See @ref iface_zwp_linux_dmabuf_feedback_v1.
 */
/**
 * @defgroup iface_zwp_linux_dmabuf_feedback_v1 The zwp_linux_dmabuf_feedback_v1 interface
 *
 * This object advertises dmabuf parameters feedback. This includes the
 * preferred devices and the supported formats/modifiers.
 *
 * The parameters are sent once when this object is created and whenever they
 * change. The done event is always sent once after all parameters have been
 * sent. When a single parameter changes, all parameters are re-sent by the
 * compositor.
 *
 * Compositors can re-send the parameters when the current client buffer
 * allocations are sub-optimal. Compositors should not re-send the
 * parameters if re-allocating the buffers would not result in a more optimal
 * configuration. In particular, compositors should avoid sending the exact
 * same parameters multiple times in a row.
 *
 * The tranche_target_device and tranche_formats events are grouped by
 * tranches of preference. For each tranche, a tranche_target_device, one
 * tranche_flags and one or more tranche_formats events are sent, followed
 * by a tranche_done event finishing the list. The tranches are sent in
 * descending order of preference. All formats and modifiers in the same
 * tranche have the same preference.
 *
 * To send parameters, the compositor sends one main_device event, tranches
 * (each consisting of one tranche_target_device event, one tranche_flags
 * event, tranche_formats events and then a tranche_done event), then one
 * done event.
 */
extern const struct wl_interface zwp_linux_dmabuf_feedback_v1_interface;
#endif

/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 * @struct zwp_linux_dmabuf_v1_listener
 */
struct zwp_linux_dmabuf_v1_listener {
	/**
	 * supported buffer format
	 *
	 * This event advertises one buffer format that the server
	 * supports. All the supported formats are advertised once when the
	 * client binds to this interface. A roundtrip after binding
	 * guarantees that the client has received all supported formats.
	 *
	 * For the definition of the format codes, see the
	 * zwp_linux_buffer_params_v1::create request.
	 *
	 * Starting version 4, the format event is deprecated and must not
	 * be sent by compositors. Instead, use get_default_feedback or
	 * get_surface_feedback.
	 * @param format DRM_FORMAT code
	 */
	void (*format)(void *data,
		       struct zwp_linux_dmabuf_v1 *zwp_linux_dmabuf_v1,
		       uint32_t format);
	/**
	 * supported buffer format modifier
	 *
	 * This event advertises the formats that the server supports,
	 * along with the modifiers supported for each format. All the
	 * supported modifiers for all the supported formats are advertised
	 * once when the client binds to this interface. A roundtrip after
	 * binding guarantees that the client has received all supported
	 * format-modifier pairs.
	 *
	 * For legacy support, DRM_FORMAT_MOD_INVALID (that is, modifier_hi
	 * == 0x00ffffff and modifier_lo == 0xffffffff) is allowed in this
	 * event. It indicates that the server can support the format with
	 * an implicit modifier. When a plane has DRM_FORMAT_MOD_INVALID as
	 * its modifier, it is as if no explicit modifier is specified. The
	 * effective modifier will be derived from the dmabuf.
	 *
	 * A compositor that sends valid modifiers and
	 * DRM_FORMAT_MOD_INVALID for a given format supports both explicit
	 * modifiers and implicit modifiers.
	 *
	 * For the definition of the format and modifier codes, see the
	 * zwp_linux_buffer_params_v1::create and
	 * zwp_linux_buffer_params_v1::add requests.
	 *
	 * Starting version 4, the modifier event is deprecated and must
	 * not be sent by compositors. Instead, use get_default_feedback or
	 * get_surface_feedback.
	 * @param format DRM_FORMAT code
	 * @param modifier_hi high 32 bits of layout modifier
	 * @param modifier_lo low 32 bits of layout modifier
	 * @since 3
	 */
	void (*modifier)(void *data,
			 struct zwp_linux_dmabuf_v1 *zwp_linux_dmabuf_v1,
			 uint32_t format,
			 uint32_t modifier_hi,
			 uint32_t modifier_lo);
};

/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 */
static inline int
zwp_linux_dmabuf_v1_add_listener(struct zwp_linux_dmabuf_v1 *zwp_linux_dmabuf_v1,
				 const struct zwp_linux_dmabuf_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwp_linux_dmabuf_v1,
				     (void (**)(void)) listener, data);
}

#define ZWP_LINUX_DMABUF_V1_DESTROY 0
#define ZWP_LINUX_DMABUF_V1_CREATE_PARAMS 1
#define ZWP_LINUX_DMABUF_V1_GET_DEFAULT_FEEDBACK 2
#define ZWP_LINUX_DMABUF_V1_GET_SURFACE_FEEDBACK 3

/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 */
#define ZWP_LINUX_DMABUF_V1_FORMAT_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 */
#define ZWP_LINUX_DMABUF_V1_MODIFIER_SINCE_VERSION 3

/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 */
#define ZWP_LINUX_DMABUF_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 */
#define ZWP_LINUX_DMABUF_V1_CREATE_PARAMS_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 */
#define ZWP_LINUX_DMABUF_V1_GET_DEFAULT_FEEDBACK_SINCE_VERSION 4
/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 */
#define ZWP_LINUX_DMABUF_V1_GET_SURFACE_FEEDBACK_SINCE_VERSION 4

/** @ingroup iface_zwp_linux_dmabuf_v1 */
static inline void
zwp_linux_dmabuf_v1_set_user_data(struct zwp_linux_dmabuf_v1 *zwp_linux_dmabuf_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_linux_dmabuf_v1, user_data);
}

/** @ingroup iface_zwp_linux_dmabuf_v1 */
static inline void *
zwp_linux_dmabuf_v1_get_user_data(struct zwp_linux_dmabuf_v1 *zwp_linux_dmabuf_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_linux_dmabuf_v1);
}

static inline uint32_t
zwp_linux_dmabuf_v1_get_version(struct zwp_linux_dmabuf_v1 *zwp_linux_dmabuf_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_linux_dmabuf_v1);
}

/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 *
 * Objects created through this interface, especially wl_buffers, will
 * remain valid.
 */
static inline void
zwp_linux_dmabuf_v1_destroy(struct zwp_linux_dmabuf_v1 *zwp_linux_dmabuf_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_linux_dmabuf_v1,
			 ZWP_LINUX_DMABUF_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_linux_dmabuf_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 *
 * This temporary object is used to collect multiple dmabuf handles into
 * a single batch to create a wl_buffer. It can only be used once and
 * should be destroyed after a 'created' or 'failed' event has been
 * received.
 */
static inline struct zwp_linux_buffer_params_v1 *
zwp_linux_dmabuf_v1_create_params(struct zwp_linux_dmabuf_v1 *zwp_linux_dmabuf_v1)
{
	struct wl_proxy *params_id;

	params_id = wl_proxy_marshal_flags((struct wl_proxy *) zwp_linux_dmabuf_v1,
			 ZWP_LINUX_DMABUF_V1_CREATE_PARAMS, &zwp_linux_buffer_params_v1_interface, wl_proxy_get_version((struct wl_proxy *) zwp_linux_dmabuf_v1), 0, NULL);

	return (struct zwp_linux_buffer_params_v1 *) params_id;
}

/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 *
 * This request creates a new wp_linux_dmabuf_feedback object not bound
 * to a particular surface. This object will deliver feedback about dmabuf
 * parameters to use if the client doesn't support per-surface feedback
 * (see get_surface_feedback).
 */
static inline struct zwp_linux_dmabuf_feedback_v1 *
zwp_linux_dmabuf_v1_get_default_feedback(struct zwp_linux_dmabuf_v1 *zwp_linux_dmabuf_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zwp_linux_dmabuf_v1,
			 ZWP_LINUX_DMABUF_V1_GET_DEFAULT_FEEDBACK, &zwp_linux_dmabuf_feedback_v1_interface, wl_proxy_get_version((struct wl_proxy *) zwp_linux_dmabuf_v1), 0, NULL);

	return (struct zwp_linux_dmabuf_feedback_v1 *) id;
}

/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 *
 * This request creates a new wp_linux_dmabuf_feedback object for the
 * specified wl_surface. This object will deliver feedback about dmabuf
 * parameters to use for buffers attached to this surface.
 *
 * If the surface is destroyed before the wp_linux_dmabuf_feedback object,
 * the feedback object becomes inert.
 */
static inline struct zwp_linux_dmabuf_feedback_v1 *
zwp_linux_dmabuf_v1_get_surface_feedback(struct zwp_linux_dmabuf_v1 *zwp_linux_dmabuf_v1, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zwp_linux_dmabuf_v1,
			 ZWP_LINUX_DMABUF_V1_GET_SURFACE_FEEDBACK, &zwp_linux_dmabuf_feedback_v1_interface, wl_proxy_get_version((struct wl_proxy *) zwp_linux_dmabuf_v1), 0, NULL, surface);

	return (struct zwp_linux_dmabuf_feedback_v1 *) id;
}

#ifndef ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_ENUM
#define ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_ENUM
enum zwp_linux_buffer_params_v1_error {
	/**
	 * the dmabuf_batch object has already been used to create a wl_buffer
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_ALREADY_USED = 0,
	/**
	 * plane index out of bounds
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_PLANE_IDX = 1,
	/**
	 * the plane index was already set
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_PLANE_SET = 2,
	/**
	 * missing or too many planes to create a buffer
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_INCOMPLETE = 3,
	/**
	 * format not supported
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_INVALID_FORMAT = 4,
	/**
	 * invalid width or height
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_INVALID_DIMENSIONS = 5,
	/**
	 * offset + stride * height goes out of dmabuf bounds
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_OUT_OF_BOUNDS = 6,
	/**
	 * invalid wl_buffer resulted from importing dmabufs via                the create_immed request on given buffer_params
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_INVALID_WL_BUFFER = 7,
};
#endif /* ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_ENUM */

#ifndef ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_ENUM
#define ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_ENUM
enum zwp_linux_buffer_params_v1_flags {
	/**
	 * contents are y-inverted
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_Y_INVERT = 1,
	/**
	 * content is interlaced
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_INTERLACED = 2,
	/**
	 * bottom field first
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_BOTTOM_FIRST = 4,
};
#endif /* ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_ENUM */

/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 * @struct zwp_linux_buffer_params_v1_listener
 */
struct zwp_linux_buffer_params_v1_listener {
	/**
	 * buffer creation succeeded
	 *
	 * This event indicates that the attempted buffer creation was
	 * successful. It provides the new wl_buffer referencing the
	 * dmabuf(s).
	 *
	 * Upon receiving this event, the client should destroy the
	 * zwp_linux_buffer_params_v1 object.
	 * @param buffer the newly created wl_buffer
	 */
	void (*created)(void *data,
			struct zwp_linux_buffer_params_v1 *zwp_linux_buffer_params_v1,
			struct wl_buffer *buffer);
	/**
	 * buffer creation failed
	 *
	 * This event indicates that the attempted buffer creation has
	 * failed. It usually means that one of the dmabuf constraints has
	 * not been fulfilled.
	 *
	 * Upon receiving this event, the client should destroy the
	 * zwp_linux_buffer_params_v1 object.
	 */
	void (*failed)(void *data,
		       struct zwp_linux_buffer_params_v1 *zwp_linux_buffer_params_v1);
};

/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 */
static inline int
zwp_linux_buffer_params_v1_add_listener(struct zwp_linux_buffer_params_v1 *zwp_linux_buffer_params_v1,
					const struct zwp_linux_buffer_params_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwp_linux_buffer_params_v1,
				     (void (**)(void)) listener, data);
}

#define ZWP_LINUX_BUFFER_PARAMS_V1_DESTROY 0
#define ZWP_LINUX_BUFFER_PARAMS_V1_ADD 1
#define ZWP_LINUX_BUFFER_PARAMS_V1_CREATE 2
#define ZWP_LINUX_BUFFER_PARAMS_V1_CREATE_IMMED 3

/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 */
#define ZWP_LINUX_BUFFER_PARAMS_V1_CREATED_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 */
#define ZWP_LINUX_BUFFER_PARAMS_V1_FAILED_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 */
#define ZWP_LINUX_BUFFER_PARAMS_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 */
#define ZWP_LINUX_BUFFER_PARAMS_V1_ADD_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 */
#define ZWP_LINUX_BUFFER_PARAMS_V1_CREATE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 */
#define ZWP_LINUX_BUFFER_PARAMS_V1_CREATE_IMMED_SINCE_VERSION 2

/** @ingroup iface_zwp_linux_buffer_params_v1 */
static inline void
zwp_linux_buffer_params_v1_set_user_data(struct zwp_linux_buffer_params_v1 *zwp_linux_buffer_params_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_linux_buffer_params_v1, user_data);
}

/** @ingroup iface_zwp_linux_buffer_params_v1 */
static inline void *
zwp_linux_buffer_params_v1_get_user_data(struct zwp_linux_buffer_params_v1 *zwp_linux_buffer_params_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_linux_buffer_params_v1);
}

static inline uint32_t
zwp_linux_buffer_params_v1_get_version(struct zwp_linux_buffer_params_v1 *zwp_linux_buffer_params_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_linux_buffer_params_v1);
}

/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 *
 * Cleans up the temporary data sent to the server for dmabuf-based
 * wl_buffer creation.
 */
static inline void
zwp_linux_buffer_params_v1_destroy(struct zwp_linux_buffer_params_v1 *zwp_linux_buffer_params_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_linux_buffer_params_v1,
			 ZWP_LINUX_BUFFER_PARAMS_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_linux_buffer_params_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 *
 * This request adds one dmabuf to the set in this
 * zwp_linux_buffer_params_v1.
 *
 * The 64-bit unsigned value combined from modifier_hi and modifier_lo
 * is the dmabuf layout modifier. DRM AddFB2 ioctl calls this the
 * fb modifier, which is defined in drm_mode.h of Linux UAPI.
 * This is an opaque token. Drivers use this token to express tiling,
 * compression, etc. driver-specific modifications to the base format
 * defined by the DRM fourcc code.
 *
 * Starting from version 4, the invalid_format protocol error is sent if
 * the format + modifier pair was not advertised as supported.
 *
 * Starting from version 5, the invalid_format protocol error is sent if
 * all planes don't use the same modifier.
 *
 * This request raises the PLANE_IDX error if plane_idx is too large.
 * The error PLANE_SET is raised if attempting to set a plane that
 * was already set.
 */
static inline void
zwp_linux_buffer_params_v1_add(struct zwp_linux_buffer_params_v1 *zwp_linux_buffer_params_v1, int32_t fd, uint32_t plane_idx, uint32_t offset, uint32_t stride, uint32_t modifier_hi, uint32_t modifier_lo)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_linux_buffer_params_v1,
			 ZWP_LINUX_BUFFER_PARAMS_V1_ADD, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_linux_buffer_params_v1), 0, fd, plane_idx, offset, stride, modifier_hi, modifier_lo);
}

/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 *
 * This asks for creation of a wl_buffer from the added dmabuf
 * buffers. The wl_buffer is not created immediately but returned via
 * the 'created' event if the dmabuf sharing succeeds. The sharing
 * may fail at runtime for reasons a client cannot predict, in
 * which case the 'failed' event is triggered.
 *
 * The 'format' argument is a DRM_FORMAT code, as defined by the
 * libdrm's drm_fourcc.h. The Linux kernel's DRM sub-system is the
 * authoritative source on how the format codes should work.
 *
 * The 'flags' is a bitfield of the flags defined in enum "flags".
 * 'y_invert' means the that the image needs to be y-flipped.
 *
 * Flag 'interlaced' means that the frame in the buffer is not
 * progressive as usual, but interlaced. An interlaced buffer as
 * supported here must always contain both top and bottom fields.
 * The top field always begins on the first pixel row. The temporal
 * ordering between the two fields is top field first, unless
 * 'bottom_first' is specified. It is undefined whether 'bottom_first'
 * is ignored if 'interlaced' is not set.
 *
 * This protocol does not convey any information about field rate,
 * duration, or timing, other than the relative ordering between the
 * two fields in one buffer. A compositor may have to estimate the
 * intended field rate from the incoming buffer rate. It is undefined
 * whether the time of receiving wl_surface.commit with a new buffer
 * attached, applying the wl_surface state, wl_surface.frame callback
 * trigger, presentation, or any other point in the compositor cycle
 * is used to measure the frame or field times. There is no support
 * for detecting missed or late frames/fields/buffers either, and
 * there is no support whatsoever for cooperating with interlaced
 * compositor output.
 *
 * The composited image quality resulting from the use of interlaced
 * buffers is explicitly undefined. A compositor may use elaborate
 * hardware features or software to deinterlace and create progressive
 * output frames from a sequence of interlaced input buffers, or it
 * may produce substandard image quality. However, compositors that
 * cannot guarantee reasonable image quality in all cases are recommended
 * to just reject all interlaced buffers.
 *
 * Any argument errors, including non-positive width or height,
 * mismatch between the number of planes and the format, bad
 * format, bad offset or stride, may be indicated by fatal protocol
 * errors: INCOMPLETE, INVALID_FORMAT, INVALID_DIMENSIONS,
 * OUT_OF_BOUNDS.
 *
 * Dmabuf import errors in the server that are not obvious client
 * bugs are returned via the 'failed' event as non-fatal. This
 * allows attempting dmabuf sharing and falling back in the client
 * if it fails.
 *
 * This request can be sent only once in the object's lifetime, after
 * which the only legal request is destroy. This object should be
 * destroyed after issuing a 'create' request. Attempting to use this
 * object after issuing 'create' raises ALREADY_USED protocol error.
 *
 * It is not mandatory to issue 'create'. If a client wants to
 * cancel the buffer creation, it can just destroy this object.
 */
static inline void
zwp_linux_buffer_params_v1_create(struct zwp_linux_buffer_params_v1 *zwp_linux_buffer_params_v1, int32_t width, int32_t height, uint32_t format, uint32_t flags)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_linux_buffer_params_v1,
			 ZWP_LINUX_BUFFER_PARAMS_V1_CREATE, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_linux_buffer_params_v1), 0, width, height, format, flags);
}

/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 *
 * This asks for immediate creation of a wl_buffer by importing the
 * added dmabufs.
 *
 * In case of import success, no event is sent from the server, and the
 * wl_buffer is ready to be used by the client.
 *
 * Upon import failure, either of the following may happen, as seen fit
 * by the implementation:
 * - the client is terminated with one of the following fatal protocol
 * errors:
 * - INCOMPLETE, INVALID_FORMAT, INVALID_DIMENSIONS, OUT_OF_BOUNDS,
 * in case of argument errors such as mismatch between the number
 * of planes and the format, bad format, non-positive width or
 * height, or bad offset or stride.
 * - INVALID_WL_BUFFER, in case the cause for failure is unknown or
 * platform specific.
 * - the server creates an invalid wl_buffer, marks it as failed and
 * sends a 'failed' event to the client. The result of using this
 * invalid wl_buffer as an argument in any request by the client is
 * defined by the compositor implementation.
 *
 * This takes the same arguments as a 'create' request, and obeys the
 * same restrictions.
 */
static inline struct wl_buffer *
zwp_linux_buffer_params_v1_create_immed(struct zwp_linux_buffer_params_v1 *zwp_linux_buffer_params_v1, int32_t width, int32_t height, uint32_t format, uint32_t flags)
{
	struct wl_proxy *buffer_id;

	buffer_id = wl_proxy_marshal_flags((struct wl_proxy *) zwp_linux_buffer_params_v1,
			 ZWP_LINUX_BUFFER_PARAMS_V1_CREATE_IMMED, &wl_buffer_interface, wl_proxy_get_version((struct wl_proxy *) zwp_linux_buffer_params_v1), 0, NULL, width, height, format, flags);

	return (struct wl_buffer *) buffer_id;
}

#ifndef ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FLAGS_ENUM
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FLAGS_ENUM
enum zwp_linux_dmabuf_feedback_v1_tranche_flags {
	/**
	 * direct scan-out tranche
	 */
	ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FLAGS_SCANOUT = 1,
};
#endif /* ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FLAGS_ENUM */

/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 * @struct zwp_linux_dmabuf_feedback_v1_listener
 */
struct zwp_linux_dmabuf_feedback_v1_listener {
	/**
	 * all feedback has been sent
	 *
	 * This event is sent after all parameters of a
	 * wp_linux_dmabuf_feedback object have been sent.
	 *
	 * This allows changes to the wp_linux_dmabuf_feedback parameters
	 * to be seen as atomic, even if they happen via multiple events.
	 */
	void (*done)(void *data,
		     struct zwp_linux_dmabuf_feedback_v1 *zwp_linux_dmabuf_feedback_v1);
	/**
	 * format and modifier table
	 *
	 * This event provides a file descriptor which can be
	 * memory-mapped to access the format and modifier table.
	 *
	 * The table contains a tightly packed array of consecutive format
	 * + modifier pairs. Each pair is 16 bytes wide. It contains a
	 * format as a 32-bit unsigned integer, followed by 4 bytes of
	 * unused padding, and a modifier as a 64-bit unsigned integer. The
	 * native endianness is used.
	 *
	 * The client must map the file descriptor in read-only private
	 * mode.
	 *
	 * Compositors are not allowed to mutate the table file contents
	 * once this event has been sent. Instead, compositors must create
	 * a new, separate table file and re-send feedback parameters.
	 * Compositors are allowed to store duplicate format + modifier
	 * pairs in the table.
	 * @param fd table file descriptor
	 * @param size table size, in bytes
	 */
	void (*format_table)(void *data,
			     struct zwp_linux_dmabuf_feedback_v1 *zwp_linux_dmabuf_feedback_v1,
			     int32_t fd,
			     uint32_t size);
	/**
	 * preferred main device
	 *
	 * This event advertises the main device that the server prefers
	 * to use when direct scan-out to the target device isn't possible.
	 * The advertised main device may be different for each
	 * wp_linux_dmabuf_feedback object, and may change over time.
	 *
	 * There is exactly one main device. The compositor must send at
	 * least one preference tranche with tranche_target_device equal to
	 * main_device.
	 *
	 * Clients need to create buffers that the main device can import
	 * and read from, otherwise creating the dmabuf wl_buffer will fail
	 * (see the wp_linux_buffer_params.create and create_immed requests
	 * for details). The main device will also likely be kept active by
	 * the compositor, so clients can use it instead of waking up
	 * another device for power savings.
	 *
	 * In general the device is a DRM node. The DRM node type (primary
	 * vs. render) is unspecified. Clients must not rely on the
	 * compositor sending a particular node type. Clients cannot check
	 * two devices for equality by comparing the dev_t value.
	 *
	 * If explicit modifiers are not supported and the client performs
	 * buffer allocations on a different device than the main device,
	 * then the client must force the buffer to have a linear layout.
	 * @param device device dev_t value
	 */
	void (*main_device)(void *data,
			    struct zwp_linux_dmabuf_feedback_v1 *zwp_linux_dmabuf_feedback_v1,
			    struct wl_array *device);
	/**
	 * a preference tranche has been sent
	 *
	 * This event splits tranche_target_device and tranche_formats
	 * events in preference tranches. It is sent after a set of
	 * tranche_target_device and tranche_formats events; it represents
	 * the end of a tranche. The next tranche will have a lower
	 * preference.
	 */
	void (*tranche_done)(void *data,
			     struct zwp_linux_dmabuf_feedback_v1 *zwp_linux_dmabuf_feedback_v1);
	/**
	 * target device
	 *
	 * This event advertises the target device that the server
	 * prefers to use for a buffer created given this tranche. The
	 * advertised target device may be different for each preference
	 * tranche, and may change over time.
	 *
	 * There is exactly one target device per tranche.
	 *
	 * The target device may be a scan-out device, for example if the
	 * compositor prefers to directly scan-out a buffer created given
	 * this tranche. The target device may be a rendering device, for
	 * example if the compositor prefers to texture from said buffer.
	 *
	 * The client can use this hint to allocate the buffer in a way
	 * that makes it accessible from the target device, ideally
	 * directly. The buffer must still be accessible from the main
	 * device, either through direct import or through a potentially
	 * more expensive fallback path. If the buffer can't be directly
	 * imported from the main device then clients must be prepared for
	 * the compositor changing the tranche priority or making wl_buffer
	 * creation fail (see the wp_linux_buffer_params.create and
	 * create_immed requests for details).
	 *
	 * If the device is a DRM node, the DRM node type (primary vs.
	 * render) is unspecified. Clients must not rely on the compositor
	 * sending a particular node type. Clients cannot check two devices
	 * for equality by comparing the dev_t value.
	 *
	 * This event is tied to a preference tranche, see the tranche_done
	 * event.
	 * @param device device dev_t value
	 */
	void (*tranche_target_device)(void *data,
				      struct zwp_linux_dmabuf_feedback_v1 *zwp_linux_dmabuf_feedback_v1,
				      struct wl_array *device);
	/**
	 * supported buffer format modifier
	 *
	 * This event advertises the format + modifier combinations that
	 * the compositor supports.
	 *
	 * It carries an array of indices, each referring to a format +
	 * modifier pair in the last received format table (see the
	 * format_table event). Each index is a 16-bit unsigned integer in
	 * native endianness.
	 *
	 * For legacy support, DRM_FORMAT_MOD_INVALID is an allowed
	 * modifier. It indicates that the server can support the format
	 * with an implicit modifier. When a buffer has
	 * DRM_FORMAT_MOD_INVALID as its modifier, it is as if no explicit
	 * modifier is specified. The effective modifier will be derived
	 * from the dmabuf.
	 *
	 * A compositor that sends valid modifiers and
	 * DRM_FORMAT_MOD_INVALID for a given format supports both explicit
	 * modifiers and implicit modifiers.
	 *
	 * Compositors must not send duplicate format + modifier pairs
	 * within the same tranche or across two different tranches with
	 * the same target device and flags.
	 *
	 * This event is tied to a preference tranche, see the tranche_done
	 * event.
	 *
	 * For the definition of the format and modifier codes, see the
	 * wp_linux_buffer_params.create request.
	 * @param indices array of 16-bit indexes
	 */
	void (*tranche_formats)(void *data,
				struct zwp_linux_dmabuf_feedback_v1 *zwp_linux_dmabuf_feedback_v1,
				struct wl_array *indices);
	/**
	 * tranche flags
	 *
	 * This event sets tranche-specific flags.
	 *
	 * The scanout flag is a hint that direct scan-out may be attempted
	 * by the compositor on the target device if the client
	 * appropriately allocates a buffer. How to allocate a buffer that
	 * can be scanned out on the target device is
	 * implementation-defined.
	 *
	 * This event is tied to a preference tranche, see the tranche_done
	 * event.
	 * @param flags tranche flags
	 */
	void (*tranche_flags)(void *data,
			      struct zwp_linux_dmabuf_feedback_v1 *zwp_linux_dmabuf_feedback_v1,
			      uint32_t flags);
};

/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 */
static inline int
zwp_linux_dmabuf_feedback_v1_add_listener(struct zwp_linux_dmabuf_feedback_v1 *zwp_linux_dmabuf_feedback_v1,
					  const struct zwp_linux_dmabuf_feedback_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwp_linux_dmabuf_feedback_v1,
				     (void (**)(void)) listener, data);
}

#define ZWP_LINUX_DMABUF_FEEDBACK_V1_DESTROY 0

/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 */
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 */
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_FORMAT_TABLE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 */
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_MAIN_DEVICE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 */
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 */
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_TARGET_DEVICE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 */
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FORMATS_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 */
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FLAGS_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 */
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zwp_linux_dmabuf_feedback_v1 */
static inline void
zwp_linux_dmabuf_feedback_v1_set_user_data(struct zwp_linux_dmabuf_feedback_v1 *zwp_linux_dmabuf_feedback_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwp_linux_dmabuf_feedback_v1, user_data);
}

/** @ingroup iface_zwp_linux_dmabuf_feedback_v1 */
static inline void *
zwp_linux_dmabuf_feedback_v1_get_user_data(struct zwp_linux_dmabuf_feedback_v1 *zwp_linux_dmabuf_feedback_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwp_linux_dmabuf_feedback_v1);
}

static inline uint32_t
zwp_linux_dmabuf_feedback_v1_get_version(struct zwp_linux_dmabuf_feedback_v1 *zwp_linux_dmabuf_feedback_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwp_linux_dmabuf_feedback_v1);
}

/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 *
 * Using this request a client can tell the server that it is not going to
 * use the wp_linux_dmabuf_feedback object anymore.
 */
static inline void
zwp_linux_dmabuf_feedback_v1_destroy(struct zwp_linux_dmabuf_feedback_v1 *zwp_linux_dmabuf_feedback_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwp_linux_dmabuf_feedback_v1,
			 ZWP_LINUX_DMABUF_FEEDBACK_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwp_linux_dmabuf_feedback_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
