// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from ATmega8535.atdf, see http://packs.download.atmel.com/

//go:build avr && atmega8535

// Device information for the ATmega8535.
package avr

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATmega8535"
	ARCH   = "AVR8"
	FAMILY = "megaAVR"
)

// Interrupts
const (
	IRQ_RESET        = 0  // External Reset, Power-on Reset and Watchdog Reset
	IRQ_INT0         = 1  // External Interrupt 0
	IRQ_INT1         = 2  // External Interrupt 1
	IRQ_TIMER2_COMP  = 3  // Timer/Counter2 Compare Match
	IRQ_TIMER2_OVF   = 4  // Timer/Counter2 Overflow
	IRQ_TIMER1_CAPT  = 5  // Timer/Counter1 Capture Event
	IRQ_TIMER1_COMPA = 6  // Timer/Counter1 Compare Match A
	IRQ_TIMER1_COMPB = 7  // Timer/Counter1 Compare Match B
	IRQ_TIMER1_OVF   = 8  // Timer/Counter1 Overflow
	IRQ_TIMER0_OVF   = 9  // Timer/Counter0 Overflow
	IRQ_SPI_STC      = 10 // SPI Serial Transfer Complete
	IRQ_USART_RX     = 11 // USART, RX Complete
	IRQ_USART_UDRE   = 12 // USART Data Register Empty
	IRQ_USART_TX     = 13 // USART, TX Complete
	IRQ_ADC          = 14 // ADC Conversion Complete
	IRQ_EE_RDY       = 15 // EEPROM Ready
	IRQ_ANA_COMP     = 16 // Analog Comparator
	IRQ_TWI          = 17 // Two-wire Serial Interface
	IRQ_INT2         = 18 // External Interrupt Request 2
	IRQ_TIMER0_COMP  = 19 // TimerCounter0 Compare Match
	IRQ_SPM_RDY      = 20 // Store Program Memory Read
	IRQ_max          = 20 // Highest interrupt number on this device.
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export __vector_RESET
//go:interrupt
func interruptRESET() {
	callHandlers(IRQ_RESET)
}

//export __vector_INT0
//go:interrupt
func interruptINT0() {
	callHandlers(IRQ_INT0)
}

//export __vector_INT1
//go:interrupt
func interruptINT1() {
	callHandlers(IRQ_INT1)
}

//export __vector_TIMER2_COMP
//go:interrupt
func interruptTIMER2_COMP() {
	callHandlers(IRQ_TIMER2_COMP)
}

//export __vector_TIMER2_OVF
//go:interrupt
func interruptTIMER2_OVF() {
	callHandlers(IRQ_TIMER2_OVF)
}

//export __vector_TIMER1_CAPT
//go:interrupt
func interruptTIMER1_CAPT() {
	callHandlers(IRQ_TIMER1_CAPT)
}

//export __vector_TIMER1_COMPA
//go:interrupt
func interruptTIMER1_COMPA() {
	callHandlers(IRQ_TIMER1_COMPA)
}

//export __vector_TIMER1_COMPB
//go:interrupt
func interruptTIMER1_COMPB() {
	callHandlers(IRQ_TIMER1_COMPB)
}

//export __vector_TIMER1_OVF
//go:interrupt
func interruptTIMER1_OVF() {
	callHandlers(IRQ_TIMER1_OVF)
}

//export __vector_TIMER0_OVF
//go:interrupt
func interruptTIMER0_OVF() {
	callHandlers(IRQ_TIMER0_OVF)
}

//export __vector_SPI_STC
//go:interrupt
func interruptSPI_STC() {
	callHandlers(IRQ_SPI_STC)
}

//export __vector_USART_RX
//go:interrupt
func interruptUSART_RX() {
	callHandlers(IRQ_USART_RX)
}

//export __vector_USART_UDRE
//go:interrupt
func interruptUSART_UDRE() {
	callHandlers(IRQ_USART_UDRE)
}

//export __vector_USART_TX
//go:interrupt
func interruptUSART_TX() {
	callHandlers(IRQ_USART_TX)
}

//export __vector_ADC
//go:interrupt
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export __vector_EE_RDY
//go:interrupt
func interruptEE_RDY() {
	callHandlers(IRQ_EE_RDY)
}

//export __vector_ANA_COMP
//go:interrupt
func interruptANA_COMP() {
	callHandlers(IRQ_ANA_COMP)
}

//export __vector_TWI
//go:interrupt
func interruptTWI() {
	callHandlers(IRQ_TWI)
}

//export __vector_INT2
//go:interrupt
func interruptINT2() {
	callHandlers(IRQ_INT2)
}

//export __vector_TIMER0_COMP
//go:interrupt
func interruptTIMER0_COMP() {
	callHandlers(IRQ_TIMER0_COMP)
}

//export __vector_SPM_RDY
//go:interrupt
func interruptSPM_RDY() {
	callHandlers(IRQ_SPM_RDY)
}

// Peripherals.
var (
	// Analog-to-Digital Converter
	ADMUX  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x27)))
	ADCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x26)))
	ADCL   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	ADCH   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))
	SFIOR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))

	// Analog Comparator
	ACSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x28)))

	// Two Wire Serial Interface
	TWBR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x20)))
	TWCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x56)))
	TWSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x21)))
	TWDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))
	TWAR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x22)))

	// USART
	UDR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2c)))
	UCSRA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2b)))
	UCSRB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2a)))
	UCSRC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	UBRRH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	UBRRL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x29)))

	// I/O Port
	PORTA = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))
	DDRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3a)))
	PINA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x39)))

	// I/O Port
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x38)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x37)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))

	// I/O Port
	PORTC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))
	DDRC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x34)))
	PINC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x33)))

	// I/O Port
	PORTD = (*volatile.Register8)(unsafe.Pointer(uintptr(0x32)))
	DDRD  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x31)))
	PIND  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x30)))

	// Serial Peripheral Interface
	SPDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2f)))
	SPSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2e)))
	SPCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2d)))

	// EEPROM
	EEARL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
	EEARH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))
	EEDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EECR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))

	// Timer/Counter, 8-bit
	TCCR0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	TCNT0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x52)))
	OCR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5c)))
	TIMSK = (*volatile.Register8)(unsafe.Pointer(uintptr(0x59)))
	TIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x58)))

	// Timer/Counter, 16-bit
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4f)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4e)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4a)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4b)))
	OCR1BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x48)))
	OCR1BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x49)))
	ICR1L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))
	ICR1H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))

	// Timer/Counter, 8-bit Async
	TCCR2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x45)))
	TCNT2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x44)))
	OCR2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x43)))
	ASSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x42)))

	// External Interrupts
	GICR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5b)))
	GIFR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5a)))
	MCUCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x55)))
	MCUCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x54)))

	// Watchdog Timer
	WDTCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))

	// CPU Registers
	SREG   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SPL    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	OSCCAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x51)))
	SPMCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))

	// Fuses
	HIGH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))
)

// Bitfields for FUSE: Fuses
const (
	// HIGH
	HIGH_S8535C      = 0x80 // AT90S4434/8535 compatibility mode
	HIGH_S8535C_Msk  = 0x80 // AT90S4434/8535 compatibility mode
	HIGH_WDTON       = 0x40 // Watch-dog Timer always on
	HIGH_WDTON_Msk   = 0x40 // Watch-dog Timer always on
	HIGH_SPIEN       = 0x20 // Serial program downloading (SPI) enabled
	HIGH_SPIEN_Msk   = 0x20 // Serial program downloading (SPI) enabled
	HIGH_EESAVE      = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_EESAVE_Msk  = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BOOTSZ0     = 0x2  // Select Boot Size
	HIGH_BOOTSZ1     = 0x4  // Select Boot Size
	HIGH_BOOTSZ_Msk  = 0x6  // Select Boot Size
	HIGH_BOOTRST     = 0x1  // Boot Reset vector Enabled
	HIGH_BOOTRST_Msk = 0x1  // Boot Reset vector Enabled
	HIGH_CKOPT       = 0x10 // CKOPT fuse (operation dependent of CKSEL fuses)
	HIGH_CKOPT_Msk   = 0x10 // CKOPT fuse (operation dependent of CKSEL fuses)

	// LOW
	LOW_BODLEVEL      = 0x80 // Brownout detector trigger level
	LOW_BODLEVEL_Msk  = 0x80 // Brownout detector trigger level
	LOW_BODEN         = 0x40 // Brown-out detection enabled
	LOW_BODEN_Msk     = 0x40 // Brown-out detection enabled
	LOW_SUT_CKSEL0    = 0x1  // Select Clock Source
	LOW_SUT_CKSEL1    = 0x2  // Select Clock Source
	LOW_SUT_CKSEL2    = 0x4  // Select Clock Source
	LOW_SUT_CKSEL3    = 0x8  // Select Clock Source
	LOW_SUT_CKSEL4    = 0x10 // Select Clock Source
	LOW_SUT_CKSEL5    = 0x20 // Select Clock Source
	LOW_SUT_CKSEL_Msk = 0x3f // Select Clock Source
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0      = 0x1  // Memory Lock
	LOCKBIT_LB1      = 0x2  // Memory Lock
	LOCKBIT_LB_Msk   = 0x3  // Memory Lock
	LOCKBIT_BLB00    = 0x4  // Boot Loader Protection Mode
	LOCKBIT_BLB01    = 0x8  // Boot Loader Protection Mode
	LOCKBIT_BLB0_Msk = 0xc  // Boot Loader Protection Mode
	LOCKBIT_BLB10    = 0x10 // Boot Loader Protection Mode
	LOCKBIT_BLB11    = 0x20 // Boot Loader Protection Mode
	LOCKBIT_BLB1_Msk = 0x30 // Boot Loader Protection Mode
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// ADMUX: The ADC multiplexer Selection Register
	ADMUX_REFS0     = 0x40 // Reference Selection Bits
	ADMUX_REFS1     = 0x80 // Reference Selection Bits
	ADMUX_REFS_Msk  = 0xc0 // Reference Selection Bits
	ADMUX_ADLAR     = 0x20 // Left Adjust Result
	ADMUX_ADLAR_Msk = 0x20 // Left Adjust Result
	ADMUX_MUX0      = 0x1  // Analog Channel and Gain Selection Bits
	ADMUX_MUX1      = 0x2  // Analog Channel and Gain Selection Bits
	ADMUX_MUX2      = 0x4  // Analog Channel and Gain Selection Bits
	ADMUX_MUX3      = 0x8  // Analog Channel and Gain Selection Bits
	ADMUX_MUX4      = 0x10 // Analog Channel and Gain Selection Bits
	ADMUX_MUX_Msk   = 0x1f // Analog Channel and Gain Selection Bits

	// ADCSRA: The ADC Control and Status register
	ADCSRA_ADEN      = 0x80 // ADC Enable
	ADCSRA_ADEN_Msk  = 0x80 // ADC Enable
	ADCSRA_ADSC      = 0x40 // ADC Start Conversion
	ADCSRA_ADSC_Msk  = 0x40 // ADC Start Conversion
	ADCSRA_ADATE     = 0x20 // ADC Auto Trigger
	ADCSRA_ADATE_Msk = 0x20 // ADC Auto Trigger
	ADCSRA_ADIF      = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIF_Msk  = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIE      = 0x8  // ADC Interrupt Enable
	ADCSRA_ADIE_Msk  = 0x8  // ADC Interrupt Enable
	ADCSRA_ADPS0     = 0x1  // ADC Prescaler Select Bits
	ADCSRA_ADPS1     = 0x2  // ADC Prescaler Select Bits
	ADCSRA_ADPS2     = 0x4  // ADC Prescaler Select Bits
	ADCSRA_ADPS_Msk  = 0x7  // ADC Prescaler Select Bits

	// SFIOR: Special Function IO Register
	SFIOR_ADTS0    = 0x20 // ADC Auto Trigger Sources
	SFIOR_ADTS1    = 0x40 // ADC Auto Trigger Sources
	SFIOR_ADTS2    = 0x80 // ADC Auto Trigger Sources
	SFIOR_ADTS_Msk = 0xe0 // ADC Auto Trigger Sources
)

// Bitfields for AC: Analog Comparator
const (
	// ACSR: Analog Comparator Control And Status Register
	ACSR_ACD      = 0x80 // Analog Comparator Disable
	ACSR_ACD_Msk  = 0x80 // Analog Comparator Disable
	ACSR_ACBG     = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACBG_Msk = 0x40 // Analog Comparator Bandgap Select
	ACSR_ACO      = 0x20 // Analog Compare Output
	ACSR_ACO_Msk  = 0x20 // Analog Compare Output
	ACSR_ACI      = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACI_Msk  = 0x10 // Analog Comparator Interrupt Flag
	ACSR_ACIE     = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIE_Msk = 0x8  // Analog Comparator Interrupt Enable
	ACSR_ACIC     = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIC_Msk = 0x4  // Analog Comparator Input Capture Enable
	ACSR_ACIS0    = 0x1  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS1    = 0x2  // Analog Comparator Interrupt Mode Select bits
	ACSR_ACIS_Msk = 0x3  // Analog Comparator Interrupt Mode Select bits
)

// Bitfields for TWI: Two Wire Serial Interface
const (
	// TWCR: TWI Control Register
	TWCR_TWINT     = 0x80 // TWI Interrupt Flag
	TWCR_TWINT_Msk = 0x80 // TWI Interrupt Flag
	TWCR_TWEA      = 0x40 // TWI Enable Acknowledge Bit
	TWCR_TWEA_Msk  = 0x40 // TWI Enable Acknowledge Bit
	TWCR_TWSTA     = 0x20 // TWI Start Condition Bit
	TWCR_TWSTA_Msk = 0x20 // TWI Start Condition Bit
	TWCR_TWSTO     = 0x10 // TWI Stop Condition Bit
	TWCR_TWSTO_Msk = 0x10 // TWI Stop Condition Bit
	TWCR_TWWC      = 0x8  // TWI Write Collition Flag
	TWCR_TWWC_Msk  = 0x8  // TWI Write Collition Flag
	TWCR_TWEN      = 0x4  // TWI Enable Bit
	TWCR_TWEN_Msk  = 0x4  // TWI Enable Bit
	TWCR_TWIE      = 0x1  // TWI Interrupt Enable
	TWCR_TWIE_Msk  = 0x1  // TWI Interrupt Enable

	// TWSR: TWI Status Register
	TWSR_TWS0     = 0x8  // TWI Status
	TWSR_TWS1     = 0x10 // TWI Status
	TWSR_TWS2     = 0x20 // TWI Status
	TWSR_TWS3     = 0x40 // TWI Status
	TWSR_TWS4     = 0x80 // TWI Status
	TWSR_TWS_Msk  = 0xf8 // TWI Status
	TWSR_TWPS0    = 0x1  // TWI Prescaler
	TWSR_TWPS1    = 0x2  // TWI Prescaler
	TWSR_TWPS_Msk = 0x3  // TWI Prescaler

	// TWAR: TWI (Slave) Address register
	TWAR_TWA0      = 0x2  // TWI (Slave) Address register Bits
	TWAR_TWA1      = 0x4  // TWI (Slave) Address register Bits
	TWAR_TWA2      = 0x8  // TWI (Slave) Address register Bits
	TWAR_TWA3      = 0x10 // TWI (Slave) Address register Bits
	TWAR_TWA4      = 0x20 // TWI (Slave) Address register Bits
	TWAR_TWA5      = 0x40 // TWI (Slave) Address register Bits
	TWAR_TWA6      = 0x80 // TWI (Slave) Address register Bits
	TWAR_TWA_Msk   = 0xfe // TWI (Slave) Address register Bits
	TWAR_TWGCE     = 0x1  // TWI General Call Recognition Enable Bit
	TWAR_TWGCE_Msk = 0x1  // TWI General Call Recognition Enable Bit
)

// Bitfields for USART: USART
const (
	// UCSRA: USART Control and Status Register A
	UCSRA_RXC      = 0x80 // USART Receive Complete
	UCSRA_RXC_Msk  = 0x80 // USART Receive Complete
	UCSRA_TXC      = 0x40 // USART Transmitt Complete
	UCSRA_TXC_Msk  = 0x40 // USART Transmitt Complete
	UCSRA_UDRE     = 0x20 // USART Data Register Empty
	UCSRA_UDRE_Msk = 0x20 // USART Data Register Empty
	UCSRA_FE       = 0x10 // Framing Error
	UCSRA_FE_Msk   = 0x10 // Framing Error
	UCSRA_DOR      = 0x8  // Data overRun
	UCSRA_DOR_Msk  = 0x8  // Data overRun
	UCSRA_UPE      = 0x4  // Parity Error
	UCSRA_UPE_Msk  = 0x4  // Parity Error
	UCSRA_U2X      = 0x2  // Double the USART transmission speed
	UCSRA_U2X_Msk  = 0x2  // Double the USART transmission speed
	UCSRA_MPCM     = 0x1  // Multi-processor Communication Mode
	UCSRA_MPCM_Msk = 0x1  // Multi-processor Communication Mode

	// UCSRB: USART Control and Status Register B
	UCSRB_RXCIE     = 0x80 // RX Complete Interrupt Enable
	UCSRB_RXCIE_Msk = 0x80 // RX Complete Interrupt Enable
	UCSRB_TXCIE     = 0x40 // TX Complete Interrupt Enable
	UCSRB_TXCIE_Msk = 0x40 // TX Complete Interrupt Enable
	UCSRB_UDRIE     = 0x20 // USART Data register Empty Interrupt Enable
	UCSRB_UDRIE_Msk = 0x20 // USART Data register Empty Interrupt Enable
	UCSRB_RXEN      = 0x10 // Receiver Enable
	UCSRB_RXEN_Msk  = 0x10 // Receiver Enable
	UCSRB_TXEN      = 0x8  // Transmitter Enable
	UCSRB_TXEN_Msk  = 0x8  // Transmitter Enable
	UCSRB_UCSZ2     = 0x4  // Character Size Bit 2
	UCSRB_UCSZ2_Msk = 0x4  // Character Size Bit 2
	UCSRB_RXB8      = 0x2  // Receive Data Bit 8
	UCSRB_RXB8_Msk  = 0x2  // Receive Data Bit 8
	UCSRB_TXB8      = 0x1  // Transmit Data Bit 8
	UCSRB_TXB8_Msk  = 0x1  // Transmit Data Bit 8

	// UCSRC: USART Control and Status Register C
	UCSRC_URSEL     = 0x80 // Register Select
	UCSRC_URSEL_Msk = 0x80 // Register Select
	UCSRC_UMSEL     = 0x40 // USART Mode Select
	UCSRC_UMSEL_Msk = 0x40 // USART Mode Select
	UCSRC_UPM0      = 0x10 // Parity Mode Bits
	UCSRC_UPM1      = 0x20 // Parity Mode Bits
	UCSRC_UPM_Msk   = 0x30 // Parity Mode Bits
	UCSRC_USBS      = 0x8  // Stop Bit Select
	UCSRC_USBS_Msk  = 0x8  // Stop Bit Select
	UCSRC_UCSZ0     = 0x2  // Character Size Bits
	UCSRC_UCSZ1     = 0x4  // Character Size Bits
	UCSRC_UCSZ_Msk  = 0x6  // Character Size Bits
	UCSRC_UCPOL     = 0x1  // Clock Polarity
	UCSRC_UCPOL_Msk = 0x1  // Clock Polarity

	// UBRRH: USART Baud Rate Register High Byte
	UBRRH_URSEL     = 0x80 // Register Select
	UBRRH_URSEL_Msk = 0x80 // Register Select
	UBRRH_UBRR10    = 0x4  // USART Baud Rate Register bit 11
	UBRRH_UBRR11    = 0x8  // USART Baud Rate Register bit 11
	UBRRH_UBRR1_Msk = 0xc  // USART Baud Rate Register bit 11
	UBRRH_UBRR0     = 0x1  // USART Baud Rate Register bits
	UBRRH_UBRR1     = 0x2  // USART Baud Rate Register bits
	UBRRH_UBRR_Msk  = 0x3  // USART Baud Rate Register bits
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// SPSR: SPI Status Register
	SPSR_SPIF      = 0x80 // SPI Interrupt Flag
	SPSR_SPIF_Msk  = 0x80 // SPI Interrupt Flag
	SPSR_WCOL      = 0x40 // Write Collision Flag
	SPSR_WCOL_Msk  = 0x40 // Write Collision Flag
	SPSR_SPI2X     = 0x1  // Double SPI Speed Bit
	SPSR_SPI2X_Msk = 0x1  // Double SPI Speed Bit

	// SPCR: SPI Control Register
	SPCR_SPIE     = 0x80 // SPI Interrupt Enable
	SPCR_SPIE_Msk = 0x80 // SPI Interrupt Enable
	SPCR_SPE      = 0x40 // SPI Enable
	SPCR_SPE_Msk  = 0x40 // SPI Enable
	SPCR_DORD     = 0x20 // Data Order
	SPCR_DORD_Msk = 0x20 // Data Order
	SPCR_MSTR     = 0x10 // Master/Slave Select
	SPCR_MSTR_Msk = 0x10 // Master/Slave Select
	SPCR_CPOL     = 0x8  // Clock polarity
	SPCR_CPOL_Msk = 0x8  // Clock polarity
	SPCR_CPHA     = 0x4  // Clock Phase
	SPCR_CPHA_Msk = 0x4  // Clock Phase
	SPCR_SPR0     = 0x1  // SPI Clock Rate Selects
	SPCR_SPR1     = 0x2  // SPI Clock Rate Selects
	SPCR_SPR_Msk  = 0x3  // SPI Clock Rate Selects
)

// Bitfields for EEPROM: EEPROM
const (
	// EECR: EEPROM Control Register
	EECR_EERIE     = 0x8 // EEPROM Ready Interrupt Enable
	EECR_EERIE_Msk = 0x8 // EEPROM Ready Interrupt Enable
	EECR_EEMWE     = 0x4 // EEPROM Master Write Enable
	EECR_EEMWE_Msk = 0x4 // EEPROM Master Write Enable
	EECR_EEWE      = 0x2 // EEPROM Write Enable
	EECR_EEWE_Msk  = 0x2 // EEPROM Write Enable
	EECR_EERE      = 0x1 // EEPROM Read Enable
	EECR_EERE_Msk  = 0x1 // EEPROM Read Enable
)

// Bitfields for TC0: Timer/Counter, 8-bit
const (
	// TCCR0: Timer/Counter Control Register
	TCCR0_FOC0      = 0x80 // Force Output Compare
	TCCR0_FOC0_Msk  = 0x80 // Force Output Compare
	TCCR0_WGM00     = 0x40 // Waveform Generation Mode 0
	TCCR0_WGM00_Msk = 0x40 // Waveform Generation Mode 0
	TCCR0_COM00     = 0x10 // Compare Match Output Modes
	TCCR0_COM01     = 0x20 // Compare Match Output Modes
	TCCR0_COM0_Msk  = 0x30 // Compare Match Output Modes
	TCCR0_WGM01     = 0x8  // Waveform Generation Mode 1
	TCCR0_WGM01_Msk = 0x8  // Waveform Generation Mode 1
	TCCR0_CS00      = 0x1  // Clock Selects
	TCCR0_CS01      = 0x2  // Clock Selects
	TCCR0_CS02      = 0x4  // Clock Selects
	TCCR0_CS0_Msk   = 0x7  // Clock Selects

	// TIMSK: Timer/Counter Interrupt Mask Register
	TIMSK_OCIE0     = 0x2 // Timer/Counter0 Output Compare Match Interrupt register
	TIMSK_OCIE0_Msk = 0x2 // Timer/Counter0 Output Compare Match Interrupt register
	TIMSK_TOIE0     = 0x1 // Timer/Counter0 Overflow Interrupt Enable
	TIMSK_TOIE0_Msk = 0x1 // Timer/Counter0 Overflow Interrupt Enable

	// TIFR: Timer/Counter Interrupt Flag register
	TIFR_OCF0     = 0x2 // Output Compare Flag 0
	TIFR_OCF0_Msk = 0x2 // Output Compare Flag 0
	TIFR_TOV0     = 0x1 // Timer/Counter0 Overflow Flag
	TIFR_TOV0_Msk = 0x1 // Timer/Counter0 Overflow Flag
)

// Bitfields for TC1: Timer/Counter, 16-bit
const (
	// TCCR1A: Timer/Counter1 Control Register A
	TCCR1A_COM1A0    = 0x40 // Compare Output Mode 1A, bits
	TCCR1A_COM1A1    = 0x80 // Compare Output Mode 1A, bits
	TCCR1A_COM1A_Msk = 0xc0 // Compare Output Mode 1A, bits
	TCCR1A_COM1B0    = 0x10 // Compare Output Mode 1B, bits
	TCCR1A_COM1B1    = 0x20 // Compare Output Mode 1B, bits
	TCCR1A_COM1B_Msk = 0x30 // Compare Output Mode 1B, bits
	TCCR1A_FOC1A     = 0x8  // Force Output Compare 1A
	TCCR1A_FOC1A_Msk = 0x8  // Force Output Compare 1A
	TCCR1A_FOC1B     = 0x4  // Force Output Compare 1B
	TCCR1A_FOC1B_Msk = 0x4  // Force Output Compare 1B
	TCCR1A_WGM10     = 0x1  // Waveform Generation Mode
	TCCR1A_WGM11     = 0x2  // Waveform Generation Mode
	TCCR1A_WGM1_Msk  = 0x3  // Waveform Generation Mode

	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_ICNC1     = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICNC1_Msk = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICES1     = 0x40 // Input Capture 1 Edge Select
	TCCR1B_ICES1_Msk = 0x40 // Input Capture 1 Edge Select
	TCCR1B_WGM10     = 0x8  // Waveform Generation Mode
	TCCR1B_WGM11     = 0x10 // Waveform Generation Mode
	TCCR1B_WGM1_Msk  = 0x18 // Waveform Generation Mode
	TCCR1B_CS10      = 0x1  // Prescaler source of Timer/Counter 1
	TCCR1B_CS11      = 0x2  // Prescaler source of Timer/Counter 1
	TCCR1B_CS12      = 0x4  // Prescaler source of Timer/Counter 1
	TCCR1B_CS1_Msk   = 0x7  // Prescaler source of Timer/Counter 1
)

// Bitfields for TC2: Timer/Counter, 8-bit Async
const (
	// TCCR2: Timer/Counter2 Control Register
	TCCR2_FOC2      = 0x80 // Force Output Compare
	TCCR2_FOC2_Msk  = 0x80 // Force Output Compare
	TCCR2_WGM20     = 0x40 // Waveform Genration Mode
	TCCR2_WGM20_Msk = 0x40 // Waveform Genration Mode
	TCCR2_COM20     = 0x10 // Compare Output Mode bits
	TCCR2_COM21     = 0x20 // Compare Output Mode bits
	TCCR2_COM2_Msk  = 0x30 // Compare Output Mode bits
	TCCR2_WGM21     = 0x8  // Waveform Generation Mode
	TCCR2_WGM21_Msk = 0x8  // Waveform Generation Mode
	TCCR2_CS20      = 0x1  // Clock Select bits
	TCCR2_CS21      = 0x2  // Clock Select bits
	TCCR2_CS22      = 0x4  // Clock Select bits
	TCCR2_CS2_Msk   = 0x7  // Clock Select bits

	// ASSR: Asynchronous Status Register
	ASSR_AS2        = 0x8 // Asynchronous Timer/counter2
	ASSR_AS2_Msk    = 0x8 // Asynchronous Timer/counter2
	ASSR_TCN2UB     = 0x4 // Timer/Counter2 Update Busy
	ASSR_TCN2UB_Msk = 0x4 // Timer/Counter2 Update Busy
	ASSR_OCR2UB     = 0x2 // Output Compare Register2 Update Busy
	ASSR_OCR2UB_Msk = 0x2 // Output Compare Register2 Update Busy
	ASSR_TCR2UB     = 0x1 // Timer/counter Control Register2 Update Busy
	ASSR_TCR2UB_Msk = 0x1 // Timer/counter Control Register2 Update Busy
)

// Bitfields for EXINT: External Interrupts
const (
	// GICR: General Interrupt Control Register
	GICR_INT0      = 0x40 // External Interrupt Request 0 Enable
	GICR_INT0_Msk  = 0x40 // External Interrupt Request 0 Enable
	GICR_INT1      = 0x80 // External Interrupt Request 1 Enable
	GICR_INT1_Msk  = 0x80 // External Interrupt Request 1 Enable
	GICR_INT2      = 0x20 // External Interrupt Request 2 Enable
	GICR_INT2_Msk  = 0x20 // External Interrupt Request 2 Enable
	GICR_IVSEL     = 0x2  // Interrupt Vector Select
	GICR_IVSEL_Msk = 0x2  // Interrupt Vector Select
	GICR_IVCE      = 0x1  // Interrupt Vector Change Enable
	GICR_IVCE_Msk  = 0x1  // Interrupt Vector Change Enable

	// GIFR: General Interrupt Flag Register
	GIFR_INTF0     = 0x40 // External Interrupt Flags
	GIFR_INTF1     = 0x80 // External Interrupt Flags
	GIFR_INTF_Msk  = 0xc0 // External Interrupt Flags
	GIFR_INTF2     = 0x20 // External Interrupt Flag 2
	GIFR_INTF2_Msk = 0x20 // External Interrupt Flag 2

	// MCUCR: General Interrupt Control Register
	MCUCR_ISC10    = 0x4 // Interrupt Sense Control 1 Bits
	MCUCR_ISC11    = 0x8 // Interrupt Sense Control 1 Bits
	MCUCR_ISC1_Msk = 0xc // Interrupt Sense Control 1 Bits
	MCUCR_ISC00    = 0x1 // Interrupt Sense Control 0 Bits
	MCUCR_ISC01    = 0x2 // Interrupt Sense Control 0 Bits
	MCUCR_ISC0_Msk = 0x3 // Interrupt Sense Control 0 Bits

	// MCUCSR: MCU Control And Status Register
	MCUCSR_ISC2     = 0x40 // Interrupt Sense Control 2
	MCUCSR_ISC2_Msk = 0x40 // Interrupt Sense Control 2
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCR: Watchdog Timer Control Register
	WDTCR_WDCE     = 0x10 // Watchdog Change Enable
	WDTCR_WDCE_Msk = 0x10 // Watchdog Change Enable
	WDTCR_WDE      = 0x8  // Watch Dog Enable
	WDTCR_WDE_Msk  = 0x8  // Watch Dog Enable
	WDTCR_WDP0     = 0x1  // Watch Dog Timer Prescaler bits
	WDTCR_WDP1     = 0x2  // Watch Dog Timer Prescaler bits
	WDTCR_WDP2     = 0x4  // Watch Dog Timer Prescaler bits
	WDTCR_WDP_Msk  = 0x7  // Watch Dog Timer Prescaler bits
)

// Bitfields for CPU: CPU Registers
const (
	// SREG: Status Register
	SREG_I     = 0x80 // Global Interrupt Enable
	SREG_I_Msk = 0x80 // Global Interrupt Enable
	SREG_T     = 0x40 // Bit Copy Storage
	SREG_T_Msk = 0x40 // Bit Copy Storage
	SREG_H     = 0x20 // Half Carry Flag
	SREG_H_Msk = 0x20 // Half Carry Flag
	SREG_S     = 0x10 // Sign Bit
	SREG_S_Msk = 0x10 // Sign Bit
	SREG_V     = 0x8  // Two's Complement Overflow Flag
	SREG_V_Msk = 0x8  // Two's Complement Overflow Flag
	SREG_N     = 0x4  // Negative Flag
	SREG_N_Msk = 0x4  // Negative Flag
	SREG_Z     = 0x2  // Zero Flag
	SREG_Z_Msk = 0x2  // Zero Flag
	SREG_C     = 0x1  // Carry Flag
	SREG_C_Msk = 0x1  // Carry Flag

	// OSCCAL: Oscillator Calibration Value
	OSCCAL_OSCCAL0    = 0x1  // Oscillator Calibration
	OSCCAL_OSCCAL1    = 0x2  // Oscillator Calibration
	OSCCAL_OSCCAL2    = 0x4  // Oscillator Calibration
	OSCCAL_OSCCAL3    = 0x8  // Oscillator Calibration
	OSCCAL_OSCCAL4    = 0x10 // Oscillator Calibration
	OSCCAL_OSCCAL5    = 0x20 // Oscillator Calibration
	OSCCAL_OSCCAL6    = 0x40 // Oscillator Calibration
	OSCCAL_OSCCAL7    = 0x80 // Oscillator Calibration
	OSCCAL_OSCCAL_Msk = 0xff // Oscillator Calibration

	// SPMCR
	SPMCR_SPMIE      = 0x80 // SPM Interrupt Enable
	SPMCR_SPMIE_Msk  = 0x80 // SPM Interrupt Enable
	SPMCR_RWWSB      = 0x40 // Read-While-Write Section Busy
	SPMCR_RWWSB_Msk  = 0x40 // Read-While-Write Section Busy
	SPMCR_RWWSRE     = 0x10 // Read-While-Write Section Read Enable
	SPMCR_RWWSRE_Msk = 0x10 // Read-While-Write Section Read Enable
	SPMCR_BLBSET     = 0x8  // Boot Lock Bit Set
	SPMCR_BLBSET_Msk = 0x8  // Boot Lock Bit Set
	SPMCR_PGWRT      = 0x4  // Page Write
	SPMCR_PGWRT_Msk  = 0x4  // Page Write
	SPMCR_PGERS      = 0x2  // Page Erase
	SPMCR_PGERS_Msk  = 0x2  // Page Erase
	SPMCR_SPMEN      = 0x1  // Store Program Memory Enable
	SPMCR_SPMEN_Msk  = 0x1  // Store Program Memory Enable
)
