#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
import signal
import globdef
from PyQt5 import QtWidgets
from jacktools.jackmatrix import JackMatrix
from mainwin import Mainwindow


# Define input and output port names.
#
inputs = [ '1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12' ]
outputs = [ 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H' ]
jackname = 'Matrix'


# Create the JackMatrix.
#
jmatrix = JackMatrix (len (inputs), len (outputs), 0.1, jackname)


# Connect inputs and outputs.
#
#jmat.connect_input (0, '...')
#jmat.connect_input (1, '...')
#
#jmat.connect_output (0, '...')
#jmat.connect_output (1, '...')


# Start PyQt5 app.
#
signal.signal (signal.SIGINT, signal.SIG_DFL)
app = QtWidgets.QApplication (sys.argv)
globdef.darkpal (app)
Mainwindow (inputs, outputs, jmatrix, jackname)
sys.exit (app.exec_())


