/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors.telemetry;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Closeable;
import java.security.AccessController;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.cache.Cache;
import org.opensearch.indices.IndicesService;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.commons.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.collectors.TelemetryCollector;
import org.opensearch.performanceanalyzer.commons.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.metrics.RTFMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.metrics.tags.Tags;

public class RTFCacheConfigMetricsCollector
extends PerformanceAnalyzerMetricsCollector
implements TelemetryCollector {
    private static final Logger LOG = LogManager.getLogger(RTFCacheConfigMetricsCollector.class);
    private PerformanceAnalyzerController performanceAnalyzerController;
    private ConfigOverridesWrapper configOverridesWrapper;
    private Closeable fieldDataCacheGauge;
    private Closeable requestCacheGauge;
    private boolean metricsInitialised;

    public RTFCacheConfigMetricsCollector(PerformanceAnalyzerController performanceAnalyzerController, ConfigOverridesWrapper configOverridesWrapper) {
        super(((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(RTFCacheConfigMetricsCollector.class)).samplingInterval, "RTFCacheConfigMetricsCollector", (MeasurementSet)StatMetrics.RTF_CACHE_CONFIG_METRICS_COLLECTOR_EXECUTION_TIME, StatExceptionCode.RTF_CACHE_CONFIG_METRICS_COLLECTOR_ERROR);
        this.performanceAnalyzerController = performanceAnalyzerController;
        this.configOverridesWrapper = configOverridesWrapper;
    }

    public void collectMetrics(long l) {
        if (this.performanceAnalyzerController.isCollectorDisabled(this.configOverridesWrapper, this.getCollectorName())) {
            this.closeOpenGaugeObservablesIfAny();
            LOG.info("RTFCacheConfigMetricsCollector is disabled. Skipping collection.");
            return;
        }
        MetricsRegistry metricsRegistry = OpenSearchResources.INSTANCE.getMetricsRegistry();
        if (metricsRegistry == null) {
            LOG.error("could not get the instance of MetricsRegistry class");
            return;
        }
        IndicesService indicesService = OpenSearchResources.INSTANCE.getIndicesService();
        if (indicesService == null) {
            LOG.error("could not get the instance of indicesService class");
            return;
        }
        LOG.debug("Executing collect metrics for RTFCacheConfigMetricsCollector");
        this.initialiseMetricsIfNeeded(metricsRegistry, indicesService);
    }

    private void initialiseMetricsIfNeeded(MetricsRegistry metricsRegistry, IndicesService indicesService) {
        if (!this.metricsInitialised) {
            this.fieldDataCacheGauge = metricsRegistry.createGauge("cache_max_size", "Cache Max Size metrics", RTFMetrics.MetricUnits.BYTE.toString(), () -> RTFCacheConfigMetricsCollector.getFieldCacheMaxSizeStatus(indicesService), Tags.create().addTag("cache_type", AllMetrics.CacheType.FIELD_DATA_CACHE.toString()));
            this.requestCacheGauge = metricsRegistry.createGauge("cache_max_size", "Cache Max Size metrics", RTFMetrics.MetricUnits.BYTE.toString(), () -> this.getRequestCacheMaxSizeStatus(indicesService), Tags.create().addTag("cache_type", AllMetrics.CacheType.SHARD_REQUEST_CACHE.toString()));
            this.metricsInitialised = true;
        }
    }

    private void closeOpenGaugeObservablesIfAny() {
        if (this.fieldDataCacheGauge != null) {
            try {
                this.fieldDataCacheGauge.close();
            }
            catch (Exception e) {
                LOG.error("Unable to close the fieldDataCacheGauge observable");
            }
            finally {
                this.fieldDataCacheGauge = null;
            }
        }
        if (this.requestCacheGauge != null) {
            try {
                this.requestCacheGauge.close();
            }
            catch (Exception e) {
                LOG.error("Unable to close the fieldDataCacheGauge observable");
            }
            finally {
                this.requestCacheGauge = null;
            }
        }
        if (this.metricsInitialised) {
            this.metricsInitialised = false;
        }
    }

    private double getRequestCacheMaxSizeStatus(IndicesService indicesService) {
        CacheMaxSizeStatus shardRequestCacheMaxSizeStatus = AccessController.doPrivileged(() -> {
            try {
                Object reqCache = FieldUtils.readField((Object)indicesService, (String)"indicesRequestCache", (boolean)true);
                Object openSearchOnHeapCache = FieldUtils.readField((Object)reqCache, (String)"cache", (boolean)true);
                Cache requestCache = (Cache)FieldUtils.readField((Object)openSearchOnHeapCache, (String)"cache", (boolean)true);
                Long requestCacheMaxSize = (Long)FieldUtils.readField((Object)requestCache, (String)"maximumWeight", (boolean)true);
                return new CacheMaxSizeStatus(AllMetrics.CacheType.SHARD_REQUEST_CACHE.toString(), requestCacheMaxSize);
            }
            catch (Exception e) {
                LOG.debug("Error occurred while fetching shardRequestCacheMaxSizeStatus: " + e.getMessage());
                return null;
            }
        });
        if (shardRequestCacheMaxSizeStatus != null && shardRequestCacheMaxSizeStatus.getCacheMaxSize() > 0L) {
            return shardRequestCacheMaxSizeStatus.getCacheMaxSize();
        }
        return 0.0;
    }

    private static double getFieldCacheMaxSizeStatus(IndicesService indicesService) {
        CacheMaxSizeStatus fieldDataCacheMaxSizeStatus = AccessController.doPrivileged(() -> {
            try {
                Cache fieldDataCache = indicesService.getIndicesFieldDataCache().getCache();
                long fieldDataMaxSize = (Long)FieldUtils.readField((Object)fieldDataCache, (String)"maximumWeight", (boolean)true);
                return new CacheMaxSizeStatus(AllMetrics.CacheType.FIELD_DATA_CACHE.toString(), fieldDataMaxSize);
            }
            catch (Exception e) {
                LOG.debug("Error occurred while fetching fieldDataCacheMaxSizeStatus: " + e.getMessage());
                return null;
            }
        });
        if (fieldDataCacheMaxSizeStatus != null && fieldDataCacheMaxSizeStatus.getCacheMaxSize() > 0L) {
            return fieldDataCacheMaxSizeStatus.getCacheMaxSize();
        }
        return 0.0;
    }

    static class CacheMaxSizeStatus
    extends MetricStatus {
        private final String cacheType;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private final Long cacheMaxSize;

        CacheMaxSizeStatus(String cacheType, Long cacheMaxSize) {
            this.cacheType = cacheType;
            this.cacheMaxSize = cacheMaxSize;
        }

        @JsonProperty(value="CacheType")
        public String getCacheType() {
            return this.cacheType;
        }

        @JsonProperty(value="Cache_MaxSize")
        public long getCacheMaxSize() {
            return this.cacheMaxSize;
        }
    }
}

