# -*- warn-indent:false;  -*-

# line 1 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"

# line 646 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"


# THIS IS A GENERATED FILE, DO NOT EDIT DIRECTLY
# This file was generated from lib/regexp_parser/scanner/scanner.rl

require 'regexp_parser/error'

class Regexp::Scanner
  # General scanner error (catch all)
  class ScannerError < Regexp::Parser::Error; end

  # Base for all scanner validation errors
  class ValidationError < Regexp::Parser::Error
    def initialize(reason)
      super reason
    end
  end

  # Unexpected end of pattern
  class PrematureEndError < ScannerError
    def initialize(where = '')
      super "Premature end of pattern at #{where}"
    end
  end

  # Invalid sequence format. Used for escape sequences, mainly.
  class InvalidSequenceError < ValidationError
    def initialize(what = 'sequence', where = '')
      super "Invalid #{what} at #{where}"
    end
  end

  # Invalid group. Used for named groups.
  class InvalidGroupError < ValidationError
    def initialize(what, reason)
      super "Invalid #{what}, #{reason}."
    end
  end

  # Invalid groupOption. Used for inline options.
  # TODO: should become InvalidGroupOptionError in v3.0.0 for consistency
  class InvalidGroupOption < ValidationError
    def initialize(option, text)
      super "Invalid group option #{option} in #{text}"
    end
  end

  # Invalid back reference. Used for name a number refs/calls.
  class InvalidBackrefError < ValidationError
    def initialize(what, reason)
      super "Invalid back reference #{what}, #{reason}"
    end
  end

  # The property name was not recognized by the scanner.
  class UnknownUnicodePropertyError < ValidationError
    def initialize(name)
      super "Unknown unicode character property name #{name}"
    end
  end

  # The POSIX class name was not recognized by the scanner.
  class UnknownPosixClassError < ValidationError
    def initialize(text)
      super "Unknown POSIX class #{text}"
    end
  end

  # Scans the given regular expression text, or Regexp object and collects the
  # emitted token into an array that gets returned at the end. If a block is
  # given, it gets called for each emitted token.
  #
  # This method may raise errors if a syntax error is encountered.
  # --------------------------------------------------------------------------
  def self.scan(input_object, options: nil, &block)
    new.scan(input_object, options: options, &block)
  end

  def scan(input_object, options: nil, &block)
    self.literal = nil
    stack = []

    input = input_object.is_a?(Regexp) ? input_object.source : input_object
    self.free_spacing = free_spacing?(input_object, options)
    self.spacing_stack = [{:free_spacing => free_spacing, :depth => 0}]

    data  = input.unpack("c*") if input.is_a?(String)
    eof   = data.length

    self.tokens = []
    self.block  = block_given? ? block : nil

    self.set_depth = 0
    self.group_depth = 0
    self.conditional_stack = []
    self.char_pos = 0

    
# line 101 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner.rb"
class << self
	attr_accessor :_re_scanner_trans_keys
	private :_re_scanner_trans_keys, :_re_scanner_trans_keys=
end
self._re_scanner_trans_keys = [
	0, 0, -128, -65, -128, -65, 
	-128, -65, 41, 41, 39, 
	57, 39, 39, 33, 62, 
	62, 62, 39, 60, 39, 57, 
	39, 39, 48, 57, 39, 
	57, 39, 57, 48, 57, 
	39, 39, 45, 62, 62, 62, 
	48, 57, 48, 62, 43, 
	62, 48, 57, 62, 62, 
	39, 60, 39, 57, 39, 39, 
	48, 57, 39, 57, 39, 
	57, 48, 57, 45, 62, 
	62, 62, 48, 57, 48, 62, 
	43, 62, 48, 57, 48, 
	57, 48, 125, 44, 125, 
	123, 123, 9, 122, 9, 125, 
	9, 122, -128, -65, -128, 
	-65, 38, 38, 58, 93, 
	58, 93, -128, -65, -128, -65, 
	45, 45, 92, 92, 92, 
	92, 45, 45, 92, 92, 
	92, 92, 48, 123, 48, 102, 
	48, 102, 48, 102, 48, 
	102, 9, 125, 9, 125, 
	9, 125, 9, 125, 9, 125, 
	9, 125, 48, 123, 39, 
	39, 41, 41, 41, 57, 
	62, 62, -128, 127, -62, -12, 
	1, 127, 1, 127, 9, 
	32, 33, 126, 10, 10, 
	63, 63, 33, 126, 33, 126, 
	62, 62, 43, 63, 43, 
	63, 43, 63, 65, 122, 
	44, 57, 68, 119, 80, 112, 
	-62, 125, -128, -65, -128, 
	-65, -128, -65, 38, 38, 
	38, 93, 58, 58, 67, 120, 
	-62, 125, -128, -65, -128, 
	-65, -128, -65, 48, 55, 
	48, 55, 77, 77, 45, 45, 
	0, 0, 67, 99, 45, 
	45, 0, 0, 92, 92, 
	48, 102, 39, 60, 39, 57, 
	49, 57, 41, 57, 45, 
	62, 0
]

class << self
	attr_accessor :_re_scanner_key_spans
	private :_re_scanner_key_spans, :_re_scanner_key_spans=
end
self._re_scanner_key_spans = [
	0, 64, 64, 64, 1, 19, 1, 30, 
	1, 22, 19, 1, 10, 19, 19, 10, 
	1, 18, 1, 10, 15, 20, 10, 1, 
	22, 19, 1, 10, 19, 19, 10, 18, 
	1, 10, 15, 20, 10, 10, 78, 82, 
	1, 114, 117, 114, 64, 64, 1, 36, 
	36, 64, 64, 1, 1, 1, 1, 1, 
	1, 76, 55, 55, 55, 55, 117, 117, 
	117, 117, 117, 117, 76, 1, 1, 17, 
	1, 256, 51, 127, 127, 24, 94, 1, 
	1, 94, 94, 1, 21, 21, 21, 58, 
	14, 52, 33, 188, 64, 64, 64, 1, 
	56, 1, 54, 188, 64, 64, 64, 8, 
	8, 1, 1, 0, 33, 1, 0, 1, 
	55, 22, 19, 9, 17, 18
]

class << self
	attr_accessor :_re_scanner_index_offsets
	private :_re_scanner_index_offsets, :_re_scanner_index_offsets=
end
self._re_scanner_index_offsets = [
	0, 0, 65, 130, 195, 197, 217, 219, 
	250, 252, 275, 295, 297, 308, 328, 348, 
	359, 361, 380, 382, 393, 409, 430, 441, 
	443, 466, 486, 488, 499, 519, 539, 550, 
	569, 571, 582, 598, 619, 630, 641, 720, 
	803, 805, 920, 1038, 1153, 1218, 1283, 1285, 
	1322, 1359, 1424, 1489, 1491, 1493, 1495, 1497, 
	1499, 1501, 1578, 1634, 1690, 1746, 1802, 1920, 
	2038, 2156, 2274, 2392, 2510, 2587, 2589, 2591, 
	2609, 2611, 2868, 2920, 3048, 3176, 3201, 3296, 
	3298, 3300, 3395, 3490, 3492, 3514, 3536, 3558, 
	3617, 3632, 3685, 3719, 3908, 3973, 4038, 4103, 
	4105, 4162, 4164, 4219, 4408, 4473, 4538, 4603, 
	4612, 4621, 4623, 4625, 4626, 4660, 4662, 4663, 
	4665, 4721, 4744, 4764, 4774, 4792
]

class << self
	attr_accessor :_re_scanner_indicies
	private :_re_scanner_indicies, :_re_scanner_indicies=
end
self._re_scanner_indicies = [
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	0, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 0, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 0, 6, 5, 8, 7, 7, 
	7, 7, 7, 4, 7, 7, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	7, 8, 7, 10, 9, 9, 9, 9, 
	9, 9, 9, 9, 9, 9, 9, 4, 
	9, 9, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 9, 9, 9, 10, 
	8, 9, 8, 9, 12, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 13, 11, 15, 14, 14, 14, 14, 
	14, 16, 14, 14, 17, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 14, 15, 
	14, 19, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 11, 15, 11, 11, 11, 
	11, 11, 11, 11, 11, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 11, 
	15, 11, 11, 11, 20, 11, 20, 11, 
	11, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 11, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 11, 15, 
	11, 22, 21, 21, 23, 24, 24, 24, 
	24, 24, 24, 24, 24, 24, 21, 21, 
	21, 21, 15, 21, 15, 21, 25, 24, 
	24, 24, 24, 24, 24, 24, 24, 24, 
	11, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 11, 11, 11, 11, 15, 
	11, 26, 11, 26, 11, 11, 24, 24, 
	24, 24, 24, 24, 24, 24, 24, 24, 
	11, 11, 11, 11, 15, 11, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	11, 15, 11, 27, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	28, 11, 30, 29, 29, 29, 29, 29, 
	31, 29, 29, 11, 32, 32, 32, 32, 
	32, 32, 32, 32, 32, 29, 30, 29, 
	33, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 11, 30, 11, 11, 11, 11, 
	11, 11, 11, 11, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 11, 30, 
	11, 11, 11, 34, 11, 34, 11, 11, 
	32, 32, 32, 32, 32, 32, 32, 32, 
	32, 32, 11, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 11, 36, 35, 
	35, 11, 37, 37, 37, 37, 37, 37, 
	37, 37, 37, 35, 35, 35, 35, 30, 
	35, 30, 35, 38, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 11, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	11, 11, 11, 11, 30, 11, 39, 11, 
	39, 11, 11, 37, 37, 37, 37, 37, 
	37, 37, 37, 37, 37, 11, 11, 11, 
	11, 30, 11, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 11, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	40, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 42, 40, 
	41, 40, 40, 40, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 40, 40, 40, 40, 40, 40, 40, 
	40, 42, 40, 44, 45, 46, 46, 46, 
	46, 46, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 46, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 46, 46, 45, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 45, 45, 
	45, 46, 45, 45, 45, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 45, 
	45, 45, 47, 46, 45, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 45, 
	46, 46, 46, 46, 46, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 46, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 46, 46, 45, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 45, 45, 45, 46, 45, 45, 45, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 45, 45, 45, 45, 46, 45, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 45, 45, 48, 45, 46, 46, 
	46, 46, 46, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 46, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 46, 46, 45, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 45, 
	45, 45, 46, 45, 45, 45, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	45, 45, 45, 45, 46, 45, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	45, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 49, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 49, 53, 52, 56, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 57, 55, 
	57, 55, 56, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 55, 55, 55, 55, 55, 
	55, 55, 55, 57, 55, 58, 55, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 59, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	59, 62, 45, 64, 63, 66, 63, 67, 
	45, 69, 68, 71, 68, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 45, 
	45, 45, 45, 45, 45, 45, 72, 72, 
	72, 72, 72, 72, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 72, 72, 
	72, 72, 72, 72, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	73, 45, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 45, 45, 45, 45, 
	45, 45, 45, 74, 74, 74, 74, 74, 
	74, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 74, 74, 74, 74, 74, 
	74, 45, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 45, 45, 45, 45, 
	45, 45, 45, 75, 75, 75, 75, 75, 
	75, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 75, 75, 75, 75, 75, 
	75, 45, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 45, 45, 45, 45, 
	45, 45, 45, 76, 76, 76, 76, 76, 
	76, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 76, 76, 76, 76, 76, 
	76, 45, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 45, 45, 45, 45, 
	45, 45, 45, 77, 77, 77, 77, 77, 
	77, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 77, 77, 77, 77, 77, 
	77, 45, 73, 73, 73, 73, 73, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 73, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 45, 45, 45, 45, 45, 
	45, 45, 78, 78, 78, 78, 78, 78, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 78, 78, 78, 78, 78, 78, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 76, 45, 
	73, 73, 73, 73, 73, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 73, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 79, 
	79, 79, 79, 79, 79, 79, 79, 79, 
	79, 45, 45, 45, 45, 45, 45, 45, 
	79, 79, 79, 79, 79, 79, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	79, 79, 79, 79, 79, 79, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 76, 45, 73, 73, 
	73, 73, 73, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 73, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 45, 
	45, 45, 45, 45, 45, 45, 80, 80, 
	80, 80, 80, 80, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 80, 80, 
	80, 80, 80, 80, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 76, 45, 73, 73, 73, 73, 
	73, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 73, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 45, 45, 45, 
	45, 45, 45, 45, 81, 81, 81, 81, 
	81, 81, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 81, 81, 81, 81, 
	81, 81, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	76, 45, 73, 73, 73, 73, 73, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 73, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 45, 45, 45, 45, 45, 
	45, 45, 82, 82, 82, 82, 82, 82, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 82, 82, 82, 82, 82, 82, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 76, 45, 
	73, 73, 73, 73, 73, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 73, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 76, 45, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	83, 83, 83, 83, 83, 83, 83, 84, 
	84, 84, 84, 84, 84, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 84, 
	84, 84, 84, 84, 84, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 83, 83, 83, 83, 83, 
	83, 45, 83, 87, 86, 88, 85, 88, 
	85, 85, 85, 85, 85, 85, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 89, 
	85, 87, 90, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 91, 91, 91, 91, 91, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 92, 92, 92, 92, 
	92, 92, 92, 92, 93, 93, 93, 93, 
	93, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 94, 95, 95, 96, 97, 
	95, 95, 95, 98, 99, 100, 101, 95, 
	95, 102, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 103, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 104, 105, 
	106, 107, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 108, 109, 
	106, 95, 92, 95, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 91, 91, 91, 91, 91, 110, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 110, 
	110, 110, 110, 110, 110, 110, 110, 110, 
	110, 110, 110, 110, 110, 110, 110, 110, 
	110, 110, 110, 110, 110, 110, 110, 110, 
	110, 110, 110, 110, 110, 110, 110, 110, 
	110, 110, 110, 110, 110, 110, 110, 110, 
	110, 110, 110, 110, 110, 110, 110, 110, 
	110, 110, 110, 110, 110, 110, 110, 110, 
	110, 110, 110, 110, 110, 110, 110, 110, 
	110, 110, 110, 110, 110, 110, 110, 110, 
	110, 110, 110, 110, 110, 110, 110, 110, 
	110, 110, 110, 110, 110, 110, 110, 110, 
	110, 110, 110, 110, 110, 110, 92, 110, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	93, 93, 93, 93, 93, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	92, 92, 92, 92, 92, 92, 92, 94, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 92, 111, 
	94, 94, 94, 94, 94, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 94, 
	111, 95, 95, 110, 110, 95, 95, 95, 
	110, 110, 110, 110, 95, 95, 110, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 110, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 110, 110, 110, 110, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 110, 110, 110, 95, 110, 
	113, 96, 115, 114, 118, 117, 5, 117, 
	117, 117, 119, 120, 116, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 8, 117, 121, 
	118, 8, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 8, 117, 116, 117, 116, 117, 117, 
	117, 116, 116, 116, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 122, 117, 116, 116, 
	116, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	117, 117, 117, 117, 117, 117, 117, 117, 
	116, 117, 8, 9, 125, 124, 124, 124, 
	124, 124, 124, 124, 124, 124, 124, 124, 
	124, 124, 124, 124, 124, 124, 124, 124, 
	125, 124, 127, 126, 126, 126, 126, 126, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	126, 126, 126, 126, 126, 126, 127, 126, 
	129, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 129, 128, 131, 131, 
	130, 130, 130, 130, 131, 130, 130, 130, 
	132, 130, 130, 130, 130, 130, 130, 130, 
	130, 130, 130, 130, 130, 130, 130, 131, 
	130, 130, 130, 130, 130, 130, 130, 131, 
	130, 130, 130, 130, 133, 130, 130, 130, 
	134, 130, 130, 130, 130, 130, 130, 130, 
	130, 130, 130, 130, 130, 130, 130, 131, 
	130, 136, 135, 135, 135, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 135, 
	137, 45, 45, 45, 137, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 137, 137, 
	45, 45, 45, 137, 137, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	137, 45, 45, 45, 137, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 137, 
	45, 45, 45, 137, 45, 138, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 138, 45, 139, 
	139, 139, 139, 139, 139, 139, 139, 139, 
	139, 139, 139, 139, 139, 139, 139, 139, 
	139, 139, 139, 139, 139, 139, 139, 139, 
	139, 139, 139, 139, 139, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 141, 141, 141, 
	141, 141, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 142, 50, 143, 50, 142, 142, 142, 
	142, 50, 144, 142, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 142, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	145, 146, 147, 148, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	142, 142, 142, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 149, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 149, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 149, 151, 
	149, 153, 152, 152, 152, 152, 152, 152, 
	152, 152, 152, 152, 152, 152, 152, 152, 
	152, 152, 152, 152, 152, 152, 152, 152, 
	152, 152, 152, 152, 152, 152, 152, 152, 
	152, 152, 152, 152, 152, 152, 152, 152, 
	152, 152, 152, 152, 152, 152, 152, 152, 
	152, 152, 152, 152, 152, 152, 152, 152, 
	154, 152, 55, 156, 158, 158, 157, 157, 
	157, 158, 157, 157, 157, 157, 158, 157, 
	157, 158, 157, 157, 158, 157, 157, 157, 
	158, 157, 157, 157, 158, 158, 158, 157, 
	157, 157, 158, 158, 158, 158, 158, 158, 
	157, 158, 157, 157, 157, 157, 157, 158, 
	157, 158, 157, 158, 158, 158, 158, 158, 
	158, 158, 157, 159, 159, 159, 159, 159, 
	159, 159, 159, 159, 159, 159, 159, 159, 
	159, 159, 159, 159, 159, 159, 159, 159, 
	159, 159, 159, 159, 159, 159, 159, 159, 
	159, 160, 160, 160, 160, 160, 160, 160, 
	160, 160, 160, 160, 160, 160, 160, 160, 
	160, 161, 161, 161, 161, 161, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 162, 60, 60, 
	60, 162, 162, 162, 162, 60, 60, 162, 
	60, 163, 164, 164, 164, 164, 164, 164, 
	164, 165, 165, 60, 60, 60, 60, 60, 
	162, 60, 45, 45, 166, 167, 60, 60, 
	45, 167, 60, 60, 45, 60, 168, 60, 
	60, 169, 60, 167, 167, 60, 60, 60, 
	167, 167, 60, 45, 162, 162, 162, 162, 
	60, 60, 170, 170, 62, 167, 170, 170, 
	60, 167, 60, 60, 60, 60, 60, 170, 
	60, 169, 60, 170, 167, 170, 171, 170, 
	167, 172, 60, 45, 162, 162, 162, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	60, 60, 60, 60, 60, 60, 60, 60, 
	173, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 173, 174, 174, 174, 174, 174, 174, 
	174, 174, 174, 174, 174, 174, 174, 174, 
	174, 174, 174, 174, 174, 174, 174, 174, 
	174, 174, 174, 174, 174, 174, 174, 174, 
	174, 174, 174, 174, 174, 174, 174, 174, 
	174, 174, 174, 174, 174, 174, 174, 174, 
	174, 174, 174, 174, 174, 174, 174, 174, 
	174, 174, 174, 174, 174, 174, 174, 174, 
	174, 174, 173, 176, 176, 176, 176, 176, 
	176, 176, 176, 175, 178, 178, 178, 178, 
	178, 178, 178, 178, 177, 180, 63, 182, 
	181, 63, 184, 68, 68, 68, 68, 68, 
	68, 68, 68, 68, 68, 68, 68, 68, 
	68, 68, 68, 68, 68, 68, 68, 68, 
	68, 68, 68, 68, 68, 68, 68, 68, 
	68, 68, 185, 68, 187, 186, 68, 71, 
	68, 189, 189, 189, 189, 189, 189, 189, 
	189, 189, 189, 188, 188, 188, 188, 188, 
	188, 188, 189, 189, 189, 189, 189, 189, 
	188, 188, 188, 188, 188, 188, 188, 188, 
	188, 188, 188, 188, 188, 188, 188, 188, 
	188, 188, 188, 188, 188, 188, 188, 188, 
	188, 188, 189, 189, 189, 189, 189, 189, 
	188, 191, 190, 190, 190, 190, 190, 192, 
	190, 190, 190, 193, 193, 193, 193, 193, 
	193, 193, 193, 193, 190, 190, 194, 190, 
	87, 86, 86, 86, 86, 86, 195, 86, 
	86, 195, 195, 195, 195, 195, 195, 195, 
	195, 195, 195, 86, 89, 89, 89, 89, 
	89, 89, 89, 89, 89, 195, 88, 195, 
	195, 195, 195, 195, 195, 89, 89, 89, 
	89, 89, 89, 89, 89, 89, 89, 195, 
	195, 90, 90, 195, 195, 195, 195, 195, 
	195, 195, 195, 195, 195, 90, 90, 90, 
	90, 87, 90, 0
]

class << self
	attr_accessor :_re_scanner_trans_targs
	private :_re_scanner_trans_targs, :_re_scanner_trans_targs=
end
self._re_scanner_trans_targs = [
	73, 74, 1, 2, 73, 4, 73, 6, 
	73, 8, 83, 73, 10, 17, 11, 73, 
	12, 16, 14, 13, 15, 18, 19, 23, 
	21, 20, 22, 25, 31, 26, 73, 27, 
	29, 28, 30, 32, 33, 35, 34, 36, 
	73, 38, 73, 39, 41, 0, 42, 43, 
	90, 91, 91, 44, 91, 91, 91, 47, 
	48, 91, 91, 99, 99, 49, 52, 99, 
	105, 99, 107, 55, 99, 108, 99, 110, 
	58, 61, 59, 60, 99, 62, 63, 64, 
	65, 66, 67, 99, 112, 113, 69, 70, 
	113, 71, 72, 3, 75, 76, 77, 78, 
	79, 73, 80, 73, 84, 85, 73, 86, 
	73, 87, 73, 73, 88, 73, 73, 73, 
	73, 73, 73, 81, 73, 82, 73, 5, 
	73, 7, 73, 73, 73, 73, 73, 73, 
	73, 73, 73, 73, 73, 9, 24, 73, 
	37, 89, 40, 92, 93, 94, 91, 95, 
	96, 97, 91, 91, 91, 91, 45, 91, 
	91, 46, 91, 91, 91, 98, 98, 100, 
	101, 102, 99, 103, 103, 99, 51, 99, 
	54, 99, 99, 57, 68, 99, 50, 99, 
	104, 99, 99, 99, 106, 99, 53, 99, 
	109, 111, 99, 56, 99, 99, 113, 114, 
	115, 116, 117, 113
]

class << self
	attr_accessor :_re_scanner_trans_actions
	private :_re_scanner_trans_actions, :_re_scanner_trans_actions=
end
self._re_scanner_trans_actions = [
	1, 2, 0, 0, 3, 4, 5, 0, 
	6, 0, 7, 8, 0, 0, 0, 9, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 10, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	11, 0, 12, 0, 0, 0, 0, 0, 
	14, 15, 16, 0, 17, 18, 19, 0, 
	0, 20, 21, 22, 23, 0, 0, 25, 
	0, 26, 0, 0, 27, 0, 28, 0, 
	0, 0, 0, 0, 29, 0, 0, 0, 
	0, 0, 0, 30, 0, 31, 0, 0, 
	32, 0, 0, 0, 0, 0, 0, 0, 
	0, 35, 36, 37, 0, 0, 38, 0, 
	39, 40, 41, 42, 40, 43, 44, 45, 
	46, 47, 48, 49, 50, 0, 51, 0, 
	52, 0, 53, 54, 55, 56, 57, 58, 
	59, 60, 61, 62, 63, 0, 0, 64, 
	0, 66, 0, 0, 40, 40, 67, 0, 
	40, 68, 69, 70, 71, 72, 0, 73, 
	74, 0, 75, 76, 77, 78, 79, 0, 
	40, 40, 80, 81, 82, 83, 0, 84, 
	0, 85, 86, 0, 0, 87, 0, 88, 
	0, 89, 90, 91, 40, 92, 0, 93, 
	40, 0, 94, 0, 95, 96, 97, 40, 
	40, 40, 40, 98
]

class << self
	attr_accessor :_re_scanner_to_state_actions
	private :_re_scanner_to_state_actions, :_re_scanner_to_state_actions=
end
self._re_scanner_to_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 33, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 65, 65, 65, 0, 0, 0, 0, 
	0, 0, 65, 65, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 65, 0, 0, 0, 0
]

class << self
	attr_accessor :_re_scanner_from_state_actions
	private :_re_scanner_from_state_actions, :_re_scanner_from_state_actions=
end
self._re_scanner_from_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 34, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 34, 34, 34, 0, 0, 0, 0, 
	0, 0, 34, 34, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 34, 0, 0, 0, 0
]

class << self
	attr_accessor :_re_scanner_eof_actions
	private :_re_scanner_eof_actions, :_re_scanner_eof_actions=
end
self._re_scanner_eof_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	13, 13, 13, 13, 0, 0, 0, 0, 
	0, 0, 0, 24, 24, 0, 24, 24, 
	0, 24, 24, 24, 24, 24, 24, 24, 
	24, 24, 24, 24, 24, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 24, 0, 0, 0, 0, 
	0, 0, 0, 24, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0
]

class << self
	attr_accessor :_re_scanner_eof_trans
	private :_re_scanner_eof_trans, :_re_scanner_eof_trans=
end
self._re_scanner_eof_trans = [
	0, 1, 1, 1, 5, 5, 5, 5, 
	1, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 41, 41, 41, 
	0, 0, 0, 0, 50, 50, 53, 55, 
	55, 60, 60, 0, 0, 66, 0, 0, 
	71, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 86, 86, 86, 
	86, 0, 111, 111, 112, 112, 111, 113, 
	115, 117, 117, 124, 125, 127, 129, 131, 
	136, 0, 0, 0, 150, 150, 150, 150, 
	153, 156, 0, 0, 174, 174, 174, 176, 
	178, 180, 180, 180, 184, 184, 184, 184, 
	189, 0, 196, 196, 196, 196
]

class << self
	attr_accessor :re_scanner_start
end
self.re_scanner_start = 73;
class << self
	attr_accessor :re_scanner_first_final
end
self.re_scanner_first_final = 73;
class << self
	attr_accessor :re_scanner_error
end
self.re_scanner_error = 0;

class << self
	attr_accessor :re_scanner_en_char_type
end
self.re_scanner_en_char_type = 89;
class << self
	attr_accessor :re_scanner_en_unicode_property
end
self.re_scanner_en_unicode_property = 90;
class << self
	attr_accessor :re_scanner_en_character_set
end
self.re_scanner_en_character_set = 91;
class << self
	attr_accessor :re_scanner_en_set_escape_sequence
end
self.re_scanner_en_set_escape_sequence = 98;
class << self
	attr_accessor :re_scanner_en_escape_sequence
end
self.re_scanner_en_escape_sequence = 99;
class << self
	attr_accessor :re_scanner_en_conditional_expression
end
self.re_scanner_en_conditional_expression = 113;
class << self
	attr_accessor :re_scanner_en_main
end
self.re_scanner_en_main = 73;


# line 744 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
    
# line 1002 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner.rb"
begin
	p ||= 0
	pe ||= data.length
	cs = re_scanner_start
	top = 0
	ts = nil
	te = nil
	act = 0
end

# line 745 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
    
# line 1013 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner.rb"
begin
	testEof = false
	_slen, _trans, _keys, _inds, _acts, _nacts = nil
	_goto_level = 0
	_resume = 10
	_eof_trans = 15
	_again = 20
	_test_eof = 30
	_out = 40
	while true
	if _goto_level <= 0
	if p == pe
		_goto_level = _test_eof
		next
	end
	if cs == 0
		_goto_level = _out
		next
	end
	end
	if _goto_level <= _resume
	case _re_scanner_from_state_actions[cs] 
	when 34 then
# line 1 "NONE"
		begin
ts = p
		end
# line 1041 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner.rb"
	end
	_keys = cs << 1
	_inds = _re_scanner_index_offsets[cs]
	_slen = _re_scanner_key_spans[cs]
	_wide = data[p].ord
	_trans = if (   _slen > 0 && 
			_re_scanner_trans_keys[_keys] <= _wide && 
			_wide <= _re_scanner_trans_keys[_keys + 1] 
		    ) then
			_re_scanner_indicies[ _inds + _wide - _re_scanner_trans_keys[_keys] ] 
		 else 
			_re_scanner_indicies[ _inds + _slen ]
		 end
	end
	if _goto_level <= _eof_trans
	cs = _re_scanner_trans_targs[_trans]
	if _re_scanner_trans_actions[_trans] != 0
	case _re_scanner_trans_actions[_trans]
	when 36 then
# line 152 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth + 1 		end
	when 4 then
# line 153 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1 		end
	when 40 then
# line 1 "NONE"
		begin
te = p+1
		end
	when 66 then
# line 12 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/char_type.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts-1, te)
      when '\d'; emit(:type, :digit,      text)
      when '\D'; emit(:type, :nondigit,   text)
      when '\h'; emit(:type, :hex,        text)
      when '\H'; emit(:type, :nonhex,     text)
      when '\s'; emit(:type, :space,      text)
      when '\S'; emit(:type, :nonspace,   text)
      when '\w'; emit(:type, :word,       text)
      when '\W'; emit(:type, :nonword,    text)
      when '\R'; emit(:type, :linebreak,  text)
      when '\X'; emit(:type, :xgrapheme,  text)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 14 then
# line 16 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/property.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts-1, te)
      type = (text[1] == 'P') ^ (text[3] == '^') ? :nonproperty : :property

      name = data[ts+2..te-2].pack('c*').gsub(/[\^\s_\-]/, '').downcase

      token = self.class.short_prop_map[name] || self.class.long_prop_map[name]
      validation_error(:property, name) unless token

      self.emit(type, token.to_sym, text)

      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 18 then
# line 180 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin  # special case, emits two tokens
      emit(:literal, :literal, '-')
      emit(:set, :intersection, '&&')
     end
		end
	when 71 then
# line 185 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts, te)
      if tokens.last[1] == :open
        emit(:set, :negate, text)
      else
        emit(:literal, :literal, text)
      end
     end
		end
	when 73 then
# line 206 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:set, :intersection, copy(data, ts, te))
     end
		end
	when 69 then
# line 210 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      	begin
		stack[top] = cs
		top+= 1
		cs = 98
		_goto_level = _again
		next
	end

     end
		end
	when 67 then
# line 244 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:literal, :literal, copy(data, ts, te))
     end
		end
	when 16 then
# line 248 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts, te)
      emit(:literal, :literal, text)
     end
		end
	when 74 then
# line 194 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      text = copy(data, ts, te)
      # ranges cant start with a subset or intersection/negation/range operator
      if tokens.last[0] == :set
        emit(:literal, :literal, text)
      else
        emit(:set, :range, text)
      end
     end
		end
	when 77 then
# line 214 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:set, :open, copy(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 91
		_goto_level = _again
		next
	end

     end
		end
	when 72 then
# line 248 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      text = copy(data, ts, te)
      emit(:literal, :literal, text)
     end
		end
	when 17 then
# line 194 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      text = copy(data, ts, te)
      # ranges cant start with a subset or intersection/negation/range operator
      if tokens.last[0] == :set
        emit(:literal, :literal, text)
      else
        emit(:set, :range, text)
      end
     end
		end
	when 20 then
# line 214 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit(:set, :open, copy(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 91
		_goto_level = _again
		next
	end

     end
		end
	when 15 then
# line 248 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      text = copy(data, ts, te)
      emit(:literal, :literal, text)
     end
		end
	when 79 then
# line 257 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      cs = 91;
      	begin
		stack[top] = cs
		top+= 1
		cs = 99
		_goto_level = _again
		next
	end

     end
		end
	when 78 then
# line 263 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :literal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 83 then
# line 273 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts-1, te)
      emit(:backref, :number, text)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 90 then
# line 279 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :octal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 80 then
# line 284 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts-1, te)
      when '\.';  emit(:escape, :dot,               text)
      when '\|';  emit(:escape, :alternation,       text)
      when '\^';  emit(:escape, :bol,               text)
      when '\$';  emit(:escape, :eol,               text)
      when '\?';  emit(:escape, :zero_or_one,       text)
      when '\*';  emit(:escape, :zero_or_more,      text)
      when '\+';  emit(:escape, :one_or_more,       text)
      when '\(';  emit(:escape, :group_open,        text)
      when '\)';  emit(:escape, :group_close,       text)
      when '\{';  emit(:escape, :interval_open,     text)
      when '\}';  emit(:escape, :interval_close,    text)
      when '\[';  emit(:escape, :set_open,          text)
      when '\]';  emit(:escape, :set_close,         text)
      when "\\\\";
        emit(:escape, :backslash, text)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 86 then
# line 305 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      # \b is emitted as backspace only when inside a character set, otherwise
      # it is a word boundary anchor. A syntax might "normalize" it if needed.
      case text = copy(data, ts-1, te)
      when '\a'; emit(:escape, :bell,           text)
      when '\b'; emit(:escape, :backspace,      text)
      when '\e'; emit(:escape, :escape,         text)
      when '\f'; emit(:escape, :form_feed,      text)
      when '\n'; emit(:escape, :newline,        text)
      when '\r'; emit(:escape, :carriage,       text)
      when '\t'; emit(:escape, :tab,            text)
      when '\v'; emit(:escape, :vertical_tab,   text)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 29 then
# line 321 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts-1, te)
      if text[2] == '{'
        emit(:escape, :codepoint_list, text)
      else
        emit(:escape, :codepoint,      text)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 96 then
# line 331 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :hex, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 25 then
# line 340 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 27 then
# line 345 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 84 then
# line 350 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      cs = ((in_set? ? 91 : 73));
      	begin
		stack[top] = cs
		top+= 1
		cs = 89
		_goto_level = _again
		next
	end

     end
		end
	when 85 then
# line 356 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      cs = ((in_set? ? 91 : 73));
      	begin
		stack[top] = cs
		top+= 1
		cs = 90
		_goto_level = _again
		next
	end

     end
		end
	when 23 then
# line 362 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :literal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 89 then
# line 279 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:escape, :octal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 95 then
# line 331 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:escape, :hex, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 92 then
# line 340 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 94 then
# line 345 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 87 then
# line 362 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:escape, :literal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 22 then
# line 362 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit(:escape, :literal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 88 then
# line 1 "NONE"
		begin
	case act
	when 16 then
	begin begin p = ((te))-1; end

      text = copy(data, ts-1, te)
      emit(:backref, :number, text)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

    end
	when 17 then
	begin begin p = ((te))-1; end

      emit(:escape, :octal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

    end
end 
			end
	when 32 then
# line 372 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts, te-1)
      emit(:conditional, :condition, text)
      emit(:conditional, :condition_close, ')')
     end
		end
	when 97 then
# line 378 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 73
		_goto_level = _again
		next
	end

     end
		end
	when 98 then
# line 378 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 73
		_goto_level = _again
		next
	end

     end
		end
	when 31 then
# line 378 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 73
		_goto_level = _again
		next
	end

     end
		end
	when 38 then
# line 391 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:meta, :dot, copy(data, ts, te))
     end
		end
	when 43 then
# line 395 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if conditional_stack.last == group_depth
        emit(:conditional, :separator, copy(data, ts, te))
      else
        emit(:meta, :alternation, copy(data, ts, te))
      end
     end
		end
	when 42 then
# line 405 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:anchor, :bol, copy(data, ts, te))
     end
		end
	when 35 then
# line 409 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:anchor, :eol, copy(data, ts, te))
     end
		end
	when 63 then
# line 413 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:keep, :mark, copy(data, ts, te))
     end
		end
	when 62 then
# line 417 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '\A';  emit(:anchor, :bos,                text)
      when '\z';  emit(:anchor, :eos,                text)
      when '\Z';  emit(:anchor, :eos_ob_eol,         text)
      when '\b';  emit(:anchor, :word_boundary,      text)
      when '\B';  emit(:anchor, :nonword_boundary,   text)
      when '\G';  emit(:anchor, :match_start,        text)
      end
     end
		end
	when 41 then
# line 428 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      append_literal(data, ts, te)
     end
		end
	when 52 then
# line 443 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts, te)

      conditional_stack << group_depth

      emit(:conditional, :open, text[0..-2])
      emit(:conditional, :condition_open, '(')
      	begin
		stack[top] = cs
		top+= 1
		cs = 113
		_goto_level = _again
		next
	end

     end
		end
	when 53 then
# line 474 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts, te)
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        validation_error(:group_option, $1 || "-#{$2}", text)
      end
      emit_options(text)
     end
		end
	when 51 then
# line 488 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '(?=';  emit(:assertion, :lookahead,    text)
      when '(?!';  emit(:assertion, :nlookahead,   text)
      when '(?<='; emit(:assertion, :lookbehind,   text)
      when '(?<!'; emit(:assertion, :nlookbehind,  text)
      end
     end
		end
	when 6 then
# line 505 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '(?:';  emit(:group, :passive,      text)
      when '(?>';  emit(:group, :atomic,       text)
      when '(?~';  emit(:group, :absence,      text)

      when /^\(\?(?:<>|'')/
        validation_error(:group, 'named group', 'name is empty')

      when /^\(\?<[^>]+>/
        emit(:group, :named_ab,  text)

      when /^\(\?'[^']+'/
        emit(:group, :named_sq,  text)

      end
     end
		end
	when 10 then
# line 546 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when /^\\k(<>|'')/
        validation_error(:backref, 'backreference', 'ref ID is empty')
      when /^\\k(.)[^\p{digit}\-][^+\-]*\D$/
        emit(:backref, $1 == '<' ? :name_ref_ab : :name_ref_sq, text)
      when /^\\k(.)\d+\D$/
        emit(:backref, $1 == '<' ? :number_ref_ab : :number_ref_sq, text)
      when /^\\k(.)-\d+\D$/
        emit(:backref, $1 == '<' ? :number_rel_ref_ab : :number_rel_ref_sq, text)
      when /^\\k(.)[^\p{digit}\-].*[+\-]\d+\D$/
        emit(:backref, $1 == '<' ? :name_recursion_ref_ab : :name_recursion_ref_sq, text)
      when /^\\k(.)-?\d+[+\-]\d+\D$/
        emit(:backref, $1 == '<' ? :number_recursion_ref_ab : :number_recursion_ref_sq, text)
      end
     end
		end
	when 9 then
# line 565 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when /^\\g(<>|'')/
        validation_error(:backref, 'subexpression call', 'ref ID is empty')
      when /^\\g(.)[^\p{digit}+\->][^+\-]*/
        emit(:backref, $1 == '<' ? :name_call_ab : :name_call_sq, text)
      when /^\\g(.)\d+\D$/
        emit(:backref, $1 == '<' ? :number_call_ab : :number_call_sq, text)
      when /^\\g(.)[+-]\d+/
        emit(:backref, $1 == '<' ? :number_rel_call_ab : :number_rel_call_sq, text)
      end
     end
		end
	when 60 then
# line 581 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '?' ;  emit(:quantifier, :zero_or_one,            text)
      when '??';  emit(:quantifier, :zero_or_one_reluctant,  text)
      when '?+';  emit(:quantifier, :zero_or_one_possessive, text)
      end
     end
		end
	when 56 then
# line 589 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '*' ;  emit(:quantifier, :zero_or_more,            text)
      when '*?';  emit(:quantifier, :zero_or_more_reluctant,  text)
      when '*+';  emit(:quantifier, :zero_or_more_possessive, text)
      end
     end
		end
	when 58 then
# line 597 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '+' ;  emit(:quantifier, :one_or_more,            text)
      when '+?';  emit(:quantifier, :one_or_more_reluctant,  text)
      when '++';  emit(:quantifier, :one_or_more_possessive, text)
      end
     end
		end
	when 12 then
# line 605 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:quantifier, :interval, copy(data, ts, te))
     end
		end
	when 47 then
# line 620 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if free_spacing
        emit(:free_space, :comment, copy(data, ts, te))
      else
        # consume only the pound sign (#) and backtrack to do regular scanning
        append_literal(data, ts, ts + 1)
         begin p = (( ts + 1))-1; end

      end
     end
		end
	when 50 then
# line 474 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      text = copy(data, ts, te)
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        validation_error(:group_option, $1 || "-#{$2}", text)
      end
      emit_options(text)
     end
		end
	when 54 then
# line 488 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = copy(data, ts, te)
      when '(?=';  emit(:assertion, :lookahead,    text)
      when '(?!';  emit(:assertion, :nlookahead,   text)
      when '(?<='; emit(:assertion, :lookbehind,   text)
      when '(?<!'; emit(:assertion, :nlookbehind,  text)
      end
     end
		end
	when 48 then
# line 523 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      text = copy(data, ts, te)
      emit(:group, :capture, text)
     end
		end
	when 59 then
# line 581 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = copy(data, ts, te)
      when '?' ;  emit(:quantifier, :zero_or_one,            text)
      when '??';  emit(:quantifier, :zero_or_one_reluctant,  text)
      when '?+';  emit(:quantifier, :zero_or_one_possessive, text)
      end
     end
		end
	when 55 then
# line 589 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = copy(data, ts, te)
      when '*' ;  emit(:quantifier, :zero_or_more,            text)
      when '*?';  emit(:quantifier, :zero_or_more_reluctant,  text)
      when '*+';  emit(:quantifier, :zero_or_more_possessive, text)
      end
     end
		end
	when 57 then
# line 597 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = copy(data, ts, te)
      when '+' ;  emit(:quantifier, :one_or_more,            text)
      when '+?';  emit(:quantifier, :one_or_more_reluctant,  text)
      when '++';  emit(:quantifier, :one_or_more_possessive, text)
      end
     end
		end
	when 64 then
# line 610 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      append_literal(data, ts, te)
     end
		end
	when 61 then
# line 616 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      	begin
		stack[top] = cs
		top+= 1
		cs = 99
		_goto_level = _again
		next
	end

     end
		end
	when 46 then
# line 620 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      if free_spacing
        emit(:free_space, :comment, copy(data, ts, te))
      else
        # consume only the pound sign (#) and backtrack to do regular scanning
        append_literal(data, ts, ts + 1)
         begin p = (( ts + 1))-1; end

      end
     end
		end
	when 45 then
# line 630 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      if free_spacing
        emit(:free_space, :whitespace, copy(data, ts, te))
      else
        append_literal(data, ts, te)
      end
     end
		end
	when 44 then
# line 641 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      append_literal(data, ts, te)
     end
		end
	when 3 then
# line 474 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      text = copy(data, ts, te)
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        validation_error(:group_option, $1 || "-#{$2}", text)
      end
      emit_options(text)
     end
		end
	when 11 then
# line 610 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      append_literal(data, ts, te)
     end
		end
	when 8 then
# line 616 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      	begin
		stack[top] = cs
		top+= 1
		cs = 99
		_goto_level = _again
		next
	end

     end
		end
	when 1 then
# line 1 "NONE"
		begin
	case act
	when 0 then
	begin	begin
		cs = 0
		_goto_level = _again
		next
	end
end
	when 40 then
	begin begin p = ((te))-1; end

      text = copy(data, ts, te)
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        validation_error(:group_option, $1 || "-#{$2}", text)
      end
      emit_options(text)
    end
	when 41 then
	begin begin p = ((te))-1; end

      case text = copy(data, ts, te)
      when '(?=';  emit(:assertion, :lookahead,    text)
      when '(?!';  emit(:assertion, :nlookahead,   text)
      when '(?<='; emit(:assertion, :lookbehind,   text)
      when '(?<!'; emit(:assertion, :nlookbehind,  text)
      end
    end
	when 55 then
	begin begin p = ((te))-1; end

      append_literal(data, ts, te)
    end
end 
			end
	when 76 then
# line 140 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 214 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:set, :open, copy(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 91
		_goto_level = _again
		next
	end

     end
		end
	when 19 then
# line 140 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 214 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit(:set, :open, copy(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 91
		_goto_level = _again
		next
	end

     end
		end
	when 91 then
# line 140 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 340 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 93 then
# line 140 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 345 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 26 then
# line 140 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 340 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 28 then
# line 140 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 345 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 30 then
# line 146 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    validation_error(:sequence, 'sequence', text)
  		end
# line 336 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 5 then
# line 153 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1 		end
# line 459 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:group, :comment, copy(data, ts, te))
     end
		end
	when 37 then
# line 153 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1 		end
# line 528 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if conditional_stack.last == group_depth + 1
        conditional_stack.pop
        emit(:conditional, :close, copy(data, ts, te))
      else
        if spacing_stack.length > 1 &&
           spacing_stack.last[:depth] == group_depth + 1
          spacing_stack.pop
          self.free_spacing = spacing_stack.last[:free_spacing]
        end

        emit(:group, :close, copy(data, ts, te))
      end
     end
		end
	when 39 then
# line 154 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   + 1 		end
# line 434 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:set, :open, copy(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 91
		_goto_level = _again
		next
	end

     end
		end
	when 70 then
# line 155 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   - 1 		end
# line 161 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:set, :close, copy(data, ts, te))
      if in_set?
        	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

      else
        	begin
		cs = 73
		_goto_level = _again
		next
	end

      end
     end
		end
	when 75 then
# line 155 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   - 1 		end
# line 170 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin  # special case, emits two tokens
      emit(:literal, :literal, copy(data, ts, te-1))
      emit(:set, :close, copy(data, ts+1, te))
      if in_set?
        	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

      else
        	begin
		cs = 73
		_goto_level = _again
		next
	end

      end
     end
		end
	when 21 then
# line 155 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   - 1 		end
# line 219 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts, te)

      type = :posixclass
      class_name = text[2..-3]
      if class_name[0] == '^'
        class_name = class_name[1..-1]
        type = :nonposixclass
      end

      unless self.class.posix_classes.include?(class_name)
        validation_error(:posix_class, text)
      end

      emit(type, class_name.to_sym, text)
     end
		end
	when 68 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 154 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   + 1 		end
	when 82 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 273 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
act = 16;		end
	when 81 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 279 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
act = 17;		end
	when 7 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 488 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
act = 41;		end
	when 2 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 641 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
act = 55;		end
	when 49 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 153 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1 		end
# line 152 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth + 1 		end
# line 474 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
act = 40;		end
# line 2441 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner.rb"
	end
	end
	end
	if _goto_level <= _again
	case _re_scanner_to_state_actions[cs] 
	when 65 then
# line 1 "NONE"
		begin
ts = nil;		end
	when 33 then
# line 1 "NONE"
		begin
ts = nil;		end
# line 1 "NONE"
		begin
act = 0
		end
# line 2459 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner.rb"
	end

	if cs == 0
		_goto_level = _out
		next
	end
	p += 1
	if p != pe
		_goto_level = _resume
		next
	end
	end
	if _goto_level <= _test_eof
	if p == eof
	if _re_scanner_eof_trans[cs] > 0
		_trans = _re_scanner_eof_trans[cs] - 1;
		_goto_level = _eof_trans
		next;
	end
	  case _re_scanner_eof_actions[cs]
	when 13 then
# line 8 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/property.rl"
		begin

    raise PrematureEndError.new('unicode property')
  		end
	when 24 then
# line 140 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 2493 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner.rb"
	  end
	end

	end
	if _goto_level <= _out
		break
	end
end
	end

# line 746 "/build/ruby-regexp_parser/src/regexp_parser-2.6.0/tasks/../lib/regexp_parser/scanner/scanner.rl"

    # to avoid "warning: assigned but unused variable - testEof"
    testEof = testEof

    if cs == re_scanner_error
      text = copy(data, ts ? ts-1 : 0, -1)
      raise ScannerError.new("Scan error at '#{text}'")
    end

    raise PrematureEndError.new("(missing group closing paranthesis) "+
          "[#{group_depth}]") if in_group?
    raise PrematureEndError.new("(missing set closing bracket) "+
          "[#{set_depth}]") if in_set?

    # when the entire expression is a literal run
    emit_literal if literal

    tokens
  end

  # lazy-load property maps when first needed
  def self.short_prop_map
    @short_prop_map ||= parse_prop_map('short')
  end

  def self.long_prop_map
    @long_prop_map ||= parse_prop_map('long')
  end

  def self.parse_prop_map(name)
    File.read("#{__dir__}/scanner/properties/#{name}.csv").scan(/(.+),(.+)/).to_h
  end

  def self.posix_classes
    %w[alnum alpha ascii blank cntrl digit graph
       lower print punct space upper word xdigit]
  end

  # Emits an array with the details of the scanned pattern
  def emit(type, token, text)
    #puts "EMIT: type: #{type}, token: #{token}, text: #{text}, ts: #{ts}, te: #{te}"

    emit_literal if literal

    # Ragel runs with byte-based indices (ts, te). These are of little value to
    # end-users, so we keep track of char-based indices and emit those instead.
    ts_char_pos = char_pos
    te_char_pos = char_pos + text.length

    if block
      block.call type, token, text, ts_char_pos, te_char_pos
    end

    tokens << [type, token, text, ts_char_pos, te_char_pos]

    self.char_pos = te_char_pos
  end

  private

  attr_accessor :tokens, :literal, :block, :free_spacing, :spacing_stack,
                :group_depth, :set_depth, :conditional_stack, :char_pos

  def free_spacing?(input_object, options)
    if options && !input_object.is_a?(String)
      raise ArgumentError, 'options cannot be supplied unless scanning a String'
    end

    options = input_object.options if input_object.is_a?(::Regexp)

    return false unless options

    options & Regexp::EXTENDED != 0
  end

  def in_group?
    group_depth > 0
  end

  def in_set?
    set_depth > 0
  end

  # Copy from ts to te from data as text
  def copy(data, ts, te)
    data[ts...te].pack('c*').force_encoding('utf-8')
  end

  # Appends one or more characters to the literal buffer, to be emitted later
  # by a call to emit_literal.
  def append_literal(data, ts, te)
    self.literal = literal || []
    literal << copy(data, ts, te)
  end

  # Emits the literal run collected by calls to the append_literal method.
  def emit_literal
    text = literal.join
    self.literal = nil
    emit(:literal, :literal, text)
  end

  def emit_options(text)
    token = nil

    # Ruby allows things like '(?-xxxx)' or '(?xx-xx--xx-:abc)'.
    text =~ /\(\?([mixdau]*)(-(?:[mix]*))*(:)?/
    positive, negative, group_local = $1, $2, $3

    if positive.include?('x')
      self.free_spacing = true
    end

    # If the x appears in both, treat it like ruby does, the second cancels
    # the first.
    if negative && negative.include?('x')
      self.free_spacing = false
    end

    if group_local
      spacing_stack << {:free_spacing => free_spacing, :depth => group_depth}
      token = :options
    else
      # switch for parent group level
      spacing_stack.last[:free_spacing] = free_spacing
      token = :options_switch
    end

    emit(:group, token, text)
  end

  def emit_meta_control_sequence(data, ts, te, token)
    if data.last < 0x00 || data.last > 0x7F
      validation_error(:sequence, 'escape', token.to_s)
    end
    emit(:escape, token, copy(data, ts-1, te))
  end

  # Centralizes and unifies the handling of validation related
  # errors.
  def validation_error(type, what, reason = nil)
    error =
      case type
      when :backref      then InvalidBackrefError.new(what, reason)
      when :group        then InvalidGroupError.new(what, reason)
      when :group_option then InvalidGroupOption.new(what, reason)
      when :posix_class  then UnknownPosixClassError.new(what)
      when :property     then UnknownUnicodePropertyError.new(what)
      when :sequence     then InvalidSequenceError.new(what, reason)
      end

    raise error # unless @@config.validation_ignore
  end
end # module Regexp::Scanner
