/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.dartsclone.details;

import com.hankcs.hanlp.collection.dartsclone.details.AutoBytePool;
import com.hankcs.hanlp.collection.dartsclone.details.AutoIntPool;
import com.hankcs.hanlp.collection.dartsclone.details.BitVector;
import java.util.ArrayList;

class DawgBuilder {
    private static final int INITIAL_TABLE_SIZE = 1024;
    private ArrayList<DawgNode> _nodes = new ArrayList();
    private AutoIntPool _units = new AutoIntPool();
    private AutoBytePool _labels = new AutoBytePool();
    private BitVector _isIntersections = new BitVector();
    private AutoIntPool _table = new AutoIntPool();
    private AutoIntPool _nodeStack = new AutoIntPool();
    private AutoIntPool _recycleBin = new AutoIntPool();
    private int _numStates;

    DawgBuilder() {
    }

    int root() {
        return 0;
    }

    int child(int id) {
        return this._units.get(id) >>> 2;
    }

    int sibling(int id) {
        return (this._units.get(id) & 1) == 1 ? id + 1 : 0;
    }

    int value(int id) {
        return this._units.get(id) >>> 1;
    }

    boolean isLeaf(int id) {
        return this.label(id) == 0;
    }

    byte label(int id) {
        return this._labels.get(id);
    }

    boolean isIntersection(int id) {
        return this._isIntersections.get(id);
    }

    int intersectionId(int id) {
        return this._isIntersections.rank(id) - 1;
    }

    int numIntersections() {
        return this._isIntersections.numOnes();
    }

    int size() {
        return this._units.size();
    }

    void init() {
        this._table.resize(1024, 0);
        this.appendNode();
        this.appendUnit();
        this._numStates = 1;
        this._nodes.get((int)0).label = (byte)-1;
        this._nodeStack.add(0);
    }

    void finish() {
        this.flush(0);
        this._units.set(0, this._nodes.get(0).unit());
        this._labels.set(0, this._nodes.get((int)0).label);
        this._nodes.clear();
        this._table.clear();
        this._nodeStack.clear();
        this._recycleBin.clear();
        this._isIntersections.build();
    }

    void insert(byte[] key, int value) {
        int childId;
        int keyPos;
        if (value < 0) {
            throw new IllegalArgumentException("failed to insert key: negative value");
        }
        if (key.length == 0) {
            throw new IllegalArgumentException("failed to inset key: zero-length key");
        }
        int id = 0;
        for (keyPos = 0; keyPos <= key.length && (childId = this._nodes.get((int)id).child) != 0; ++keyPos) {
            byte keyLabel;
            byte by = keyLabel = keyPos < key.length ? key[keyPos] : (byte)0;
            if (keyPos < key.length && keyLabel == 0) {
                throw new IllegalArgumentException("failed to insert key: invalid null character");
            }
            byte unitLabel = this._nodes.get((int)childId).label;
            if ((keyLabel & 0xFF) < (unitLabel & 0xFF)) {
                throw new IllegalArgumentException("failed to insert key: wrong key order");
            }
            if ((keyLabel & 0xFF) > (unitLabel & 0xFF)) {
                this._nodes.get((int)childId).hasSibling = true;
                this.flush(childId);
                break;
            }
            id = childId;
        }
        if (keyPos > key.length) {
            return;
        }
        while (keyPos <= key.length) {
            byte keyLabel = keyPos < key.length ? key[keyPos] : (byte)0;
            int childId2 = this.appendNode();
            DawgNode node = this._nodes.get(id);
            DawgNode child = this._nodes.get(childId2);
            if (node.child == 0) {
                child.isState = true;
            }
            child.sibling = node.child;
            child.label = keyLabel;
            node.child = childId2;
            this._nodeStack.add(childId2);
            id = childId2;
            ++keyPos;
        }
        this._nodes.get(id).setValue(value);
    }

    void clear() {
        this._nodes.clear();
        this._units.clear();
        this._labels.clear();
        this._isIntersections.clear();
        this._table.clear();
        this._nodeStack.clear();
        this._recycleBin.clear();
        this._numStates = 0;
    }

    private void flush(int id) {
        while (this._nodeStack.get(this._nodeStack.size() - 1) != id) {
            int nodeId = this._nodeStack.get(this._nodeStack.size() - 1);
            this._nodeStack.deleteLast();
            if (this._numStates >= this._table.size() - (this._table.size() >>> 2)) {
                this.expandTable();
            }
            int numSiblings = 0;
            int i = nodeId;
            while (i != 0) {
                ++numSiblings;
                i = this._nodes.get((int)i).sibling;
            }
            int[] matchHashId = this.findNode(nodeId);
            int matchId = matchHashId[0];
            int hashId = matchHashId[1];
            if (matchId != 0) {
                this._isIntersections.set(matchId, true);
            } else {
                int i2;
                int unitId = 0;
                for (i2 = 0; i2 < numSiblings; ++i2) {
                    unitId = this.appendUnit();
                }
                i2 = nodeId;
                while (i2 != 0) {
                    this._units.set(unitId, this._nodes.get(i2).unit());
                    this._labels.set(unitId, this._nodes.get((int)i2).label);
                    --unitId;
                    i2 = this._nodes.get((int)i2).sibling;
                }
                matchId = unitId + 1;
                this._table.set(hashId, matchId);
                ++this._numStates;
            }
            int i3 = nodeId;
            while (i3 != 0) {
                int next = this._nodes.get((int)i3).sibling;
                this.freeNode(i3);
                i3 = next;
            }
            this._nodes.get((int)this._nodeStack.get((int)(this._nodeStack.size() - 1))).child = matchId;
        }
        this._nodeStack.deleteLast();
    }

    private void expandTable() {
        int tableSize = this._table.size() << 1;
        this._table.clear();
        this._table.resize(tableSize, 0);
        for (int id = 1; id < this._units.size(); ++id) {
            if (this._labels.get(id) != 0 && (this._units.get(id) & 2) != 2) continue;
            int[] ret = this.findUnit(id);
            int hashId = ret[1];
            this._table.set(hashId, id);
        }
    }

    private int[] findUnit(int id) {
        int[] ret = new int[2];
        int hashId = this.hashUnit(id) % this._table.size();
        while (true) {
            int unitId;
            if (hashId < 0) {
                hashId += this._table.size();
            }
            if ((unitId = this._table.get(hashId)) == 0) break;
            hashId = (hashId + 1) % this._table.size();
        }
        ret[1] = hashId;
        return ret;
    }

    private int[] findNode(int nodeId) {
        int[] ret = new int[2];
        int hashId = this.hashNode(nodeId) % this._table.size();
        while (true) {
            int unitId;
            if (hashId < 0) {
                hashId += this._table.size();
            }
            if ((unitId = this._table.get(hashId)) == 0) break;
            if (this.areEqual(nodeId, unitId)) {
                ret[0] = unitId;
                ret[1] = hashId;
                return ret;
            }
            hashId = (hashId + 1) % this._table.size();
        }
        ret[1] = hashId;
        return ret;
    }

    private boolean areEqual(int nodeId, int unitId) {
        int i = this._nodes.get((int)nodeId).sibling;
        while (i != 0) {
            if ((this._units.get(unitId) & 1) != 1) {
                return false;
            }
            ++unitId;
            i = this._nodes.get((int)i).sibling;
        }
        if ((this._units.get(unitId) & 1) == 1) {
            return false;
        }
        i = nodeId;
        while (i != 0) {
            if (this._nodes.get(i).unit() != this._units.get(unitId) || this._nodes.get((int)i).label != this._labels.get(unitId)) {
                return false;
            }
            i = this._nodes.get((int)i).sibling;
            --unitId;
        }
        return true;
    }

    private int hashUnit(int id) {
        int hashValue = 0;
        while (id != 0) {
            int unit = this._units.get(id);
            byte label = this._labels.get(id);
            hashValue ^= DawgBuilder.hash((label & 0xFF) << 24 ^ unit);
            if ((this._units.get(id) & 1) != 1) break;
            ++id;
        }
        return hashValue;
    }

    private int hashNode(int id) {
        int hashValue = 0;
        while (id != 0) {
            int unit = this._nodes.get(id).unit();
            byte label = this._nodes.get((int)id).label;
            hashValue ^= DawgBuilder.hash((label & 0xFF) << 24 ^ unit);
            id = this._nodes.get((int)id).sibling;
        }
        return hashValue;
    }

    private int appendUnit() {
        this._isIntersections.append();
        this._units.add(0);
        this._labels.add((byte)0);
        return this._isIntersections.size() - 1;
    }

    private int appendNode() {
        int id;
        if (this._recycleBin.empty()) {
            id = this._nodes.size();
            this._nodes.add(new DawgNode());
        } else {
            id = this._recycleBin.get(this._recycleBin.size() - 1);
            this._nodes.get(id).reset();
            this._recycleBin.deleteLast();
        }
        return id;
    }

    private void freeNode(int id) {
        this._recycleBin.add(id);
    }

    private static int hash(int key) {
        key = ~key + (key << 15);
        key ^= key >>> 12;
        key += key << 2;
        key ^= key >>> 4;
        key *= 2057;
        key ^= key >>> 16;
        return key;
    }

    static class DawgNode {
        int child;
        int sibling;
        byte label;
        boolean isState;
        boolean hasSibling;

        DawgNode() {
        }

        void reset() {
            this.child = 0;
            this.sibling = 0;
            this.label = 0;
            this.isState = false;
            this.hasSibling = false;
        }

        int getValue() {
            return this.child;
        }

        void setValue(int value) {
            this.child = value;
        }

        int unit() {
            if (this.label == 0) {
                return this.child << 1 | (this.hasSibling ? 1 : 0);
            }
            return this.child << 2 | (this.isState ? 2 : 0) | (this.hasSibling ? 1 : 0);
        }
    }
}

