/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetSelector;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class TaggingPresetSearchPrimitiveDialog
extends ExtendedDialog {
    private static TaggingPresetSearchPrimitiveDialog instance;
    private final TaggingPresetSelector selector;

    public static synchronized TaggingPresetSearchPrimitiveDialog getInstance() {
        if (instance == null) {
            instance = new TaggingPresetSearchPrimitiveDialog();
        }
        return instance;
    }

    TaggingPresetSearchPrimitiveDialog() {
        super((Component)MainApplication.getMainFrame(), I18n.tr("Search for objects by preset", new Object[0]), I18n.tr("Search", new Object[0]), I18n.tr("Cancel", new Object[0]));
        this.setButtonIcons("dialogs/search", "cancel");
        this.configureContextsensitiveHelp("/Action/TaggingPresetSearchPrimitive", true);
        this.selector = new TaggingPresetSelector(false, false);
        this.setContent(this.selector, false);
        this.selector.setDblClickListener(e -> this.buttonAction(0, null));
    }

    @Override
    public ExtendedDialog showDialog() {
        this.selector.init();
        super.showDialog();
        this.selector.clearSelection();
        return this;
    }

    @Override
    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        TaggingPreset preset;
        super.buttonAction(buttonIndex, evt);
        if (buttonIndex == 0 && (preset = this.selector.getSelectedPresetAndUpdateClassification()) != null) {
            OsmData<?, ?, ?, ?> ds = MainApplication.getLayerManager().getActiveData();
            ds.setSelected(new HashSet(ds.getPrimitives(preset)));
        }
    }

    public static class Action
    extends JosmAction {
        public Action() {
            super(I18n.tr("Search for objects by preset...", new Object[0]), "dialogs/search", I18n.tr("Search for objects by their presets.", new Object[0]), Shortcut.registerShortcut("preset:search-objects", I18n.tr("Presets: {0}", I18n.tr("Search for objects by preset...", new Object[0])), 114, 5005), true, "presets/search-objects", true);
            this.setHelpId(HelpUtil.ht("/Action/TaggingPresetSearchPrimitive"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainApplication.getLayerManager().getActiveData() != null) {
                TaggingPresetSearchPrimitiveDialog.getInstance().showDialog();
            }
        }

        @Override
        protected void updateEnabledState() {
            this.setEnabled(this.getLayerManager().getActiveData() != null);
        }
    }
}

