Object.assign(window.search, {"doc_urls":["introduction.html#introduction","introduction.html#syntactic-diffing","introduction.html#fallback-line-oriented-diffing","installation.html#installation","installation.html#pre-built-binaries","installation.html#package-manager","installation.html#macos","installation.html#linux-and-unix","installation.html#windows","installation.html#full-package-listing","from_source.html#installing-from-source","from_source.html#build-requirements","from_source.html#build","from_source.html#optional-install-a-mime-database","packaging_difftastic.html#packaging-difftastic","packaging_difftastic.html#packaging-the-binary","packaging_difftastic.html#reproducible-builds","packaging_difftastic.html#mime-database","packaging_difftastic.html#man-page","packaging_difftastic.html#the-manual","packaging_difftastic.html#testing","usage.html#usage","usage.html#file-arguments","usage.html#diffing-files","usage.html#diffing-directories","usage.html#reading-stdin","usage.html#files-with-conflicts","usage.html#configuration-options","usage.html#exit-codes","git.html#git","git.html#one-off-usage","git.html#regular-usage","git.html#difftastic-by-default","git.html#difftool","mercurial.html#mercurial","mercurial.html#hg-log--p","fossil.html#fossil","fossil.html#skip-difftastic-on-fossil","jj.html#jujutsu","languages_supported.html#languages-supported","languages_supported.html#programming-languages","languages_supported.html#structured-text-formats","language_detection.html#language-detection","parsing.html#internals-parsing","parsing.html#parsing-with-tree-sitter","parsing.html#simplified-syntax","parsing.html#conversion-process","parsing.html#lossy-syntax-trees","diffing.html#internals-diffing","diffing.html#graph-representation","diffing.html#comparing-routes","diffing.html#finding-the-best-route","tricky_cases.html#tricky-cases","tricky_cases.html#adding-delimiters","tricky_cases.html#changing-delimiters","tricky_cases.html#expanding-delimiters","tricky_cases.html#contracting-delimiters","tricky_cases.html#disconnected-delimiters","tricky_cases.html#rewrapping-large-nodes","tricky_cases.html#reordering-within-a-list","tricky_cases.html#middle-insertions","tricky_cases.html#punctuation-atoms","tricky_cases.html#sliders-flat","tricky_cases.html#sliders-nested","tricky_cases.html#minimising-depth-changes","tricky_cases.html#replacements-with-minor-similarities","tricky_cases.html#matching-substrings-in-comments","tricky_cases.html#multiline-comments","tricky_cases.html#reflowing-doc-comments","tricky_cases.html#small-changes-to-large-strings","tricky_cases.html#autoformatter-punctuation","tricky_cases.html#unordered-data-types","tricky_cases.html#novel-blank-lines","tricky_cases.html#invalid-syntax","contributing.html#contributing","contributing.html#building","contributing.html#manual","contributing.html#api-documentation","contributing.html#testing","contributing.html#logging","contributing.html#releasing","parser_vendoring.html#vendoring","parser_vendoring.html#git-subtrees","parser_vendoring.html#updating-a-parser","adding_a_parser.html#adding-a-parser","adding_a_parser.html#finding-a-parser","adding_a_parser.html#add-the-source-code","adding_a_parser.html#configure-the-build","adding_a_parser.html#configure-parsing","adding_a_parser.html#configure-language-detection","adding_a_parser.html#syntax-highlighting-optional","adding_a_parser.html#test-it","adding_a_parser.html#add-a-regression-test","adding_a_parser.html#maintenance","profiling.html#profiling","glossary.html#glossary","alternative_projects.html#alternative-projects","tree_diffing.html#tree-diffing","tree_diffing.html#json-diff-2012","tree_diffing.html#gumtree-2014","tree_diffing.html#tree-diff-2017","tree_diffing.html#autochrome-2017","tree_diffing.html#graphtage-2020","tree_diffing.html#diffsitter-2020","tree_diffing.html#sdiff-2021"],"index":{"documentStore":{"docInfo":{"0":{"body":37,"breadcrumbs":2,"title":1},"1":{"body":95,"breadcrumbs":3,"title":2},"10":{"body":0,"breadcrumbs":4,"title":2},"100":{"body":75,"breadcrumbs":7,"title":3},"101":{"body":44,"breadcrumbs":6,"title":2},"102":{"body":41,"breadcrumbs":6,"title":2},"103":{"body":23,"breadcrumbs":6,"title":2},"104":{"body":29,"breadcrumbs":6,"title":2},"11":{"body":27,"breadcrumbs":4,"title":2},"12":{"body":35,"breadcrumbs":3,"title":1},"13":{"body":30,"breadcrumbs":6,"title":4},"14":{"body":20,"breadcrumbs":5,"title":2},"15":{"body":27,"breadcrumbs":5,"title":2},"16":{"body":25,"breadcrumbs":5,"title":2},"17":{"body":42,"breadcrumbs":5,"title":2},"18":{"body":16,"breadcrumbs":5,"title":2},"19":{"body":45,"breadcrumbs":4,"title":1},"2":{"body":21,"breadcrumbs":5,"title":4},"20":{"body":24,"breadcrumbs":4,"title":1},"21":{"body":15,"breadcrumbs":2,"title":1},"22":{"body":0,"breadcrumbs":3,"title":2},"23":{"body":9,"breadcrumbs":3,"title":2},"24":{"body":28,"breadcrumbs":3,"title":2},"25":{"body":14,"breadcrumbs":3,"title":2},"26":{"body":23,"breadcrumbs":3,"title":2},"27":{"body":51,"breadcrumbs":3,"title":2},"28":{"body":42,"breadcrumbs":3,"title":2},"29":{"body":30,"breadcrumbs":3,"title":1},"3":{"body":9,"breadcrumbs":2,"title":1},"30":{"body":53,"breadcrumbs":4,"title":2},"31":{"body":70,"breadcrumbs":4,"title":2},"32":{"body":49,"breadcrumbs":4,"title":2},"33":{"body":116,"breadcrumbs":3,"title":1},"34":{"body":76,"breadcrumbs":3,"title":1},"35":{"body":29,"breadcrumbs":5,"title":3},"36":{"body":26,"breadcrumbs":3,"title":1},"37":{"body":33,"breadcrumbs":5,"title":3},"38":{"body":20,"breadcrumbs":3,"title":1},"39":{"body":14,"breadcrumbs":4,"title":2},"4":{"body":26,"breadcrumbs":4,"title":3},"40":{"body":243,"breadcrumbs":4,"title":2},"41":{"body":53,"breadcrumbs":5,"title":3},"42":{"body":83,"breadcrumbs":6,"title":2},"43":{"body":13,"breadcrumbs":4,"title":2},"44":{"body":70,"breadcrumbs":5,"title":3},"45":{"body":54,"breadcrumbs":4,"title":2},"46":{"body":152,"breadcrumbs":4,"title":2},"47":{"body":16,"breadcrumbs":5,"title":3},"48":{"body":10,"breadcrumbs":4,"title":2},"49":{"body":137,"breadcrumbs":4,"title":2},"5":{"body":0,"breadcrumbs":3,"title":2},"50":{"body":31,"breadcrumbs":4,"title":2},"51":{"body":49,"breadcrumbs":5,"title":3},"52":{"body":14,"breadcrumbs":6,"title":2},"53":{"body":46,"breadcrumbs":6,"title":2},"54":{"body":20,"breadcrumbs":6,"title":2},"55":{"body":39,"breadcrumbs":6,"title":2},"56":{"body":10,"breadcrumbs":6,"title":2},"57":{"body":21,"breadcrumbs":6,"title":2},"58":{"body":28,"breadcrumbs":7,"title":3},"59":{"body":14,"breadcrumbs":7,"title":3},"6":{"body":9,"breadcrumbs":2,"title":1},"60":{"body":22,"breadcrumbs":6,"title":2},"61":{"body":49,"breadcrumbs":6,"title":2},"62":{"body":73,"breadcrumbs":6,"title":2},"63":{"body":24,"breadcrumbs":6,"title":2},"64":{"body":18,"breadcrumbs":7,"title":3},"65":{"body":64,"breadcrumbs":7,"title":3},"66":{"body":24,"breadcrumbs":7,"title":3},"67":{"body":15,"breadcrumbs":6,"title":2},"68":{"body":34,"breadcrumbs":7,"title":3},"69":{"body":68,"breadcrumbs":8,"title":4},"7":{"body":42,"breadcrumbs":3,"title":2},"70":{"body":36,"breadcrumbs":6,"title":2},"71":{"body":87,"breadcrumbs":7,"title":3},"72":{"body":66,"breadcrumbs":7,"title":3},"73":{"body":65,"breadcrumbs":6,"title":2},"74":{"body":0,"breadcrumbs":2,"title":1},"75":{"body":35,"breadcrumbs":2,"title":1},"76":{"body":37,"breadcrumbs":2,"title":1},"77":{"body":16,"breadcrumbs":3,"title":2},"78":{"body":31,"breadcrumbs":2,"title":1},"79":{"body":18,"breadcrumbs":2,"title":1},"8":{"body":36,"breadcrumbs":2,"title":1},"80":{"body":19,"breadcrumbs":2,"title":1},"81":{"body":0,"breadcrumbs":4,"title":1},"82":{"body":20,"breadcrumbs":5,"title":2},"83":{"body":56,"breadcrumbs":5,"title":2},"84":{"body":0,"breadcrumbs":5,"title":2},"85":{"body":19,"breadcrumbs":5,"title":2},"86":{"body":25,"breadcrumbs":6,"title":3},"87":{"body":53,"breadcrumbs":5,"title":2},"88":{"body":111,"breadcrumbs":5,"title":2},"89":{"body":32,"breadcrumbs":6,"title":3},"9":{"body":7,"breadcrumbs":4,"title":3},"90":{"body":18,"breadcrumbs":6,"title":3},"91":{"body":14,"breadcrumbs":4,"title":1},"92":{"body":35,"breadcrumbs":6,"title":3},"93":{"body":19,"breadcrumbs":4,"title":1},"94":{"body":63,"breadcrumbs":3,"title":1},"95":{"body":187,"breadcrumbs":2,"title":1},"96":{"body":13,"breadcrumbs":4,"title":2},"97":{"body":33,"breadcrumbs":6,"title":2},"98":{"body":33,"breadcrumbs":7,"title":3},"99":{"body":60,"breadcrumbs":6,"title":2}},"docs":{"0":{"body":"Difftastic is a structural diff tool that understands syntax. It supports over 30 programming languages and when it works, it's fantastic . Difftastic is open source software (MIT license) and available on GitHub . This copy of the manual describes version 0.64.0. The changelog records which features and bug fixes are in each version. This manual is also available in Chinese .","breadcrumbs":"Introduction » Introduction","id":"0","title":"Introduction"},"1":{"body":"Difftastic detects the language , parses the code, and then compares the syntax trees. Let's look at an example. // old.rs\nlet ts_lang = guess(path, guess_src).map(tsp::from_language); // new.rs\nlet ts_lang = language_override .or_else(|| guess(path, guess_src)) .map(tsp::from_language); $ difft old.rs new.rs 1 1 let ts_lang = language_override\n. 2 .or_else(|| guess(path, guess_src))\n. 3 .map(tsp::from_language); Notice how difftastic recognises that .map is unchanged, even though it's now on a new line with whitespace. A line-oriented diff does a much worse job here. $ diff -u old.rs new.rs @@ -1 +1,3 @@\n-let ts_lang = guess(path, guess_src).map(tsp::from_language);\n+let ts_lang = language_override\n+ .or_else(|| guess(path, guess_src))\n+ .map(tsp::from_language); Some line-oriented diff tools also highlight word changes (e.g. GitHub or git's --word-diff). They still don't understand the code though. Difftastic will always find matched delimiters: you can see the closing ) from or_else has been highlighted.","breadcrumbs":"Introduction » Syntactic Diffing","id":"1","title":"Syntactic Diffing"},"10":{"body":"","breadcrumbs":"Installation » From Source » Installing From Source","id":"10","title":"Installing From Source"},"100":{"body":"Languages: S-expression data format Algorithm: A* search Output: Merged s-expression file Tristan Hume wrote a tree diffing algorithm during his 2017 internship at Jane Street. The source code is not available, but he has a blog post discussing the design in depth. This project finds minimal diffs between s-expression files used as configuration by Jane Street. It uses A* search to find the minimal diff between them, and builds a new s-expression with a section marked with :date-switch for the differing parts. (Jane Street also has patdiff, but that seems to be a line-oriented diff with some whitespace/integer display polish. It doesn't understand that e.g. whitespace in \"foo \" is meaningful).","breadcrumbs":"Alternative Projects » Tree Diffing » Tree Diff (2017)","id":"100","title":"Tree Diff (2017)"},"101":{"body":"Languages: Clojure Parser: Custom, preserves comments Algorithm: Dijkstra (previously A* search) Output: HTML Autochrome parses Clojure with a custom parser that preserves comments. Autochrome uses Dijkstra's algorithm to compare syntax trees. Autochrome's webpage includes worked examples of the algorithm and a discussion of design tradeoffs. It's a really great resource for understanding tree diffing techniques in general.","breadcrumbs":"Alternative Projects » Tree Diffing » Autochrome (2017)","id":"101","title":"Autochrome (2017)"},"102":{"body":"Languages: JSON, XML, HTML, YAML, plist, and CSS Parser: json5, pyYAML, ignores comments Algorithm: Levenshtein distance Output: CLI colours graphtage compares structured data by parsing into a generic file format, then displaying a diff. It even allows things like diffing JSON against YAML. As with json-diff, it does not consider [\"foo\"] and \"foo\" to have any similarities.","breadcrumbs":"Alternative Projects » Tree Diffing » graphtage (2020)","id":"102","title":"graphtage (2020)"},"103":{"body":"Parser: Tree-sitter Algorithm: Longest-common-subsequence Output: CLI colours Diffsitter is another tree-sitter based diff tool. It uses LCS diffing on the leaves of the syntax tree .","breadcrumbs":"Alternative Projects » Tree Diffing » Diffsitter (2020)","id":"103","title":"Diffsitter (2020)"},"104":{"body":"Languages: Scheme Parser: Scheme's built-in read, ignores comments Algorithm: MH-Diff from the Chawathe paper Output: CLI colours Semantically meaningful S-expression diff: Tree-diff for lisp source code was presented at FOSDEM 2021.","breadcrumbs":"Alternative Projects » Tree Diffing » sdiff (2021)","id":"104","title":"sdiff (2021)"},"11":{"body":"Difftastic is written in Rust, so you will need Rust installed. I recommend rustup to install Rust. Difftastic requires Rust version 1.74.1 or later. You will also need a C++ compiler that supports C++14. If you're using GCC, you need at least version 8.","breadcrumbs":"Installation » From Source » Build Requirements","id":"11","title":"Build Requirements"},"12":{"body":"You can download and build difftastic on crates.io with Cargo (which is part of Rust). $ cargo install --locked difftastic Difftastic uses the cc crate for building C/C++ dependencies. This allows you to use environment variables CC and CXX to control the compiler used (see the cc docs ). See contributing for instructions on debug builds.","breadcrumbs":"Installation » From Source » Build","id":"12","title":"Build"},"13":{"body":"If a MIME database is available, difftastic will use it to detect binary files more accurately. This is the same database used by the file command, so you probably already have it. The MIME database path is specified in the XDG specification . The database should be at one of the following paths: /usr/share/mime/magic /usr/local/share/mime/magic $HOME/.local/share/mime/magic","breadcrumbs":"Installation » From Source » (Optional) Install a MIME Database","id":"13","title":"(Optional) Install a MIME Database"},"14":{"body":"This page contains recommendations for people creating a difftastic package. Note that the difftastic author only provides the source code and the prebuilt binaries on GitHub. Packages have been created by other people -- thank you!","breadcrumbs":"Installation » Packaging Difftastic » Packaging Difftastic","id":"14","title":"Packaging Difftastic"},"15":{"body":"Difftastic can be built with cargo. The compiled binary will be at target/release/difft when using the following command. $ cargo build --release C library dependencies are built with the cc crate, which exposes various environment variables to configure the C toolchain (e.g. CFLAGS).","breadcrumbs":"Installation » Packaging Difftastic » Packaging The Binary","id":"15","title":"Packaging The Binary"},"16":{"body":"Difftastic's build script (the build.rs file) uses Rayon to build C libraries in parallel, which can lead to minor ordering changes in the final binary. You can avoid this by disabling Rayon parallelism. $ RAYON_NUM_THREADS=1 cargo build --release","breadcrumbs":"Installation » Packaging Difftastic » Reproducible Builds","id":"16","title":"Reproducible Builds"},"17":{"body":"Difftastic depends on tree_magic_mini , which accesses the MIME database on the current system. The MIME database is used to recognise file types, so difftastic does not try to compoare binary files as text. This means that the difftastic package should depend on a MIME database package, if available. Difftastic respects the XDG base specification to find the MIME database files. These files are typically at /usr/share/mime/, /usr/local/share/mime/ or /opt/homebrew/share/mime/.","breadcrumbs":"Installation » Packaging Difftastic » MIME Database","id":"17","title":"MIME Database"},"18":{"body":"As of difftastic 0.58, a man page is available. See the file difft.1. This file is generated from difft.1.md, but the generated difft.1 is included in the repository for convenience.","breadcrumbs":"Installation » Packaging Difftastic » Man Page","id":"18","title":"Man Page"},"19":{"body":"Please consider including the difftastic manual with your package. These are HTML files that can be generated with mdbook. The following command generates HTML at manual/book/. $ cd manual\n$ mdbook build manual/book.toml also references a script replace_version_placeholder.sh that replaces occurrences of DFT_VERSION_HERE in the manual. For packaging, it may be easier to remove the configuration from book.toml and replace the text directly. -[preprocessor.replace-version-placeholder]\n-command = \"./replace_version_placeholder.sh\" $ export CURRENTVERSION=\"7.8.9\"\n$ sed -i \"s/DFT_VERSION_HERE/$CURRENTVERSION/g\" -i src/introduction.md","breadcrumbs":"Installation » Packaging Difftastic » The Manual","id":"19","title":"The Manual"},"2":{"body":"If input files are not in a format that difftastic understands, it uses a conventional line-oriented diff with word highlighting. Difftastic will also use line-oriented diffing when given extremely large inputs.","breadcrumbs":"Introduction » Fallback Line-Oriented Diffing","id":"2","title":"Fallback Line-Oriented Diffing"},"20":{"body":"If your packaging tool supports testing, consider running the difftastic unit tests. # Run the normal tests.\n$ cargo test # Run the tests that depend on the\n# MIME database being present.\n$ cargo test -- --ignored","breadcrumbs":"Installation » Packaging Difftastic » Testing","id":"20","title":"Testing"},"21":{"body":"This page describes how to use the difft binary directly. See also the Git , Mercurial and Fossil pages for instructions on how to configure them to use difftastic.","breadcrumbs":"Usage » Usage","id":"21","title":"Usage"},"22":{"body":"","breadcrumbs":"Usage » File Arguments","id":"22","title":"File Arguments"},"23":{"body":"$ difft FIRST-FILE SECOND-FILE # For example:\n$ difft sample_files/simple_1.js sample_files/simple_2.js","breadcrumbs":"Usage » Diffing Files","id":"23","title":"Diffing Files"},"24":{"body":"$ difft FIRST-DIRECTORY SECOND-DIRECTORY # For example:\n$ difft sample_files/dir_1/ sample_files/dir_2/ Difftastic will recursively walk the two directories, diffing files with the same name. The --skip-unchanged option is useful when diffing directories that contain many unchanged files.","breadcrumbs":"Usage » Diffing Directories","id":"24","title":"Diffing Directories"},"25":{"body":"You can read a file from stdin by specifying - as the file path. $ difft - SECOND-FILE # For example:\n$ cat sample_files/simple_1.js | difft - sample_files/simple_2.js","breadcrumbs":"Usage » Reading stdin","id":"25","title":"Reading stdin"},"26":{"body":"(Added in version 0.50.) If you have a file with <<<<<<< conflict markers, you can pass it as a single argument to difftastic. Difftastic will construct the two file states and diff those. $ difft FILE-WITH-CONFLICTS # For example:\n$ difft sample_files/conflicts.el","breadcrumbs":"Usage » Files With Conflicts","id":"26","title":"Files With Conflicts"},"27":{"body":"Every difftastic option can be set with a command line argument or an environment variable. For example, DFT_BACKGROUND=light is equivalent to --background=light. Environment variables are often useful when using VCS tools like git, because they invoke the difft binary directly. For a full list of configuration options, see --help. $ difft --help\n...\nOPTIONS: --background <BACKGROUND> Set the background brightness. Difftastic will prefer brighter colours on dark backgrounds. [env: DFT_BACKGROUND=] [default: dark] [possible values: dark, light]\n...","breadcrumbs":"Usage » Configuration Options","id":"27","title":"Configuration Options"},"28":{"body":"2: Difftastic was given invalid arguments. This includes invalid usage (e.g. the wrong number of arguments) as well as paths that difftastic cannot read (e.g. non-existent paths or insufficient permissions). 1: When called with --exit-code, difftastic will return an exit code of 1 when it finds any syntactic changes (in text files) or byte changes (in binary files). 0: All other cases.","breadcrumbs":"Usage » Exit Codes","id":"28","title":"Exit Codes"},"29":{"body":"Difftastic can be used an external diff command in git, allowing difftastic to be used with any git subcommand. Warning: git v2.43.1 and earlier can crash when using an external diff and file permissions have changed. If you can't upgrade git, use the difftool configuration described below.","breadcrumbs":"Usage » Git » Git","id":"29","title":"Git"},"3":{"body":"Diffstatic can be installed as pre-built binaries or using various package managers.","breadcrumbs":"Installation » Installation","id":"3","title":"Installation"},"30":{"body":"You can set the diff.external configuration option when running git diff, or set the GIT_EXTERNAL_DIFF environment variable. View uncommitted changes with difftastic: $ git -c diff.external=difft diff Other git commands also require the --ext-diff argument in order to use diff.external. View changes from the most recent commit with difftastic: $ git -c diff.external=difft show --ext-diff View changes from recent commits on the current branch with difftastic: $ git -c diff.external=difft log -p --ext-diff","breadcrumbs":"Usage » Git » One-Off Usage","id":"30","title":"One-Off Usage"},"31":{"body":"If you like difftastic, we recommend that you configure git aliases so you can use difftastic more easily. [alias] # Difftastic aliases, so `git dlog` is `git log` with difftastic and so on. dlog = -c diff.external=difft log --ext-diff dshow = -c diff.external=difft show --ext-diff ddiff = -c diff.external=difft diff The author likes the following additional aliases to reduce typing: [alias] # `git log` with patches shown with difftastic. dl = -c diff.external=difft log -p --ext-diff # Show the most recent commit with difftastic. ds = -c diff.external=difft show --ext-diff # `git diff` with difftastic. dft = -c diff.external=difft diff","breadcrumbs":"Usage » Git » Regular Usage","id":"31","title":"Regular Usage"},"32":{"body":"If you want to use difftastic as your default diff tool, add the following to your ~/.gitconfig. [diff] external = difft This changes git diff to use difftastic, and other commands now only require --ext-diff. $ git diff\n$ git show --ext-diff\n$ git log -p --ext-diff If you've configured difftastic as the default diff tool, you can opt-out for an individual command with --no-ext-diff. $ git diff --no-ext-diff","breadcrumbs":"Usage » Git » Difftastic By Default","id":"32","title":"Difftastic By Default"},"33":{"body":"Git also has a difftool feature which allows users to invoke CLI or GUI comparison tools. For best results, we recommend using -c diff.external=difft as described above. Git passes more information to the external diff, including file permission changes and rename information, so difftastic can show more information. To define a difftool named difftastic, add the following to your ~/.gitconfig. [difftool \"difftastic\"] # See `man git-difftool` for a description of MERGED, LOCAL and REMOTE. cmd = difft \"$MERGED\" \"$LOCAL\" \"abcdef1\" \"100644\" \"$REMOTE\" \"abcdef2\" \"100644\" You can now use difftastic as a difftool: $ git difftool -t difftastic For the best results when using difftastic as a difftool, we recommend the following additional git configuration: [difftool] # Run the difftool immediately, don't ask 'are you sure' each time. prompt = false [pager] # Use a pager if the difftool output is larger than one screenful, # consistent with the behaviour of `git diff`. difftool = true [diff] # Set difftastic as the default difftool, so we don't need to specify # `-t difftastic` every time. tool = difftastic","breadcrumbs":"Usage » Git » Difftool","id":"33","title":"Difftool"},"34":{"body":"Mercurial supports external diff tools with the Extdiff extension. Enable it by adding an entry to extensions in your .hgrc. [extensions]\nextdiff = You can then run hg extdiff -p difft instead of hg diff (assumes the difft binary is on your $PATH). You can also define an alias to run difftastic with hg. Add the following to your .hgrc to run difftastic with hg dft. [extdiff]\ncmd.dft = difft\n# You can add further options which will be passed to the command line, e.g.\n# opts.dft = --background light All options of hg diff are also supported by hg dft; for example, hg dft --stat will show statistics of changed lines and hg dft -r 42 -r 45 will show the diff between two revisions.","breadcrumbs":"Usage » Mercurial » Mercurial","id":"34","title":"Mercurial"},"35":{"body":"Mercurial does not have a way of changing the default diff tool, at least to the author's knowledge. If you just want to view the diff of the most recent commit, you can use the following. hg dft -r .^ -r . This is equivalent to hg log -l 1 -p, although it does not show the commit message.","breadcrumbs":"Usage » Mercurial » hg log -p","id":"35","title":"hg log -p"},"36":{"body":"Fossil supports external diff commands by setting diff-command for the current repository: fossil settings diff-command difft To use difftastic for all repositories, use --global: fossil settings diff-command --global difft","breadcrumbs":"Usage » Fossil » Fossil","id":"36","title":"Fossil"},"37":{"body":"If you set difftastic as Fossil's diff command, but you need to use Fossil's internal diff once, use -i to skip difftastic once: fossil diff -i If you want to remove difftastic from one repository (or globally), use unset: fossil unset diff-command unset also supports the --global flag.","breadcrumbs":"Usage » Fossil » Skip difftastic on Fossil","id":"37","title":"Skip difftastic on Fossil"},"38":{"body":"Jujutsu supports external diff commands . To use difftastic for diffing in jujutsu, add the following to your user configuration file . [ui]\ndiff.tool = [\"difft\", \"--color=always\", \"$left\", \"$right\"]","breadcrumbs":"Usage » Jujutsu » Jujutsu","id":"38","title":"Jujutsu"},"39":{"body":"This page lists all the languages supported by difftastic. You can also view the languages supported in your current installed version with difft --list-languages.","breadcrumbs":"Languages Supported » Languages Supported","id":"39","title":"Languages Supported"},"4":{"body":"Diffstatic releases are published as GitHub releases with pre-built binaries for Windows, macOS and Linux. Open the latest release page , download the file matching your OS and CPU architecture, and extract the difft executable application file.","breadcrumbs":"Installation » Pre-Built Binaries","id":"4","title":"Pre-Built Binaries"},"40":{"body":"Language Parser Used Ada briot/tree-sitter-ada Apex aheber/tree-sitter-sfapex Bash tree-sitter/tree-sitter-bash C tree-sitter/tree-sitter-c C++ tree-sitter/tree-sitter-cpp C# tree-sitter/tree-sitter-c-sharp Clojure sogaiu/tree-sitter-clojure CMake uyha/tree-sitter-cmake Common Lisp theHamsta/tree-sitter-commonlisp Dart UserNobody14/tree-sitter-dart Device Tree joelspadin/tree-sitter-devicetree Elixir elixir-lang/tree-sitter-elixir Elm elm-tooling/tree-sitter-elm Elvish ckafi/tree-sitter-elvish Erlang WhatsApp/tree-sitter-erlang Emacs Lisp wilfred/tree-sitter-elisp F# ionide/tree-sitter-fsharp Gleam gleam-lang/tree-sitter-gleam Go tree-sitter/tree-sitter-go Hack slackhq/tree-sitter-hack Hare ecmma/tree-sitter-hare Haskell tree-sitter/tree-sitter-haskell Janet sogaiu/tree-sitter-janet-simple Java tree-sitter/tree-sitter-java JavaScript, JSX tree-sitter/tree-sitter-javascript Julia tree-sitter/tree-sitter-julia Kotlin fwcd/tree-sitter-kotlin Lua tree-sitter-grammars/tree-sitter-lua Make tree-sitter-grammars/tree-sitter-make Nix nix-community/tree-sitter-nix Objective-C amaanq/tree-sitter-objc OCaml tree-sitter/tree-sitter-ocaml Pascal Isopod/tree-sitter-pascal Perl ganezdragon/tree-sitter-perl PHP tree-sitter/tree-sitter-php Python tree-sitter/tree-sitter-python QML yuja/tree-sitter-qmljs R r-lib/tree-sitter-r Racket 6cdh/tree-sitter-racket Ruby tree-sitter/tree-sitter-ruby Rust tree-sitter/tree-sitter-rust Scala tree-sitter/tree-sitter-scala Scheme 6cdh/tree-sitter-scheme Smali amaanq/tree-sitter-smali Solidity JoranHonig/tree-sitter-solidity SQL m-novikov/tree-sitter-sql Swift alex-pinkus/tree-sitter-swift TypeScript, TSX tree-sitter/tree-sitter-typescript Verilog tree-sitter/tree-sitter-verilog VHDL JLeemaster/tree-sitter-vhdl Zig maxxnino/tree-sitter-zig","breadcrumbs":"Languages Supported » Programming Languages","id":"40","title":"Programming Languages"},"41":{"body":"Language Parser Used CSS tree-sitter/tree-sitter-css HCL MichaHoffmann/tree-sitter-hcl HTML tree-sitter/tree-sitter-html JSON tree-sitter/tree-sitter-json LaTeX latex-lsp/tree-sitter-latex Newick delehef/tree-sitter-newick SCSS serenadeai/tree-sitter-scss TOML tree-sitter-grammars/tree-sitter-toml XML tree-sitter-grammars/tree-sitter-xml YAML tree-sitter-grammars/tree-sitter-yaml","breadcrumbs":"Languages Supported » Structured Text Formats","id":"41","title":"Structured Text Formats"},"42":{"body":"Difftastic guesses the language used based on the file extension, file name, and the contents of the first few lines. To see the languages available, and the associated file names, use the --list-languages option. $ difft --list-languages\n...\nXML *.ant *.csproj *.plist *.resx *.svg *.ui *.vbproj *.xaml *.xml *.xsd *.xsl *.xslt *.zcml App.config nuget.config packages.config .classpath .cproject .project\nYAML *.yaml *.yml\nZig *.zig You can override language detection for specific file globs using the --override option. $ difft --override=GLOB:NAME FIRST-FILE SECOND-FILE # For example, treating .h files as C rather than C++:\n$ difft --override=*.h:c sample_files/preprocessor_1.h sample_files/preprocessor_2.h See difft --help for more examples of --override usage.","breadcrumbs":"Languages Supported » Language Detection » Language Detection","id":"42","title":"Language Detection"},"43":{"body":"Difftastic uses tree-sitter to build a parse tree. The parse tree is then converted to a simpler tree which can be diffed.","breadcrumbs":"Internals: Parsing » Internals: Parsing","id":"43","title":"Internals: Parsing"},"44":{"body":"Difftastic relies on tree-sitter to understand syntax. You can view the parse tree that tree-sitter produces using the --dump-ts flag. $ difft --dump-ts sample_files/javascript_simple_1.js | head\nprogram (0, 0) - (7, 0) comment (0, 0) - (0, 8) \"// hello\" expression_statement (1, 0) - (1, 6) call_expression (1, 0) - (1, 5) identifier (1, 0) - (1, 3) \"foo\" arguments (1, 3) - (1, 5) ( (1, 3) - (1, 4) \"(\" ) (1, 4) - (1, 5) \")\" ; (1, 5) - (1, 6) \";\" expression_statement (2, 0) - (2, 6)","breadcrumbs":"Internals: Parsing » Parsing with Tree-sitter","id":"44","title":"Parsing with Tree-sitter"},"45":{"body":"Difftastic converts the tree-sitter parse tree to a simplified syntax tree. The syntax tree is a uniform representation where everything is either an atom (e.g. integer literals, comments, variable names) or a list (consisting of the open delimiter, children and the close delimiter). The flag --dump-syntax will display the syntax tree generated for a file. $ difft --dump-syntax sample_files/before.js\n[ Atom id:1 { content: \"// hello\", position: \"0:0-8\", }, List id:2 { open_content: \"\", open_position: \"1:0-0\", children: [ ...","breadcrumbs":"Internals: Parsing » Simplified Syntax","id":"45","title":"Simplified Syntax"},"46":{"body":"The simple representation of the difftastic parse tree makes diffing much easier. Converting the detailed tree-sitter parse tree is a recursive tree walk, treating tree-sitter leaf nodes as atoms. There are two exceptions. (1) Tree-sitter parse trees sometimes include unwanted structure. Some grammars consider string literals to be a single token, whereas others treat strings as a complex structure where the delimiters are separate. tree_sitter_parser.rs uses atom_nodes to mark specific tree-sitter node names as flat atoms even if the node has children. (2) Tree-sitter parse trees include open and closing delimiters as tokens. A list [1] will have a parse tree that includes [ and ] as nodes. $ echo '[1]' > example.js\n$ difft --dump-ts example.js\nprogram (0, 0) - (1, 0) expression_statement (0, 0) - (0, 3) array (0, 0) - (0, 3) [ (0, 0) - (0, 1) \"[\" number (0, 1) - (0, 2) \"1\" ] (0, 2) - (0, 3) \"]\" tree_sitter_parser.rs uses open_delimiter_tokens to ensure that [ and ] are used as delimiter content in the enclosing list, rather than converting them to atoms. Difftastic can match up atoms that occur in different parts of the simplified syntax tree. If e.g. a [ is treated as an atom, difftastic might match it with another [ elsewhere. The resulting diff would be unbalanced, highlighting different numbers of open and close delimiters.","breadcrumbs":"Internals: Parsing » Conversion Process","id":"46","title":"Conversion Process"},"47":{"body":"The simplified syntax tree only stores node content and node position. It does not store whitespace between nodes, and position is ignored during diffing.","breadcrumbs":"Internals: Parsing » Lossy Syntax Trees","id":"47","title":"Lossy Syntax Trees"},"48":{"body":"Difftastic treats diff calculations as a route finding problem on a directed acyclic graph.","breadcrumbs":"Internals: Diffing » Internals: Diffing","id":"48","title":"Internals: Diffing"},"49":{"body":"A vertex in the graph represents a position in two syntax trees. The start vertex has both positions pointing to the first syntax node in both trees. The end vertex has both positions just after the last syntax node in both trees. Consider comparing A with X A. START\n+---------------------+\n| Left: A Right: X A |\n| ^ ^ |\n+---------------------+ END\n+---------------------+\n| Left: A Right: X A |\n| ^ ^|\n+---------------------+ From the start vertex, we have two options: we can mark the first syntax node on the left as novel, and advance to the next syntax node on the left (vertex 1 above), or we can mark the first syntax node on the right as novel, and advance to the next syntax node on the right (vertex 2 above). START +---------------------+ | Left: A Right: X A | | ^ ^ | +---------------------+ / \\ Novel atom L / \\ Novel atom R\n1 v 2 v\n+---------------------+ +---------------------+\n| Left: A Right: X A | | Left: A Right: X A |\n| ^ ^ | | ^ ^ |\n+---------------------+ +---------------------+ Choosing \"novel atom R\" to vertex 2 will turn out to be the best choice. From vertex 2, we can see three routes to the end vertex. 2 +---------------------+ | Left: A Right: X A | | ^ ^ | +---------------------+ / | \\ Novel atom L / | \\ Novel atom R v | v\n+---------------------+ | +---------------------+\n| Left: A Right: X A | | | Left: A Right: X A |\n| ^ ^ | | | ^ ^|\n+---------------------+ | +---------------------+ | | | | Novel atom R | Nodes match | Novel atom L | | | | END v | | +---------------------+ | +-------->| Left: A Right: X A |<---------+ | ^ ^| +---------------------+","breadcrumbs":"Internals: Diffing » Graph Representation","id":"49","title":"Graph Representation"},"5":{"body":"","breadcrumbs":"Installation » Package Manager","id":"5","title":"Package Manager"},"50":{"body":"We assign a cost to each edge. Marking a syntax node as novel is worse than finding a matching syntax node, so the \"novel atom\" edge has a higher cost than the \"syntax nodes match\" edge. The best route is the lowest cost route from the start vertex to the end vertex.","breadcrumbs":"Internals: Diffing » Comparing Routes","id":"50","title":"Comparing Routes"},"51":{"body":"Difftastic uses Dijkstra's algorithm to find the best (i.e. lowest cost) route. One big advantage of this algorithm is that we don't need to construct the graph in advance. Constructing the whole graph would require exponential memory relative to the number of syntax nodes. Instead, vertex neighbours are constructed as the graph is explored. There are lots of resources explaining Dijkstra's algorithm online, but I particularly recommend the graph search section of Red Blob Games .","breadcrumbs":"Internals: Diffing » Finding The Best Route","id":"51","title":"Finding The Best Route"},"52":{"body":"Tree diffing is challenging in some situations. This page discusses difficult cases, and how difftastic handles them. Not all of these cases work well in difftastic yet.","breadcrumbs":"Internals: Diffing » Tricky Cases » Tricky Cases","id":"52","title":"Tricky Cases"},"53":{"body":";; Before\nx ;; After\n(x) Possible result: (x) Desired result: (x) This is tricky because x has changed its depth in the tree, but x itself is unchanged. Not all tree diff algorithms handle this case. It is also challenging to display this case clearly: we want to highlight the changed delimiters, but not their content. This is challenging in larger expressions. Difftastic : Difftastic considers nodes to be equal even at different depths, achieving the desired result in this case.","breadcrumbs":"Internals: Diffing » Tricky Cases » Adding Delimiters","id":"53","title":"Adding Delimiters"},"54":{"body":";; Before\n(x) ;; After\n[x] Desired result: (x), [x] As with the wrapping case, we want to highlight the delimiters rather than the x. Difftastic : Difftastic handles this correctly through its tree diffing.","breadcrumbs":"Internals: Diffing » Tricky Cases » Changing Delimiters","id":"54","title":"Changing Delimiters"},"55":{"body":";; Before\n(x) y ;; After\n(x y) Possible result 1: (x) y, (x y) Possible result 2: (x) y, (x y) It's not clear which is better in this case. Difftastic : Difftastic currently shows result 2, but this case is sensitive to the cost model. Some previous versions of difftastic have shown result 1.","breadcrumbs":"Internals: Diffing » Tricky Cases » Expanding Delimiters","id":"55","title":"Expanding Delimiters"},"56":{"body":";; Before\n(x y) ;; After\n(x) y This case is similar to the expanding delimiter case.","breadcrumbs":"Internals: Diffing » Tricky Cases » Contracting Delimiters","id":"56","title":"Contracting Delimiters"},"57":{"body":";; Before\n(foo (bar)) ;; After\n(foo (novel) (bar)) Desired result: (foo (novel) (bar)) It is easy to end up with (foo (novel) (bar)), where a later pair of delimiters are chosen.","breadcrumbs":"Internals: Diffing » Tricky Cases » Disconnected Delimiters","id":"57","title":"Disconnected Delimiters"},"58":{"body":";; Before\n[[foo]]\n(x y) ;; After\n([[foo]] x y) We want to highlight [[foo]] being moved inside the parentheses. However, a naive syntax differ prefers to consider a removal of () in the before and an addition of () in the after to be more minimal diff. (Reported as issue 44 .)","breadcrumbs":"Internals: Diffing » Tricky Cases » Rewrapping Large Nodes","id":"58","title":"Rewrapping Large Nodes"},"59":{"body":";; Before\n(x y) ;; After\n(y x) Desired result: (y x) We want to highlight the list contents and not the delimiters.","breadcrumbs":"Internals: Diffing » Tricky Cases » Reordering Within A List","id":"59","title":"Reordering Within A List"},"6":{"body":"If you're a Homebrew user, you can install difftastic with brew. $ brew install difftastic","breadcrumbs":"Installation » macOS","id":"6","title":"macOS"},"60":{"body":"// Before\nfoo(bar(123)) // After\nfoo(extra(bar(123))) Desired result: foo(extra(bar(123))) We want to consider both foo and bar to be unchanged. This case is challenging for diffing algorithms that do a bottom-up then top-down matching of trees.","breadcrumbs":"Internals: Diffing » Tricky Cases » Middle Insertions","id":"60","title":"Middle Insertions"},"61":{"body":"// Before\nfoo(1, bar) // After\nfoo(bar, 2) Possible result: foo(bar, 2) Desired result: foo(bar, 2) There are two atoms inside the () that we could consider as unchanged, either the bar or the ,. (We can't consider both to be unchanged as they're reordered.) We want to consider bar to be unchanged, as it's a more important atom than the , punctuation atom. Doing this is in a language-agnostic way is difficult, so difftastic has a small list of punctuation characters that always get lower priority than other atoms.","breadcrumbs":"Internals: Diffing » Tricky Cases » Punctuation Atoms","id":"61","title":"Punctuation Atoms"},"62":{"body":"Sliders are a common problem in text based diffs, where lines are matched in a confusing way. They typically look like this. The diff has to arbitrarily choose a line containing delimiter, and it chooses the wrong one. + }\n+\n+ function foo () { } git-diff has some heuristics to reduce the risk of this (e.g. the \"patience diff\"), but it can still occur. There's a similar problem in tree diffs. ;; Before\nA B\nC D ;; After\nA B\nA B\nC D Possible result: A B\nA B\nC D Preferred result: A B\nA B\nC D Ideally we'd prefer marking contiguous nodes as novel. From the perspective of a longest-common-subsequence algorithm, these two choices are equivalent.","breadcrumbs":"Internals: Diffing » Tricky Cases » Sliders (Flat)","id":"62","title":"Sliders (Flat)"},"63":{"body":"// Before\nold1(old2) // After\nold1(new1(old2)) Possible result: old1(new1(old2)) Desired result: old1(new1(old2)) The correct answer depends on the language. Most languages want to prefer the inner delimiter, whereas Lisps and JSON prefer the outer delimiter.","breadcrumbs":"Internals: Diffing » Tricky Cases » Sliders (Nested)","id":"63","title":"Sliders (Nested)"},"64":{"body":"// Before\nif true { foo(123);\n}\nfoo(456); // After\nfoo(789); Do we consider foo(123) or foo(456) to match with foo(789)? Difftastic prefers foo(456) by preferring nodes at the same nesting depth.","breadcrumbs":"Internals: Diffing » Tricky Cases » Minimising Depth Changes","id":"64","title":"Minimising Depth Changes"},"65":{"body":"// Before\nfunction foo(x) { return x + 1; } // After\nfunction bar(y) { baz(y); } Possible result: function bar(y) { baz(y); } In this example, we've deleted a function and written a completely different one. A tree-based diff could match up the function and the outer delimiters, resulting in a confusing display showing lots of small changes. As with sliders, the replacement problem can also occur in textual line-based diffs. Line-diffs struggle if there are a small number of common lines. The more precise, granular behaviour of tree diffs makes this problem much more common though.","breadcrumbs":"Internals: Diffing » Tricky Cases » Replacements With Minor Similarities","id":"65","title":"Replacements With Minor Similarities"},"66":{"body":"// Before\n/* The quick brown fox. */\nfoobar(); // After\n/* The slow brown fox. */\nfoobaz(); foobar and foobaz are completely different, and their common prefix fooba should not be matched up. However, matching common prefixes or suffixes for comments is desirable.","breadcrumbs":"Internals: Diffing » Tricky Cases » Matching Substrings In Comments","id":"66","title":"Matching Substrings In Comments"},"67":{"body":"// Before\n/* Hello * World. */ // After\nif (x) { /* Hello * World. */\n} The inner content of these two comments is technically different. We want to treat them as identical however.","breadcrumbs":"Internals: Diffing » Tricky Cases » Multiline Comments","id":"67","title":"Multiline Comments"},"68":{"body":"Block comments have prefixes that aren't meaningful. // Before\n/* The quick brown fox jumps * over the lazy dog. */ // After\n/* The quick brown fox immediately * jumps over the lazy dog. */ The inner content has changed from jumps * over to immediately * jumps over. However, the * is decorative and we don't care that it's moved.","breadcrumbs":"Internals: Diffing » Tricky Cases » Reflowing Doc Comments","id":"68","title":"Reflowing Doc Comments"},"69":{"body":"// Before\n\"\"\"A very long string\nwith lots of words about\nlots of stuff.\"\"\" // After\n\"\"\"A very long string\nwith lots of NOVEL words about\nlots of stuff.\"\"\" It would be correct to highlight the entire string literal as being removed and replaced with a new string literal. However, this makes it hard to see what's actually changed. It's clear that variable names should be treated atomically, and comments are safe to show subword changes. It's not clear how to handle a small change in a 20 line string literal. It's tempting to split strings on spaces and diff that, but users still want to know when whitespace changes inside strings. \" \" and \" \" are not the same.","breadcrumbs":"Internals: Diffing » Tricky Cases » Small Changes To Large Strings","id":"69","title":"Small Changes To Large Strings"},"7":{"body":"If you're an Arch Linux user, you can install difftastic with pacman. $ sudo pacman -S difftastic If you're a Nix user, you can install difftastic with nix-env. $ nix-env --install difftastic If you're a Fedora user, you can install difftastic with dnf. $ sudo dnf install difftastic If you're a FreeBSD user, you can install difftastic with pkg. $ sudo pkg install difftastic","breadcrumbs":"Installation » Linux and Unix","id":"7","title":"Linux and Unix"},"70":{"body":"// Before\nfoo(\"looooong\", \"also looooong\"); // After\nfoo( \"looooong\", \"novel\", \"also looooong\",\n); Autoformatters (e.g. prettier ) will sometimes add or remove punctuation when formatting. Commas and parentheses are the most common. Syntactic diffing can ignore whitespace changes, but it has to assume punctuation is meaningful. This can lead to punctuation changes being highlighted, which may be quite far from the relevant content change.","breadcrumbs":"Internals: Diffing » Tricky Cases » Autoformatter Punctuation","id":"70","title":"Autoformatter Punctuation"},"71":{"body":"// Before\nset(1, 2) // After\nset(2, 1) Users may expect difftastic to find no changes here. This is difficult for several reasons. For programming languages, side effects might make the order relevant. set(foo(), bar()) might behave differently to set(bar(), foo()). For configuration languages like JSON or YAML, some parser implementations do actually expose ordering information (e.g. object_pairs_hook=OrderedDict in Python, or serde_json's preserve_order feature in Rust). To make matters worse, unordered tree diffing is NP-hard. For the unordered case, it turns out that all of the problems in general are NP-hard. Indeed, the tree edit distance and alignment distance problems are even MAX SNP-hard. -- A survey on tree edit distance and related problems Difftastic : Difftastic considers ordering to be meaningful everywhere, so it will always report ordering changes.","breadcrumbs":"Internals: Diffing » Tricky Cases » Unordered Data Types","id":"71","title":"Unordered Data Types"},"72":{"body":"Blank lines are challenging for syntactic diffs. We are comparing syntactic tokens, so we don't see blank lines. // Before\nA\nB // After\nA B Generally we want syntactic diffing to ignore blank lines. In this first example, this should show no changes. This is occasionally problematic, as it can hide accidental code reformatting. // Before\nA\nB // After\nA\nX Y\nB In this second example, we've inserted X and Y and a blank line. We want to highlight the blank line as an addition. // Before\nA B // After\nA\nX\nB In this third example, the syntactic diffing only sees an addition. From the user's perspective, there has also been a removal of two blank lines.","breadcrumbs":"Internals: Diffing » Tricky Cases » Novel Blank Lines","id":"72","title":"Novel Blank Lines"},"73":{"body":"There's no guarantee that the input we're given is valid syntax. Even if the code is valid, it might use syntax that isn't supported by the parser. Difftastic : Difftastic will fall back to a line-oriented diff if any parse errors occur, to avoid diffing incomplete syntax trees. When this occurs, the file header reports the error count. $ difft sample_files/syntax_error_1.js sample_files/syntax_error_2.js\nsample_files/syntax_error_after.js --- Text (2 errors, exceeded DFT_PARSE_ERROR_LIMIT)\n... Users may opt-in to syntactic diffing by setting DFT_PARSE_ERROR_LIMIT to a larger value. In this mode, difftastic treats tree-sitter error nodes as atoms and performs a tree diff as normal.","breadcrumbs":"Internals: Diffing » Tricky Cases » Invalid Syntax","id":"73","title":"Invalid Syntax"},"74":{"body":"","breadcrumbs":"Contributing » Contributing","id":"74","title":"Contributing"},"75":{"body":"Install Rust with rustup , then clone the code. $ git clone git@github.com:Wilfred/difftastic.git\n$ cd difftastic Difftastic uses Cargo for building. $ cargo build Debug builds are significantly slower than release builds. For files with more than fifty lines, it's usually worth using an optimised build. $ cargo build --release","breadcrumbs":"Contributing » Building","id":"75","title":"Building"},"76":{"body":"This website is generated with mdbook . mdbook can be installed with Cargo. Note: difftastic uses an older Rust toolchain version. You have to run cargo install mdbook outside of the repository directory. Otherwise, installation fails. $ cargo install mdbook You can then use the mdbook binary to build and serve the site locally. $ cd manual\n$ mdbook serve","breadcrumbs":"Contributing » Manual","id":"76","title":"Manual"},"77":{"body":"You can browse the internal API documentation generated by rustdoc here . Difftastic's internal docs are not available on docs.rs, as it does not support binary crates today .","breadcrumbs":"Contributing » API Documentation","id":"77","title":"API Documentation"},"78":{"body":"$ cargo test There are also several files in sample_files/ that you can use. The best way to test difftastic is to look at history from a real project. Set GIT_EXTERNAL_DIFF to point to your current build. For example, you can run difftastic on its own source code. $ GIT_EXTERNAL_DIFF=./target/release/difft git log -p --ext-diff -- src","breadcrumbs":"Contributing » Testing","id":"78","title":"Testing"},"79":{"body":"Difftastic uses the pretty_env_logger library to log some additional debug information. $ DFT_LOG=debug cargo run sample_files/old.jsx sample_files/new.jsx See the env_logger documentation for full details.","breadcrumbs":"Contributing » Logging","id":"79","title":"Logging"},"8":{"body":"If you're a Windows user using Windows Package Manager ( WinGet ), you can install difftastic with winget. $ winget install difftastic If you're a Windows user using Scoop , you can install difftastic with scoop. $ scoop install difftastic If you're a Windows user using Chocolatey , you can install difftastic with choco. $ choco install difftastic","breadcrumbs":"Installation » Windows","id":"8","title":"Windows"},"80":{"body":"Use Cargo to create a new release, and tag it in git. Difftastic has a helper script for this: $ ./scripts/release.sh You can now increment the version in Cargo.toml and add a new entry to CHANGELOG.md.","breadcrumbs":"Contributing » Releasing","id":"80","title":"Releasing"},"81":{"body":"","breadcrumbs":"Contributing » Parser Vendoring » Vendoring","id":"81","title":"Vendoring"},"82":{"body":"Tree-sitter parsers are sometimes packaged on npm, sometimes packaged on crates.io, and have different release frequencies. Difftastic uses git subtrees (not git submodules) to track parsers.","breadcrumbs":"Contributing » Parser Vendoring » Git Subtrees","id":"82","title":"Git Subtrees"},"83":{"body":"To update a parser, pull commits from the upstream git repository. For example, the following command will update the Java parser: $ git subtree pull --prefix=vendored_parsers/tree-sitter-java git@github.com:tree-sitter/tree-sitter-java.git master To see when each parser was last updated, use the following shell command: $ for d in $(git log | grep git-subtree-dir | tr -d ' ' | cut -d \":\" -f2 | sort); do echo \"$d\"; git log --pretty=\" %cs\" -n 1 $d; done","breadcrumbs":"Contributing » Parser Vendoring » Updating a parser","id":"83","title":"Updating a parser"},"84":{"body":"","breadcrumbs":"Contributing » Adding A Parser » Adding A Parser","id":"84","title":"Adding A Parser"},"85":{"body":"New parsers for difftastic must be reasonably complete and maintained. There are many tree-sitter parsers available, and the tree-sitter website includes a list of some well-known parsers .","breadcrumbs":"Contributing » Adding A Parser » Finding a parser","id":"85","title":"Finding a parser"},"86":{"body":"Once you've found a parser, add it as a git subtree to vendored_parsers/. We'll use tree-sitter-json as an example. $ git subtree add --prefix=vendored_parsers/tree-sitter-json https://github.com/tree-sitter/tree-sitter-json.git master","breadcrumbs":"Contributing » Adding A Parser » Add the source code","id":"86","title":"Add the source code"},"87":{"body":"Cargo does not allow packages to include subdirectories that contain a Cargo.toml. Add a symlink to the src/ parser subdirectory. $ cd vendored_parsers\n$ ln -s tree-sitter-json/src tree-sitter-json-src You can now add the parser to build by including the directory in build.rs. TreeSitterParser { name: \"tree-sitter-json\", src_dir: \"vendored_parsers/tree-sitter-json-src\", extra_files: vec![],\n}, If your parser includes custom C or C++ files for lexing (e.g. a scanner.cc), add them to extra_files.","breadcrumbs":"Contributing » Adding A Parser » Configure the build","id":"87","title":"Configure the build"},"88":{"body":"Add an entry to tree_sitter_parser.rs for your language. Json => { let language = unsafe { tree_sitter_json() }; TreeSitterConfig { language, atom_nodes: vec![\"string\"].into_iter().collect(), delimiter_tokens: vec![(\"{\", \"}\"), (\"[\", \"]\")], highlight_query: ts::Query::new( language, include_str!(\"../../vendored_parsers/highlights/json.scm\"), ) .unwrap(), sub_languages: vec![], }\n} atom_nodes is a list of tree-sitter node names that should be treated as atoms even though the nodes have children. This is common for things like string literals or interpolated strings, where the node might have children for the opening and closing quote. If you don't set atom_nodes, you may notice added/removed content shown in white. This is usually a sign that child node should have its parent treated as an atom. delimiter_tokens are delimiters that difftastic stores on the enclosing list node. This allows difftastic to distinguish delimiter tokens from other punctuation in the language. If you don't set delimiter_tokens, difftastic will consider the tokens in isolation, and may think that a ( was added but the ) was unchanged. You can use difft --dump-ts foo.json to see the results of the tree-sitter parser, and difft --dump-syntax foo.json to confirm that you've set atoms and delimiters correctly. sub-languages is empty for most languages: see the code documentation for details.","breadcrumbs":"Contributing » Adding A Parser » Configure parsing","id":"88","title":"Configure parsing"},"89":{"body":"Update language_name in guess_language.rs to detect your new language. Insert a match arm like: Json => \"json\", There may also file names or shebangs associated with your language; configure those by adapting the language_globs, from_emacs_mode_header and from_shebang functions in that file. GitHub's linguist definitions are a useful source of common file extensions.","breadcrumbs":"Contributing » Adding A Parser » Configure language detection","id":"89","title":"Configure language detection"},"9":{"body":"This table lists all the platforms that have packaged difftastic. Packaging status","breadcrumbs":"Installation » Full Package Listing","id":"9","title":"Full Package Listing"},"90":{"body":"To add syntax highlighting for your language, you'll also need a symlink to the queries/highlights.scm file, if available. $ cd vendored_parsers/highlights\n$ ln -s ../tree-sitter-json/queries/highlights.scm json.scm","breadcrumbs":"Contributing » Adding A Parser » Syntax highlighting (Optional)","id":"90","title":"Syntax highlighting (Optional)"},"91":{"body":"Search GitHub for a popular repository in your target language ( example search ) and confirm that git history looks sensible with difftastic.","breadcrumbs":"Contributing » Adding A Parser » Test It","id":"91","title":"Test It"},"92":{"body":"Finally, add a regression test for your language. This ensures that the output for your test file doesn't change unexpectedly. Regression test files live in sample_files/ and have the form foo_1.abc and foo_2.abc. $ nano simple_1.json\n$ nano simple_2.json Run the regression test script and update the .expected file. $ ./sample_files/compare_all.sh\n$ cp sample_files/compare.result sample_files/compare.expected","breadcrumbs":"Contributing » Adding A Parser » Add a regression test","id":"92","title":"Add a regression test"},"93":{"body":"To update a parser that is already imported, use git subtree pull. $ git subtree pull --prefix=vendored_parsers/tree-sitter-json git@github.com:tree-sitter/tree-sitter-json.git master","breadcrumbs":"Contributing » Adding A Parser » Maintenance","id":"93","title":"Maintenance"},"94":{"body":"If you have a file that's particularly slow, you can use cargo-flamegraph to see which functions are slow. $ CARGO_PROFILE_RELEASE_DEBUG=true cargo flamegraph --bin difft -- sample_files/slow_1.rs sample_files/slow_2.rs It's also worth looking at memory usage, as graph traversal bugs can lead to huge memory consumption. $ /usr/bin/time -v ./target/release/difft sample_files/slow_1.rs sample_files/slow_2.rs If timing measurement are noisy, Linux's perf tool will report instructions executed, which is more stable. $ perf stat ./target/release/difft sample_files/slow_1.rs sample_files/slow_2.rs\n$ perf stat ./target/release/difft sample_files/typing_1.ml sample_files/typing_2.ml Many more profiling techniques are discussed in The Rust Performance Book .","breadcrumbs":"Contributing » Profiling » Profiling","id":"94","title":"Profiling"},"95":{"body":"Atom : An atom is an item in difftastic's syntax tree structure that has no children. It represents things like literals, variable names, and comments. See also 'list'. Delimiter : A paired piece of syntax. A list has an open delimiter and a close delimiter, such as [ and ]. Delimiters may not be punctuation (e.g. begin and end) and may be empty strings (e.g. infix syntax converted to difftastic's syntax tree). Hunk : A group of lines displayed together in the diff output. Increasing the number of context lines increases the size of the hunk. LHS : Left-hand side. Difftastic compares two items, and LHS refers to the first item. See also 'RHS'. Line-oriented : A traditional diff that compares which lines have been added or removed, unlike difftastic. For example, GNU diff or the diffs displayed on GitHub. List : A list is an item in difftastic's syntax tree structure that has an open delimiter, children, and a close delimiter. It represents things like expressions and function definitions. See also 'atom'. Novel : An addition or a removal. Syntax is novel if it occurs in only one of the two items being compared. RHS : Right-hand side. Difftastic compares two items, and RHS refers to the second item. See also 'LHS'. Root : A syntax tree without a parent node. Roots represent top-level definitions in the file being diffed. Slider : A diffing situation where there are multiple minimal diffs possible, due to adjacent content. It is possible to 'slide' to produce better results in this situation. See the discussion in Tricky Cases . Syntax node : An item in difftastic's syntax tree structure. Either an atom or a list. Token : A small piece of syntax tracked by difftastic (e.g. $x, function or ]), for highlighting and aligned display. This is either an atom or a non-empty delimiter.","breadcrumbs":"Glossary » Glossary","id":"95","title":"Glossary"},"96":{"body":"Many different tools exist for diffing files. This section of the manual discusses the design of other tools that have influenced difftastic.","breadcrumbs":"Alternative Projects » Alternative Projects","id":"96","title":"Alternative Projects"},"97":{"body":"This page summarises some of the other tree diffing tools available. If you're in a hurry, start by looking at Autochrome. It's extremely capable, and has an excellent description of the design. If you're interested in a summary of the academic literature, this blog post (and its accompanying paper -- mirrored under a CC BY-NC license) are great resources.","breadcrumbs":"Alternative Projects » Tree Diffing » Tree Diffing","id":"97","title":"Tree Diffing"},"98":{"body":"Languages: JSON Algorithm: Pairwise comparison Output: CLI colours json-diff performs a structural diff of JSON files. It considers subtrees to be different if they don't match exactly, so e.g. \"foo\" and [\"foo\"] are entirely different. json-diff is also noteworthy for its extremely readable display of results.","breadcrumbs":"Alternative Projects » Tree Diffing » json-diff (2012)","id":"98","title":"json-diff (2012)"},"99":{"body":"Languages: ~10 programming languages Parser: Several, including srcML Algorithm: Top-down, then bottom-up Output: HTML, Swing GUI, or text GumTree can parse several programming languages and then performs a tree-based diff, outputting an HTML display. The GumTree algorithm is described in the associated paper 'Fine-grained and accurate source code differencing' by Falleri et al ( DOI , PDF ). It performs a greedy top-down search for identical subtrees, then performs a bottom-up search to match up the rest.","breadcrumbs":"Alternative Projects » Tree Diffing » GumTree (2014)","id":"99","title":"GumTree (2014)"}},"length":105,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"5":{"0":{"df":1,"docs":{"26":{"tf":1.0}}},"8":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{".":{"0":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},":":{"0":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":4,"docs":{"28":{"tf":1.0},"44":{"tf":3.1622776601683795},"45":{"tf":1.0},"46":{"tf":4.0}}},"1":{",":{"3":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},".":{"7":{"4":{".":{"1":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"6":{"4":{"4":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"99":{"tf":1.0}}},":":{"0":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":10,"docs":{"1":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"35":{"tf":1.0},"44":{"tf":3.7416573867739413},"46":{"tf":2.6457513110645907},"49":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"65":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.0}}},"2":{"0":{"1":{"2":{"df":1,"docs":{"98":{"tf":1.0}}},"4":{"df":1,"docs":{"99":{"tf":1.0}}},"7":{"df":2,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.0}}},"df":0,"docs":{}},"2":{"0":{"df":2,"docs":{"102":{"tf":1.0},"103":{"tf":1.0}}},"1":{"df":1,"docs":{"104":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"69":{"tf":1.0}}},"df":9,"docs":{"1":{"tf":1.0},"28":{"tf":1.0},"44":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"49":{"tf":2.23606797749979},"55":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"71":{"tf":1.0},"73":{"tf":1.0}}},"3":{"0":{"df":1,"docs":{"0":{"tf":1.0}}},"df":3,"docs":{"1":{"tf":1.0},"44":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772}}},"4":{"2":{"df":1,"docs":{"34":{"tf":1.0}}},"4":{"df":1,"docs":{"58":{"tf":1.0}}},"5":{"df":1,"docs":{"34":{"tf":1.0}}},"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"44":{"tf":2.0}}},"6":{"c":{"d":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"44":{"tf":1.7320508075688772}}},"7":{"df":1,"docs":{"44":{"tf":1.0}}},"8":{"df":3,"docs":{"11":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0}}},"a":{"b":{"c":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"1":{"df":1,"docs":{"33":{"tf":1.0}}},"2":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"33":{"tf":1.0},"49":{"tf":1.4142135623730951}}}}},"c":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"97":{"tf":1.0}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"69":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"a":{"df":1,"docs":{"40":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}}},"d":{"df":11,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"38":{"tf":1.0},"70":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":1.7320508075688772},"87":{"tf":1.7320508075688772},"88":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.4142135623730951}},"e":{"d":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"88":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"58":{"tf":1.0},"72":{"tf":1.4142135623730951},"79":{"tf":1.0},"95":{"tf":1.0}}}}},"df":6,"docs":{"26":{"tf":1.0},"34":{"tf":1.0},"53":{"tf":1.0},"84":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.0}},"j":{"a":{"c":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"51":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"l":{"df":1,"docs":{"99":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"40":{"tf":1.0}}}},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":11,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.7320508075688772},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"51":{"tf":1.7320508075688772},"53":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}}}}},"i":{"a":{"df":2,"docs":{"31":{"tf":1.4142135623730951},"34":{"tf":1.0}},"s":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"71":{"tf":1.0},"95":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":6,"docs":{"102":{"tf":1.0},"12":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"96":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"1":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"q":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"103":{"tf":1.0},"46":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"40":{"tf":1.0}}}},"i":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}},"p":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"22":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"44":{"tf":1.0}}}}}}}},"m":{"df":1,"docs":{"89":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"33":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"50":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"42":{"tf":1.0},"89":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"34":{"tf":1.0},"70":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"46":{"tf":1.0},"88":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":9,"docs":{"45":{"tf":1.4142135623730951},"46":{"tf":2.23606797749979},"49":{"tf":2.6457513110645907},"50":{"tf":1.0},"61":{"tf":2.23606797749979},"69":{"tf":1.0},"73":{"tf":1.0},"88":{"tf":1.7320508075688772},"95":{"tf":2.23606797749979}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":2,"docs":{"14":{"tf":1.0},"31":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"101":{"tf":1.7320508075688772},"97":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":10,"docs":{"0":{"tf":1.4142135623730951},"100":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"42":{"tf":1.0},"77":{"tf":1.0},"85":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"16":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"73":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"=":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"df":2,"docs":{"27":{"tf":2.0},"34":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}},"df":4,"docs":{"57":{"tf":2.0},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"71":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":6,"docs":{"103":{"tf":1.0},"17":{"tf":1.0},"42":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"99":{"tf":1.0}}},"h":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"z":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":2,"docs":{"62":{"tf":2.6457513110645907},"72":{"tf":2.449489742783178}},"e":{"df":5,"docs":{"20":{"tf":1.0},"58":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"95":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":20,"docs":{"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.7320508075688772}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"71":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"33":{"tf":1.0},"65":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"29":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"33":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"78":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"55":{"tf":1.0},"95":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"100":{"tf":1.4142135623730951},"34":{"tf":1.0},"47":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"51":{"tf":1.0}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":13,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0}}}}},"df":1,"docs":{"94":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"72":{"tf":2.6457513110645907}}}}},"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"51":{"tf":1.0}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":2,"docs":{"100":{"tf":1.0},"97":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":1,"docs":{"94":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"49":{"tf":2.0},"60":{"tf":1.0},"61":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"60":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}},"s":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"0":{"tf":1.0},"94":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"87":{"tf":1.0}}}},"df":11,"docs":{"100":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":2.0},"15":{"tf":1.0},"16":{"tf":2.0},"19":{"tf":1.0},"43":{"tf":1.0},"75":{"tf":2.6457513110645907},"76":{"tf":1.0},"78":{"tf":1.0},"87":{"tf":1.4142135623730951}}},"df":0,"docs":{},"t":{"df":4,"docs":{"104":{"tf":1.0},"15":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.4142135623730951}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"c":{"+":{"+":{"1":{"4":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"/":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}}}},"df":1,"docs":{"28":{"tf":1.0}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"97":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"80":{"tf":1.0},"87":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":11,"docs":{"12":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"20":{"tf":1.4142135623730951},"75":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"87":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"e":{"df":9,"docs":{"28":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"60":{"tf":1.0},"71":{"tf":1.0},"95":{"tf":1.0}}}},"t":{"df":1,"docs":{"25":{"tf":1.0}}}},"c":{"df":3,"docs":{"12":{"tf":1.7320508075688772},"15":{"tf":1.0},"97":{"tf":1.0}}},"d":{"df":5,"docs":{"19":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"87":{"tf":1.0},"90":{"tf":1.0}}},"df":10,"docs":{"11":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"30":{"tf":1.7320508075688772},"31":{"tf":2.449489742783178},"33":{"tf":1.0},"40":{"tf":2.449489742783178},"42":{"tf":1.4142135623730951},"62":{"tf":2.0},"87":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"60":{"tf":1.0},"72":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"g":{"df":19,"docs":{"1":{"tf":1.0},"16":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":2.23606797749979},"70":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"88":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"88":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"o":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.4142135623730951}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"49":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"49":{"tf":1.0},"62":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"k":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"55":{"tf":1.0},"69":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":5,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"33":{"tf":1.0},"98":{"tf":1.0}}},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"101":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":5,"docs":{"1":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"88":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}},"m":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}},"d":{".":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":12,"docs":{"1":{"tf":1.4142135623730951},"100":{"tf":1.0},"104":{"tf":1.0},"14":{"tf":1.0},"28":{"tf":1.7320508075688772},"72":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"=":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"27":{"tf":1.0},"98":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"70":{"tf":1.0}},"n":{"d":{"df":12,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.4142135623730951},"27":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":2.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"83":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":10,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"104":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"66":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951},"69":{"tf":1.0},"95":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"35":{"tf":1.4142135623730951},"83":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":8,"docs":{"103":{"tf":1.0},"40":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"70":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"1":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"72":{"tf":1.0},"95":{"tf":2.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"33":{"tf":1.0},"98":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"65":{"tf":1.0},"66":{"tf":1.0},"85":{"tf":1.0}}},"x":{"df":1,"docs":{"46":{"tf":1.0}}}}},"o":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":15,"docs":{"100":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0},"71":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"88":{"tf":1.0},"91":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"62":{"tf":1.0},"65":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":13,"docs":{"102":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"64":{"tf":1.0},"71":{"tf":1.0},"88":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"45":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"51":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"94":{"tf":1.0}}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"14":{"tf":1.0},"24":{"tf":1.0},"62":{"tf":1.0},"87":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":11,"docs":{"42":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"62":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"74":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"46":{"tf":1.0}}},"t":{"df":4,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"63":{"tf":1.0},"69":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"54":{"tf":1.0},"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"55":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"p":{"df":1,"docs":{"92":{"tf":1.0}},"p":{"df":1,"docs":{"40":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}},"u":{"df":1,"docs":{"4":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"77":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":2,"docs":{"12":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"80":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":1,"docs":{"83":{"tf":1.0}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"s":{"df":2,"docs":{"102":{"tf":1.0},"41":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"17":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"55":{"tf":1.0},"78":{"tf":1.0}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"\"":{"7":{".":{"8":{".":{"9":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"101":{"tf":1.4142135623730951},"87":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"83":{"tf":1.0}}}},"x":{"df":0,"docs":{},"x":{"df":1,"docs":{"12":{"tf":1.0}}}}},"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}},"t":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"13":{"tf":2.23606797749979},"17":{"tf":2.23606797749979},"20":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"100":{"tf":1.0},"102":{"tf":1.0},"71":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"100":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":2,"docs":{"62":{"tf":2.0},"83":{"tf":2.23606797749979}},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":3,"docs":{"12":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"27":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"35":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"33":{"tf":1.0},"34":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"89":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":14,"docs":{"1":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":2.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"59":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"65":{"tf":1.0},"88":{"tf":1.7320508075688772},"95":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"20":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"100":{"tf":1.0},"53":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":5,"docs":{"0":{"tf":1.0},"21":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"97":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":4,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}},"r":{"df":8,"docs":{"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"46":{"tf":1.0},"79":{"tf":1.0},"88":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"42":{"tf":1.4142135623730951},"89":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"40":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"t":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"=":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"=":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"79":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}},"df":3,"docs":{"31":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":23,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"2":{"tf":1.4142135623730951},"23":{"tf":1.0},"24":{"tf":1.7320508075688772},"38":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"52":{"tf":1.0},"54":{"tf":1.0},"60":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951},"96":{"tf":1.0},"97":{"tf":1.4142135623730951}},"f":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"=":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.7320508075688772},"31":{"tf":2.449489742783178},"33":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":31,"docs":{"0":{"tf":1.0},"1":{"tf":2.0},"100":{"tf":2.0},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.7320508075688772},"2":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":2.23606797749979},"31":{"tf":2.6457513110645907},"32":{"tf":3.3166247903554},"33":{"tf":1.7320508075688772},"34":{"tf":2.0},"35":{"tf":1.4142135623730951},"36":{"tf":2.0},"37":{"tf":2.0},"38":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":2.23606797749979},"65":{"tf":2.0},"69":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"78":{"tf":1.0},"95":{"tf":2.23606797749979},"98":{"tf":2.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"100":{"tf":1.0},"46":{"tf":1.4142135623730951},"53":{"tf":1.0},"58":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"99":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"52":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.4142135623730951}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{".":{"1":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"18":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":57,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.7320508075688772},"11":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"17":{"tf":2.0},"18":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.4142135623730951},"20":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"31":{"tf":2.6457513110645907},"32":{"tf":2.0},"33":{"tf":3.0},"34":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":2.0},"38":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":2.8284271247461903},"71":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"8":{"tf":2.449489742783178},"80":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.7320508075688772},"9":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":2.0},"96":{"tf":1.0}},"i":{"c":{"'":{"df":3,"docs":{"16":{"tf":1.0},"77":{"tf":1.0},"95":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":21,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"42":{"tf":2.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"73":{"tf":1.0},"88":{"tf":1.4142135623730951},"94":{"tf":1.0}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"29":{"tf":1.0},"33":{"tf":3.605551275463989}}}}}}}},"j":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"'":{"df":2,"docs":{"101":{"tf":1.0},"51":{"tf":1.4142135623730951}}},"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":1,"docs":{"83":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"19":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"24":{"tf":2.23606797749979},"76":{"tf":1.0},"87":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"52":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":8,"docs":{"100":{"tf":1.0},"102":{"tf":1.0},"45":{"tf":1.0},"53":{"tf":1.0},"65":{"tf":1.0},"95":{"tf":1.7320508075688772},"98":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"102":{"tf":1.0},"71":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"88":{"tf":1.0}}}}}}}}}}}},"l":{"df":1,"docs":{"31":{"tf":1.0}},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"o":{"c":{"df":3,"docs":{"12":{"tf":1.0},"68":{"tf":1.0},"77":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"77":{"tf":1.4142135623730951},"79":{"tf":1.0},"88":{"tf":1.0}}}}}}}},"df":1,"docs":{"61":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"100":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"i":{"df":1,"docs":{"99":{"tf":1.0}}},"n":{"'":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.0},"33":{"tf":1.4142135623730951},"51":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"88":{"tf":1.4142135623730951},"98":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"83":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"60":{"tf":1.0},"99":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"12":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":1,"docs":{"31":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}}},"m":{"df":0,"docs":{},"p":{"df":4,"docs":{"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"100":{"tf":1.0},"47":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":13,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"15":{"tf":1.0},"28":{"tf":1.4142135623730951},"34":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"87":{"tf":1.0},"95":{"tf":1.7320508075688772},"98":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"0":{"tf":1.0},"33":{"tf":1.0},"50":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"57":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.0},"46":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":2,"docs":{"46":{"tf":1.0},"83":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"a":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"50":{"tf":1.7320508075688772}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"40":{"tf":1.0}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.7320508075688772}}}}}},"m":{"df":1,"docs":{"40":{"tf":1.7320508075688772}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}},"m":{"a":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"88":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"46":{"tf":1.0},"88":{"tf":1.0}}}}}},"d":{"df":4,"docs":{"49":{"tf":2.0},"50":{"tf":1.0},"57":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.0},"92":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"69":{"tf":1.0},"98":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"34":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.0}}}}},"v":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":2,"docs":{"27":{"tf":1.0},"7":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"27":{"tf":1.4142135623730951},"30":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"27":{"tf":1.0},"35":{"tf":1.0},"62":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"73":{"tf":2.0}}}}}},"t":{"df":1,"docs":{"99":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":7,"docs":{"1":{"tf":1.0},"102":{"tf":1.0},"46":{"tf":1.0},"53":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"88":{"tf":1.0}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"45":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"98":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":16,"docs":{"1":{"tf":1.0},"101":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"34":{"tf":1.0},"42":{"tf":1.4142135623730951},"65":{"tf":1.0},"72":{"tf":1.7320508075688772},"78":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":1,"docs":{"97":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"4":{"tf":1.0},"94":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"55":{"tf":1.0},"56":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"71":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}},"s":{"df":2,"docs":{"15":{"tf":1.0},"71":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"100":{"tf":2.0},"104":{"tf":1.0},"53":{"tf":1.0},"95":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"34":{"tf":2.0}}}}}},"df":4,"docs":{"30":{"tf":1.7320508075688772},"31":{"tf":2.0},"32":{"tf":2.23606797749979},"78":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":3,"docs":{"34":{"tf":1.7320508075688772},"42":{"tf":1.0},"89":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":6,"docs":{"29":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0}}}}},"r":{"a":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"87":{"tf":1.4142135623730951}}}}}},"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":3,"docs":{"2":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}}}}}},"f":{"2":{"df":1,"docs":{"83":{"tf":1.0}}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"76":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"99":{"tf":1.0}}}}}},"s":{"df":1,"docs":{"33":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":1,"docs":{"40":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"33":{"tf":1.0},"71":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"42":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":31,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":2.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.0},"23":{"tf":1.7320508075688772},"24":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"26":{"tf":2.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.4142135623730951},"42":{"tf":2.6457513110645907},"45":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.7320508075688772},"90":{"tf":1.0},"92":{"tf":1.7320508075688772},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"92":{"tf":1.0}}}},"d":{"df":9,"docs":{"1":{"tf":1.0},"100":{"tf":1.4142135623730951},"17":{"tf":1.0},"28":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.4142135623730951},"71":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"99":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"42":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"72":{"tf":1.0},"95":{"tf":1.0}}}}},"x":{"df":1,"docs":{"0":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"37":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"94":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"t":{"df":2,"docs":{"46":{"tf":1.0},"62":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":10,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"83":{"tf":1.4142135623730951}}}}}},"o":{"(":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}}}},"1":{"2":{"3":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"61":{"tf":1.0}}},"4":{"5":{"6":{"df":1,"docs":{"64":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"8":{"9":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"r":{"(":{"1":{"2":{"3":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"61":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"(":{"b":{"a":{"df":0,"docs":{},"r":{"(":{"1":{"2":{"3":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"x":{"df":1,"docs":{"65":{"tf":1.0}}}},".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}}}},"_":{"1":{".":{"a":{"b":{"c":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"a":{"b":{"c":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"a":{"df":1,"docs":{"66":{"tf":1.0}},"r":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"z":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":10,"docs":{"100":{"tf":1.0},"102":{"tf":1.4142135623730951},"44":{"tf":1.0},"57":{"tf":2.0},"58":{"tf":1.7320508075688772},"60":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"98":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"100":{"tf":1.0},"102":{"tf":1.0},"2":{"tf":1.0},"41":{"tf":1.0},"70":{"tf":1.0}}}},"df":1,"docs":{"92":{"tf":1.0}}}},"s":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}},"df":3,"docs":{"21":{"tf":1.0},"36":{"tf":2.0},"37":{"tf":1.7320508075688772}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":2,"docs":{"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"89":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"27":{"tf":1.0},"79":{"tf":1.0},"9":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"62":{"tf":1.0},"65":{"tf":2.23606797749979},"89":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"w":{"c":{"d":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"g":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"51":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"z":{"d":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"c":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"45":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"1":{"tf":1.0}}},"@":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"83":{"tf":1.0},"93":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"=":{".":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"30":{"tf":1.0},"78":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"32":{"tf":1.0},"33":{"tf":1.0}}}}}}}},"df":16,"docs":{"21":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":2.23606797749979},"30":{"tf":2.23606797749979},"31":{"tf":2.23606797749979},"32":{"tf":2.23606797749979},"33":{"tf":2.449489742783178},"62":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.7320508075688772},"83":{"tf":2.23606797749979},"86":{"tf":1.4142135623730951},"91":{"tf":1.0},"93":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"u":{"b":{"'":{"df":1,"docs":{"89":{"tf":1.0}}},"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"14":{"tf":1.0},"4":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"2":{"tf":1.0},"28":{"tf":1.0},"73":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"40":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951}}}},"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"95":{"tf":1.0}}}},"o":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"99":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"40":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"h":{"df":4,"docs":{"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"51":{"tf":2.0},"94":{"tf":1.0}},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"102":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"101":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":1,"docs":{"83":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":2.23606797749979}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"r":{"c":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"1":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":1,"docs":{"42":{"tf":1.0}}}}},"i":{"df":2,"docs":{"33":{"tf":1.0},"99":{"tf":1.0}}},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"99":{"tf":1.7320508075688772}}}}}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"95":{"tf":1.4142135623730951}},"l":{"df":4,"docs":{"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":2,"docs":{"69":{"tf":1.0},"71":{"tf":1.7320508075688772}}},"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}},"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}},"df":1,"docs":{"42":{"tf":1.0}},"e":{"a":{"d":{"df":1,"docs":{"44":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"73":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":3,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"p":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"42":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"1":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}},"g":{"df":2,"docs":{"34":{"tf":2.8284271247461903},"35":{"tf":1.7320508075688772}},"r":{"c":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"88":{"tf":1.0}}}}}}}},"df":12,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.0},"46":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"90":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"78":{"tf":1.0},"91":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":5,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"19":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"94":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"100":{"tf":1.0}}}},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"i":{".":{"df":1,"docs":{"51":{"tf":1.0}}},"d":{":":{"1":{"df":1,"docs":{"45":{"tf":1.0}}},"2":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":1.0},"99":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":6,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"20":{"tf":1.0},"47":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"33":{"tf":1.0},"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"61":{"tf":1.0},"93":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":9,"docs":{"101":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0},"46":{"tf":1.7320508075688772},"85":{"tf":1.0},"87":{"tf":1.7320508075688772},"99":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"!":{"(":{"\"":{".":{".":{"/":{".":{".":{"/":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"m":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"71":{"tf":1.0}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"95":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"33":{"tf":1.7320508075688772},"71":{"tf":1.0},"79":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"63":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.4142135623730951},"73":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"60":{"tf":1.0},"72":{"tf":1.0},"89":{"tf":1.0}}}}},"i":{"d":{"df":3,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":11,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.0},"3":{"tf":1.4142135623730951},"39":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":2.6457513110645907},"75":{"tf":1.0},"76":{"tf":2.0},"8":{"tf":2.449489742783178}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"34":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"21":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"45":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":1.0}}}}},"n":{"df":4,"docs":{"37":{"tf":1.0},"43":{"tf":1.0},"48":{"tf":1.0},"77":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"100":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"73":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"27":{"tf":1.0},"33":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.0}}},"p":{"df":0,"docs":{},"o":{"d":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"58":{"tf":1.0}}}}},"t":{"'":{"df":10,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"101":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.7320508075688772},"75":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"95":{"tf":2.8284271247461903}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"j":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"100":{"tf":1.7320508075688772}},"t":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}},"v":{"a":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"df":2,"docs":{"40":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"o":{"b":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"86":{"tf":1.0},"93":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"m":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}},"/":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"m":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}}}},"5":{"df":1,"docs":{"102":{"tf":1.0}}},"df":10,"docs":{"102":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951},"63":{"tf":1.0},"71":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.7320508075688772},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"93":{"tf":1.0},"98":{"tf":2.23606797749979}}}},"x":{"df":1,"docs":{"40":{"tf":1.0}}}},"u":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.7320508075688772}}}}}}},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"68":{"tf":2.0}}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"69":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"85":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":20,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.0},"39":{"tf":2.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.0},"42":{"tf":2.449489742783178},"61":{"tf":1.0},"63":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"88":{"tf":2.6457513110645907},"89":{"tf":1.7320508075688772},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.7320508075688772}},"e":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":3,"docs":{"2":{"tf":1.0},"58":{"tf":1.0},"69":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"33":{"tf":1.0},"53":{"tf":1.0},"73":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"83":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"57":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"x":{"df":1,"docs":{"41":{"tf":1.7320508075688772}}}}},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}},"c":{"df":1,"docs":{"103":{"tf":1.0}}},"df":2,"docs":{"35":{"tf":1.0},"49":{"tf":1.7320508075688772}},"e":{"a":{"d":{"df":3,"docs":{"16":{"tf":1.0},"70":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}},"v":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":3,"docs":{"38":{"tf":1.0},"49":{"tf":3.3166247903554},"95":{"tf":1.0}}}},"t":{"'":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"95":{"tf":1.0}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"102":{"tf":1.0}}}}}}}}}}},"x":{"df":1,"docs":{"87":{"tf":1.0}}}},"h":{"df":1,"docs":{"95":{"tf":1.7320508075688772}}},"i":{"b":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"79":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"34":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"31":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":13,"docs":{"1":{"tf":1.7320508075688772},"100":{"tf":1.0},"2":{"tf":1.7320508075688772},"27":{"tf":1.0},"34":{"tf":1.4142135623730951},"42":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772},"69":{"tf":1.0},"72":{"tf":2.6457513110645907},"73":{"tf":1.0},"75":{"tf":1.0},"95":{"tf":2.0}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"x":{"'":{"df":1,"docs":{"94":{"tf":1.0}}},"df":2,"docs":{"4":{"tf":1.0},"7":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"p":{"df":3,"docs":{"104":{"tf":1.0},"40":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"t":{"df":11,"docs":{"27":{"tf":1.0},"39":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"61":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"95":{"tf":2.23606797749979}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":5,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"69":{"tf":1.7320508075688772},"88":{"tf":1.0},"95":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"92":{"tf":1.0}}}}},"n":{"df":2,"docs":{"87":{"tf":1.0},"90":{"tf":1.0}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"33":{"tf":1.4142135623730951},"76":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":7,"docs":{"30":{"tf":1.0},"31":{"tf":2.0},"32":{"tf":1.0},"35":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"69":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.0},"62":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"1":{"tf":1.0},"62":{"tf":1.0},"78":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"70":{"tf":1.7320508075688772}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"47":{"tf":1.0}}}}},"t":{"df":3,"docs":{"51":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":2.0}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"u":{"a":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":2,"docs":{"4":{"tf":1.0},"6":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"k":{"df":0,"docs":{},"e":{"df":5,"docs":{"40":{"tf":1.4142135623730951},"46":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"3":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}},"df":2,"docs":{"18":{"tf":1.4142135623730951},"33":{"tf":1.0}},"i":{"df":4,"docs":{"24":{"tf":1.0},"85":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"/":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":4,"docs":{"0":{"tf":1.4142135623730951},"19":{"tf":2.0},"76":{"tf":1.4142135623730951},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"1":{"tf":1.0}}},"r":{"df":0,"docs":{},"k":{"df":5,"docs":{"100":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"62":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"83":{"tf":1.0},"86":{"tf":1.0},"93":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":13,"docs":{"1":{"tf":1.0},"4":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"60":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.7320508075688772},"89":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"x":{"df":1,"docs":{"71":{"tf":1.0}},"x":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"76":{"tf":2.449489742783178}}}}}},"df":0,"docs":{}},"df":1,"docs":{"40":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":5,"docs":{"100":{"tf":1.0},"104":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"51":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}}},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"21":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":2,"docs":{"100":{"tf":1.0},"33":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"h":{"df":1,"docs":{"104":{"tf":1.0}}},"i":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"13":{"tf":1.7320508075688772},"17":{"tf":2.23606797749979},"20":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"100":{"tf":1.4142135623730951},"58":{"tf":1.0},"95":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"65":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"73":{"tf":1.0}},"l":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":9,"docs":{"13":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.4142135623730951},"42":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.4142135623730951},"75":{"tf":1.0},"94":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"58":{"tf":1.0},"68":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"1":{"tf":1.0},"46":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"95":{"tf":1.0}}}}}}}}},"n":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"58":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":10,"docs":{"24":{"tf":1.0},"33":{"tf":1.0},"42":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"69":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"95":{"tf":1.0}}}},"n":{"df":0,"docs":{},"o":{"df":1,"docs":{"92":{"tf":1.4142135623730951}}}}},"c":{"df":1,"docs":{"97":{"tf":1.0}}},"df":1,"docs":{"83":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"d":{"df":5,"docs":{"11":{"tf":1.7320508075688772},"33":{"tf":1.0},"37":{"tf":1.0},"51":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"63":{"tf":1.0},"64":{"tf":1.0}}}},"w":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}},"df":6,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"69":{"tf":1.0},"80":{"tf":1.4142135623730951},"85":{"tf":1.0},"89":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"40":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":12,"docs":{"46":{"tf":2.0},"47":{"tf":1.7320508075688772},"49":{"tf":2.6457513110645907},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"73":{"tf":1.0},"88":{"tf":2.23606797749979},"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"94":{"tf":1.0}}}}},"n":{"df":2,"docs":{"28":{"tf":1.0},"95":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"20":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"76":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"98":{"tf":1.0}}}}}}}}},"i":{"c":{"df":2,"docs":{"1":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":8,"docs":{"49":{"tf":3.0},"50":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"62":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"w":{"df":5,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"80":{"tf":1.0},"87":{"tf":1.0}}}},"p":{"df":1,"docs":{"71":{"tf":1.4142135623730951}},"m":{"df":1,"docs":{"82":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"28":{"tf":1.0},"46":{"tf":1.4142135623730951},"51":{"tf":1.0},"65":{"tf":1.0},"95":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"=":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}},"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"72":{"tf":1.0}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"46":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.4142135623730951},"95":{"tf":1.0}},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}},"1":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"1":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"2":{"df":1,"docs":{"63":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"d":{"2":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"86":{"tf":1.0}}},"df":8,"docs":{"13":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"51":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"95":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}},"df":6,"docs":{"0":{"tf":1.0},"4":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"88":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"t":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"32":{"tf":1.0},"73":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"75":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":8,"docs":{"13":{"tf":1.0},"24":{"tf":1.0},"27":{"tf":2.0},"30":{"tf":1.0},"34":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"49":{"tf":1.0},"90":{"tf":1.0}}}}},"s":{".":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":2.0}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"16":{"tf":1.0},"30":{"tf":1.0},"71":{"tf":2.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"100":{"tf":1.0},"2":{"tf":1.7320508075688772},"73":{"tf":1.0},"95":{"tf":1.0}}}}}}},"s":{"df":1,"docs":{"4":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.0},"49":{"tf":1.0},"71":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"63":{"tf":1.0},"65":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"33":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"68":{"tf":2.0}},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"42":{"tf":1.7320508075688772}},"e":{"=":{"*":{".":{"df":0,"docs":{},"h":{":":{"c":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{":":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":11,"docs":{"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.0},"3":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.4142135623730951},"87":{"tf":1.0},"9":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":7,"docs":{"14":{"tf":1.0},"18":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"39":{"tf":1.0},"4":{"tf":1.0},"52":{"tf":1.0},"97":{"tf":1.0}},"r":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"57":{"tf":1.0},"95":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"98":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"104":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"88":{"tf":1.0},"95":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":2,"docs":{"58":{"tf":1.0},"70":{"tf":1.0}}}}}}}},"s":{"df":10,"docs":{"1":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":2.23606797749979},"73":{"tf":1.0},"88":{"tf":1.0},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":17,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":2.0},"84":{"tf":1.0},"85":{"tf":2.0},"86":{"tf":1.0},"87":{"tf":1.7320508075688772},"88":{"tf":1.0},"93":{"tf":1.0},"99":{"tf":1.0}}}}},"t":{"df":3,"docs":{"100":{"tf":1.0},"12":{"tf":1.0},"46":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"51":{"tf":1.0},"94":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":3,"docs":{"26":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.0}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"100":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"25":{"tf":1.0},"28":{"tf":1.4142135623730951},"34":{"tf":1.0}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"f":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":6,"docs":{"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"78":{"tf":1.0}},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"f":{"df":1,"docs":{"94":{"tf":1.7320508075688772}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"73":{"tf":1.0},"94":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.7320508075688772}}}}}},"l":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"62":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"h":{"df":0,"docs":{},"p":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"k":{"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"102":{"tf":1.0},"42":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"78":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"100":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"45":{"tf":1.0},"47":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"27":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":2,"docs":{"100":{"tf":1.0},"97":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"65":{"tf":1.0}}}}},"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"27":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"x":{"=":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"83":{"tf":1.0},"86":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"66":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"104":{"tf":1.0},"20":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"101":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"83":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}},"y":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"55":{"tf":1.0}},"s":{"df":1,"docs":{"101":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":4,"docs":{"48":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"44":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.4142135623730951}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":6,"docs":{"0":{"tf":1.0},"40":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.0},"71":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"100":{"tf":1.0},"42":{"tf":1.0},"78":{"tf":1.0},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"83":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"61":{"tf":1.7320508075688772},"70":{"tf":2.0},"88":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"40":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"102":{"tf":1.0}}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}},"j":{"df":1,"docs":{"40":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"m":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"s":{"=":{"1":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}}},"df":4,"docs":{"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772},"49":{"tf":2.0}},"e":{"a":{"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"104":{"tf":1.0},"25":{"tf":1.4142135623730951},"28":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"101":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"71":{"tf":1.0},"85":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"35":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"1":{"tf":1.0},"17":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"11":{"tf":1.0},"14":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.4142135623730951},"51":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"24":{"tf":1.0},"46":{"tf":1.0}}}}}},"d":{"df":1,"docs":{"51":{"tf":1.0}},"u":{"c":{"df":2,"docs":{"31":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"68":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"92":{"tf":2.0}}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":1,"docs":{"51":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":6,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"82":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.0}}}},"i":{"df":1,"docs":{"44":{"tf":1.0}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}},"v":{"df":7,"docs":{"19":{"tf":1.0},"37":{"tf":1.0},"58":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"59":{"tf":1.0},"61":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"69":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"58":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"94":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"18":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":2,"docs":{"49":{"tf":1.0},"95":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":4,"docs":{"11":{"tf":1.4142135623730951},"30":{"tf":1.0},"32":{"tf":1.0},"51":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":3,"docs":{"101":{"tf":1.0},"51":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"99":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":15,"docs":{"33":{"tf":1.4142135623730951},"46":{"tf":1.0},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":2.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"88":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}}}},"x":{"df":1,"docs":{"42":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"28":{"tf":1.0},"65":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}}},"h":{"df":1,"docs":{"95":{"tf":1.7320508075688772}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":3,"docs":{"38":{"tf":1.0},"49":{"tf":3.3166247903554},"95":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"62":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951}}}}},"u":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":8,"docs":{"20":{"tf":1.7320508075688772},"30":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.7320508075688772},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"92":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}},"df":7,"docs":{"11":{"tf":2.0},"12":{"tf":1.0},"40":{"tf":1.4142135623730951},"71":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"94":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"11":{"tf":1.0},"75":{"tf":1.0}}}}}}}},"s":{"/":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"$":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"69":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":4,"docs":{"13":{"tf":1.0},"24":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"78":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"/":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}}}}}}},"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"92":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"_":{"1":{"df":1,"docs":{"24":{"tf":1.0}}},"2":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"1":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"x":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"x":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"1":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}},"2":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"1":{".":{"df":0,"docs":{},"j":{"df":2,"docs":{"23":{"tf":1.0},"25":{"tf":1.0}}}},"df":0,"docs":{}},"2":{".":{"df":0,"docs":{},"j":{"df":2,"docs":{"23":{"tf":1.0},"25":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"_":{"1":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"2":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"1":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}},"2":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"1":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}}}}},"df":0,"docs":{}},"2":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"c":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"104":{"tf":1.0}}},"df":2,"docs":{"104":{"tf":1.0},"40":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"80":{"tf":1.0},"92":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"80":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"104":{"tf":1.0}}}}}},"df":5,"docs":{"100":{"tf":2.0},"104":{"tf":1.0},"7":{"tf":1.0},"87":{"tf":1.0},"90":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"51":{"tf":1.0},"91":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"42":{"tf":1.0},"72":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"100":{"tf":1.0},"51":{"tf":1.0},"96":{"tf":1.0}}}}}}},"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":15,"docs":{"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"18":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"42":{"tf":1.4142135623730951},"49":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.4142135623730951},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":2.23606797749979}},"m":{"df":1,"docs":{"100":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}},"t":{"(":{"1":{"df":1,"docs":{"71":{"tf":1.0}}},"2":{"df":1,"docs":{"71":{"tf":1.0}}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":8,"docs":{"27":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"33":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.7320508075688772}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"71":{"tf":1.0},"78":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}},"f":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"89":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":10,"docs":{"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"55":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0}},"n":{"df":3,"docs":{"31":{"tf":1.0},"55":{"tf":1.0},"88":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"71":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"102":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"40":{"tf":1.0},"46":{"tf":1.0}},"e":{"_":{"1":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"92":{"tf":1.0}}}}}}},"df":0,"docs":{}},"2":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"92":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"47":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"26":{"tf":1.0},"46":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"76":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":5,"docs":{"40":{"tf":4.123105625617661},"41":{"tf":1.7320508075688772},"83":{"tf":1.0},"86":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":16,"docs":{"103":{"tf":1.4142135623730951},"40":{"tf":7.280109889280518},"41":{"tf":3.605551275463989},"43":{"tf":1.0},"44":{"tf":1.7320508075688772},"45":{"tf":1.0},"46":{"tf":2.23606797749979},"73":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"86":{"tf":1.7320508075688772},"87":{"tf":2.0},"88":{"tf":1.4142135623730951},"90":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}},"u":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"52":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"24":{"tf":1.0},"37":{"tf":1.4142135623730951}}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}},"r":{"df":4,"docs":{"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"65":{"tf":1.0},"95":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"66":{"tf":1.0},"94":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}},"l":{"df":4,"docs":{"61":{"tf":1.0},"65":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"p":{"df":1,"docs":{"71":{"tf":1.0}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"46":{"tf":1.0},"70":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":9,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"100":{"tf":1.0},"104":{"tf":1.0},"14":{"tf":1.0},"78":{"tf":1.0},"86":{"tf":1.0},"89":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":4,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0}},"i":{"df":3,"docs":{"13":{"tf":1.0},"25":{"tf":1.0},"33":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"r":{"c":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"87":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"78":{"tf":1.0},"87":{"tf":1.7320508075688772}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"49":{"tf":2.0},"50":{"tf":1.0},"97":{"tf":1.0}}}},"t":{"df":2,"docs":{"34":{"tf":1.0},"94":{"tf":1.4142135623730951}},"e":{"df":1,"docs":{"26":{"tf":1.0}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"u":{"df":1,"docs":{"9":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"1":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"47":{"tf":1.4142135623730951},"88":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"100":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"46":{"tf":1.4142135623730951},"69":{"tf":2.8284271247461903},"88":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.4142135623730951},"95":{"tf":1.7320508075688772},"98":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}}},"u":{"b":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"87":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"88":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"103":{"tf":1.0},"62":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":6,"docs":{"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}},"s":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":10,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"20":{"tf":1.0},"34":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.7320508075688772},"73":{"tf":1.0},"77":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"33":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"g":{"df":1,"docs":{"42":{"tf":1.0}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"99":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"100":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"87":{"tf":1.0},"90":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.0},"28":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":2.0},"73":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":16,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":2.449489742783178},"46":{"tf":1.0},"47":{"tf":1.4142135623730951},"49":{"tf":2.6457513110645907},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"58":{"tf":1.0},"73":{"tf":2.0},"88":{"tf":1.0},"90":{"tf":1.4142135623730951},"95":{"tf":3.1622776601683795}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"80":{"tf":1.0}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"94":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"91":{"tf":1.0}}}}}}},"df":1,"docs":{"33":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"101":{"tf":1.0},"94":{"tf":1.0}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"20":{"tf":2.6457513110645907},"78":{"tf":1.7320508075688772},"91":{"tf":1.0},"92":{"tf":2.23606797749979}}}},"x":{"df":0,"docs":{},"t":{"df":7,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"41":{"tf":1.0},"62":{"tf":1.0},"73":{"tf":1.0},"99":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"14":{"tf":1.0}}}},"t":{"'":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"'":{"df":2,"docs":{"62":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"'":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"102":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.4142135623730951}}},"k":{"df":1,"docs":{"88":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.0},"89":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"65":{"tf":1.0},"88":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"49":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"54":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"33":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}},"o":{"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"46":{"tf":1.4142135623730951},"72":{"tf":1.0},"88":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"76":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":12,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"103":{"tf":1.0},"20":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"p":{"df":3,"docs":{"60":{"tf":1.0},"95":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"82":{"tf":1.0},"95":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"101":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"94":{"tf":1.0}}}}}}},"df":1,"docs":{"83":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"42":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":30,"docs":{"1":{"tf":1.0},"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"103":{"tf":1.7320508075688772},"104":{"tf":1.0},"40":{"tf":4.47213595499958},"41":{"tf":2.449489742783178},"43":{"tf":2.0},"44":{"tf":2.0},"45":{"tf":2.23606797749979},"46":{"tf":3.4641016151377544},"47":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"82":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.7320508075688772},"88":{"tf":1.4142135623730951},"90":{"tf":1.0},"95":{"tf":2.23606797749979},"97":{"tf":1.4142135623730951},"99":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"88":{"tf":1.0}}}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"87":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":3,"docs":{"52":{"tf":1.0},"53":{"tf":1.0},"95":{"tf":1.0}}}}},"df":1,"docs":{"17":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"100":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"33":{"tf":1.0},"64":{"tf":1.0}}}}},"s":{":":{":":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":2.23606797749979}}}}},"df":0,"docs":{}}},"df":3,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"88":{"tf":1.0}},"x":{"df":1,"docs":{"40":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"49":{"tf":1.0},"71":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":10,"docs":{"24":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0},"95":{"tf":1.7320508075688772}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"31":{"tf":1.0},"71":{"tf":1.0}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"i":{"c":{"df":2,"docs":{"17":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":1,"docs":{"1":{"tf":1.0}},"i":{"df":2,"docs":{"38":{"tf":1.0},"42":{"tf":1.0}}},"n":{"b":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":6,"docs":{"1":{"tf":1.0},"24":{"tf":1.4142135623730951},"53":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"88":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"2":{"tf":1.0},"44":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"92":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"20":{"tf":1.0}}},"x":{"df":1,"docs":{"7":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"95":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"71":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.7320508075688772}}}}},"w":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"83":{"tf":2.0},"89":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":6,"docs":{"46":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"99":{"tf":1.7320508075688772}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":6,"docs":{"21":{"tf":1.0},"28":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"42":{"tf":1.0},"94":{"tf":1.0}}}},"df":44,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"103":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"24":{"tf":1.0},"27":{"tf":1.4142135623730951},"29":{"tf":2.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":2.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"38":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.7320508075688772},"51":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"72":{"tf":1.0}}},"df":8,"docs":{"33":{"tf":1.0},"38":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":2.0},"71":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.7320508075688772}},"n":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"y":{"1":{"4":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.0}},"e":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.0}},"e":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"75":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"h":{"a":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"2":{".":{"4":{"3":{".":{"1":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"u":{"df":2,"docs":{"27":{"tf":1.0},"73":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":7,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"27":{"tf":1.4142135623730951},"30":{"tf":1.0},"45":{"tf":1.0},"69":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"15":{"tf":1.0},"3":{"tf":1.0}}}}}}},"b":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":2,"docs":{"49":{"tf":2.23606797749979},"94":{"tf":1.0}},"e":{"c":{"!":{"[":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"\"":{"]":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"87":{"tf":1.0},"88":{"tf":1.4142135623730951}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"81":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"86":{"tf":1.0},"87":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"87":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"19":{"tf":1.0},"26":{"tf":1.0},"39":{"tf":1.0},"55":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":3,"docs":{"49":{"tf":3.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}}}},"h":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":4,"docs":{"30":{"tf":1.7320508075688772},"35":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":2,"docs":{"24":{"tf":1.0},"46":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"32":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}},"y":{"df":4,"docs":{"35":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"86":{"tf":1.0}}}},"r":{"df":1,"docs":{"73":{"tf":1.0}}},"v":{"df":2,"docs":{"65":{"tf":1.0},"72":{"tf":1.0}}}},"b":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.0},"85":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"28":{"tf":1.0},"52":{"tf":1.0},"85":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":2,"docs":{"46":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"88":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":5,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}},"e":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"100":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"4":{"tf":1.0},"8":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"59":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.0},"69":{"tf":1.4142135623730951}}},"df":0,"docs":{},"k":{"df":3,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"52":{"tf":1.0}}},"l":{"d":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"s":{"df":3,"docs":{"1":{"tf":1.0},"50":{"tf":1.0},"71":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"75":{"tf":1.0},"94":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"11":{"tf":1.0},"65":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"28":{"tf":1.0},"62":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"100":{"tf":1.0}}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"g":{"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":1.0}}}},"df":11,"docs":{"49":{"tf":3.1622776601683795},"53":{"tf":2.449489742783178},"54":{"tf":2.23606797749979},"55":{"tf":2.449489742783178},"56":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"65":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.7320508075688772},"95":{"tf":1.0}},"m":{"df":0,"docs":{},"l":{"df":3,"docs":{"102":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}}},"s":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":4,"docs":{"102":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"df":5,"docs":{"55":{"tf":2.449489742783178},"56":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"90":{"tf":1.0}}}},"r":{"df":5,"docs":{"11":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":1.7320508075688772},"97":{"tf":1.4142135623730951}}},"v":{"df":3,"docs":{"32":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"j":{"a":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"z":{"c":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"40":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}}}}}},"breadcrumbs":{"root":{"0":{".":{"5":{"0":{"df":1,"docs":{"26":{"tf":1.0}}},"8":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}},"6":{"4":{".":{"0":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},":":{"0":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":4,"docs":{"28":{"tf":1.0},"44":{"tf":3.1622776601683795},"45":{"tf":1.0},"46":{"tf":4.0}}},"1":{",":{"3":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},".":{"7":{"4":{".":{"1":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"6":{"4":{"4":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"99":{"tf":1.0}}},":":{"0":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":10,"docs":{"1":{"tf":1.7320508075688772},"28":{"tf":1.4142135623730951},"35":{"tf":1.0},"44":{"tf":3.7416573867739413},"46":{"tf":2.6457513110645907},"49":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"65":{"tf":1.0},"71":{"tf":1.0},"83":{"tf":1.0}}},"2":{"0":{"1":{"2":{"df":1,"docs":{"98":{"tf":1.4142135623730951}}},"4":{"df":1,"docs":{"99":{"tf":1.4142135623730951}}},"7":{"df":2,"docs":{"100":{"tf":1.7320508075688772},"101":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"2":{"0":{"df":2,"docs":{"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951}}},"1":{"df":1,"docs":{"104":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":1,"docs":{"69":{"tf":1.0}}},"df":9,"docs":{"1":{"tf":1.0},"28":{"tf":1.0},"44":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"49":{"tf":2.23606797749979},"55":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"71":{"tf":1.0},"73":{"tf":1.0}}},"3":{"0":{"df":1,"docs":{"0":{"tf":1.0}}},"df":3,"docs":{"1":{"tf":1.0},"44":{"tf":1.7320508075688772},"46":{"tf":1.7320508075688772}}},"4":{"2":{"df":1,"docs":{"34":{"tf":1.0}}},"4":{"df":1,"docs":{"58":{"tf":1.0}}},"5":{"df":1,"docs":{"34":{"tf":1.0}}},"df":1,"docs":{"44":{"tf":1.4142135623730951}}},"5":{"df":1,"docs":{"44":{"tf":2.0}}},"6":{"c":{"d":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"44":{"tf":1.7320508075688772}}},"7":{"df":1,"docs":{"44":{"tf":1.0}}},"8":{"df":3,"docs":{"11":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0}}},"a":{"b":{"c":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"1":{"df":1,"docs":{"33":{"tf":1.0}}},"2":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":2,"docs":{"33":{"tf":1.0},"49":{"tf":1.4142135623730951}}}}},"c":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"97":{"tf":1.0}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"17":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"13":{"tf":1.0},"99":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"69":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"a":{"df":1,"docs":{"40":{"tf":1.4142135623730951}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}}},"d":{"df":11,"docs":{"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"38":{"tf":1.0},"70":{"tf":1.0},"80":{"tf":1.0},"86":{"tf":2.0},"87":{"tf":1.7320508075688772},"88":{"tf":1.0},"90":{"tf":1.0},"92":{"tf":1.7320508075688772}},"e":{"d":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"88":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"58":{"tf":1.0},"72":{"tf":1.4142135623730951},"79":{"tf":1.0},"95":{"tf":1.0}}}}},"df":14,"docs":{"26":{"tf":1.0},"34":{"tf":1.0},"53":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"95":{"tf":1.0}},"j":{"a":{"c":{"df":1,"docs":{"95":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"v":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"49":{"tf":1.4142135623730951},"51":{"tf":1.0}}},"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"102":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"l":{"df":1,"docs":{"99":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"40":{"tf":1.0}}}},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":11,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.7320508075688772},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"51":{"tf":1.7320508075688772},"53":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}}}}},"i":{"a":{"df":2,"docs":{"31":{"tf":1.4142135623730951},"34":{"tf":1.0}},"s":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"71":{"tf":1.0},"95":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":6,"docs":{"102":{"tf":1.0},"12":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":9,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"96":{"tf":1.7320508075688772},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"1":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"q":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"103":{"tf":1.0},"46":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"63":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"40":{"tf":1.0}}}},"i":{"df":1,"docs":{"77":{"tf":1.7320508075688772}}},"p":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"7":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"22":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"30":{"tf":1.0},"44":{"tf":1.0}}}}}}}},"m":{"df":1,"docs":{"89":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"33":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"50":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":3,"docs":{"42":{"tf":1.0},"89":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"34":{"tf":1.0},"70":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"46":{"tf":1.0},"88":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":9,"docs":{"45":{"tf":1.4142135623730951},"46":{"tf":2.23606797749979},"49":{"tf":2.6457513110645907},"50":{"tf":1.0},"61":{"tf":2.449489742783178},"69":{"tf":1.0},"73":{"tf":1.0},"88":{"tf":1.7320508075688772},"95":{"tf":2.23606797749979}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":2,"docs":{"14":{"tf":1.0},"31":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"101":{"tf":2.0},"97":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":10,"docs":{"0":{"tf":1.4142135623730951},"100":{"tf":1.0},"13":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"42":{"tf":1.0},"77":{"tf":1.0},"85":{"tf":1.0},"90":{"tf":1.0},"97":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"16":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"73":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"=":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"df":2,"docs":{"27":{"tf":2.0},"34":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"r":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}},"df":4,"docs":{"57":{"tf":2.0},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"71":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":6,"docs":{"103":{"tf":1.0},"17":{"tf":1.0},"42":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"99":{"tf":1.0}}},"h":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"z":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"65":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":2,"docs":{"62":{"tf":2.6457513110645907},"72":{"tf":2.449489742783178}},"e":{"df":5,"docs":{"20":{"tf":1.0},"58":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"95":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":20,"docs":{"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.4142135623730951},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.7320508075688772}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"95":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"71":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"33":{"tf":1.0},"65":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"29":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"33":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.7320508075688772},"78":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"55":{"tf":1.0},"95":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"100":{"tf":1.4142135623730951},"34":{"tf":1.0},"47":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"51":{"tf":1.0}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":13,"docs":{"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"34":{"tf":1.0},"4":{"tf":1.7320508075688772},"76":{"tf":1.0},"77":{"tf":1.0}}}}},"df":1,"docs":{"94":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"72":{"tf":2.8284271247461903}}}}},"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"51":{"tf":1.0}}},"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"68":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":2,"docs":{"100":{"tf":1.0},"97":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":1,"docs":{"94":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"49":{"tf":2.0},"60":{"tf":1.0},"61":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"60":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"6":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}},"s":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"0":{"tf":1.0},"94":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"87":{"tf":1.0}}}},"df":11,"docs":{"100":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":2.23606797749979},"15":{"tf":1.0},"16":{"tf":2.23606797749979},"19":{"tf":1.0},"43":{"tf":1.0},"75":{"tf":2.8284271247461903},"76":{"tf":1.0},"78":{"tf":1.0},"87":{"tf":1.7320508075688772}}},"df":0,"docs":{},"t":{"df":4,"docs":{"104":{"tf":1.0},"15":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.7320508075688772}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"c":{"+":{"+":{"1":{"4":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"/":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}}}},"df":1,"docs":{"28":{"tf":1.0}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"97":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"68":{"tf":1.0}}},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"80":{"tf":1.0},"87":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"=":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":11,"docs":{"12":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"20":{"tf":1.4142135623730951},"75":{"tf":1.7320508075688772},"76":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"87":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"e":{"df":24,"docs":{"28":{"tf":1.0},"52":{"tf":2.23606797749979},"53":{"tf":2.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"56":{"tf":1.7320508075688772},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.0},"95":{"tf":1.0}}}},"t":{"df":1,"docs":{"25":{"tf":1.0}}}},"c":{"df":3,"docs":{"12":{"tf":1.7320508075688772},"15":{"tf":1.0},"97":{"tf":1.0}}},"d":{"df":5,"docs":{"19":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"87":{"tf":1.0},"90":{"tf":1.0}}},"df":10,"docs":{"11":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"30":{"tf":1.7320508075688772},"31":{"tf":2.449489742783178},"33":{"tf":1.0},"40":{"tf":2.449489742783178},"42":{"tf":1.4142135623730951},"62":{"tf":2.0},"87":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"60":{"tf":1.0},"72":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"g":{"df":19,"docs":{"1":{"tf":1.0},"16":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":2.449489742783178},"70":{"tf":1.7320508075688772},"71":{"tf":1.4142135623730951},"72":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"80":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"0":{"tf":1.0}}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"88":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"88":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"o":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"8":{"tf":1.4142135623730951}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"49":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"49":{"tf":1.0},"62":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"57":{"tf":1.0}}}}}}},"k":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"55":{"tf":1.0},"69":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":5,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"33":{"tf":1.0},"98":{"tf":1.0}}},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"101":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"e":{"df":5,"docs":{"1":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"88":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}},"m":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}},"d":{".":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":12,"docs":{"1":{"tf":1.4142135623730951},"100":{"tf":1.0},"104":{"tf":1.0},"14":{"tf":1.0},"28":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"86":{"tf":1.4142135623730951},"88":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"=":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"38":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"27":{"tf":1.0},"98":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"70":{"tf":1.0}},"n":{"d":{"df":12,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.4142135623730951},"27":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"32":{"tf":1.4142135623730951},"34":{"tf":1.0},"36":{"tf":2.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"83":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":10,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"104":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"66":{"tf":1.7320508075688772},"67":{"tf":1.7320508075688772},"68":{"tf":1.7320508075688772},"69":{"tf":1.0},"95":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"35":{"tf":1.4142135623730951},"83":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":8,"docs":{"103":{"tf":1.0},"40":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"70":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":7,"docs":{"1":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"72":{"tf":1.0},"95":{"tf":2.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"33":{"tf":1.0},"98":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":3,"docs":{"65":{"tf":1.0},"66":{"tf":1.0},"85":{"tf":1.0}}},"x":{"df":1,"docs":{"46":{"tf":1.0}}}}},"o":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":15,"docs":{"100":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":1.7320508075688772},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0},"71":{"tf":1.0},"87":{"tf":1.4142135623730951},"88":{"tf":1.4142135623730951},"89":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"88":{"tf":1.0},"91":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":2.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":2,"docs":{"62":{"tf":1.0},"65":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":13,"docs":{"102":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"64":{"tf":1.0},"71":{"tf":1.0},"88":{"tf":1.0},"98":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"45":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"51":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"94":{"tf":1.0}}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"14":{"tf":1.0},"24":{"tf":1.0},"62":{"tf":1.0},"87":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":11,"docs":{"42":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"62":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":22,"docs":{"12":{"tf":1.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0},"86":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"18":{"tf":1.0}}},"t":{"df":1,"docs":{"2":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}},"t":{"df":4,"docs":{"43":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"63":{"tf":1.0},"69":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"54":{"tf":1.0},"88":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"55":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"p":{"df":1,"docs":{"92":{"tf":1.0}},"p":{"df":1,"docs":{"40":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}}}},"u":{"df":1,"docs":{"4":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"77":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":2,"docs":{"12":{"tf":1.0},"82":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"80":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":1,"docs":{"83":{"tf":1.0}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"s":{"df":2,"docs":{"102":{"tf":1.0},"41":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"17":{"tf":1.0},"30":{"tf":1.0},"36":{"tf":1.0},"39":{"tf":1.0},"55":{"tf":1.0},"78":{"tf":1.0}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"=":{"\"":{"7":{".":{"8":{".":{"9":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":2,"docs":{"101":{"tf":1.4142135623730951},"87":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"83":{"tf":1.0}}}},"x":{"df":0,"docs":{},"x":{"df":1,"docs":{"12":{"tf":1.0}}}}},"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}},"t":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":3,"docs":{"13":{"tf":2.449489742783178},"17":{"tf":2.449489742783178},"20":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"100":{"tf":1.0},"102":{"tf":1.0},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":1,"docs":{"100":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":2,"docs":{"62":{"tf":2.0},"83":{"tf":2.23606797749979}},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":3,"docs":{"12":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"68":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":4,"docs":{"27":{"tf":1.0},"32":{"tf":2.0},"33":{"tf":1.0},"35":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"33":{"tf":1.0},"34":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"89":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"65":{"tf":1.0}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":14,"docs":{"1":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":2.0},"53":{"tf":1.7320508075688772},"54":{"tf":1.7320508075688772},"55":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"59":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"65":{"tf":1.0},"88":{"tf":1.7320508075688772},"95":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"17":{"tf":1.4142135623730951},"20":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"100":{"tf":1.0},"53":{"tf":1.4142135623730951},"64":{"tf":1.7320508075688772}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":5,"docs":{"0":{"tf":1.0},"21":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"33":{"tf":1.0},"97":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":4,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"96":{"tf":1.0},"97":{"tf":1.0}}}},"r":{"df":8,"docs":{"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"66":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":3,"docs":{"46":{"tf":1.0},"79":{"tf":1.0},"88":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":4,"docs":{"1":{"tf":1.0},"13":{"tf":1.0},"42":{"tf":2.0},"89":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"40":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"t":{"_":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"=":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"=":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"79":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}}},"df":3,"docs":{"31":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":44,"docs":{"1":{"tf":1.4142135623730951},"100":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"104":{"tf":1.0},"2":{"tf":1.7320508075688772},"23":{"tf":1.4142135623730951},"24":{"tf":2.0},"38":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"95":{"tf":1.4142135623730951},"96":{"tf":1.0},"97":{"tf":2.0},"98":{"tf":1.0},"99":{"tf":1.0}},"f":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"=":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.7320508075688772},"31":{"tf":2.449489742783178},"33":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"df":31,"docs":{"0":{"tf":1.0},"1":{"tf":2.0},"100":{"tf":2.23606797749979},"102":{"tf":1.4142135623730951},"103":{"tf":1.0},"104":{"tf":1.7320508075688772},"2":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":2.23606797749979},"31":{"tf":2.6457513110645907},"32":{"tf":3.3166247903554},"33":{"tf":1.7320508075688772},"34":{"tf":2.0},"35":{"tf":1.4142135623730951},"36":{"tf":2.0},"37":{"tf":2.0},"38":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":2.23606797749979},"65":{"tf":2.0},"69":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951},"78":{"tf":1.0},"95":{"tf":2.23606797749979},"98":{"tf":2.23606797749979},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"100":{"tf":1.0},"46":{"tf":1.4142135623730951},"53":{"tf":1.0},"58":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"82":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"99":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"52":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.7320508075688772}}}}},"t":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{".":{"1":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"18":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"18":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":58,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.7320508075688772},"11":{"tf":1.4142135623730951},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":2.23606797749979},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":2.23606797749979},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"29":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"31":{"tf":2.6457513110645907},"32":{"tf":2.23606797749979},"33":{"tf":3.0},"34":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":2.23606797749979},"38":{"tf":1.0},"39":{"tf":1.0},"42":{"tf":1.0},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.7320508075688772},"6":{"tf":1.4142135623730951},"61":{"tf":1.0},"64":{"tf":1.0},"7":{"tf":2.8284271247461903},"71":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.0},"8":{"tf":2.449489742783178},"80":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.7320508075688772},"9":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":2.0},"96":{"tf":1.0}},"i":{"c":{"'":{"df":3,"docs":{"16":{"tf":1.0},"77":{"tf":1.0},"95":{"tf":2.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":21,"docs":{"1":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.7320508075688772},"36":{"tf":1.4142135623730951},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"42":{"tf":2.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"73":{"tf":1.0},"88":{"tf":1.4142135623730951},"94":{"tf":1.0}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"29":{"tf":1.0},"33":{"tf":3.7416573867739413}}}}}}}},"j":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"'":{"df":2,"docs":{"101":{"tf":1.0},"51":{"tf":1.4142135623730951}}},"df":1,"docs":{"101":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":1,"docs":{"83":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"48":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":3,"docs":{"19":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"24":{"tf":2.449489742783178},"76":{"tf":1.0},"87":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":6,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"52":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":8,"docs":{"100":{"tf":1.0},"102":{"tf":1.0},"45":{"tf":1.0},"53":{"tf":1.0},"65":{"tf":1.0},"95":{"tf":1.7320508075688772},"98":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"102":{"tf":1.0},"71":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"88":{"tf":1.0}}}}}}}}}}}},"l":{"df":1,"docs":{"31":{"tf":1.0}},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"o":{"c":{"df":3,"docs":{"12":{"tf":1.0},"68":{"tf":1.4142135623730951},"77":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"77":{"tf":1.7320508075688772},"79":{"tf":1.0},"88":{"tf":1.0}}}}}}}},"df":1,"docs":{"61":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"100":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}},"i":{"df":1,"docs":{"99":{"tf":1.0}}},"n":{"'":{"df":0,"docs":{},"t":{"df":7,"docs":{"1":{"tf":1.0},"33":{"tf":1.4142135623730951},"51":{"tf":1.0},"68":{"tf":1.0},"72":{"tf":1.0},"88":{"tf":1.4142135623730951},"98":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"83":{"tf":1.0}}}},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"60":{"tf":1.0},"99":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"12":{"tf":1.0},"4":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":1,"docs":{"31":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}}},"m":{"df":0,"docs":{},"p":{"df":4,"docs":{"44":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"100":{"tf":1.0},"47":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":13,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"15":{"tf":1.0},"28":{"tf":1.4142135623730951},"34":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"87":{"tf":1.0},"95":{"tf":1.7320508075688772},"98":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"0":{"tf":1.0},"33":{"tf":1.0},"50":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"57":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.0},"46":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":2,"docs":{"46":{"tf":1.0},"83":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"a":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"50":{"tf":1.7320508075688772}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":1,"docs":{"40":{"tf":1.0}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.7320508075688772}}}}}},"m":{"df":1,"docs":{"40":{"tf":1.7320508075688772}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}},"m":{"a":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"88":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"46":{"tf":1.0},"88":{"tf":1.0}}}}}},"d":{"df":4,"docs":{"49":{"tf":2.0},"50":{"tf":1.0},"57":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.0},"92":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"69":{"tf":1.0},"98":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"34":{"tf":1.0},"80":{"tf":1.0},"88":{"tf":1.0}}}}},"v":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":2,"docs":{"27":{"tf":1.0},"7":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"27":{"tf":1.4142135623730951},"30":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"27":{"tf":1.0},"35":{"tf":1.0},"62":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"73":{"tf":2.0}}}}}},"t":{"df":1,"docs":{"99":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":7,"docs":{"1":{"tf":1.0},"102":{"tf":1.0},"46":{"tf":1.0},"53":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"88":{"tf":1.0}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"45":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"98":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":16,"docs":{"1":{"tf":1.0},"101":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"34":{"tf":1.0},"42":{"tf":1.4142135623730951},"65":{"tf":1.0},"72":{"tf":1.7320508075688772},"78":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":1,"docs":{"97":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"4":{"tf":1.0},"94":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"28":{"tf":1.0},"96":{"tf":1.0}}}},"t":{"df":1,"docs":{"28":{"tf":2.0}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"55":{"tf":1.4142135623730951},"56":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"71":{"tf":1.0},"92":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}},"s":{"df":2,"docs":{"15":{"tf":1.0},"71":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":4,"docs":{"100":{"tf":2.0},"104":{"tf":1.0},"53":{"tf":1.0},"95":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"34":{"tf":2.0}}}}}},"df":4,"docs":{"30":{"tf":1.7320508075688772},"31":{"tf":2.0},"32":{"tf":2.23606797749979},"78":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":3,"docs":{"34":{"tf":1.7320508075688772},"42":{"tf":1.0},"89":{"tf":1.0}}}},"r":{"df":0,"docs":{},"n":{"df":6,"docs":{"29":{"tf":1.4142135623730951},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0},"38":{"tf":1.0}}}}},"r":{"a":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"87":{"tf":1.4142135623730951}}}}}},"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":3,"docs":{"2":{"tf":1.0},"97":{"tf":1.0},"98":{"tf":1.0}}}}}}}},"f":{"2":{"df":1,"docs":{"83":{"tf":1.0}}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"76":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"2":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"99":{"tf":1.0}}}}}},"s":{"df":1,"docs":{"33":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"df":1,"docs":{"70":{"tf":1.0}}}},"df":1,"docs":{"40":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"33":{"tf":1.0},"71":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"w":{"df":1,"docs":{"42":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":31,"docs":{"100":{"tf":1.4142135623730951},"102":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":2.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.0},"2":{"tf":1.0},"22":{"tf":1.4142135623730951},"23":{"tf":2.0},"24":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"26":{"tf":2.23606797749979},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"33":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.4142135623730951},"42":{"tf":2.6457513110645907},"45":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"87":{"tf":1.0},"89":{"tf":1.7320508075688772},"90":{"tf":1.0},"92":{"tf":1.7320508075688772},"94":{"tf":1.0},"95":{"tf":1.0},"96":{"tf":1.0},"98":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"92":{"tf":1.0}}}},"d":{"df":9,"docs":{"1":{"tf":1.0},"100":{"tf":1.4142135623730951},"17":{"tf":1.0},"28":{"tf":1.0},"48":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.7320508075688772},"71":{"tf":1.0},"85":{"tf":1.4142135623730951}}},"df":0,"docs":{},"e":{"df":1,"docs":{"99":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"42":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"72":{"tf":1.0},"95":{"tf":1.0}}}}},"x":{"df":1,"docs":{"0":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"37":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"94":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}},"t":{"df":2,"docs":{"46":{"tf":1.0},"62":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":10,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"38":{"tf":1.0},"83":{"tf":1.4142135623730951}}}}}},"o":{"(":{"\"":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"70":{"tf":1.0}}}}}}}}}}},"1":{"2":{"3":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":1,"docs":{"61":{"tf":1.0}}},"4":{"5":{"6":{"df":1,"docs":{"64":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"8":{"9":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"a":{"df":0,"docs":{},"r":{"(":{"1":{"2":{"3":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"61":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"(":{"b":{"a":{"df":0,"docs":{},"r":{"(":{"1":{"2":{"3":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"x":{"df":1,"docs":{"65":{"tf":1.0}}}},".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.4142135623730951}}}}}}},"_":{"1":{".":{"a":{"b":{"c":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"a":{"b":{"c":{"df":1,"docs":{"92":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"a":{"df":1,"docs":{"66":{"tf":1.0}},"r":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"z":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":10,"docs":{"100":{"tf":1.0},"102":{"tf":1.4142135623730951},"44":{"tf":1.0},"57":{"tf":2.0},"58":{"tf":1.7320508075688772},"60":{"tf":1.0},"62":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"98":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"100":{"tf":1.0},"102":{"tf":1.0},"2":{"tf":1.0},"41":{"tf":1.4142135623730951},"70":{"tf":1.0}}}},"df":1,"docs":{"92":{"tf":1.0}}}},"s":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}},"df":3,"docs":{"21":{"tf":1.0},"36":{"tf":2.449489742783178},"37":{"tf":2.23606797749979}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"86":{"tf":1.0}}},"df":0,"docs":{}}},"x":{"df":2,"docs":{"66":{"tf":1.4142135623730951},"68":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"89":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"27":{"tf":1.0},"79":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":5,"docs":{"62":{"tf":1.0},"65":{"tf":2.23606797749979},"89":{"tf":1.0},"94":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"w":{"c":{"d":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"g":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"51":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"z":{"d":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"c":{"c":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":9,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"18":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"45":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"1":{"tf":1.0}}},"@":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{":":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"83":{"tf":1.0},"93":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"=":{".":{"/":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"30":{"tf":1.0},"78":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"32":{"tf":1.0},"33":{"tf":1.0}}}}}}}},"df":16,"docs":{"21":{"tf":1.0},"27":{"tf":1.0},"29":{"tf":2.6457513110645907},"30":{"tf":2.449489742783178},"31":{"tf":2.449489742783178},"32":{"tf":2.449489742783178},"33":{"tf":2.6457513110645907},"62":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":2.0},"83":{"tf":2.23606797749979},"86":{"tf":1.4142135623730951},"91":{"tf":1.0},"93":{"tf":1.4142135623730951}},"h":{"df":0,"docs":{},"u":{"b":{"'":{"df":1,"docs":{"89":{"tf":1.0}}},"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"14":{"tf":1.0},"4":{"tf":1.0},"91":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"2":{"tf":1.0},"28":{"tf":1.0},"73":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"40":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"36":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951}}}},"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"95":{"tf":1.0}}}},"o":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"99":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"40":{"tf":1.4142135623730951},"41":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"h":{"df":4,"docs":{"48":{"tf":1.0},"49":{"tf":1.7320508075688772},"51":{"tf":2.0},"94":{"tf":1.0}},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"102":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"101":{"tf":1.0},"97":{"tf":1.0}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":1,"docs":{"83":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"1":{"tf":2.23606797749979}}}}},"df":0,"docs":{}}},"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"r":{"c":{")":{".":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"p":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"1":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}},"df":1,"docs":{"42":{"tf":1.0}}}}},"i":{"df":2,"docs":{"33":{"tf":1.0},"99":{"tf":1.0}}},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"99":{"tf":2.0}}}}}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"95":{"tf":1.4142135623730951}},"l":{"df":4,"docs":{"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"69":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":2,"docs":{"69":{"tf":1.0},"71":{"tf":1.7320508075688772}}},"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}},"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}},"df":1,"docs":{"42":{"tf":1.0}},"e":{"a":{"d":{"df":1,"docs":{"44":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"73":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":3,"docs":{"44":{"tf":1.0},"45":{"tf":1.0},"67":{"tf":1.4142135623730951}}}},"p":{"df":2,"docs":{"27":{"tf":1.4142135623730951},"42":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"80":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"1":{"tf":1.0},"71":{"tf":1.0},"77":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}},"g":{"df":2,"docs":{"34":{"tf":2.8284271247461903},"35":{"tf":2.0}},"r":{"c":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"88":{"tf":1.0}}}}}}}},"df":12,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.0},"46":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"90":{"tf":1.7320508075688772},"95":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"78":{"tf":1.0},"91":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":5,"docs":{"101":{"tf":1.0},"102":{"tf":1.0},"19":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{":":{"/":{"/":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"86":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"94":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"100":{"tf":1.0}}}},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}}}}}}},"i":{".":{"df":1,"docs":{"51":{"tf":1.0}}},"d":{":":{"1":{"df":1,"docs":{"45":{"tf":1.0}}},"2":{"df":1,"docs":{"45":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":1.0},"99":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"44":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":6,"docs":{"102":{"tf":1.0},"104":{"tf":1.0},"20":{"tf":1.0},"47":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":2,"docs":{"33":{"tf":1.0},"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"61":{"tf":1.0},"93":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":9,"docs":{"101":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0},"46":{"tf":1.7320508075688772},"85":{"tf":1.0},"87":{"tf":1.7320508075688772},"99":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"!":{"(":{"\"":{".":{".":{"/":{".":{".":{"/":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"m":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"71":{"tf":1.0}}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"32":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"95":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"96":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":3,"docs":{"33":{"tf":1.7320508075688772},"71":{"tf":1.0},"79":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"63":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"2":{"tf":1.4142135623730951},"73":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"60":{"tf":1.4142135623730951},"72":{"tf":1.0},"89":{"tf":1.0}}}}},"i":{"d":{"df":3,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"69":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":21,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"3":{"tf":2.0},"39":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":2.8284271247461903},"75":{"tf":1.0},"76":{"tf":2.0},"8":{"tf":2.6457513110645907},"9":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":2,"docs":{"34":{"tf":1.0},"51":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"12":{"tf":1.0},"21":{"tf":1.0},"94":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"45":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"97":{"tf":1.0}}}}},"n":{"df":33,"docs":{"37":{"tf":1.0},"43":{"tf":1.7320508075688772},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.7320508075688772},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"100":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"2":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"28":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"27":{"tf":1.0},"33":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"88":{"tf":1.0}}},"p":{"df":0,"docs":{},"o":{"d":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"58":{"tf":1.0}}}}},"t":{"'":{"df":10,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"101":{"tf":1.0},"55":{"tf":1.0},"61":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.7320508075688772},"75":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"95":{"tf":2.8284271247461903}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}},"j":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"100":{"tf":1.7320508075688772}},"t":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}},"v":{"a":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"df":2,"docs":{"40":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"o":{"b":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"86":{"tf":1.0},"93":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"m":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}},"/":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"m":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}}}},"5":{"df":1,"docs":{"102":{"tf":1.0}}},"df":10,"docs":{"102":{"tf":1.7320508075688772},"41":{"tf":1.4142135623730951},"63":{"tf":1.0},"71":{"tf":1.0},"86":{"tf":1.4142135623730951},"87":{"tf":1.7320508075688772},"88":{"tf":1.0},"89":{"tf":1.4142135623730951},"93":{"tf":1.0},"98":{"tf":2.449489742783178}}}},"x":{"df":1,"docs":{"40":{"tf":1.0}}}},"u":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":2.23606797749979}}}}}}},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"68":{"tf":2.0}}}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"69":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"85":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":20,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"104":{"tf":1.0},"39":{"tf":2.449489742783178},"40":{"tf":2.0},"41":{"tf":1.4142135623730951},"42":{"tf":3.0},"61":{"tf":1.0},"63":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"88":{"tf":2.6457513110645907},"89":{"tf":2.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.7320508075688772}},"e":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"89":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"89":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":3,"docs":{"2":{"tf":1.0},"58":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"33":{"tf":1.0},"53":{"tf":1.0},"73":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"83":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"57":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"x":{"df":1,"docs":{"41":{"tf":1.7320508075688772}}}}},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}},"c":{"df":1,"docs":{"103":{"tf":1.0}}},"df":2,"docs":{"35":{"tf":1.0},"49":{"tf":1.7320508075688772}},"e":{"a":{"d":{"df":3,"docs":{"16":{"tf":1.0},"70":{"tf":1.0},"94":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":1,"docs":{"46":{"tf":1.0}}},"v":{"df":1,"docs":{"103":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":3,"docs":{"38":{"tf":1.0},"49":{"tf":3.3166247903554},"95":{"tf":1.0}}}},"t":{"'":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"95":{"tf":1.0}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"102":{"tf":1.0}}}}}}}}}}},"x":{"df":1,"docs":{"87":{"tf":1.0}}}},"h":{"df":1,"docs":{"95":{"tf":1.7320508075688772}}},"i":{"b":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"79":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"0":{"tf":1.0},"97":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"34":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"31":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":13,"docs":{"1":{"tf":1.7320508075688772},"100":{"tf":1.0},"2":{"tf":2.0},"27":{"tf":1.0},"34":{"tf":1.4142135623730951},"42":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772},"69":{"tf":1.0},"72":{"tf":2.8284271247461903},"73":{"tf":1.0},"75":{"tf":1.0},"95":{"tf":2.0}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"89":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"x":{"'":{"df":1,"docs":{"94":{"tf":1.0}}},"df":2,"docs":{"4":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}},"s":{"df":0,"docs":{},"p":{"df":3,"docs":{"104":{"tf":1.0},"40":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"t":{"df":11,"docs":{"27":{"tf":1.0},"39":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"61":{"tf":1.0},"85":{"tf":1.0},"88":{"tf":1.4142135623730951},"9":{"tf":1.7320508075688772},"95":{"tf":2.23606797749979}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":5,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"69":{"tf":1.7320508075688772},"88":{"tf":1.0},"95":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"92":{"tf":1.0}}}}},"n":{"df":2,"docs":{"87":{"tf":1.0},"90":{"tf":1.0}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"33":{"tf":1.4142135623730951},"76":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":7,"docs":{"30":{"tf":1.0},"31":{"tf":2.0},"32":{"tf":1.0},"35":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.7320508075688772},"83":{"tf":1.4142135623730951}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"69":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"103":{"tf":1.0},"62":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"k":{"df":6,"docs":{"1":{"tf":1.0},"62":{"tf":1.0},"78":{"tf":1.0},"91":{"tf":1.0},"94":{"tf":1.0},"97":{"tf":1.0}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"70":{"tf":1.7320508075688772}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}}},"t":{"df":3,"docs":{"51":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":2.0}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"41":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"u":{"a":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":2,"docs":{"4":{"tf":1.0},"6":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.4142135623730951}}}}}}},"k":{"df":0,"docs":{},"e":{"df":5,"docs":{"40":{"tf":1.4142135623730951},"46":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"71":{"tf":1.4142135623730951}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"3":{"tf":1.0},"5":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":2,"docs":{"18":{"tf":1.7320508075688772},"33":{"tf":1.0}},"i":{"df":4,"docs":{"24":{"tf":1.0},"85":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.0}}},"u":{"a":{"df":0,"docs":{},"l":{"/":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":4,"docs":{"0":{"tf":1.4142135623730951},"19":{"tf":2.23606797749979},"76":{"tf":1.7320508075688772},"96":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"1":{"tf":1.0}}},"r":{"df":0,"docs":{},"k":{"df":5,"docs":{"100":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"62":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"83":{"tf":1.0},"86":{"tf":1.0},"93":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":13,"docs":{"1":{"tf":1.0},"4":{"tf":1.0},"46":{"tf":1.4142135623730951},"49":{"tf":1.0},"50":{"tf":1.4142135623730951},"60":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":2.0},"89":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"x":{"df":1,"docs":{"71":{"tf":1.0}},"x":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"76":{"tf":2.449489742783178}}}}}},"df":0,"docs":{}},"df":1,"docs":{"40":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"17":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":5,"docs":{"100":{"tf":1.0},"104":{"tf":1.0},"68":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"51":{"tf":1.0},"94":{"tf":1.4142135623730951}}}}}},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"21":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"g":{"df":2,"docs":{"100":{"tf":1.0},"33":{"tf":1.4142135623730951}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"h":{"df":1,"docs":{"104":{"tf":1.0}}},"i":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"13":{"tf":2.0},"17":{"tf":2.449489742783178},"20":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"100":{"tf":1.4142135623730951},"58":{"tf":1.0},"95":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"65":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"73":{"tf":1.0}},"l":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":9,"docs":{"13":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.4142135623730951},"42":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.0},"65":{"tf":1.4142135623730951},"75":{"tf":1.0},"94":{"tf":1.4142135623730951}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"58":{"tf":1.0},"68":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"1":{"tf":1.0},"46":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"95":{"tf":1.0}}}}}}}}},"n":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"58":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":10,"docs":{"24":{"tf":1.0},"33":{"tf":1.0},"42":{"tf":1.4142135623730951},"45":{"tf":1.0},"46":{"tf":1.0},"69":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"95":{"tf":1.0}}}},"n":{"df":0,"docs":{},"o":{"df":1,"docs":{"92":{"tf":1.4142135623730951}}}}},"c":{"df":1,"docs":{"97":{"tf":1.0}}},"df":1,"docs":{"83":{"tf":1.0}},"e":{"df":0,"docs":{},"e":{"d":{"df":5,"docs":{"11":{"tf":1.7320508075688772},"33":{"tf":1.0},"37":{"tf":1.0},"51":{"tf":1.0},"90":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"63":{"tf":1.4142135623730951},"64":{"tf":1.0}}}},"w":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}},"df":6,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"69":{"tf":1.0},"80":{"tf":1.4142135623730951},"85":{"tf":1.0},"89":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"40":{"tf":1.7320508075688772},"7":{"tf":1.7320508075688772}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":12,"docs":{"46":{"tf":2.0},"47":{"tf":1.7320508075688772},"49":{"tf":2.6457513110645907},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.4142135623730951},"62":{"tf":1.0},"64":{"tf":1.0},"73":{"tf":1.0},"88":{"tf":2.23606797749979},"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"94":{"tf":1.0}}}}},"n":{"df":2,"docs":{"28":{"tf":1.0},"95":{"tf":1.0}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"20":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"14":{"tf":1.0},"76":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"98":{"tf":1.0}}}}}}}}},"i":{"c":{"df":2,"docs":{"1":{"tf":1.0},"88":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":8,"docs":{"49":{"tf":3.0},"50":{"tf":1.4142135623730951},"57":{"tf":1.7320508075688772},"62":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.4142135623730951},"95":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"w":{"df":5,"docs":{"1":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"80":{"tf":1.0},"87":{"tf":1.0}}}},"p":{"df":1,"docs":{"71":{"tf":1.4142135623730951}},"m":{"df":1,"docs":{"82":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"28":{"tf":1.0},"46":{"tf":1.4142135623730951},"51":{"tf":1.0},"65":{"tf":1.0},"95":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"=":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}},"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"72":{"tf":1.0}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"46":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.4142135623730951},"95":{"tf":1.0}},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.7320508075688772}}}},"1":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"1":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"2":{"df":1,"docs":{"63":{"tf":1.7320508075688772}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"d":{"2":{"df":1,"docs":{"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"76":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"c":{"df":2,"docs":{"37":{"tf":1.4142135623730951},"86":{"tf":1.0}}},"df":8,"docs":{"13":{"tf":1.0},"30":{"tf":1.4142135623730951},"33":{"tf":1.0},"37":{"tf":1.0},"51":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.0},"95":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}},"df":6,"docs":{"0":{"tf":1.0},"4":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.4142135623730951},"88":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"t":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":2,"docs":{"32":{"tf":1.0},"73":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"75":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":8,"docs":{"13":{"tf":1.4142135623730951},"24":{"tf":1.0},"27":{"tf":2.23606797749979},"30":{"tf":1.0},"34":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"49":{"tf":1.0},"90":{"tf":1.4142135623730951}}}}},"s":{".":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":2.0}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"16":{"tf":1.0},"30":{"tf":1.0},"71":{"tf":2.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"100":{"tf":1.0},"2":{"tf":2.0},"73":{"tf":1.0},"95":{"tf":1.0}}}}}}},"s":{"df":1,"docs":{"4":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"76":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"32":{"tf":1.0},"49":{"tf":1.0},"71":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"63":{"tf":1.0},"65":{"tf":1.0}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":10,"docs":{"100":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"33":{"tf":1.0},"92":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"68":{"tf":2.0}},"r":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"42":{"tf":1.7320508075688772}},"e":{"=":{"*":{".":{"df":0,"docs":{},"h":{":":{"c":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{":":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":13,"docs":{"14":{"tf":2.23606797749979},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"3":{"tf":1.0},"5":{"tf":1.4142135623730951},"8":{"tf":1.0},"82":{"tf":1.4142135623730951},"87":{"tf":1.0},"9":{"tf":2.0}},"e":{"df":0,"docs":{},"s":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":7,"docs":{"14":{"tf":1.0},"18":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"39":{"tf":1.0},"4":{"tf":1.0},"52":{"tf":1.0},"97":{"tf":1.0}},"r":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"57":{"tf":1.0},"95":{"tf":1.0}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"98":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"104":{"tf":1.0},"97":{"tf":1.0},"99":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"88":{"tf":1.0},"95":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":2,"docs":{"58":{"tf":1.0},"70":{"tf":1.0}}}}}}}},"s":{"df":11,"docs":{"1":{"tf":1.0},"101":{"tf":1.0},"102":{"tf":1.0},"43":{"tf":2.23606797749979},"44":{"tf":2.0},"45":{"tf":1.4142135623730951},"46":{"tf":2.449489742783178},"47":{"tf":1.0},"73":{"tf":1.0},"88":{"tf":1.4142135623730951},"99":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":22,"docs":{"101":{"tf":1.4142135623730951},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.7320508075688772},"83":{"tf":2.449489742783178},"84":{"tf":1.7320508075688772},"85":{"tf":2.449489742783178},"86":{"tf":1.4142135623730951},"87":{"tf":2.0},"88":{"tf":1.4142135623730951},"89":{"tf":1.0},"90":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.4142135623730951},"99":{"tf":1.0}}}}},"t":{"df":3,"docs":{"100":{"tf":1.0},"12":{"tf":1.0},"46":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"51":{"tf":1.0},"94":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":3,"docs":{"26":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.0}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"100":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"25":{"tf":1.0},"28":{"tf":1.4142135623730951},"34":{"tf":1.0}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"f":{"df":1,"docs":{"99":{"tf":1.0}}}},"df":6,"docs":{"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.7320508075688772},"78":{"tf":1.0}},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"f":{"df":1,"docs":{"94":{"tf":1.7320508075688772}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":4,"docs":{"73":{"tf":1.0},"94":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.7320508075688772}}}}}},"l":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"62":{"tf":1.0},"72":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"h":{"df":0,"docs":{},"p":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"k":{"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"102":{"tf":1.0},"42":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"49":{"tf":1.0},"78":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"100":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"45":{"tf":1.0},"47":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":8,"docs":{"27":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":2,"docs":{"100":{"tf":1.0},"97":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"65":{"tf":1.0}}}}},"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"27":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"x":{"=":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"83":{"tf":1.0},"86":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"66":{"tf":1.4142135623730951},"68":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"104":{"tf":1.0},"20":{"tf":1.0}}}},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"101":{"tf":1.4142135623730951}},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"83":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"70":{"tf":1.0}}}}},"y":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"55":{"tf":1.0}},"s":{"df":1,"docs":{"101":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":4,"docs":{"48":{"tf":1.0},"62":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"46":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"44":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":2.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":6,"docs":{"0":{"tf":1.0},"40":{"tf":1.4142135623730951},"44":{"tf":1.0},"46":{"tf":1.0},"71":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":11,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"102":{"tf":1.0},"103":{"tf":1.0},"104":{"tf":1.0},"42":{"tf":1.0},"78":{"tf":1.0},"96":{"tf":1.7320508075688772},"97":{"tf":1.0},"98":{"tf":1.0},"99":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"83":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"61":{"tf":2.0},"70":{"tf":2.23606797749979},"88":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"40":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"102":{"tf":1.0}}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}},"j":{"df":1,"docs":{"40":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"m":{"df":1,"docs":{"90":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"66":{"tf":1.0},"68":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"s":{"=":{"1":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}}},"df":4,"docs":{"34":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772},"49":{"tf":2.0}},"e":{"a":{"d":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"98":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"104":{"tf":1.0},"25":{"tf":1.7320508075688772},"28":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"101":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"71":{"tf":1.0},"85":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.4142135623730951},"31":{"tf":1.0},"35":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"1":{"tf":1.0},"17":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"11":{"tf":1.0},"14":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.4142135623730951},"51":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"d":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"24":{"tf":1.0},"46":{"tf":1.0}}}}}},"d":{"df":1,"docs":{"51":{"tf":1.0}},"u":{"c":{"df":2,"docs":{"31":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"92":{"tf":2.23606797749979}}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":1,"docs":{"51":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":6,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"80":{"tf":1.7320508075688772},"82":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":2,"docs":{"70":{"tf":1.0},"71":{"tf":1.0}}}},"i":{"df":1,"docs":{"44":{"tf":1.0}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}},"v":{"df":7,"docs":{"19":{"tf":1.0},"37":{"tf":1.0},"58":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"95":{"tf":1.4142135623730951}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"59":{"tf":1.4142135623730951},"61":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":3,"docs":{"19":{"tf":1.4142135623730951},"65":{"tf":1.7320508075688772},"69":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"58":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"94":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"18":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0},"91":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":2,"docs":{"49":{"tf":1.0},"95":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"45":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.4142135623730951}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":4,"docs":{"11":{"tf":1.7320508075688772},"30":{"tf":1.0},"32":{"tf":1.0},"51":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":3,"docs":{"101":{"tf":1.0},"51":{"tf":1.0},"97":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"99":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":15,"docs":{"33":{"tf":1.4142135623730951},"46":{"tf":1.0},"53":{"tf":1.7320508075688772},"54":{"tf":1.0},"55":{"tf":2.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"88":{"tf":1.0},"95":{"tf":1.0},"98":{"tf":1.0}}}}},"x":{"df":1,"docs":{"42":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"28":{"tf":1.0},"65":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"58":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"h":{"df":1,"docs":{"95":{"tf":1.7320508075688772}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":3,"docs":{"38":{"tf":1.0},"49":{"tf":3.3166247903554},"95":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"62":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.4142135623730951}}}},"u":{"df":0,"docs":{},"t":{"df":4,"docs":{"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":2.0},"51":{"tf":1.7320508075688772}}}}},"u":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"df":8,"docs":{"20":{"tf":1.7320508075688772},"30":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.7320508075688772},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0},"92":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}}},"df":7,"docs":{"11":{"tf":2.0},"12":{"tf":1.0},"40":{"tf":1.4142135623730951},"71":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"94":{"tf":1.0}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"11":{"tf":1.0},"75":{"tf":1.0}}}}}}}},"s":{"/":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"$":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"69":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":4,"docs":{"13":{"tf":1.0},"24":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"78":{"tf":1.0},"92":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"/":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"45":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"92":{"tf":1.0}}}}}}}}},"_":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"92":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"_":{"1":{"df":1,"docs":{"24":{"tf":1.0}}},"2":{"df":1,"docs":{"24":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"1":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"44":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"x":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"x":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"1":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}},"2":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"42":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"1":{".":{"df":0,"docs":{},"j":{"df":2,"docs":{"23":{"tf":1.0},"25":{"tf":1.0}}}},"df":0,"docs":{}},"2":{".":{"df":0,"docs":{},"j":{"df":2,"docs":{"23":{"tf":1.0},"25":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"_":{"1":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"2":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"94":{"tf":1.7320508075688772}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"1":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}},"2":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"j":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"1":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}}}}},"df":0,"docs":{}},"2":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"c":{"c":{"df":1,"docs":{"87":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"104":{"tf":1.0}}},"df":2,"docs":{"104":{"tf":1.0},"40":{"tf":1.4142135623730951}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":4,"docs":{"16":{"tf":1.0},"19":{"tf":1.0},"80":{"tf":1.0},"92":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"80":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"104":{"tf":1.4142135623730951}}}}}},"df":5,"docs":{"100":{"tf":2.0},"104":{"tf":1.0},"7":{"tf":1.0},"87":{"tf":1.0},"90":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"51":{"tf":1.0},"91":{"tf":1.4142135623730951},"99":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"42":{"tf":1.0},"72":{"tf":1.0},"95":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"100":{"tf":1.0},"51":{"tf":1.0},"96":{"tf":1.0}}}}}}},"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":15,"docs":{"1":{"tf":1.0},"12":{"tf":1.4142135623730951},"18":{"tf":1.0},"21":{"tf":1.0},"27":{"tf":1.0},"33":{"tf":1.0},"42":{"tf":1.4142135623730951},"49":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.4142135623730951},"79":{"tf":1.0},"83":{"tf":1.0},"88":{"tf":1.4142135623730951},"94":{"tf":1.0},"95":{"tf":2.23606797749979}},"m":{"df":1,"docs":{"100":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"104":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"91":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"46":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"i":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}}},"t":{"(":{"1":{"df":1,"docs":{"71":{"tf":1.0}}},"2":{"df":1,"docs":{"71":{"tf":1.0}}},"b":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"71":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"df":8,"docs":{"27":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"33":{"tf":1.0},"36":{"tf":1.7320508075688772},"37":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.0},"88":{"tf":1.7320508075688772}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"71":{"tf":1.0},"78":{"tf":1.0},"99":{"tf":1.4142135623730951}}}}}},"f":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"89":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"w":{"df":10,"docs":{"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"35":{"tf":1.0},"55":{"tf":1.0},"65":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.0}},"n":{"df":3,"docs":{"31":{"tf":1.0},"55":{"tf":1.0},"88":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"71":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"102":{"tf":1.0},"56":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"40":{"tf":1.0},"46":{"tf":1.0}},"e":{"_":{"1":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"92":{"tf":1.0}}}}}}},"df":0,"docs":{}},"2":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"92":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":1,"docs":{"43":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"45":{"tf":1.7320508075688772},"46":{"tf":1.0},"47":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"26":{"tf":1.0},"46":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"76":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":5,"docs":{"40":{"tf":4.123105625617661},"41":{"tf":1.7320508075688772},"83":{"tf":1.0},"86":{"tf":1.0},"93":{"tf":1.0}}}}}},"df":16,"docs":{"103":{"tf":1.4142135623730951},"40":{"tf":7.280109889280518},"41":{"tf":3.605551275463989},"43":{"tf":1.0},"44":{"tf":2.0},"45":{"tf":1.0},"46":{"tf":2.23606797749979},"73":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951},"85":{"tf":1.4142135623730951},"86":{"tf":1.7320508075688772},"87":{"tf":2.0},"88":{"tf":1.4142135623730951},"90":{"tf":1.0},"93":{"tf":1.4142135623730951}}}}},"u":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"52":{"tf":1.0},"95":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":2,"docs":{"24":{"tf":1.0},"37":{"tf":1.7320508075688772}}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"h":{"df":0,"docs":{},"q":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"95":{"tf":1.0}},"r":{"df":4,"docs":{"62":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"65":{"tf":1.0},"95":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"66":{"tf":1.0},"94":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}},"l":{"df":4,"docs":{"61":{"tf":1.0},"65":{"tf":1.4142135623730951},"69":{"tf":1.7320508075688772},"95":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"p":{"df":1,"docs":{"71":{"tf":1.0}}}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":3,"docs":{"46":{"tf":1.0},"70":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":12,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"100":{"tf":1.0},"104":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"78":{"tf":1.0},"86":{"tf":1.4142135623730951},"89":{"tf":1.0},"99":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"69":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":4,"docs":{"13":{"tf":1.0},"17":{"tf":1.0},"42":{"tf":1.0},"46":{"tf":1.0}},"i":{"df":3,"docs":{"13":{"tf":1.0},"25":{"tf":1.0},"33":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"r":{"c":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"87":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"78":{"tf":1.0},"87":{"tf":1.7320508075688772}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"99":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"49":{"tf":2.0},"50":{"tf":1.0},"97":{"tf":1.0}}}},"t":{"df":2,"docs":{"34":{"tf":1.0},"94":{"tf":1.4142135623730951}},"e":{"df":1,"docs":{"26":{"tf":1.0}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"u":{"df":1,"docs":{"9":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"1":{"tf":1.0},"62":{"tf":1.0},"69":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":2,"docs":{"47":{"tf":1.4142135623730951},"88":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"100":{"tf":1.7320508075688772}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":4,"docs":{"46":{"tf":1.4142135623730951},"69":{"tf":3.0},"88":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"0":{"tf":1.0},"102":{"tf":1.0},"41":{"tf":1.4142135623730951},"46":{"tf":1.4142135623730951},"95":{"tf":1.7320508075688772},"98":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"69":{"tf":1.4142135623730951}}}}}},"u":{"b":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"87":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"88":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"103":{"tf":1.0},"62":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":6,"docs":{"82":{"tf":1.7320508075688772},"83":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"93":{"tf":1.4142135623730951},"98":{"tf":1.0},"99":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"7":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"66":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"97":{"tf":1.0}},"s":{"df":1,"docs":{"97":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":13,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"20":{"tf":1.0},"34":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":2.23606797749979},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"73":{"tf":1.0},"77":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"33":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"71":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"g":{"df":1,"docs":{"42":{"tf":1.0}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"99":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"100":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"87":{"tf":1.0},"90":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"28":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":2.0},"73":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":16,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"101":{"tf":1.0},"103":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":2.6457513110645907},"46":{"tf":1.0},"47":{"tf":1.7320508075688772},"49":{"tf":2.6457513110645907},"50":{"tf":1.7320508075688772},"51":{"tf":1.0},"58":{"tf":1.0},"73":{"tf":2.23606797749979},"88":{"tf":1.0},"90":{"tf":1.7320508075688772},"95":{"tf":3.1622776601683795}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"80":{"tf":1.0}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":2,"docs":{"15":{"tf":1.0},"94":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"91":{"tf":1.0}}}}}}},"df":1,"docs":{"33":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"101":{"tf":1.0},"94":{"tf":1.0}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"20":{"tf":2.8284271247461903},"78":{"tf":2.0},"91":{"tf":1.4142135623730951},"92":{"tf":2.449489742783178}}}},"x":{"df":0,"docs":{},"t":{"df":7,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"41":{"tf":1.4142135623730951},"62":{"tf":1.0},"73":{"tf":1.0},"99":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"14":{"tf":1.0}}}},"t":{"'":{"df":1,"docs":{"94":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"'":{"df":2,"docs":{"62":{"tf":1.0},"73":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"'":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"102":{"tf":1.0},"88":{"tf":1.0},"95":{"tf":1.4142135623730951}}},"k":{"df":1,"docs":{"88":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.0},"89":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"65":{"tf":1.0},"88":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"49":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"54":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"33":{"tf":1.4142135623730951},"94":{"tf":1.0}}}}},"o":{"d":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"95":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"46":{"tf":1.4142135623730951},"72":{"tf":1.0},"88":{"tf":1.4142135623730951},"95":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"41":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"15":{"tf":1.0},"76":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":12,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"103":{"tf":1.0},"20":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.0},"94":{"tf":1.0},"96":{"tf":1.4142135623730951},"97":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"p":{"df":3,"docs":{"60":{"tf":1.0},"95":{"tf":1.0},"99":{"tf":1.4142135623730951}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"82":{"tf":1.0},"95":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"101":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"94":{"tf":1.0}}}}}}},"df":1,"docs":{"83":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":7,"docs":{"42":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"73":{"tf":1.0},"88":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"46":{"tf":1.4142135623730951},"88":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":32,"docs":{"1":{"tf":1.0},"100":{"tf":2.0},"101":{"tf":1.7320508075688772},"102":{"tf":1.0},"103":{"tf":2.0},"104":{"tf":1.4142135623730951},"40":{"tf":4.47213595499958},"41":{"tf":2.449489742783178},"43":{"tf":2.0},"44":{"tf":2.23606797749979},"45":{"tf":2.23606797749979},"46":{"tf":3.4641016151377544},"47":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"65":{"tf":1.4142135623730951},"71":{"tf":1.7320508075688772},"73":{"tf":1.7320508075688772},"82":{"tf":1.0},"85":{"tf":1.4142135623730951},"86":{"tf":1.0},"87":{"tf":1.7320508075688772},"88":{"tf":1.4142135623730951},"90":{"tf":1.0},"95":{"tf":2.23606797749979},"97":{"tf":2.0},"98":{"tf":1.0},"99":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"88":{"tf":1.0}}}}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"87":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":23,"docs":{"52":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"95":{"tf":1.0}}}}},"df":1,"docs":{"17":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"100":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":2,"docs":{"33":{"tf":1.0},"64":{"tf":1.0}}}}},"s":{":":{":":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"88":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"1":{"tf":2.23606797749979}}}}},"df":0,"docs":{}}},"df":3,"docs":{"44":{"tf":1.4142135623730951},"46":{"tf":1.0},"88":{"tf":1.0}},"x":{"df":1,"docs":{"40":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"49":{"tf":1.0},"71":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":10,"docs":{"24":{"tf":1.0},"26":{"tf":1.0},"34":{"tf":1.0},"46":{"tf":1.0},"49":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0},"95":{"tf":1.7320508075688772}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"31":{"tf":1.0},"71":{"tf":1.4142135623730951}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"i":{"c":{"df":2,"docs":{"17":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"df":1,"docs":{"1":{"tf":1.0}},"i":{"df":2,"docs":{"38":{"tf":1.0},"42":{"tf":1.0}}},"n":{"b":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"46":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":6,"docs":{"1":{"tf":1.0},"24":{"tf":1.4142135623730951},"53":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.7320508075688772},"88":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"97":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"100":{"tf":1.0},"101":{"tf":1.0},"2":{"tf":1.0},"44":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"92":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"45":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"20":{"tf":1.0}}},"x":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"95":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"71":{"tf":2.0}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.7320508075688772}}}}},"w":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"83":{"tf":2.23606797749979},"89":{"tf":1.0},"92":{"tf":1.0},"93":{"tf":1.0}}}},"df":0,"docs":{}},"df":6,"docs":{"46":{"tf":1.0},"57":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0},"66":{"tf":1.0},"99":{"tf":1.7320508075688772}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":20,"docs":{"21":{"tf":1.7320508075688772},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.7320508075688772},"31":{"tf":1.7320508075688772},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"94":{"tf":1.0}}}},"df":44,"docs":{"100":{"tf":1.4142135623730951},"101":{"tf":1.0},"103":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"24":{"tf":1.0},"27":{"tf":1.4142135623730951},"29":{"tf":2.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":2.0},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.7320508075688772},"38":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"46":{"tf":1.7320508075688772},"51":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0},"8":{"tf":1.7320508075688772},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0},"93":{"tf":1.0},"94":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"72":{"tf":1.0}}},"df":8,"docs":{"33":{"tf":1.0},"38":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":2.0},"71":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.7320508075688772}},"n":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"y":{"1":{"4":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"94":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.0}},"e":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"17":{"tf":1.0}},"e":{"/":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"75":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"h":{"a":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"2":{".":{"4":{"3":{".":{"1":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"73":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"u":{"df":2,"docs":{"27":{"tf":1.0},"73":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":7,"docs":{"12":{"tf":1.0},"15":{"tf":1.0},"27":{"tf":1.4142135623730951},"30":{"tf":1.0},"45":{"tf":1.0},"69":{"tf":1.0},"95":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"15":{"tf":1.0},"3":{"tf":1.0}}}}}}},"b":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":2,"docs":{"49":{"tf":2.23606797749979},"94":{"tf":1.0}},"e":{"c":{"!":{"[":{"\"":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"\"":{"]":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{")":{".":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"88":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"87":{"tf":1.0},"88":{"tf":1.4142135623730951}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"81":{"tf":1.7320508075688772},"82":{"tf":1.0},"83":{"tf":1.0}},"e":{"d":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":2,"docs":{"86":{"tf":1.0},"87":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"87":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"69":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.4142135623730951},"19":{"tf":1.0},"26":{"tf":1.0},"39":{"tf":1.0},"55":{"tf":1.0},"76":{"tf":1.0},"80":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":3,"docs":{"49":{"tf":3.0},"50":{"tf":1.4142135623730951},"51":{"tf":1.0}}}}}}},"h":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":4,"docs":{"30":{"tf":1.7320508075688772},"35":{"tf":1.0},"39":{"tf":1.0},"44":{"tf":1.0}}}}}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":2,"docs":{"24":{"tf":1.0},"46":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":13,"docs":{"32":{"tf":1.0},"35":{"tf":1.0},"37":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"63":{"tf":1.0},"67":{"tf":1.0},"69":{"tf":1.0},"72":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}},"y":{"df":4,"docs":{"35":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"86":{"tf":1.0}}}},"r":{"df":1,"docs":{"73":{"tf":1.0}}},"v":{"df":2,"docs":{"65":{"tf":1.0},"72":{"tf":1.0}}}},"b":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"101":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.0},"85":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"28":{"tf":1.0},"52":{"tf":1.0},"85":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"69":{"tf":1.0}}},"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":2,"docs":{"46":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"88":{"tf":1.0}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":5,"docs":{"1":{"tf":1.0},"100":{"tf":1.0},"47":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0}},"e":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"100":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"51":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"4":{"tf":1.0},"8":{"tf":2.449489742783178}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.7320508075688772}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"59":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"95":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"1":{"tf":1.4142135623730951},"2":{"tf":1.0},"69":{"tf":1.4142135623730951}}},"df":0,"docs":{},"k":{"df":3,"docs":{"0":{"tf":1.0},"101":{"tf":1.0},"52":{"tf":1.0}}},"l":{"d":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"s":{"df":3,"docs":{"1":{"tf":1.0},"50":{"tf":1.0},"71":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"75":{"tf":1.0},"94":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"11":{"tf":1.0},"65":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"28":{"tf":1.0},"62":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"100":{"tf":1.0}}}}}}},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"g":{"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":1.0}}}},"df":11,"docs":{"49":{"tf":3.1622776601683795},"53":{"tf":2.449489742783178},"54":{"tf":2.23606797749979},"55":{"tf":2.449489742783178},"56":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"65":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.7320508075688772},"95":{"tf":1.0}},"m":{"df":0,"docs":{},"l":{"df":3,"docs":{"102":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}}},"s":{"d":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":4,"docs":{"102":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951},"71":{"tf":1.0}}}}},"df":5,"docs":{"55":{"tf":2.449489742783178},"56":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"59":{"tf":1.7320508075688772},"72":{"tf":1.4142135623730951}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"'":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"90":{"tf":1.0}}}},"r":{"df":5,"docs":{"11":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":2.0},"8":{"tf":1.7320508075688772},"97":{"tf":1.4142135623730951}}},"v":{"df":3,"docs":{"32":{"tf":1.0},"86":{"tf":1.0},"88":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"j":{"a":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"z":{"c":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"42":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"40":{"tf":1.4142135623730951},"42":{"tf":1.4142135623730951}}}}}}},"title":{"root":{"2":{"0":{"1":{"2":{"df":1,"docs":{"98":{"tf":1.0}}},"4":{"df":1,"docs":{"99":{"tf":1.0}}},"7":{"df":2,"docs":{"100":{"tf":1.0},"101":{"tf":1.0}}},"df":0,"docs":{}},"2":{"0":{"df":2,"docs":{"102":{"tf":1.0},"103":{"tf":1.0}}},"1":{"df":1,"docs":{"104":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"d":{"d":{"df":2,"docs":{"86":{"tf":1.0},"92":{"tf":1.0}}},"df":2,"docs":{"53":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"96":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"101":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"70":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"51":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"15":{"tf":1.0},"4":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":5,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"16":{"tf":1.0},"75":{"tf":1.0},"87":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"54":{"tf":1.0},"64":{"tf":1.0},"69":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":2,"docs":{"28":{"tf":1.0},"86":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"66":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"27":{"tf":1.0},"87":{"tf":1.0},"88":{"tf":1.0},"89":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"74":{"tf":1.0}}}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"b":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"64":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"42":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"f":{"df":6,"docs":{"1":{"tf":1.0},"2":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"48":{"tf":1.0},"97":{"tf":1.0}},"f":{"df":2,"docs":{"100":{"tf":1.0},"98":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"103":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.0},"32":{"tf":1.0},"37":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"24":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"o":{"c":{"df":1,"docs":{"68":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"77":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"55":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":3,"docs":{"22":{"tf":1.0},"23":{"tf":1.0},"26":{"tf":1.0}}}},"n":{"d":{"df":2,"docs":{"51":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"36":{"tf":1.0},"37":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"82":{"tf":1.0}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"95":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"49":{"tf":1.0}},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"102":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"99":{"tf":1.0}}}}}}}},"h":{"df":0,"docs":{},"g":{"df":1,"docs":{"35":{"tf":1.0}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"90":{"tf":1.0}}}}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"3":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"43":{"tf":1.0},"48":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"98":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":1,"docs":{"38":{"tf":1.0}}}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"39":{"tf":1.0},"40":{"tf":1.0},"42":{"tf":1.0},"89":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"58":{"tf":1.0},"69":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":2,"docs":{"2":{"tf":1.0},"72":{"tf":1.0}}},"u":{"df":0,"docs":{},"x":{"df":1,"docs":{"7":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"59":{"tf":1.0},"9":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"df":2,"docs":{"35":{"tf":1.0},"79":{"tf":1.0}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"47":{"tf":1.0}}}}}}},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"6":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"93":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"5":{"tf":1.0}}}},"df":1,"docs":{"18":{"tf":1.0}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"66":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{}}},"i":{"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"13":{"tf":1.0},"17":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"67":{"tf":1.0}}}}}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"63":{"tf":1.0}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"72":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"13":{"tf":1.0},"27":{"tf":1.0},"90":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"2":{"tf":1.0}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":4,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"18":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"df":3,"docs":{"43":{"tf":1.0},"44":{"tf":1.0},"88":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}}}}}},"df":1,"docs":{"35":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"46":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"94":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"96":{"tf":1.0}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"61":{"tf":1.0},"70":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"68":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"92":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"80":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"59":{"tf":1.0}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"65":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"50":{"tf":1.0},"51":{"tf":1.0}}}}}},"s":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"104":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"45":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"44":{"tf":1.0}}}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"37":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"62":{"tf":1.0},"63":{"tf":1.0}}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"69":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"10":{"tf":1.0},"86":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"69":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"41":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"66":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"df":0,"docs":{},"x":{"df":4,"docs":{"45":{"tf":1.0},"47":{"tf":1.0},"73":{"tf":1.0},"90":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"20":{"tf":1.0},"78":{"tf":1.0},"91":{"tf":1.0},"92":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"41":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":4,"docs":{"100":{"tf":1.0},"44":{"tf":1.0},"47":{"tf":1.0},"97":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"71":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"7":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"71":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"21":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"81":{"tf":1.0}}}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"59":{"tf":1.0}}}}}}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});