﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/medialive/MediaLive_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace MediaLive
{
namespace Model
{
  enum class DvbSubOcrLanguage
  {
    NOT_SET,
    DEU,
    ENG,
    FRA,
    NLD,
    POR,
    SPA
  };

namespace DvbSubOcrLanguageMapper
{
AWS_MEDIALIVE_API DvbSubOcrLanguage GetDvbSubOcrLanguageForName(const Aws::String& name);

AWS_MEDIALIVE_API Aws::String GetNameForDvbSubOcrLanguage(DvbSubOcrLanguage value);
} // namespace DvbSubOcrLanguageMapper
} // namespace Model
} // namespace MediaLive
} // namespace Aws
