﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/identitystore/IdentityStore_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/identitystore/model/GroupMembership.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace IdentityStore
{
namespace Model
{
  class ListGroupMembershipsForMemberResult
  {
  public:
    AWS_IDENTITYSTORE_API ListGroupMembershipsForMemberResult();
    AWS_IDENTITYSTORE_API ListGroupMembershipsForMemberResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_IDENTITYSTORE_API ListGroupMembershipsForMemberResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>A list of <code>GroupMembership</code> objects in the group for a specified
     * member.</p>
     */
    inline const Aws::Vector<GroupMembership>& GetGroupMemberships() const{ return m_groupMemberships; }

    /**
     * <p>A list of <code>GroupMembership</code> objects in the group for a specified
     * member.</p>
     */
    inline void SetGroupMemberships(const Aws::Vector<GroupMembership>& value) { m_groupMemberships = value; }

    /**
     * <p>A list of <code>GroupMembership</code> objects in the group for a specified
     * member.</p>
     */
    inline void SetGroupMemberships(Aws::Vector<GroupMembership>&& value) { m_groupMemberships = std::move(value); }

    /**
     * <p>A list of <code>GroupMembership</code> objects in the group for a specified
     * member.</p>
     */
    inline ListGroupMembershipsForMemberResult& WithGroupMemberships(const Aws::Vector<GroupMembership>& value) { SetGroupMemberships(value); return *this;}

    /**
     * <p>A list of <code>GroupMembership</code> objects in the group for a specified
     * member.</p>
     */
    inline ListGroupMembershipsForMemberResult& WithGroupMemberships(Aws::Vector<GroupMembership>&& value) { SetGroupMemberships(std::move(value)); return *this;}

    /**
     * <p>A list of <code>GroupMembership</code> objects in the group for a specified
     * member.</p>
     */
    inline ListGroupMembershipsForMemberResult& AddGroupMemberships(const GroupMembership& value) { m_groupMemberships.push_back(value); return *this; }

    /**
     * <p>A list of <code>GroupMembership</code> objects in the group for a specified
     * member.</p>
     */
    inline ListGroupMembershipsForMemberResult& AddGroupMemberships(GroupMembership&& value) { m_groupMemberships.push_back(std::move(value)); return *this; }


    /**
     * <p>The pagination token used for the <code>ListUsers</code>,
     * <code>ListGroups</code>, and <code>ListGroupMemberships</code> API operations.
     * This value is generated by the identity store service. It is returned in the API
     * response if the total results are more than the size of one page. This token is
     * also returned when it is used in the API request to search for the next page.
     * </p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }

    /**
     * <p>The pagination token used for the <code>ListUsers</code>,
     * <code>ListGroups</code>, and <code>ListGroupMemberships</code> API operations.
     * This value is generated by the identity store service. It is returned in the API
     * response if the total results are more than the size of one page. This token is
     * also returned when it is used in the API request to search for the next page.
     * </p>
     */
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }

    /**
     * <p>The pagination token used for the <code>ListUsers</code>,
     * <code>ListGroups</code>, and <code>ListGroupMemberships</code> API operations.
     * This value is generated by the identity store service. It is returned in the API
     * response if the total results are more than the size of one page. This token is
     * also returned when it is used in the API request to search for the next page.
     * </p>
     */
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }

    /**
     * <p>The pagination token used for the <code>ListUsers</code>,
     * <code>ListGroups</code>, and <code>ListGroupMemberships</code> API operations.
     * This value is generated by the identity store service. It is returned in the API
     * response if the total results are more than the size of one page. This token is
     * also returned when it is used in the API request to search for the next page.
     * </p>
     */
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }

    /**
     * <p>The pagination token used for the <code>ListUsers</code>,
     * <code>ListGroups</code>, and <code>ListGroupMemberships</code> API operations.
     * This value is generated by the identity store service. It is returned in the API
     * response if the total results are more than the size of one page. This token is
     * also returned when it is used in the API request to search for the next page.
     * </p>
     */
    inline ListGroupMembershipsForMemberResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}

    /**
     * <p>The pagination token used for the <code>ListUsers</code>,
     * <code>ListGroups</code>, and <code>ListGroupMemberships</code> API operations.
     * This value is generated by the identity store service. It is returned in the API
     * response if the total results are more than the size of one page. This token is
     * also returned when it is used in the API request to search for the next page.
     * </p>
     */
    inline ListGroupMembershipsForMemberResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}

    /**
     * <p>The pagination token used for the <code>ListUsers</code>,
     * <code>ListGroups</code>, and <code>ListGroupMemberships</code> API operations.
     * This value is generated by the identity store service. It is returned in the API
     * response if the total results are more than the size of one page. This token is
     * also returned when it is used in the API request to search for the next page.
     * </p>
     */
    inline ListGroupMembershipsForMemberResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}


    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }

    
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }

    
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }

    
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }

    
    inline ListGroupMembershipsForMemberResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}

    
    inline ListGroupMembershipsForMemberResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}

    
    inline ListGroupMembershipsForMemberResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}

  private:

    Aws::Vector<GroupMembership> m_groupMemberships;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace IdentityStore
} // namespace Aws
