/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.ImportsStructureEntitySorter;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class ShortForm2AnnotationGenerator
extends AbstractCompositeOntologyChange {
    private static final long serialVersionUID = 40000L;

    public ShortForm2AnnotationGenerator(@Nonnull OWLDataFactory df, @Nonnull OWLOntologyManager ontologyManager, @Nonnull OWLOntology ontology, @Nonnull ShortFormProvider shortFormProvider, @Nonnull IRI annotationIRI, @Nullable String languageTag) {
        super(df);
        this.generateChanges(OWLAPIPreconditions.checkNotNull(ontologyManager, "ontologyManager cannot be null"), OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null"), OWLAPIPreconditions.checkNotNull(shortFormProvider, "shortFormProvider cannot be null"), OWLAPIPreconditions.checkNotNull(annotationIRI, "annotationIRI cannot be null"), languageTag);
    }

    public ShortForm2AnnotationGenerator(@Nonnull OWLDataFactory df, @Nonnull OWLOntologyManager ontologyManager, @Nonnull OWLOntology ontology, @Nonnull ShortFormProvider shortFormProvider, @Nonnull IRI annotationIRI) {
        this(df, ontologyManager, ontology, shortFormProvider, annotationIRI, null);
    }

    private void generateChanges(OWLOntologyManager ontologyManager, @Nonnull OWLOntology ontology, @Nonnull ShortFormProvider shortFormProvider, @Nonnull IRI annotationIRI, @Nullable String languageTag) {
        ImportsStructureEntitySorter sorter = new ImportsStructureEntitySorter(ontology);
        Map ontology2EntityMap = sorter.getObjects();
        for (OWLOntology ont : ontology2EntityMap.keySet()) {
            assert (ont != null);
            for (OWLEntity ent : ontology2EntityMap.get(ont)) {
                assert (ent != null);
                String shortForm = shortFormProvider.getShortForm(ent);
                OWLLiteral con = languageTag != null ? ontologyManager.getOWLDataFactory().getOWLLiteral(shortForm, languageTag) : ontologyManager.getOWLDataFactory().getOWLLiteral(shortForm);
                if (!ontology.containsEntityInSignature(ent)) continue;
                AddAxiom chg = new AddAxiom(ont, ontologyManager.getOWLDataFactory().getOWLAnnotationAssertionAxiom(ontologyManager.getOWLDataFactory().getOWLAnnotationProperty(annotationIRI), ent.getIRI(), con));
                this.addChange(chg);
            }
        }
    }
}

