/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.internal.restclient.capability.resources.AnnotationCapability;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.IResource;

public abstract class AssociationCapability
extends AnnotationCapability {
    private IClient client;

    public AssociationCapability(String name, IResource resource, IClient client) {
        super(name, resource);
        this.client = client;
    }

    protected IClient getClient() {
        return this.client;
    }

    @Override
    public boolean isSupported() {
        if (this.client == null) {
            return false;
        }
        return super.isSupported();
    }

    protected <T extends IResource> T getAssociatedResource(String kind) {
        if (!this.isSupported()) {
            return null;
        }
        String name = this.getResource().getAnnotation(this.getAnnotationKey());
        return this.getClient().get(kind, name, this.getResource().getNamespaceName());
    }
}

