/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import org.jboss.ws.common.Messages;
import org.jboss.ws.common.reflection.AbstractClassProcessor;
import org.jboss.ws.common.reflection.AnnotationAware;

public abstract class AbstractAnnotatedClassProcessor<AO extends AccessibleObject, A extends Annotation>
extends AbstractClassProcessor<AO>
implements AnnotationAware<A> {
    private final Class<A> annotationClass;

    public AbstractAnnotatedClassProcessor(Class<A> annotationClass) {
        if (annotationClass == null) {
            throw Messages.MESSAGES.annotationClassCannotBeNull();
        }
        this.annotationClass = annotationClass;
    }

    @Override
    public boolean matches(AO accessibleObject) {
        return ((AccessibleObject)accessibleObject).isAnnotationPresent(this.getAnnotation());
    }

    @Override
    public Class<A> getAnnotation() {
        return this.annotationClass;
    }
}

