/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.modules.JDKPaths;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.filter.PathFilter;

public final class PathUtils {
    private PathUtils() {
    }

    public static <T extends Collection<? super String>> T filterPaths(Iterable<String> source, PathFilter filter, T target) {
        for (String path : source) {
            if (!filter.accept(path)) continue;
            target.add((String)path);
        }
        return target;
    }

    public static Set<String> getPathSet(ClassLoader classLoader) {
        if (classLoader == null) {
            return JDKPaths.JDK;
        }
        if (classLoader instanceof ModuleClassLoader) {
            ModuleClassLoader moduleClassLoader = (ModuleClassLoader)classLoader;
            return Collections.unmodifiableSet(moduleClassLoader.getPaths());
        }
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            URL[] urls = urlClassLoader.getURLs();
            HashSet<String> paths = new HashSet<String>();
            for (URL url : urls) {
                File file;
                URI uri;
                try {
                    uri = url.toURI();
                }
                catch (URISyntaxException e) {
                    return null;
                }
                String scheme = uri.getScheme();
                if (!"file".equals(scheme)) continue;
                try {
                    file = new File(uri);
                }
                catch (Exception e) {
                    return null;
                }
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    JDKPaths.processDirectory(paths, file);
                    continue;
                }
                try {
                    JDKPaths.processJar(paths, file);
                }
                catch (IOException e) {
                    return null;
                }
            }
            return Collections.unmodifiableSet(paths);
        }
        return null;
    }

    public static String relativize(String path) {
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '/' || path.charAt(i) == File.separatorChar) continue;
            return path.substring(i);
        }
        return "";
    }

    public static String fileNameOfPath(String path) {
        return path.substring(Math.max(path.lastIndexOf(47), path.lastIndexOf(File.separatorChar)) + 1);
    }

    public static String canonicalize(String path) {
        int length = path.length();
        int state = 0;
        if (length == 0) {
            return path;
        }
        char[] targetBuf = new char[length];
        int e = length;
        int i = length;
        int a = length - 1;
        int skip = 0;
        block22: while (--i >= 0) {
            char c = path.charAt(i);
            block0 : switch (c) {
                case '/': {
                    switch (state) {
                        case 0: {
                            state = 3;
                            e = i;
                            continue block22;
                        }
                        case 1: {
                            state = 3;
                            e = i;
                            continue block22;
                        }
                        case 2: {
                            state = 3;
                            e = i;
                            ++skip;
                            continue block22;
                        }
                        case 3: {
                            e = i;
                            continue block22;
                        }
                    }
                    throw new IllegalStateException();
                }
                case '.': {
                    switch (state) {
                        case 0: {
                            state = 1;
                            continue block22;
                        }
                        case 1: {
                            state = 2;
                            continue block22;
                        }
                        case 2: {
                            break block0;
                        }
                        case 3: {
                            state = 1;
                            continue block22;
                        }
                    }
                    throw new IllegalStateException();
                }
            }
            if (File.separatorChar != '/' && c == File.separatorChar) {
                switch (state) {
                    case 0: {
                        state = 3;
                        e = i;
                        continue block22;
                    }
                    case 1: {
                        state = 3;
                        e = i;
                        continue block22;
                    }
                    case 2: {
                        state = 3;
                        e = i;
                        ++skip;
                        continue block22;
                    }
                    case 3: {
                        e = i;
                        continue block22;
                    }
                }
                throw new IllegalStateException();
            }
            int newE = e > 0 ? path.lastIndexOf(47, e - 1) : -1;
            int segmentLength = e - newE - 1;
            if (skip > 0) {
                --skip;
            } else {
                if (state == 3) {
                    targetBuf[a--] = 47;
                }
                path.getChars(newE + 1, e, targetBuf, (a -= segmentLength) + 1);
            }
            state = 0;
            i = newE + 1;
            e = newE;
        }
        if (state == 3) {
            targetBuf[a--] = 47;
        }
        return new String(targetBuf, a + 1, length - a - 1);
    }

    public static boolean isChild(String parent, String child) {
        String cp = PathUtils.canonicalize(parent);
        cp = cp.endsWith("/") ? cp.substring(0, cp.length() - 1) : cp;
        String cc = PathUtils.canonicalize(child);
        if (PathUtils.isRelative(cp) != PathUtils.isRelative(cc)) {
            throw new IllegalArgumentException("Cannot compare relative and absolute paths");
        }
        int cpl = cp.length();
        return cpl == 0 || cc.length() > cpl + 1 && cc.startsWith(cp) && cc.charAt(cpl) == '/';
    }

    public static boolean isDirectChild(String parent, String child) {
        String cp = PathUtils.canonicalize(parent);
        cp = cp.endsWith("/") ? cp.substring(0, cp.length() - 1) : cp;
        String cc = PathUtils.canonicalize(child);
        if (PathUtils.isRelative(cp) != PathUtils.isRelative(cc)) {
            throw new IllegalArgumentException("Cannot compare relative and absolute paths");
        }
        int cpl = cp.length();
        if (cpl == 0) {
            return cc.indexOf(47) < 0;
        }
        return cc.length() > cpl + 1 && cc.startsWith(cp) && cc.charAt(cpl) == '/' && cc.indexOf(47, cpl + 1) == -1;
    }

    public static String toGenericSeparators(String original) {
        return File.separatorChar == '/' ? original : original.replace(File.separatorChar, '/');
    }

    public static boolean isRelative(String path) {
        return path.isEmpty() || !PathUtils.isSeparator(path.charAt(0));
    }

    public static boolean isSeparator(char ch) {
        return ch == '/' || File.separatorChar != '/' && ch == File.separatorChar;
    }

    private static boolean isAllowedPunct(int cp) {
        return cp == 95 || cp == 36 || cp == 37 || cp == 94 || cp == 38 || cp == 40 || cp == 41 || cp == 45 || cp == 43 || cp == 61 || cp == 59 || cp == 91 || cp == 93 || cp == 123 || cp == 125 || cp == 60 || cp == 62 || cp == 44 || cp == 34 || cp == 39;
    }

    public static String basicModuleNameToPath(String moduleName) {
        String normalized = Normalizer.normalize(moduleName, Normalizer.Form.NFKC);
        int length = normalized.length();
        StringBuilder builder = new StringBuilder(length + 5);
        boolean slot = false;
        boolean sep = false;
        boolean dot = false;
        boolean esc = false;
        int i = 0;
        while (i < length) {
            int cp = normalized.codePointAt(i);
            if (Character.isLetterOrDigit(cp) || PathUtils.isAllowedPunct(cp)) {
                builder.appendCodePoint(cp);
                esc = false;
                sep = true;
                dot = true;
            } else if (cp == 92) {
                if (esc) {
                    return null;
                }
                esc = true;
            } else if (cp == 58) {
                if (esc) {
                    builder.append(':');
                    esc = false;
                    sep = true;
                    dot = true;
                } else if (slot) {
                    builder.append(':');
                    esc = false;
                    sep = true;
                    dot = true;
                } else {
                    if (!sep) {
                        return null;
                    }
                    builder.append('/');
                    slot = true;
                    sep = false;
                    dot = false;
                }
            } else if (cp == 46) {
                if (slot) {
                    if (!dot) {
                        return null;
                    }
                    builder.append('.');
                    sep = true;
                    esc = false;
                } else {
                    if (!sep) {
                        return null;
                    }
                    builder.append('/');
                    sep = false;
                    dot = false;
                    esc = false;
                }
            } else if (cp == 47) {
                if (!dot) {
                    return null;
                }
                builder.append('.');
                sep = true;
                dot = false;
                esc = false;
            } else {
                return null;
            }
            i = normalized.offsetByCodePoints(i, 1);
        }
        if (!dot || !sep || esc) {
            return null;
        }
        if (!slot) {
            builder.append("/main");
        }
        return builder.toString();
    }

    static <T> Map<String, List<T>> deduplicateLists(Map<String, List<T>> allPaths) {
        if (allPaths == null) {
            return null;
        }
        if (allPaths.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap newPaths = new HashMap();
        HashMap dedup = new HashMap();
        for (Map.Entry<String, List<T>> e : allPaths.entrySet()) {
            List l = (List)dedup.get(e.getValue());
            if (l == null) {
                l = Collections.unmodifiableList(new ArrayList(e.getValue()));
                dedup.put(e.getValue(), l);
            }
            newPaths.put(e.getKey(), l);
        }
        return Collections.unmodifiableMap(newPaths);
    }
}

