/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.io.IOException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import org.wildfly.common.Assert;
import org.wildfly.security.keystore.ModifyTrackingKeyStoreSpi;

public class ModifyTrackingKeyStore
extends KeyStore {
    private final ModifyTrackingKeyStoreSpi keyStoreSpi;

    private ModifyTrackingKeyStore(ModifyTrackingKeyStoreSpi keyStoreSpi, Provider provider, String type) {
        super(keyStoreSpi, provider, type);
        this.keyStoreSpi = keyStoreSpi;
    }

    public static ModifyTrackingKeyStore modifyTrackingKeyStore(KeyStore toWrap) throws NoSuchAlgorithmException, CertificateException, IOException {
        Assert.checkNotNullParam("toWrap", toWrap);
        ModifyTrackingKeyStore keyStore = new ModifyTrackingKeyStore(new ModifyTrackingKeyStoreSpi(toWrap), toWrap.getProvider(), toWrap.getType());
        keyStore.load(null, null);
        return keyStore;
    }

    public boolean isModified() {
        return this.keyStoreSpi.isModified();
    }

    public void setModified(boolean modified) {
        this.keyStoreSpi.setModified(modified);
    }
}

