/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jwt;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import javax.ws.rs.ext.ContextResolver;
import org.jboss.resteasy.jwt.JsonWebToken;

public class JWTContextResolver
implements ContextResolver<ObjectMapper> {
    protected ObjectMapper mapper = new ObjectMapper();

    public JWTContextResolver() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
    }

    public JWTContextResolver(boolean indent) {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        if (indent) {
            this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
    }

    public ObjectMapper getContext(Class<?> type) {
        if (JsonWebToken.class.isAssignableFrom(type)) {
            return this.mapper;
        }
        return null;
    }
}

