#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 mintty
version:              0.1.2
visibility:           public
id:                   mintty-0.1.2-Hgc1CH6hJ9D6IyLAd4caus
key:                  mintty-0.1.2-Hgc1CH6hJ9D6IyLAd4caus
license:              BSD-3-Clause
copyright:            (C) 2017 Ryan Scott
maintainer:           Ryan Scott <ryan.gl.scott@gmail.com>
author:               Ryan Scott
stability:            Provisional
homepage:             https://github.com/RyanGlScott/mintty
synopsis:
    A reliable way to detect the presence of a MinTTY console on Windows

description:
    MinTTY is a Windows-specific terminal emulator for the
    widely used Cygwin and MSYS projects, which provide
    Unix-like environments for Windows. MinTTY consoles behave
    differently from native Windows consoles (such as
    @cmd.exe@ or PowerShell) in many ways, and in some cases,
    these differences make it necessary to treat MinTTY
    consoles differently in code.

    The @mintty@ library provides a simple way to detect if
    your code in running in a MinTTY console on Windows. It
    exports @isMinTTY@, which does the right thing 90% of the
    time (by checking if standard error is attached to
    MinTTY), and it also exports @isMinTTYHandle@ for the
    other 10% of the time (when you want to check is some
    arbitrary handle is attached to MinTTY). As you might
    expect, both of these functions will simply return @False@
    on any non-Windows operating system.

category:             System
abi:                  91e40ab1de519780876399668eddefc2
exposed:              True
exposed-modules:      System.Console.MinTTY
import-dirs:          /usr/lib/ghc-8.10.5/site-local/mintty-0.1.2
library-dirs:         /usr/lib/ghc-8.10.5/site-local/mintty-0.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/mintty-0.1.2
hs-libraries:         HSmintty-0.1.2-Hgc1CH6hJ9D6IyLAd4caus
depends:              base-4.14.2.0
haddock-interfaces:   /usr/share/doc/haskell-mintty/html/mintty.haddock
haddock-html:         /usr/share/doc/haskell-mintty/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

