package bubble;
import java.awt.geom.Point2D;

/**
 * 自動操縦の試験的実装です。
 * @author Kumano Tatsuo
 * Created on 2005/01/01 14:31:52
 */
public class KumanoAI2 implements AI {
    /**
     * 走っているかどうか
     */
    private boolean isRunning;

    /**
     * ゲームの情報
     */
    private final ReadOnlyGame game;

    /**
     * コンストラクタです。 
     * @param game ゲームの情報
     */
    public KumanoAI2(ReadOnlyGame game) {
        this.game = game;
        this.isRunning = true;
    }

    public void run() {
        int lastY = Integer.MAX_VALUE;
        while (this.isRunning) {
            try {
                this.game.stop();
                Point2D location = this.game.getLocation();
                if (location != null) {
                    int x = (int) location.getX();
                    int y = (int) location.getY();
                    int speed = lastY - y;
                    if (speed > 0) {
                        ++speed;
                        if (Util.getMinDistanceColor(x, y - speed, this.game) != this.game
                                .getColor() || y > (Const.STAGE_ROWS - 2) * Const.GRID_HEIGHT) {
                            if (Util.getMinDistanceSq(x, y - speed, this.game) < (Const.GRID_WIDTH + 6)
                                    * (Const.GRID_WIDTH + 6)) {
                                this.game.stop();
                                if (Util.getMinDistanceSq(x, y - speed, this.game) < (Const.GRID_WIDTH + 2)
                                        * (Const.GRID_WIDTH + 2)) {
                                    if (Util.getMinDistanceSq(x - 4, y - speed, this.game) < Util
                                            .getMinDistanceSq(x + 4, y - speed, this.game)) {
                                        this.game.moveRight();
                                    } else {
                                        this.game.moveLeft();
                                    }
                                }
                            } else {
                                this.game.moveUp();
                            }
                        } else {
                            this.game.moveUp();
                        }
                    }
                    lastY = y;
                }
                Thread.sleep(Const.MAIN_LOOP_WAIT_TIME);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        this.game.stop();
        this.isRunning = false;
    }
}
