package bubble;

import java.awt.Panel;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import sound.BGM;

/**
 * キー入力を処理するクラスです。
 * @author Kumano Tatsuo
 * 作成日：2004/10/15
 */
public class KeyHandler implements KeyListener {
    /**
     * パネル
     */
    private Panel panel;

    /**
     * プレイヤ1のゲームの情報
     */
    private Game game1;

    /**
     * プレイヤ2のゲームの情報
     */
    private Game game2;

    /**
     * プレイヤ1の自動操縦
     */
    private AI ai1;

    /**
     * プレイヤ2の自動操縦
     */
    private AI ai2;

    /**
     * BGM
     */
    private BGM bgm;

    /**
     * キーハンドラが初期化されるときに呼び出されます。
     * @param panel パネル
     * @param game1 プレイヤ1のゲームの情報
     * @param game2 プレイヤ2のゲームの情報
     */
    public KeyHandler(Panel panel, Game game1, Game game2) {
        this.panel = panel;
        this.game1 = game1;
        this.game2 = game2;
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
        case KeyEvent.VK_X:
            this.game1.setLeft(true);
            this.game1.setLeftKeyPressed(true);
            break;
        case KeyEvent.VK_V:
            this.game1.setRight(true);
            this.game1.setRightKeyPressed(true);
            break;
        case KeyEvent.VK_C:
            this.game1.setUp(true);
            this.game1.setUpKeyPressed(true);
            break;
        case KeyEvent.VK_LEFT:
            this.game2.setLeft(true);
            this.game2.setLeftKeyPressed(true);
            break;
        case KeyEvent.VK_RIGHT:
            this.game2.setRight(true);
            this.game2.setRightKeyPressed(true);
            break;
        case KeyEvent.VK_UP:
        case KeyEvent.VK_DOWN:
            this.game2.setUpKeyPressed(true);
            this.game2.setUp(true);
            break;
        case KeyEvent.VK_B:
            if (this.bgm == null) {
                this.bgm = new BGM();
                this.bgm.play();
            } else {
                this.bgm.stop();
                this.bgm = null;
            }
            break;
        case KeyEvent.VK_1:
            if (this.ai1 == null) {
                this.ai1 = new KumanoAI4(new ReadOnlyGame(this.game1), Const.STAGE_ROWS / 6);
                new Thread(this.ai1).start();
            } else {
                this.ai1.stop();
                this.ai1 = null;
            }
            break;
        case KeyEvent.VK_2:
            if (this.ai1 == null) {
                this.ai1 = new KumanoAI4(new ReadOnlyGame(this.game1), Const.STAGE_ROWS * 2 / 6);
                new Thread(this.ai1).start();
            } else {
                this.ai1.stop();
                this.ai1 = null;
            }
            break;
        case KeyEvent.VK_3:
            if (this.ai1 == null) {
                this.ai1 = new KumanoAI4(new ReadOnlyGame(this.game1), Const.STAGE_ROWS * 3 / 6);
                new Thread(this.ai1).start();
            } else {
                this.ai1.stop();
                this.ai1 = null;
            }
            break;
        case KeyEvent.VK_4:
            if (this.ai1 == null) {
                this.ai1 = new KumanoAI4(new ReadOnlyGame(this.game1), Const.STAGE_ROWS * 4 / 6);
                new Thread(this.ai1).start();
            } else {
                this.ai1.stop();
                this.ai1 = null;
            }
            break;
        case KeyEvent.VK_5:
            if (this.ai1 == null) {
                this.ai1 = new KumanoAI4(new ReadOnlyGame(this.game1), Const.STAGE_ROWS * 5 / 6);
                new Thread(this.ai1).start();
            } else {
                this.ai1.stop();
                this.ai1 = null;
            }
            break;
        case KeyEvent.VK_NUMPAD1:
            if (this.ai2 == null) {
                this.ai2 = new KumanoAI4(new ReadOnlyGame(this.game2), Const.STAGE_ROWS / 6);
                new Thread(this.ai2).start();
            } else {
                this.ai2.stop();
                this.ai2 = null;
            }
            break;
        case KeyEvent.VK_NUMPAD2:
            if (this.ai2 == null) {
                this.ai2 = new KumanoAI4(new ReadOnlyGame(this.game2), Const.STAGE_ROWS * 2 / 6);
                new Thread(this.ai2).start();
            } else {
                this.ai2.stop();
                this.ai2 = null;
            }
            break;
        case KeyEvent.VK_NUMPAD3:
            if (this.ai2 == null) {
                this.ai2 = new KumanoAI4(new ReadOnlyGame(this.game2), Const.STAGE_ROWS * 3 / 6);
                new Thread(this.ai2).start();
            } else {
                this.ai2.stop();
                this.ai2 = null;
            }
            break;
        case KeyEvent.VK_NUMPAD4:
            if (this.ai2 == null) {
                this.ai2 = new KumanoAI4(new ReadOnlyGame(this.game2), Const.STAGE_ROWS * 4 / 6);
                new Thread(this.ai2).start();
            } else {
                this.ai2.stop();
                this.ai2 = null;
            }
            break;
        case KeyEvent.VK_NUMPAD5:
            if (this.ai2 == null) {
                this.ai2 = new KumanoAI4(new ReadOnlyGame(this.game2), Const.STAGE_ROWS * 5 / 6);
                new Thread(this.ai2).start();
            } else {
                this.ai2.stop();
                this.ai2 = null;
            }
            break;
        }
    }

    public void keyReleased(KeyEvent e) {
        switch (e.getKeyCode()) {
        case KeyEvent.VK_X:
            this.game1.setLeft(false);
            break;
        case KeyEvent.VK_V:
            this.game1.setRight(false);
            break;
        case KeyEvent.VK_C:
            this.game1.setUp(false);
            break;
        case KeyEvent.VK_LEFT:
            this.game2.setLeft(false);
            break;
        case KeyEvent.VK_RIGHT:
            this.game2.setRight(false);
            break;
        case KeyEvent.VK_UP:
        case KeyEvent.VK_DOWN:
            this.game2.setUp(false);
            break;
        }
    }

    public void keyTyped(KeyEvent e) {
        // do nothing
    }
}
