/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.parser;

import yt4droid.Comments;
import yt4droid.Contact;
import yt4droid.Feeds;
import yt4droid.ResponseList;
import yt4droid.UpdateResult;
import yt4droid.UploadResult;
import yt4droid.UserProfile;
import yt4droid.YoutubeException;
import yt4droid.conf.Configuration;
import yt4droid.http.HttpResponse;
import yt4droid.parser.CommentParser;
import yt4droid.parser.ContactParser;
import yt4droid.parser.FeedsParser;
import yt4droid.parser.UpdateResultParser;
import yt4droid.parser.UploadResultParser;
import yt4droid.parser.UserProfileParser;

public class ParserFactory {
    private Configuration conf;

    public ParserFactory(Configuration conf) {
        this.conf = conf;
    }

    public UploadResult uploadVideo(HttpResponse res) {
        return UploadResultParser.createVideoID(res, this.conf);
    }

    public String uploadMetaData(HttpResponse res) {
        return UploadResultParser.createUploadUrl(res, this.conf);
    }

    public ResponseList<Feeds> createUserUploadList(HttpResponse res) throws YoutubeException {
        return FeedsParser.createFeedsList(res, this.conf);
    }

    public ResponseList<Comments> createCommentsList(HttpResponse res) throws YoutubeException {
        return CommentParser.createCommentsList(res, this.conf);
    }

    public ResponseList<Feeds> createFeedsListFromQuery(HttpResponse res) throws YoutubeException {
        return FeedsParser.createFeedsList(res, this.conf);
    }

    public UpdateResult updateRatings(HttpResponse res) throws YoutubeException {
        return UpdateResultParser.createResult(res);
    }

    public UpdateResult updateComment(HttpResponse res) throws YoutubeException {
        return UpdateResultParser.createResult(res);
    }

    public UpdateResult deleteVideo(HttpResponse res) throws YoutubeException {
        return UpdateResultParser.createResult(res);
    }

    public UpdateResult updateVideo(HttpResponse res) throws YoutubeException {
        return UpdateResultParser.createResult(res);
    }

    public UserProfile createUserProfile(HttpResponse res) throws YoutubeException {
        return UserProfileParser.createUserProfile(res, this.conf);
    }

    public ResponseList<Contact> createMyContacts(HttpResponse res) throws YoutubeException {
        return ContactParser.createContactList(res, this.conf);
    }

    public UpdateResult addContact(HttpResponse res) throws YoutubeException {
        return UpdateResultParser.createResult(res);
    }

    public UpdateResult updateContact(HttpResponse res) throws YoutubeException {
        return UpdateResultParser.createResult(res);
    }
}

