/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.parser;

import java.util.Date;
import yt4droid.AccessControlEntity;
import yt4droid.AccessControlEntityImpl;
import yt4droid.ContentEntity;
import yt4droid.ContentEntityImpl;
import yt4droid.Feeds;
import yt4droid.PlayerEntity;
import yt4droid.PlayerEntityImpl;
import yt4droid.ResponseList;
import yt4droid.ResponseListImpl;
import yt4droid.ThumbnailEntity;
import yt4droid.ThumbnailEntityImpl;
import yt4droid.YoutubeException;
import yt4droid.conf.Configuration;
import yt4droid.http.HttpResponse;
import yt4droid.internal.org.json.JSONArray;
import yt4droid.internal.org.json.JSONException;
import yt4droid.internal.org.json.JSONObject;
import yt4droid.util.ParseUtil;

public class FeedsParser
implements Feeds {
    private String id;
    private Date uploaded;
    private Date updated;
    private String uploader;
    private String category;
    private String title;
    private String description;
    private String[] tags;
    private ThumbnailEntity thumbnail;
    private PlayerEntity player;
    private ContentEntity content;
    private String duration;
    private String aspectRatio;
    private float rating;
    private int likeCount;
    private int ratingCount;
    private int viewCount;
    private int favoriteCount;
    private int commentCount;
    private AccessControlEntity accessControl;

    protected FeedsParser(HttpResponse res, Configuration conf) throws YoutubeException {
        JSONObject json = res.asJSONObject();
        this.init(json);
    }

    public FeedsParser(JSONObject json) throws YoutubeException {
        this.init(json);
    }

    private void init(JSONObject json) throws YoutubeException {
        this.id = ParseUtil.getRawString("id", json);
        this.uploaded = ParseUtil.parseDate(ParseUtil.getRawString("uploaded", json));
        this.updated = ParseUtil.parseDate(ParseUtil.getRawString("updated", json));
        this.uploader = ParseUtil.getRawString("uploader", json);
        this.category = ParseUtil.getRawString("category", json);
        this.title = ParseUtil.getRawString("title", json);
        this.description = ParseUtil.getRawString("description", json);
        this.tags = ParseUtil.getStringArray("tags", json);
        try {
            this.thumbnail = new ThumbnailEntityImpl(json);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.player = new PlayerEntityImpl(json);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.content = new ContentEntityImpl(json);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.duration = ParseUtil.getRawString("duration", json);
        this.aspectRatio = ParseUtil.getRawString("aspectRatio", json);
        this.rating = ParseUtil.getFloat("rating", json);
        this.likeCount = ParseUtil.getInt("likeCount", json);
        this.ratingCount = ParseUtil.getInt("ratingCount", json);
        this.viewCount = ParseUtil.getInt("viewCount", json);
        this.favoriteCount = ParseUtil.getInt("favoriteCount", json);
        this.commentCount = ParseUtil.getInt("commentCount", json);
        try {
            this.accessControl = new AccessControlEntityImpl(json);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Date getUploaded() {
        return this.uploaded;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public String getUploader() {
        return this.uploader;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String[] getTags() {
        return this.tags;
    }

    @Override
    public ThumbnailEntity getThumbnail() {
        return this.thumbnail;
    }

    @Override
    public PlayerEntity getPlayer() {
        return this.player;
    }

    @Override
    public ContentEntity getContent() {
        return this.content;
    }

    @Override
    public String getDuration() {
        return this.duration;
    }

    @Override
    public String getAspectRatio() {
        return this.aspectRatio;
    }

    @Override
    public float getRating() {
        return this.rating;
    }

    @Override
    public int getLikeCount() {
        return this.likeCount;
    }

    @Override
    public int getRatingCount() {
        return this.ratingCount;
    }

    @Override
    public int getViewCount() {
        return this.viewCount;
    }

    @Override
    public int getFavoriteCount() {
        return this.favoriteCount;
    }

    @Override
    public int getCommentCount() {
        return this.commentCount;
    }

    @Override
    public AccessControlEntity getAccessControl() {
        return this.accessControl;
    }

    public static ResponseList<Feeds> createFeedsList(HttpResponse res, Configuration conf) throws YoutubeException {
        try {
            JSONObject json = res.asJSONObject();
            JSONObject dataObject = json.getJSONObject("data");
            int size = 0;
            JSONArray itemsArray = null;
            if (!dataObject.getString("totalItems").equals("0")) {
                itemsArray = dataObject.getJSONArray("items");
                size = itemsArray.length();
            }
            ResponseListImpl<Feeds> feedsList = new ResponseListImpl<Feeds>(size, res);
            int i = 0;
            while (i < size) {
                JSONObject itemObject = itemsArray.getJSONObject(i);
                FeedsParser feeds = new FeedsParser(itemObject);
                feedsList.add(feeds);
                ++i;
            }
            return feedsList;
        }
        catch (JSONException jsone) {
            throw new YoutubeException("parseError", jsone);
        }
        catch (YoutubeException ye) {
            throw ye;
        }
    }
}

