/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.parser;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import yt4droid.Contact;
import yt4droid.ResponseList;
import yt4droid.ResponseListImpl;
import yt4droid.YoutubeException;
import yt4droid.conf.Configuration;
import yt4droid.http.HttpResponse;
import yt4droid.internal.xml.XMLParseHandler;
import yt4droid.util.ParseUtil;

public class ContactParser
implements Contact {
    private String id;
    private Date published;
    private Date updated;
    private Date edited;
    private String title;
    private List<Map<String, List<Map<String, String>>>> link;
    private String name;
    private String uri;
    private String userName;
    private String status;

    protected ContactParser(Map entryMap) throws YoutubeException {
        this.init(entryMap);
    }

    private void init(Map entryMap) throws YoutubeException {
        this.id = (String)entryMap.get("id");
        this.published = ParseUtil.parseDate((String)entryMap.get("published"));
        this.updated = ParseUtil.parseDate((String)entryMap.get("updated"));
        this.edited = ParseUtil.parseDate((String)entryMap.get("app:edited"));
        this.title = (String)entryMap.get("title");
        this.link = (List)entryMap.get("link");
        Map authorMap = (Map)entryMap.get("author");
        if (authorMap != null) {
            this.name = (String)authorMap.get("name");
            this.uri = (String)authorMap.get("uri");
        }
        this.userName = (String)entryMap.get("yt:username");
        this.status = (String)entryMap.get("yt:status");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Date getPublished() {
        return this.published;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public Date getEdited() {
        return this.edited;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public List<Map<String, List<Map<String, String>>>> getLink() {
        return this.link;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public static ResponseList<Contact> createContactList(HttpResponse res, Configuration conf) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            XMLParseHandler handler = new XMLParseHandler(new HashMap());
            parser.parse(res.asStream(), (DefaultHandler)handler);
            Map map = handler.getDataBean();
            List feedsList = (List)map.get("feed");
            List entryList = null;
            int i = 0;
            i = 0;
            while (feedsList.size() > i) {
                Map entryMap = (Map)feedsList.get(i);
                entryList = (List)entryMap.get("entry");
                if (entryList != null) break;
                ++i;
            }
            ResponseListImpl<Contact> contactList = null;
            if (entryList != null) {
                contactList = new ResponseListImpl<Contact>(entryList.size(), (Map)feedsList.get(i));
                int j = 0;
                while (entryList.size() > j) {
                    if (entryList.get(j) instanceof Map) {
                        ContactParser contact = new ContactParser((Map)entryList.get(j));
                        contactList.add(contact);
                    }
                    ++j;
                }
            } else {
                Map itemMap = null;
                int k = 0;
                while (feedsList.size() > k) {
                    Map entityMap = (Map)feedsList.get(k);
                    String id = (String)entityMap.get("id");
                    if (id != null) {
                        itemMap = (Map)feedsList.get(k);
                        break;
                    }
                    ++k;
                }
                if (itemMap != null) {
                    contactList = new ResponseListImpl(0, itemMap);
                } else {
                    throw new IllegalStateException("Cannot parse this entry from youtube.");
                }
            }
            return contactList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

