/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import yt4droid.YoutubeException;
import yt4droid.internal.org.json.JSONArray;
import yt4droid.internal.org.json.JSONException;
import yt4droid.internal.org.json.JSONObject;
import yt4droid.internal.org.json.JSONTokener;

public abstract class HttpResponse {
    protected int statusCode;
    protected String responseAsString = null;
    protected InputStream is;
    private boolean streamConsumed = false;
    private JSONObject json = null;
    private JSONArray jsonArray = null;

    public int getStatusCode() {
        return this.statusCode;
    }

    public abstract String getResponseHeader(String var1);

    public abstract Map<String, List<String>> getResponseHeaderFields();

    public InputStream asStream() {
        if (this.streamConsumed) {
            throw new IllegalStateException("Stream has already been consumed.");
        }
        return this.is;
    }

    public String asString() throws YoutubeException {
        if (this.responseAsString == null) {
            BufferedReader br = null;
            InputStream stream = null;
            try {
                stream = this.asStream();
                if (stream == null) {
                    return null;
                }
                try {
                    String line;
                    br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                    StringBuffer buf = new StringBuffer();
                    while ((line = br.readLine()) != null) {
                        buf.append(line).append("\n");
                    }
                    this.responseAsString = buf.toString();
                    stream.close();
                    this.streamConsumed = true;
                }
                catch (IOException ioe) {
                    throw new YoutubeException(ioe.getMessage(), ioe);
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
                this.disconnectForcibly();
            }
        }
        return this.responseAsString;
    }

    private void disconnectForcibly() {
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract void disconnect() throws IOException;

    public JSONObject asJSONObject() throws YoutubeException {
        if (this.json == null) {
            Reader reader = null;
            try {
                try {
                    if (this.responseAsString == null) {
                        reader = this.asReader();
                        this.json = new JSONObject(new JSONTokener(reader));
                    } else {
                        this.json = new JSONObject(this.responseAsString);
                    }
                }
                catch (JSONException jsone) {
                    if (this.responseAsString == null) {
                        throw new YoutubeException(jsone.getMessage(), jsone);
                    }
                    throw new YoutubeException(String.valueOf(jsone.getMessage()) + ":" + this.responseAsString, jsone);
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                this.disconnectForcibly();
            }
        }
        return this.json;
    }

    public JSONArray asJSONArray() throws YoutubeException {
        if (this.jsonArray == null) {
            Reader reader = null;
            try {
                try {
                    if (this.responseAsString == null) {
                        reader = this.asReader();
                        this.jsonArray = new JSONArray(new JSONTokener(reader));
                    } else {
                        this.jsonArray = new JSONArray(this.responseAsString);
                    }
                }
                catch (JSONException jsone) {
                    throw new YoutubeException(jsone.getMessage(), jsone);
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                this.disconnectForcibly();
            }
        }
        return this.jsonArray;
    }

    public Reader asReader() {
        try {
            return new BufferedReader(new InputStreamReader(this.is, "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            return new InputStreamReader(this.is);
        }
    }
}

