/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.http;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import yt4droid.YoutubeException;
import yt4droid.conf.Configuration;
import yt4droid.http.HttpClient;
import yt4droid.http.HttpClientBase;
import yt4droid.http.HttpParameter;
import yt4droid.http.HttpRequest;
import yt4droid.http.HttpResponceCode;
import yt4droid.http.HttpResponse;
import yt4droid.http.HttpResponseImpl;
import yt4droid.http.RequestMethod;

public class HttpClientImpl
extends HttpClientBase
implements HttpClient,
HttpResponceCode {
    private static final Map<Configuration, HttpClient> instanceMap = new HashMap<Configuration, HttpClient>(1);

    public HttpClientImpl(Configuration conf) {
        super(conf);
    }

    public static HttpClient getInstance(Configuration conf) {
        HttpClient client = instanceMap.get(conf);
        if (client == null) {
            client = new HttpClientImpl(conf);
            instanceMap.put(conf, client);
        }
        return client;
    }

    public HttpResponse get(String url) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.GET, url, null, null, null));
    }

    public HttpResponse post(String url, HttpParameter[] params) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.POST, url, params, null, null));
    }

    @Override
    public HttpResponse request(HttpRequest req) throws YoutubeException {
        int retry = this.CONF.getHttpRetryCount() + 1;
        HttpResponseImpl res = null;
        int retriedCount = 0;
        while (retriedCount < retry) {
            block33: {
                int responseCode = -1;
                try {
                    OutputStream os = null;
                    OutputStreamWriter outStreamWriter = null;
                    try {
                        HttpParameter param;
                        int n;
                        int n2;
                        HttpParameter[] httpParameterArray;
                        HttpURLConnection con = this.getConnection(req.getURL());
                        con.setDoInput(true);
                        this.setHeaders(req, con);
                        con.setRequestMethod(req.getMethod().name());
                        if (req.getMethod() == RequestMethod.POST) {
                            if (HttpParameter.containsFile(req.getParameters())) {
                                httpParameterArray = req.getParameters();
                                n2 = httpParameterArray.length;
                                n = 0;
                                while (n < n2) {
                                    param = httpParameterArray[n];
                                    if (param.isFile()) {
                                        int bytesRead;
                                        int bufferSize = this.CONF.getBufferSize();
                                        byte[] buffer = new byte[bufferSize];
                                        int chunk = param.getEnd() - param.getStart() + 1;
                                        FileInputStream fileStream = new FileInputStream(param.getFile());
                                        con.setDoOutput(true);
                                        con.setFixedLengthStreamingMode(chunk);
                                        con.setRequestProperty("Content-Type", param.getContentType());
                                        con.setRequestProperty("Content-Range", String.format("bytes %d-%d/%d", param.getStart(), param.getEnd(), param.getLength()));
                                        fileStream.skip(param.getStart());
                                        int totalRead = 0;
                                        double totalBytesUploaded = this.CONF.getTotalBytesUpload();
                                        os = con.getOutputStream();
                                        while ((bytesRead = fileStream.read(buffer, 0, bufferSize)) != -1) {
                                            os.write(buffer, 0, bytesRead);
                                            totalRead += bytesRead;
                                            totalBytesUploaded += (double)bytesRead;
                                            if (this.CONF.getUploadListener() != null) {
                                                double percent = totalBytesUploaded / (double)param.getLength() * 99.0;
                                                this.CONF.getUploadListener().onProgressUpload(percent);
                                            }
                                            if (totalRead == param.getEnd() - param.getStart() + 1) break;
                                        }
                                        this.CONF.setTotalBytesUpload((int)totalBytesUploaded);
                                    } else if (param.isMetaData()) {
                                        con.setDoOutput(true);
                                        con.setRequestProperty("Content-Type", "application/atom+xml");
                                        if (param.getFileName() != null) {
                                            con.setRequestProperty("Slug", param.getFileName());
                                        }
                                        con.setRequestProperty("Content-Length", Integer.toString(param.getMetaData().getBytes("UTF-8").length));
                                        outStreamWriter = new OutputStreamWriter(con.getOutputStream());
                                        outStreamWriter.write(param.getMetaData());
                                        outStreamWriter.close();
                                    } else {
                                        con.setDoOutput(true);
                                        con.setRequestProperty("Content-Disposition", "form-data; name=" + param.getName());
                                        con.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
                                        outStreamWriter = new OutputStreamWriter(con.getOutputStream());
                                        outStreamWriter.write(param.getValue().getBytes("UTF-8").toString());
                                        outStreamWriter.close();
                                    }
                                    ++n;
                                }
                            } else {
                                con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                                String postParam = HttpParameter.encodeParameters(req.getParameters());
                                byte[] bytes = postParam.getBytes("UTF-8");
                                con.setRequestProperty("Content-Length", Integer.toString(bytes.length));
                                con.setDoOutput(true);
                                try {
                                    os = con.getOutputStream();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                os.write(bytes);
                                os.flush();
                                os.close();
                            }
                        } else if (req.getMethod() == RequestMethod.PUT && HttpParameter.containsFile(req.getParameters())) {
                            httpParameterArray = req.getParameters();
                            n2 = httpParameterArray.length;
                            n = 0;
                            while (n < n2) {
                                param = httpParameterArray[n];
                                if (param.isMetaData()) {
                                    con.setDoOutput(true);
                                    con.setRequestProperty("Content-Type", "application/atom+xml");
                                    if (param.getFileName() != null) {
                                        con.setRequestProperty("Slug", param.getFileName());
                                    }
                                    con.setRequestProperty("Content-Length", Integer.toString(param.getMetaData().getBytes("UTF-8").length));
                                    outStreamWriter = new OutputStreamWriter(con.getOutputStream());
                                    outStreamWriter.write(param.getMetaData());
                                    outStreamWriter.close();
                                }
                                ++n;
                            }
                        }
                        res = new HttpResponseImpl(con);
                        responseCode = con.getResponseCode();
                        if (responseCode == 200 || responseCode == 201 || responseCode == 308) break;
                        if (responseCode == 401 || responseCode < 500 || retriedCount == this.CONF.getHttpRetryCount()) {
                            throw new YoutubeException(res);
                        }
                    }
                    finally {
                        try {
                            os.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (IOException ioe) {
                    if (retriedCount != this.CONF.getHttpRetryCount()) break block33;
                    throw new YoutubeException(ioe, res);
                }
            }
            try {
                Thread.sleep(this.CONF.getHttpRetryIntervalSeconds() * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++retriedCount;
        }
        return res;
    }

    public static String encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException neverHappen) {
            throw new AssertionError((Object)"will never happen");
        }
    }

    private void setHeaders(HttpRequest req, HttpURLConnection connection) {
        String authorizationHeader = null;
        if (req.getAuthorization() != null && (authorizationHeader = req.getAuthorization().getAuthorizationHeader(req)) != null) {
            connection.setRequestProperty("Authorization", String.format("GoogleLogin auth=\"%s\"", authorizationHeader));
        }
        if (req.getRequestHeaders() != null) {
            for (String key : req.getRequestHeaders().keySet()) {
                connection.addRequestProperty(key, req.getRequestHeaders().get(key));
            }
        }
    }

    private HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection con;
        if (this.isProxyConfigured()) {
            if (this.CONF.getHttpProxyUser() != null && !this.CONF.getHttpProxyUser().equals("")) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                            return new PasswordAuthentication(HttpClientImpl.this.CONF.getHttpProxyUser(), HttpClientImpl.this.CONF.getHttpProxyPassword().toCharArray());
                        }
                        return null;
                    }
                });
            }
            Proxy proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(this.CONF.getHttpProxyHost(), this.CONF.getHttpProxyPort()));
            con = (HttpURLConnection)new URL(url).openConnection(proxy);
        } else {
            con = (HttpURLConnection)new URL(url).openConnection();
        }
        if (this.CONF.getHttpConnectionTimeout() > 0) {
            con.setConnectTimeout(this.CONF.getHttpConnectionTimeout());
        }
        if (this.CONF.getHttpReadTimeout() > 0) {
            con.setReadTimeout(this.CONF.getHttpReadTimeout());
        }
        con.setInstanceFollowRedirects(false);
        return con;
    }

    @Override
    public void shutDown() {
    }
}

